/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.util;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.datatypes.BAxisVideoResolutionSettings;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.naxisVideo.util.BAxisUserNameAndPassword;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpStream;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.VideoStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;

public class AxisHttpUtil {
    private static Logger logger = Logger.getLogger(AxisHttpUtil.class.getName());

    public static void streamToDestination(BAxisVideoCamera camera, BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        try {
            BIpAddress addr = new BIpAddress(((BAxisVideoCameraDeviceId)camera.getVideoDeviceId()).getUrlAddress(), ((BAxisVideoCameraDeviceId)camera.getVideoDeviceId()).getWebPort());
            camera.getAxisVideoNetwork().getHttpConfig().lease(2);
            HttpComm hcom = camera.getAxisVideoNetwork().hcomm();
            String uri = AxisHttpUtil.makeUri(camera, playbackParams);
            NHttpRequest rqst = new NHttpRequest(addr, "GET", uri);
            String passKey = camera.getUpdatedVideoKey();
            rqst.addBasicAuthorization(camera.getCredentials().getUsername(), passKey);
            BAxisUserNameAndPassword axisCredentials = new BAxisUserNameAndPassword();
            axisCredentials.setUsername(camera.getCredentials().getUsername());
            axisCredentials.setPassword(BPassword.make((String)passKey));
            rqst.setUsernamePassword((BUsernameAndPassword)axisCredentials);
            NHttpStream hstream = hcom.openStream(rqst);
            AxisVideoSteam vs = new AxisVideoSteam(playbackParams, hstream.getInputStream(), hstream);
            videoDestination.receiveVideoStream((IVideoStream)vs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException("Unable to establish stream", (Throwable)e);
        }
    }

    static String makeUri(BAxisVideoCamera camera, BPlaybackParams playbackParams) {
        StringBuilder urlBuf = AxisHttpUtil.initUrlRequest(camera);
        AxisHttpUtil.updateUrlToRequestResolution(urlBuf, playbackParams.getResolution(), camera.getResolutionSettings(), playbackParams);
        AxisHttpUtil.updateUrlToRequestFrameRate(urlBuf, playbackParams.getFrameRate());
        return urlBuf.toString();
    }

    static StringBuilder initUrlRequest(BAxisVideoCamera camera) {
        BAxisVideoCameraDeviceId camId = (BAxisVideoCameraDeviceId)camera.getVideoDeviceId();
        StringBuilder buf = new StringBuilder("http://");
        buf.append(camId.getUrlAddress());
        buf.append("/axis-cgi/mjpg/video.cgi?clock=0&date=0");
        return buf;
    }

    static void updateUrlToRequestResolution(StringBuilder urlBuf, BVideoResolutionEnum resolution, BAxisVideoResolutionSettings resolutionSetings, BPlaybackParams playbackParams) {
        if (resolution == BVideoResolutionEnum.high) {
            String res = resolutionSetings.getHigh();
            if (res.length() != 0) {
                urlBuf.append("&resolution=" + res);
            }
        } else if (resolution == BVideoResolutionEnum.medium) {
            String res = resolutionSetings.getMedium();
            if (res.length() != 0) {
                urlBuf.append("&resolution=" + res);
            }
        } else if (resolution == BVideoResolutionEnum.low) {
            String res = resolutionSetings.getLow();
            if (res.length() != 0) {
                urlBuf.append("&resolution=" + res);
            }
        } else {
            logger.log(Level.FINE, ">> Unrecognized Niagara AX video resolution: " + resolution);
        }
        urlBuf.append("&compression=" + AxisHttpUtil.getAxisVideoCompression(playbackParams));
    }

    static int getAxisVideoCompression(BPlaybackParams playbackParams) {
        BVideoCompressionEnum desiredCompression = playbackParams.getCompression();
        if (desiredCompression == BVideoCompressionEnum.none) {
            return 0;
        }
        if (desiredCompression == BVideoCompressionEnum.low) {
            return 10;
        }
        if (desiredCompression == BVideoCompressionEnum.medium) {
            return 30;
        }
        if (desiredCompression == BVideoCompressionEnum.high) {
            return 80;
        }
        throw new IllegalArgumentException("Requested compression unrecognized: " + desiredCompression);
    }

    static void updateUrlToRequestFrameRate(StringBuilder urlBuf, BVideoFrameRateEnum frameRate) {
        if (frameRate == BVideoFrameRateEnum.high) {
            urlBuf.append("&fps=30");
        } else if (frameRate == BVideoFrameRateEnum.medium) {
            urlBuf.append("&fps=15");
        } else if (frameRate == BVideoFrameRateEnum.low) {
            urlBuf.append("&fps=4");
        } else {
            logger.log(Level.FINE, ">> Unrecognized Niagara AX frame rate: " + frameRate);
        }
    }

    public static String[] inspectHtml(String pattern, int numGroups, String rsp) {
        Pattern oroPattern = null;
        try {
            oroPattern = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Matcher oroMatcher = oroPattern.matcher(rsp);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            String[] retVal = new String[numGroups + 1];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = oroResult.group(i);
            }
            return retVal;
        }
        return null;
    }

    public static String inspectLeftHtml(String axisParam, String rsp) {
        Pattern oroPattern = null;
        try {
            oroPattern = Pattern.compile(axisParam + "=(.*)");
        }
        catch (PatternSyntaxException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Matcher oroMatcher = oroPattern.matcher(rsp);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            return oroResult.group(1);
        }
        return null;
    }

    public static String inspectRightHtml(String axisParam, String rsp) {
        Pattern oroPattern = null;
        try {
            oroPattern = Pattern.compile("(.*)=" + axisParam);
        }
        catch (PatternSyntaxException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        Matcher oroMatcher = oroPattern.matcher(rsp);
        if (oroMatcher.find()) {
            MatchResult oroResult = oroMatcher.toMatchResult();
            return oroResult.group(1);
        }
        return null;
    }

    public static void interruptCurrentThread() {
        try {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().interrupt();
                return null;
            });
        }
        catch (PrivilegedActionException pe) {
            Exception inner = pe.getException();
            logger.log(Level.SEVERE, "Exception on calling interrupt : ", pe);
        }
    }

    private static class AxisVideoSteam
    extends VideoStream {
        NHttpStream hstream;

        AxisVideoSteam(BPlaybackParams playbackParams, InputStream in, NHttpStream hstream) {
            super(playbackParams, in);
            this.hstream = hstream;
        }

        public void closeVideoStream() throws IOException {
            this.hstream.close();
        }
    }
}

