/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.util.EscUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.baja.sys.BDynamicEnum;
import javax.baja.util.Lexicon;

public class AxisVideoMoveToPresetRequest
extends NHttpRequest {
    public static final Lexicon LEX = Lexicon.make(AxisVideoMoveToPresetRequest.class);
    BAxisVideoCamera camera;
    BDynamicEnum presetPosition;

    public AxisVideoMoveToPresetRequest(BIpAddress ipaddress, BAxisVideoCamera camera, BDynamicEnum presetPosition) {
        super(ipaddress);
        this.camera = camera;
        this.presetPosition = presetPosition;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        StringBuilder urlBuf = this.initUrlRequest();
        urlBuf.append(this.getMoveToPresetUrlParams());
        return urlBuf.toString();
    }

    private StringBuilder initUrlRequest() {
        StringBuilder buf = new StringBuilder("");
        buf.append("/axis-cgi/com/ptz.cgi?");
        return buf;
    }

    private String getMoveToPresetUrlParams() {
        String sPosition = EscUtil.slot.unescape(this.presetPosition.getTag());
        try {
            sPosition = URLEncoder.encode(sPosition, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(LEX.getText("UTF8EncodingNotSupported"));
        }
        if (sPosition.indexOf(126) >= 0) {
            throw new IllegalArgumentException(LEX.getText("TildeNotAllowedInPresetName"));
        }
        if (sPosition.length() > 31) {
            sPosition = sPosition.substring(0, 31);
        }
        return "gotoserverpresetname=" + sPosition;
    }
}

