/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.event.enableEvents;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.BAxisVideoNetwork;
import com.tridium.naxisVideo.comm.BAxisVideoEventsReceiver;
import com.tridium.naxisVideo.event.enableEvents.AxisParameterUtil;
import java.net.UnknownHostException;
import javax.baja.sys.Sys;

public class EventServerUtil {
    protected BAxisVideoCamera avCamera;

    public EventServerUtil(BAxisVideoCamera avCamera) {
        this.avCamera = avCamera;
    }

    public String getParameterKeyForTheEventServerWithIpOfThisStationInAxisCam() throws AxisParameterUtil.ParameterNotFoundException, AxisParameterUtil.ReadGroupException, UnknownHostException {
        return AxisParameterUtil.queryGroup(this.avCamera, "EventServers.TCP.*.Address", Sys.getLocalHost(null).getHostAddress());
    }

    public String getIdForTheEventServerWithIpOfThisStationInAxisCam(String axisEventServerName) throws UnknownHostException, AxisParameterUtil.ReadGroupException, AxisParameterUtil.UnableToAddGroupException, AxisParameterUtil.UnableToUpdateParameterException {
        axisEventServerName = axisEventServerName.replaceAll("[^\\w\\d\\s]", "_");
        axisEventServerName = axisEventServerName.replaceAll("\\s+", " ");
        BAxisVideoNetwork avNetwork = (BAxisVideoNetwork)this.avCamera.getNetwork();
        BAxisVideoEventsReceiver avEventsReceiver = avNetwork.getEventReceiver();
        int tcpIpPort = avEventsReceiver.getTcpIpPort();
        try {
            String eventServerAddressParameterkey = this.getParameterKeyForTheEventServerWithIpOfThisStationInAxisCam();
            String eventServerId = eventServerAddressParameterkey.substring(5, 24);
            AxisParameterUtil.queryGroup(this.avCamera, eventServerId + ".Name", axisEventServerName);
            AxisParameterUtil.updateParameter(this.avCamera, eventServerId + ".Port", "" + tcpIpPort);
            return eventServerId;
        }
        catch (AxisParameterUtil.ParameterNotFoundException pnfe) {
            String stationAddress = Sys.getLocalHost(null).getHostAddress();
            return this.addEventServerInsideAxisCamWithIpOfThisStation(this.avCamera, stationAddress, axisEventServerName, tcpIpPort);
        }
    }

    public String addEventServerInsideAxisCamWithIpOfThisStation(BAxisVideoCamera avCamera, String stationAddress, String axisEventServerName, int tcpIpAddress) throws UnknownHostException, AxisParameterUtil.UnableToAddGroupException {
        String tId = AxisParameterUtil.addParameterGroup(avCamera, "EventServers.TCP&template=tcp_config&EventServers.TCP.T.Name=" + axisEventServerName + "&EventServers.TCP.T.Address=" + stationAddress + "&EventServers.TCP.T.Port=" + tcpIpAddress);
        return "EventServers.TCP." + tId;
    }
}

