/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm.req;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfPingRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddfHttp.comm.rsp.BDdfHttpInspectPingResponse;
import com.tridium.ddfHttp.identify.BIDdfHttpInspectUrl;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDdfHttpInspectPingRequest
extends BDdfPingRequest {
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfHttpInspectPingRequest.class);
    protected String urlAddress = "";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public byte[] toByteArray() {
        String deviceUrl;
        String pingUrl;
        BDdfIdParams pingParameters = this.getPingParameters();
        BDdfIdParams deviceId = this.getDeviceId();
        if (pingParameters instanceof BIDdfHttpInspectUrl) {
            pingUrl = ((BIDdfHttpInspectUrl)pingParameters).getUrl();
            if (pingUrl.trim().length() == 0 || pingUrl.trim().equals("-")) {
                pingUrl = null;
            }
        } else {
            pingUrl = null;
        }
        if (deviceId instanceof BIDdfHttpInspectUrl) {
            deviceUrl = ((BIDdfHttpInspectUrl)deviceId).getUrl();
            if (deviceUrl.trim().length() == 0 || deviceUrl.trim().equals("-")) {
                deviceUrl = null;
            }
        } else {
            deviceUrl = null;
        }
        if (pingUrl == null && deviceUrl == null) {
            throw new BajaRuntimeException("No URL!");
        }
        if (deviceUrl != null && pingUrl != null) {
            if (deviceUrl.endsWith("/")) {
                deviceUrl = deviceUrl.substring(0, deviceUrl.length() - 1);
            }
            if (pingUrl.startsWith("/")) {
                pingUrl = pingUrl.substring(1);
            }
            this.urlAddress = deviceUrl + '/' + pingUrl;
        } else if (deviceUrl == null) {
            this.urlAddress = pingUrl;
        } else if (pingUrl == null) {
            this.urlAddress = deviceUrl;
        } else {
            throw new IllegalStateException("Program Execution should not have made it here");
        }
        return this.urlAddress.getBytes();
    }

    public BIDdfResponse processReceive(IDdfDataFrame ddfDataFrame) throws DdfResponseException {
        return new BDdfHttpInspectPingResponse(ddfDataFrame, this.urlAddress);
    }
}

