/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.util;

import com.tridium.util.ThrowableUtil;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="state", type="BDescriptorState", defaultValue="BDescriptorState.idle", flags=1), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make())"), @NiagaraProperty(name="lastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="lastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
@NiagaraAction(name="execute", flags=16)
public abstract class BAbstractDescriptor
extends BComponent
implements BIStatus {
    @Generated
    public static final Property status = BAbstractDescriptor.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property state = BAbstractDescriptor.newProperty((int)1, (BValue)BDescriptorState.idle, null);
    @Generated
    public static final Property enabled = BAbstractDescriptor.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property executionTime = BAbstractDescriptor.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    @Generated
    public static final Property lastAttempt = BAbstractDescriptor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastSuccess = BAbstractDescriptor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailure = BAbstractDescriptor.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property faultCause = BAbstractDescriptor.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action execute = BAbstractDescriptor.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractDescriptor.class);

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BDescriptorState getState() {
        return (BDescriptorState)this.get(state);
    }

    @Generated
    public void setState(BDescriptorState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BTimeTrigger getExecutionTime() {
        return (BTimeTrigger)this.get(executionTime);
    }

    @Generated
    public void setExecutionTime(BTimeTrigger v) {
        this.set(executionTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    @Generated
    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    @Generated
    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    @Generated
    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail() {
        this.executeFail("");
    }

    public void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail(Throwable ex) {
        this.executeFail(BAbstractDescriptor.getFailureReason(ex));
    }

    private static String getFailureReason(Throwable ex) {
        String reason = ex == null ? "" : (ex instanceof LocalizableException || ex instanceof LocalizableRuntimeException ? ((Localizable)ex).toString(null) : ThrowableUtil.dumpToString((Throwable)ex, (int)1));
        if (reason == null) {
            reason = ex.toString();
        }
        reason = reason.replace("\n", "");
        return reason;
    }

    public void executeInProgress() {
        this.setState(BDescriptorState.inProgress);
    }

    public abstract void doExecute();

    public boolean isUnoperational() {
        return this.isDisabled() || this.isDown();
    }

    public boolean isDown() {
        return this.getStatus().isDown();
    }

    public boolean isFault() {
        return this.getStatus().isFault();
    }

    public boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public abstract void updateStatus();

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(execute)) {
            if (this.isUnoperational()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, arg, cx);
        }
        return super.post(action, arg, cx);
    }

    protected abstract IFuture postExecute(Action var1, BValue var2, Context var3);

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 23: {
                this.fwStationStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.updateStatus();
        this.add("triggerLink?", (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
    }

    private void fwStopped() {
        Property triggerLink = this.getProperty("triggerLink");
        if (triggerLink != null) {
            this.remove(triggerLink);
        }
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled)) {
            this.updateStatus();
        } else if (prop.equals(executionTime)) {
            this.add("triggerLink?", (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
        }
    }

    private void fwStationStarted() {
        if (this.getState() != BDescriptorState.idle) {
            this.setState(BDescriptorState.idle);
            this.execute();
        }
    }
}

