/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.point.conv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.driver.point.BProxyExt;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BLinearConversion
extends BProxyConversion {
    public static final BLinearConversion DEFAULT = new BLinearConversion(1.0, 0.0);
    public static final Type TYPE = Sys.loadType(BLinearConversion.class);
    private double scale;
    private double offset;
    private int hashCode = -1;

    public static BLinearConversion make(double scale, double offset) {
        if (scale == 1.0 && offset == 0.0) {
            return DEFAULT;
        }
        return (BLinearConversion)new BLinearConversion(scale, offset).intern();
    }

    private BLinearConversion(double scale, double offset) {
        this.scale = scale;
        this.offset = offset;
    }

    public double getScale() {
        return this.scale;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue) throws Exception {
        if (deviceValue instanceof BStatusNumeric) {
            BLinearConversion.convert(ext, (BStatusNumeric)deviceValue, (BStatusNumeric)proxyValue, true, this.scale, this.offset);
        } else {
            proxyValue.copyFrom((BComplex)deviceValue);
        }
    }

    @Override
    public void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue) throws Exception {
        if (proxyValue instanceof BStatusNumeric) {
            BLinearConversion.convert(ext, (BStatusNumeric)proxyValue, (BStatusNumeric)deviceValue, false, this.scale, this.offset);
        } else {
            deviceValue.copyFrom((BComplex)proxyValue);
        }
    }

    static void convert(BProxyExt ext, BStatusNumeric from, BStatusNumeric to, boolean deviceToProxy, double scale, double offset) {
        double fromValue = from.getValue();
        double toValue = deviceToProxy ? fromValue * scale + offset : (fromValue - offset) / scale;
        to.setStatus(from.getStatus());
        to.setValue(toValue);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + Double.doubleToRawLongBits(this.offset);
            hash = hash * 37L + Double.doubleToRawLongBits(this.scale);
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLinearConversion) {
            BLinearConversion x = (BLinearConversion)((Object)obj);
            return this.scale == x.scale && this.offset == x.offset;
        }
        return false;
    }

    public String toString(Context context) {
        StringBuilder s = new StringBuilder();
        s.append(TYPE.getDisplayName(context));
        if (this.scale != 1.0) {
            s.append(" *").append(BDouble.toString((double)this.scale, (Context)context));
        }
        if (this.offset < 0.0) {
            s.append(' ').append(BDouble.toString((double)this.offset, (Context)context));
        } else if (this.offset > 0.0) {
            s.append(" +").append(BDouble.toString((double)this.offset, (Context)context));
        }
        return s.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.offset);
    }

    public BObject decode(DataInput in) throws IOException {
        return BLinearConversion.make(in.readDouble(), in.readDouble());
    }

    public String encodeToString() {
        return BDouble.encode((double)this.scale) + ";" + BDouble.encode((double)this.offset);
    }

    public BObject decodeFromString(String s) throws IOException {
        int semi = s.indexOf(59);
        return BLinearConversion.make(BDouble.decode((String)s.substring(0, semi)), BDouble.decode((String)s.substring(semi + 1)));
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

