/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.history;

import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.history.BIHistoryPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="onDemandPollEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="onDemandPollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="configOverrides", type="BComponent", defaultValue="new BComponent()")})
public abstract class BHistoryImport
extends BArchiveDescriptor
implements BIHistoryPollable,
BIPollableHistorySource {
    @Generated
    public static final Property onDemandPollEnabled = BHistoryImport.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property onDemandPollFrequency = BHistoryImport.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property configOverrides = BHistoryImport.newProperty((int)0, (BValue)new BComponent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryImport.class);
    private static final BIcon icon = BIcon.make((String)"module://driver/com/tridium/driver/ui/history/importHistory.png");
    public static final Context asyncHistoryPoll = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public String toString() {
            return "Context.asyncHistoryPoll";
        }
    };
    public static final Context syncHistoryPoll = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        public String toString() {
            return "Context.syncHistoryPoll";
        }
    };
    BHistoryNetworkExt ext = null;
    int historySubscribeCounter = 0;
    Object syncObj = new Object();

    @Generated
    public boolean getOnDemandPollEnabled() {
        return this.getBoolean(onDemandPollEnabled);
    }

    @Generated
    public void setOnDemandPollEnabled(boolean v) {
        this.setBoolean(onDemandPollEnabled, v, null);
    }

    @Generated
    public BPollFrequency getOnDemandPollFrequency() {
        return (BPollFrequency)this.get(onDemandPollFrequency);
    }

    @Generated
    public void setOnDemandPollFrequency(BPollFrequency v) {
        this.set(onDemandPollFrequency, (BValue)v, null);
    }

    @Generated
    public BComponent getConfigOverrides() {
        return (BComponent)this.get(configOverrides);
    }

    @Generated
    public void setConfigOverrides(BComponent v) {
        this.set(configOverrides, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        while (parent != null && !(parent instanceof BIArchiveFolder)) {
            parent = (BComponent)parent.getParent();
        }
        if (parent == null) {
            return false;
        }
        try {
            return ((BIArchiveFolder)parent).getImportDescriptorType() != null;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public BHistoryConfig makeLocalConfig(BHistoryConfig remoteConfig) {
        BHistoryConfig newConfig = (BHistoryConfig)remoteConfig.newCopy(true);
        BComponent configChanges = this.getConfigOverrides();
        Property[] props = configChanges.getPropertiesArray();
        for (int i = 0; i < props.length; ++i) {
            Property changeProp = props[i];
            BValue changeValue = configChanges.get(changeProp).newCopy(true);
            Property configProp = newConfig.getProperty(changeProp.getName());
            if (configProp == null) {
                newConfig.add(changeProp.getName(), changeValue, configChanges.getFlags((Slot)changeProp), configChanges.getSlotFacets((Slot)changeProp), null);
                continue;
            }
            newConfig.set(configProp, changeValue);
        }
        try {
            BOrd ord = this.getSourceOrd();
            BOrdList src = newConfig.getSource();
            if (src.size() < 1) {
                newConfig.setSource(BOrdList.make((BOrd)ord));
            } else if (!src.get(src.size() - 1).equals((Object)ord)) {
                BOrdList newSrc = BOrdList.add((BOrdList)src, (BOrd)ord);
                newConfig.setSource(newSrc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newConfig;
    }

    private BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return this.getSlotPathOrd();
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return this.getSlotPathOrd();
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribed() {
        Object object = this.syncObj;
        synchronized (object) {
            this.historySubscribeCounter = 0;
            if (this.ext != null) {
                this.ext.getOnDemandPollScheduler().unsubscribe(this);
            }
        }
    }

    @Override
    public void poll() {
        if (this.getOnDemandPollEnabled() && !this.isUnoperational() && this.historySubscribeCounter > 0) {
            this.invoke(execute, null, asyncHistoryPoll);
        }
    }

    public boolean historyPollingEnabled() {
        if (!this.getOnDemandPollEnabled()) {
            return false;
        }
        BHistoryNetworkExt historyExt = this.getHistoryNetworkExt();
        if (historyExt == null) {
            return false;
        }
        BPollScheduler scheduler = historyExt.getOnDemandPollScheduler();
        if (!this.isRunning()) {
            scheduler.lease();
        }
        return scheduler.getPollEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateHistorySubscriptionCount(int change) {
        int result = 0;
        boolean syncExecute = false;
        Object object = this.syncObj;
        synchronized (object) {
            int oldCount = this.historySubscribeCounter;
            this.historySubscribeCounter += change;
            if (this.historySubscribeCounter < 0) {
                this.historySubscribeCounter = 0;
            } else if (oldCount == 0 && this.historySubscribeCounter > 0 && this.isRunning()) {
                this.ext = this.getHistoryNetworkExt();
                if (this.ext != null) {
                    BPollScheduler scheduler = this.ext.getOnDemandPollScheduler();
                    if (this.getOnDemandPollEnabled() && !this.isUnoperational() && scheduler.getPollEnabled() && this.historySubscribeCounter > 0) {
                        syncExecute = true;
                    }
                    scheduler.subscribe(this);
                }
            }
            if (this.historySubscribeCounter == 0 && this.ext != null) {
                this.ext.getOnDemandPollScheduler().unsubscribe(this);
            }
            result = this.historySubscribeCounter;
        }
        if (syncExecute) {
            this.invoke(execute, null, syncHistoryPoll);
        }
        return result;
    }

    @Override
    public BPollFrequency getPollFrequency() {
        return this.getOnDemandPollFrequency();
    }

    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle((Object)"HistoryImport", 2);
        out.prop((Object)"historySubscriptionCount", (Object)("" + this.historySubscribeCounter));
        out.endProps();
        super.spy(out);
    }

    public BIcon getIcon() {
        return icon;
    }
}

