/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.util;

import java.util.StringTokenizer;

public final class DrByteArrayUtil {
    private static final boolean LEADING_ZERO_DEFAULT = true;

    public static String toString(byte[] a) {
        return DrByteArrayUtil.toString(a, 16, ' ', a.length, 0, true);
    }

    public static String toString(byte[] a, int len) {
        return DrByteArrayUtil.toString(a, 16, ' ', len, 0, true);
    }

    public static String toString(byte[] a, int len, int offset) {
        return DrByteArrayUtil.toString(a, 16, ' ', len, offset, true);
    }

    public static String toString(byte[] a, boolean leadingZero) {
        return DrByteArrayUtil.toString(a, 16, ' ', a.length, 0, leadingZero);
    }

    public static String toString(byte[] a, char delimiter) {
        return DrByteArrayUtil.toString(a, 16, delimiter, a.length, 0, true);
    }

    public static String toString(byte[] a, char delimiter, int len) {
        return DrByteArrayUtil.toString(a, 16, delimiter, len, 0, true);
    }

    public static String toString(byte[] a, int radix, char delimiter, int len) {
        return DrByteArrayUtil.toString(a, radix, delimiter, len, 0, true);
    }

    public static String toString(byte[] a, int radix, char delimiter, int len, int offset) {
        return DrByteArrayUtil.toString(a, radix, delimiter, len, offset, true);
    }

    public static String toString(byte[] a, int radix, char delimiter, int len, int offset, boolean leadingZero) {
        StringBuilder sb = new StringBuilder();
        int dispLen = Integer.toString(255, radix).length();
        if (offset + len > a.length) {
            len = a.length - offset;
        }
        if (len == 0) {
            return "";
        }
        int bytes = len + offset;
        for (int i = offset; i < bytes; ++i) {
            if (i > offset) {
                sb.append(delimiter);
            }
            String s = Integer.toString(a[i] & 0xFF, radix);
            if (leadingZero) {
                for (int n = s.length(); n < dispLen; ++n) {
                    sb.append('0');
                }
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static byte[] getBytes(String s) {
        return DrByteArrayUtil.getBytes(s, -1, 16);
    }

    public static byte[] getBytes(String s, String del) {
        return DrByteArrayUtil.getBytes(s, del, -1, 16);
    }

    public static byte[] getBytes(String s, int length) {
        return DrByteArrayUtil.getBytes(s, length, 16);
    }

    public static byte[] getBytes(String s, int length, int radix) {
        return DrByteArrayUtil.getBytes(s, ":,. ;\\/", length, radix);
    }

    public static byte[] getBytes(String s, String del, int length, int radix) {
        byte[] b;
        StringTokenizer st = new StringTokenizer(s, del);
        int tokCnt = st.countTokens();
        if (tokCnt == 1) {
            int slen = s.length();
            if (length < 0) {
                length = (slen + 1) / 2;
            }
            b = new byte[length];
            for (int i = 0; i < length; ++i) {
                b[i] = slen >= i * 2 + 2 ? (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2).trim(), radix) : (slen == i * 2 + 1 ? (byte)Integer.parseInt(s.substring(i * 2).trim(), radix) : (byte)0);
            }
        } else {
            if (length < 0) {
                length = tokCnt;
            }
            b = new byte[length];
            for (int i = 0; i < length; ++i) {
                b[i] = st.hasMoreTokens() ? (byte)Integer.parseInt(st.nextToken().trim(), radix) : (byte)0;
            }
        }
        return b;
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        int len = a1.length;
        if (len != a2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }
}

