/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.sys.BValue;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public abstract class TaskDetailDialog
extends TaskDetailPane {
    protected DialogCancel cancelCommand;
    private BDialog dialog;
    private BButton closeButton;

    public boolean open() {
        this.dialog.setBoundsCenteredOnOwner();
        new Thread(this).start();
        this.dialog.open();
        return this.update() == BJobState.success;
    }

    public BDialog getDialog() {
        return this.dialog;
    }

    public abstract String getDialogTitle();

    public abstract String getHeadingTitle();

    public String getHeadingDescription() {
        return null;
    }

    public BImage getHeadingIcon() {
        return null;
    }

    protected void init(BWidget owner) {
        super.init();
        BGridPane headingGrid = new BGridPane(2);
        headingGrid.setHalign(BHalign.left);
        headingGrid.setColumnAlign(BHalign.fill);
        headingGrid.setValign(BValign.top);
        headingGrid.setStretchColumn(1);
        if (this.getHeadingIcon() == null) {
            headingGrid.add(null, (BValue)new BNullWidget());
        } else {
            headingGrid.add(null, (BValue)new BLabel(this.getHeadingIcon()));
        }
        BGridPane headingRight = new BGridPane(1);
        headingRight.setHalign(BHalign.left);
        headingRight.setColumnAlign(BHalign.fill);
        headingRight.setValign(BValign.top);
        headingRight.setStretchColumn(0);
        BLabel headingLabel = new BLabel(this.getHeadingTitle(), BHalign.left);
        headingRight.add(null, (BValue)headingLabel);
        headingLabel.setFont(Theme.widget().getLargeBoldFont());
        if (this.getHeadingDescription() != null) {
            headingRight.add(null, (BValue)new BLabel(this.getHeadingDescription(), BHalign.left));
        }
        headingGrid.add(null, (BValue)headingRight);
        BBorderPane headingBorder = new BBorderPane((BWidget)headingGrid, BBorder.make((String)"bottom(solid)"));
        headingBorder.setFill(Theme.widget().getControlHeader());
        BButtonPane buttons = new BButtonPane();
        this.closeButton = new BButton();
        buttons.add((BWidget)this.closeButton);
        this.dialog = new BDialog(owner, this.getDialogTitle(), true, (BWidget)new BEdgePane((BWidget)headingBorder, (BWidget)new BEdgePane((BWidget)new BBox(660.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)buttons, 0.0, 10.0, 10.0, 10.0)), (BWidget)new BBox(0.0, 480.0), null, (BWidget)new BBorderPane(this.getPane(), 10.0, 10.0, 10.0, 10.0)));
        this.cancelCommand = new DialogCancel();
        this.closeButton.setCommand((Command)this.cancelCommand, true, false);
    }

    @Override
    public void setCancelEnabled(boolean value) {
        super.setCancelEnabled(value);
        this.cancelCommand.setEnabled(value);
    }

    @Override
    protected BJobState update() {
        BJobState result = super.update();
        if (result == BJobState.failed || result == BJobState.canceled || result == BJobState.success) {
            this.closeButton.setCommand((Command)new DialogClose(), true, false);
        }
        return result;
    }

    private class DialogCancel
    extends Command {
        private Lexicon lex;

        public DialogCancel() {
            super((BWidget)TaskDetailDialog.this.dialog, UiLexicon.bajaui().getText("action.cancel"));
            this.lex = Lexicon.make((String)"platDaemon");
        }

        public CommandArtifact doInvoke() {
            TaskDetailDialog.this.getLog().append("\n");
            TaskDetailDialog.this.getLog().append(this.lex.getText("TaskDetailPane.output.cancelPending"));
            TaskDetailDialog.this.getLog().append("\n");
            TaskDetailDialog.this.cancel();
            return null;
        }
    }

    private class DialogClose
    extends Command {
        public DialogClose() {
            super((BWidget)TaskDetailDialog.this.dialog, UiLexicon.bajaui().getText("commands.close.label"));
        }

        public CommandArtifact doInvoke() {
            TaskDetailDialog.this.dialog.close();
            return null;
        }
    }
}

