/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.tcpip;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.platform.ui.tcpip.BTcpIpHostEditor;
import com.tridium.platform.ui.util.AuditUtil;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.naming.BHost;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
public class BTcpIpConfiguration
extends BDaemonSessionView {
    @Generated
    public static final Type TYPE = Sys.loadType(BTcpIpConfiguration.class);
    private AuditUtil.ViewAuditCommand auditCommand;
    private BTcpIpHostSettings tcpIpHostSettings;
    private BDhcpdHostSettings dhcpdHostSettings;
    private BLinkCfgHostSettings linkCfgHostSettings;
    private final BTcpIpHostEditor hostEditor = new BTcpIpHostEditor();
    private final BScrollPane scrollPane;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTcpIpConfiguration() {
        BBrush backgroundBrush = Theme.scrollPane().getControlBackground();
        this.scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.hostEditor, 10.0, 10.0, 5.0, 10.0));
        this.scrollPane.setViewportBackground(backgroundBrush);
        this.tcpIpHostSettings = new BTcpIpHostSettings();
        this.dhcpdHostSettings = new BDhcpdHostSettings();
        this.linkCfgHostSettings = new BLinkCfgHostSettings();
        this.linkTo(null, (BComponent)this.hostEditor, (Slot)BTcpIpHostEditor.pluginModified, (Slot)setModified);
    }

    @Override
    protected void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        try {
            boolean readonly;
            BWbShell shell = this.getWbShell();
            if (shell != null) {
                BButtonPane buttons = new BButtonPane();
                buttons.addWorkbenchButtons((BWidget)this);
                this.auditCommand = new AuditUtil.ViewAuditCommand("ipchanges", (BWidget)this);
                buttons.add((Command)this.auditCommand);
                this.auditCommand.setEnabled(!this.isReadonly() && this.auditCommand.auditFileExists());
                BEdgePane edge = new BEdgePane();
                edge.setCenter((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.none, BInsets.DEFAULT));
                edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 10.0, 0.0, 10.0));
                this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)edge));
            } else {
                this.setContent((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.none, BInsets.DEFAULT));
            }
            TcpUtil.loadFromSession((BTcpIpHostSettings)this.tcpIpHostSettings, (BDaemonSession)session);
            if (session.getHostProperties().supportsServlet("dhcpd")) {
                DhcpdUtil.loadFromSession((BDhcpdHostSettings)this.dhcpdHostSettings, (BDaemonSession)session);
                DhcpdUtil.loadDhcpdConfFile((BDhcpdHostSettings)this.dhcpdHostSettings, (BDaemonSession)session);
                if (DhcpdUtil.fixDhcpdHostSettings((BDhcpdHostSettings)this.dhcpdHostSettings, (BTcpIpHostSettings)this.tcpIpHostSettings)) {
                    DhcpdUtil.saveToSession((BDhcpdHostSettings)this.dhcpdHostSettings, (BDaemonSession)session);
                }
                DhcpdUtil.copyDhcpdSlotToAdapters((BDhcpdHostSettings)this.dhcpdHostSettings, (BTcpIpHostSettings)this.tcpIpHostSettings);
            }
            if (session.getHostProperties().supportsServlet("linkcfg")) {
                LinkCfgUtil.loadFromSession((BLinkCfgHostSettings)this.linkCfgHostSettings, (BDaemonSession)session);
                LinkCfgUtil.loadLinkCfgFile((BLinkCfgHostSettings)this.linkCfgHostSettings, (BDaemonSession)session);
                LinkCfgUtil.copyLinkCfgSlotToHost((BLinkCfgHostSettings)this.linkCfgHostSettings, (BTcpIpHostSettings)this.tcpIpHostSettings);
            }
            this.hostEditor.loadValue((BObject)this.tcpIpHostSettings);
            boolean bl = readonly = this.isReadonly() || this.tcpIpHostSettings.getIsReadonly() || !session.getHostProperties().hasFullAccess();
            if (this.isReadonly() == readonly) {
                this.doSetReadonly(readonly);
            } else {
                this.setReadonly(readonly);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("platDaemon", "TcpIpConfiguration.parseError", (Throwable)e);
        }
    }

    protected void doSetReadonly(boolean readonly) {
        this.hostEditor.setReadonly(readonly);
        if (this.auditCommand != null) {
            this.auditCommand.setEnabled(!readonly && this.auditCommand.auditFileExists());
        }
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (this.tcpIpHostSettings.getIsReadonly()) {
            return value;
        }
        boolean hostFileDirty = this.hostEditor.isHostFileDirty();
        BTcpIpHostSettings oldTcpIpHostSettings = (BTcpIpHostSettings)this.tcpIpHostSettings.newCopy();
        BTcpIpHostSettings newTcpIpHostSettings = (BTcpIpHostSettings)this.hostEditor.saveValue();
        TcpUtil.saveToSession((BTcpIpHostSettings)newTcpIpHostSettings, (BDaemonSession)this.getDaemonSession(), (boolean)hostFileDirty);
        AuditUtil.audit((String)"ipchanges", (BHost)this.getDaemonSession().getHost(), (Type)TYPE, (BComponent)oldTcpIpHostSettings, (BComponent)newTcpIpHostSettings);
        this.tcpIpHostSettings = newTcpIpHostSettings;
        if (this.getDaemonSession().getHostProperties().supportsServlet("dhcpd")) {
            BDhcpdHostSettings newDhcpdHostSettings = (BDhcpdHostSettings)this.dhcpdHostSettings.newCopy();
            DhcpdUtil.copyDhcpdSlotFromAdapters((BDhcpdHostSettings)newDhcpdHostSettings, (BTcpIpHostSettings)this.tcpIpHostSettings);
            DhcpdUtil.fixDhcpdHostSettings((BDhcpdHostSettings)newDhcpdHostSettings, (BTcpIpHostSettings)this.tcpIpHostSettings);
            DhcpdUtil.saveToSession((BDhcpdHostSettings)newDhcpdHostSettings, (BDaemonSession)this.getDaemonSession());
            this.dhcpdHostSettings = newDhcpdHostSettings;
        }
        if (this.getDaemonSession().getHostProperties().supportsServlet("linkcfg")) {
            BLinkCfgHostSettings newLinkCfgHostSettings = (BLinkCfgHostSettings)this.linkCfgHostSettings.newCopy();
            LinkCfgUtil.copyLinkCfgSlotFromHost((BLinkCfgHostSettings)newLinkCfgHostSettings, (BTcpIpHostSettings)this.tcpIpHostSettings);
            LinkCfgUtil.saveToSession((BLinkCfgHostSettings)newLinkCfgHostSettings, (BDaemonSession)this.getDaemonSession());
            this.linkCfgHostSettings = newLinkCfgHostSettings;
        }
        this.promptForReboot(true);
        return value;
    }
}

