/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.softwaremanager.BSoftwareManager;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.util.LabelUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

class CommitCommand
extends AsyncCommand {
    private final BSoftwareManager installer;
    private final Object INVOKE_MONITOR = new Object();
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");

    public CommitCommand(BSoftwareManager installer) {
        super((BWidget)installer, installer.getType().getModule(), "SoftwareManager.command.installNow");
        this.installer = installer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        try {
            Object object = this.INVOKE_MONITOR;
            synchronized (object) {
                BStationStatus status;
                BDaemonSession session = this.installer.getDaemonSession();
                boolean mustReboot = false;
                Array runningApps = new Array(BAppSurrogate.class);
                long flags = this.installer.tableModel.getScenario().getProcessingFlags();
                if ((flags & 4L) > 0L && (flags & 1L) == 0L && (flags & 2L) == 0L) {
                    BAppSurrogate[] applications;
                    for (BAppSurrogate app : applications = this.installer.getAppSurrogates()) {
                        status = app.getAppStatus();
                        if (!(app instanceof BStationSurrogate) || status != BStationStatus.starting && status != BStationStatus.stopping) continue;
                        flags |= 2L;
                        break;
                    }
                }
                if ((flags & 1L) > 0L || (flags & 2L) > 0L || (flags & 4L) > 0L) {
                    BAppSurrogate[] apps;
                    for (BAppSurrogate app : apps = this.installer.getAppSurrogates()) {
                        status = app.getAppStatus();
                        if (status != BStationStatus.starting && status != BStationStatus.running && status != BStationStatus.stopping || (flags & 1L) <= 0L && !(app instanceof BStationSurrogate)) continue;
                        runningApps.add((Object)app);
                    }
                    if (((flags & 1L) > 0L || (flags & 2L) > 0L) && runningApps.size() > 0) {
                        if (session.getHostProperties().getAllowStationRestart()) {
                            if (1 != BDialog.confirm((BWidget)this.installer, (String)lex.getText("CommitCommand.stopApps.title"), (Object)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platDaemon", (String)"CommitCommand.stopApps.message")), (int)3)) {
                                return;
                            }
                        } else {
                            mustReboot = true;
                        }
                    }
                }
                if ((flags & 0x10000L) > 0L) {
                    mustReboot = true;
                }
                if (mustReboot && 4 != BDialog.confirm((BWidget)this.installer, (String)lex.getText("CommitCommand.promptReboot.title"), (Object)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platDaemon", (String)"CommitCommand.promptReboot.message")), (int)12)) {
                    return;
                }
                if (((flags & 1L) > 0L || (flags & 2L) > 0L) && runningApps.size() > 0) {
                    runningApps.clear();
                    runningApps.addAll((Object[])BAppSurrogate.stopAllApps((BDaemonSession)session, (Type)((flags & 1L) > 0L ? null : BStationSurrogate.TYPE), null, (DaemonSessionTaskListener)this.installer));
                }
                try {
                    BWbShell shell = this.installer.getWbShell();
                    try {
                        if (shell != null) {
                            shell.enterBusy();
                        }
                        InstallScenario scenario = this.installer.tableModel.getScenario();
                        scenario.setIgnoreDhcpdTransfer((flags & 0x80000L) == 0L);
                        scenario.setIgnoreLinkTransfer((flags & 0x80000L) == 0L);
                        scenario.commit((DaemonSessionTaskListener)this.installer, (ICancelHint)this.installer);
                        this.installer.tableModel.resetScenario();
                    }
                    finally {
                        if (shell != null) {
                            shell.exitBusy();
                        }
                    }
                    session.getHostProperties().reset();
                    BRemoteDaemonPlatform.make((BDaemonSession)session, null).requestReload();
                    if ((flags & 0x20000L) > 0L && session.getHostProperties().supportsServlet("osupdate")) {
                        session.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
                    }
                    if ((flags & 0x80000L) > 0L) {
                        BTcpIpHostSettings changes = this.installer.tableModel.getScenario().getTcpIpChanges();
                        BTcpIpHostSettings currentHostSettings = new BTcpIpHostSettings();
                        TcpUtil.loadFromSession((BTcpIpHostSettings)currentHostSettings, (BDaemonSession)session);
                        if (changes != null && !changes.getIsReadonly() && !currentHostSettings.getIsReadonly()) {
                            TcpUtil.saveToSession((BTcpIpHostSettings)changes, (BDaemonSession)session, (boolean)false);
                        }
                    }
                    if (mustReboot) {
                        session.sendRebootRequest();
                        if (shell != null) {
                            BDialog.message((BWidget)shell, (String)lex.getText("DaemonSessionView.reboot.notifyTitle", new Object[]{session.getRemoteAddressString()}), (Object)lex.getText("DaemonSessionView.reboot.notifyMessage", new Object[]{session.getRemoteAddressString()}));
                        }
                    } else if ((flags & 0x40000L) > 0L) {
                        if (4 == BDialog.confirm((BWidget)this.installer, (String)lex.getText("CommitCommand.updateDaemon.title"), (Object)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platDaemon", (String)"CommitCommand.updateDaemon.message")), (int)12)) {
                            session.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception changes) {}
                        }
                    } else {
                        this.installer.tableModel.rebuild();
                        BAppSurrogate[] apps = (BAppSurrogate[])runningApps.trim();
                        if (apps.length > 0) {
                            if ((flags & 1L) == 0L && (flags & 2L) == 0L) {
                                for (BAppSurrogate app : apps) {
                                    if (!(app instanceof BStationSurrogate)) continue;
                                    ((BStationSurrogate)app).syncStationModulesAsync();
                                }
                            } else {
                                StringBuilder appNames = new StringBuilder();
                                for (BAppSurrogate app : apps) {
                                    if (appNames.length() > 0) {
                                        appNames.append(", ");
                                    }
                                    appNames.append("\"");
                                    appNames.append(app.getAppName());
                                    appNames.append("\"");
                                    app.startAppAsync();
                                }
                                if (shell == null) {
                                    BDialog.message((BWidget)this.installer, (String)lex.getText("CommitCommand.restartApp.title"), (Object)lex.getText("CommitCommand.restartApp.message", new Object[]{appNames}));
                                } else if (this.openApplicationDirector(appNames.toString())) {
                                    shell.hyperlink(BOrd.make((BOrd)session.getNavOrd(), (OrdQuery)BViewScheme.INSTANCE.parse("platDaemon:ApplicationDirector")));
                                }
                            }
                        }
                    }
                }
                catch (ICancelHint.CanceledException ce) {
                    BDialog.message((BWidget)this.installer, (Object)LexiconText.make((String)"platform", (String)"canceled.label").getText(null));
                }
            }
        }
        catch (ICancelHint.CanceledException ce) {
            BDialog.message((BWidget)this.installer, (Object)LexiconText.make((String)"platform", (String)"canceled.label").getText(null));
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
    }

    private boolean openApplicationDirector(String appNames) {
        boolean open;
        try {
            BOptions options = BOptions.load((String)BSoftwareManager.TYPE.toString(), (Type)BOptions.TYPE);
            BBoolean b = (BBoolean)options.get("openApplicationDirector");
            if (b == null) {
                BGridPane grid = new BGridPane(1);
                grid.setRowGap(12.0);
                BCheckBox checkBox = new BCheckBox(BDaemonSessionView.lexicon.getText("CommitCommand.openApplicationDirector.dontAsk"), false);
                grid.add(null, (BValue)new BLabel(BDaemonSessionView.lexicon.getText("CommitCommand.openApplicationDirector.question", new Object[]{appNames})));
                grid.add(null, (BValue)checkBox);
                boolean bl = open = 4 == BDialog.confirm((BWidget)this.installer, (String)BDaemonSessionView.lexicon.getText("CommitCommand.openApplicationDirector.dlgTitle"), (Object)new BBorderPane((BWidget)grid, 0.0, 5.0, 5.0, 5.0));
                if (checkBox.isSelected()) {
                    options.add("openApplicationDirector", (BValue)BBoolean.make((boolean)open));
                    options.save();
                }
            } else {
                BDialog.message((BWidget)this.installer, (String)lex.getText("CommitCommand.restartApp.title"), (Object)lex.getText("CommitCommand.restartApp.message", new Object[]{appNames}));
                open = b.getBoolean();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return open;
    }
}

