/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.platDaemon.ui.softwaremanager.BInstallerTableRowFilter;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="statusString", type="String", defaultValue="")
public class BStatusFilter
extends BInstallerTableRowFilter {
    @Generated
    public static final Property statusString = BStatusFilter.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStatusFilter.class);
    private int[] statusValues;
    private boolean formatting = false;
    private static Map<String, Array<Integer>> statusTextMap = null;

    @Generated
    public String getStatusString() {
        return this.getString(statusString);
    }

    @Generated
    public void setStatusString(String v) {
        this.setString(statusString, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStatusFilter() {
        this(new int[0]);
    }

    public BStatusFilter(int[] values) {
        this.statusValues = values;
        this.formatStatusString();
    }

    @Override
    protected synchronized boolean doAccept(InstallerTableRow row) {
        for (int statusValue : this.statusValues) {
            if (row.getStatus() != statusValue) continue;
            return true;
        }
        return false;
    }

    public synchronized void include(int value) {
        this.include(new int[]{value});
    }

    public synchronized void include(int[] values) {
        boolean updated = false;
        for (int value : values) {
            int ix;
            if (value == 3 || value == 12 || value == 4 || (ix = this.indexOf(value)) >= 0) continue;
            int[] temp = new int[this.statusValues.length + 1];
            temp[0] = value;
            System.arraycopy(this.statusValues, 0, temp, 1, this.statusValues.length);
            this.statusValues = temp;
            updated = true;
        }
        if (updated) {
            this.formatStatusString();
        }
    }

    public synchronized void exclude(int value) {
        this.exclude(new int[]{value});
    }

    public synchronized void exclude(int[] values) {
        boolean updated = false;
        for (int value : values) {
            int ix;
            if (value == 3 || value == 12 || value == 4 || (ix = this.indexOf(value)) < 0) continue;
            int[] temp = new int[this.statusValues.length - 1];
            if (ix > 0) {
                System.arraycopy(this.statusValues, 0, temp, 0, ix);
            }
            if (ix < this.statusValues.length - 1) {
                System.arraycopy(this.statusValues, ix + 1, temp, ix, this.statusValues.length - ix - 1);
            }
            this.statusValues = temp;
            updated = true;
        }
        if (updated) {
            this.formatStatusString();
        }
    }

    private synchronized int indexOf(int statusValue) {
        for (int i = 0; i < this.statusValues.length; ++i) {
            if (this.statusValues[i] != statusValue) continue;
            return i;
        }
        return -1;
    }

    public String[] getStatusStrings() {
        return TextUtil.split((String)this.getStatusString(), (char)'|');
    }

    public static String[] getAvailableStrings() {
        return new String[]{BStatusFilter.statusToString(6), BStatusFilter.statusToString(13), BStatusFilter.statusToString(2), BStatusFilter.statusToString(7), BStatusFilter.statusToString(8), BStatusFilter.statusToString(11)};
    }

    public static String statusToString(int status) {
        switch (status) {
            case 6: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.notInstalled");
            }
            case 13: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.needCommissioningMissing");
            }
            case 1: 
            case 2: 
            case 5: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.upToDate");
            }
            case 7: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.badInstallable");
            }
            case 8: 
            case 9: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.badTarget");
            }
            case 11: {
                return TYPE.getModule().getLexicon().getText("SoftwareManager.status.noLocal");
            }
        }
        return "";
    }

    public static int[] stringToStatus(String string) {
        Array<Integer> list = BStatusFilter.getStatusTextMap().get(string);
        if (list == null) {
            return new int[0];
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    private static Map<String, Array<Integer>> getStatusTextMap() {
        if (statusTextMap == null) {
            statusTextMap = new HashMap<String, Array<Integer>>();
            BStatusFilter.updateMapEntry(0, statusTextMap);
            BStatusFilter.updateMapEntry(1, statusTextMap);
            BStatusFilter.updateMapEntry(2, statusTextMap);
            BStatusFilter.updateMapEntry(5, statusTextMap);
            BStatusFilter.updateMapEntry(6, statusTextMap);
            BStatusFilter.updateMapEntry(13, statusTextMap);
            BStatusFilter.updateMapEntry(7, statusTextMap);
            BStatusFilter.updateMapEntry(8, statusTextMap);
            BStatusFilter.updateMapEntry(9, statusTextMap);
            BStatusFilter.updateMapEntry(11, statusTextMap);
        }
        return statusTextMap;
    }

    private static void updateMapEntry(int status, Map<String, Array<Integer>> map) {
        String key = BStatusFilter.statusToString(status);
        Array currentEntry = map.get(key);
        if (currentEntry == null) {
            currentEntry = new Array(Integer.class);
            map.put(key, (Array<Integer>)currentEntry);
        }
        currentEntry.add((Object)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseStatusString() {
        if (this.formatting) {
            return;
        }
        Property property = statusString;
        synchronized (property) {
            String[] tokens = this.getStatusStrings();
            int[] temp = new int[50];
            int ix = 0;
            for (String token : tokens) {
                int[] toAdd;
                for (int aToAdd : toAdd = BStatusFilter.stringToStatus(token)) {
                    temp[ix++] = aToAdd;
                }
            }
            int[] result = new int[ix];
            System.arraycopy(temp, 0, result, 0, ix);
            this.statusValues = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatStatusString() {
        Property property = statusString;
        synchronized (property) {
            this.formatting = true;
            StringBuilder result = new StringBuilder();
            HashSet<String> set = new HashSet<String>();
            for (int statusValue : this.statusValues) {
                set.add(BStatusFilter.statusToString(statusValue));
            }
            Object object = set.iterator();
            while (object.hasNext()) {
                String statusString = (String)object.next();
                if (result.length() > 0) {
                    result.append("|");
                }
                result.append(statusString);
            }
            this.setStatusString(result.toString());
            this.formatting = false;
        }
    }

    public void changed(Property property, Context context) {
        if (property == statusString) {
            this.parseStatusString();
        }
    }
}

