/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.softwaremanager.BInstallerTableFilterPrompt;
import com.tridium.platDaemon.ui.softwaremanager.BPartDetailsPane;
import com.tridium.platDaemon.ui.softwaremanager.BSoftwareManagerFilter;
import com.tridium.platDaemon.ui.softwaremanager.CancelDowngradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelInstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelReinstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelUninstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.CancelUpgradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.CommitCommand;
import com.tridium.platDaemon.ui.softwaremanager.DowngradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.ImportFromPlatformCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallVersionCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallerCellRenderer;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platDaemon.ui.softwaremanager.RebuildSignatureRegistryCommand;
import com.tridium.platDaemon.ui.softwaremanager.ReinstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.ResetCommand;
import com.tridium.platDaemon.ui.softwaremanager.UninstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.UpgradeCommand;
import com.tridium.platDaemon.ui.softwaremanager.UpgradeOutOfDateCommand;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.net.ConnectException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.IInsets;
import javax.baja.gx.Insets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@NiagaraActions(value={@NiagaraAction(name="handleTableModified"), @NiagaraAction(name="handleSelectionModified")})
public class BSoftwareManager
extends BDaemonSessionView {
    @Generated
    public static final Action handleTableModified = BSoftwareManager.newAction((int)0, null);
    @Generated
    public static final Action handleSelectionModified = BSoftwareManager.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSoftwareManager.class);
    BTable table;
    InstallerTableModel tableModel;
    private final BButton leftButton;
    private final BButton rightButton;
    private static String swPath = null;
    private final BLabel currentSpaceLabel;
    private final BLabel spaceDeltaLabel;
    private final BLabel afterSpaceLabel;
    private long currentFreeSpace;
    boolean trapSelectionModified = true;
    private final AsyncCommand cancelInstallCommand;
    private final AsyncCommand cancelUninstallCommand;
    private final AsyncCommand cancelUpgradeCommand;
    private final AsyncCommand cancelReinstallCommand;
    private final AsyncCommand cancelDowngradeCommand;
    private final AsyncCommand commitCommand;
    private final AsyncCommand installCommand;
    private final AsyncCommand resetCommand;
    private final AsyncCommand uninstallCommand;
    private final AsyncCommand upgradeCommand;
    private final AsyncCommand reinstallCommand;
    private final AsyncCommand downgradeCommand;
    private final AsyncCommand upgradeOODCommand;
    private final AsyncCommand rebuildSignatureRegistryCommand;
    private final Command[] leftButtonCommands;
    private final Command[] rightButtonCommands;
    private static final Version REBUILD_SIGNATURE_REGISTRY_MIN_VERSION = new Version("4.13");

    @Generated
    public void handleTableModified() {
        this.invoke(handleTableModified, null, null);
    }

    @Generated
    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSoftwareManager() {
        BGridPane spacePane = new BGridPane(7);
        BLabel bigSpaceLabel = new BLabel(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(88888888L));
        bigSpaceLabel.computePreferredSize();
        BLabel smallSpaceLabel = new BLabel(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(88888L));
        smallSpaceLabel.computePreferredSize();
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)bigSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)smallSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)bigSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.setHalign(BHalign.left);
        BButton button = new BButton((Command)new EditFilterCommand(), false, true);
        spacePane.add("editFilter", (BValue)button);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((Type)TYPE, (String)"SoftwareManager.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((Type)TYPE, (String)"SoftwareManager.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((Type)TYPE, (String)"SoftwareManager.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane topPane = new BGridPane(1);
        topPane.setHalign(BHalign.left);
        topPane.add(null, (BValue)new BBorderPane((BWidget)spacePane, 0.0, 0.0, 4.0, 0.0));
        this.tableModel = new InstallerTableModel();
        this.table = new BTable((TableModel)this.tableModel);
        this.tableModel.setFilter(this.loadFilter());
        this.table.setCellRenderer((TableCellRenderer)new InstallerCellRenderer());
        this.table.setController((TableController)new ModuleTableController());
        AsyncGroup commandGroup = new AsyncGroup();
        this.cancelInstallCommand = new CancelInstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelInstallCommand);
        this.cancelUninstallCommand = new CancelUninstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelUninstallCommand);
        this.cancelUpgradeCommand = new CancelUpgradeCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelUpgradeCommand);
        this.cancelReinstallCommand = new CancelReinstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelReinstallCommand);
        this.cancelDowngradeCommand = new CancelDowngradeCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.cancelDowngradeCommand);
        this.commitCommand = new CommitCommand(this);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.commitCommand);
        this.rebuildSignatureRegistryCommand = new RebuildSignatureRegistryCommand(this);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.rebuildSignatureRegistryCommand);
        this.installCommand = new InstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.installCommand);
        this.resetCommand = new ResetCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.resetCommand);
        this.uninstallCommand = new UninstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.uninstallCommand);
        this.upgradeCommand = new UpgradeCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeCommand);
        this.reinstallCommand = new ReinstallCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.reinstallCommand);
        this.downgradeCommand = new DowngradeCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.downgradeCommand);
        this.upgradeOODCommand = new UpgradeOutOfDateCommand((BWidget)this, this.tableModel);
        commandGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeOODCommand);
        this.resetCommand.setEnabled(false);
        this.installCommand.setEnabled(false);
        this.uninstallCommand.setEnabled(false);
        this.commitCommand.setEnabled(false);
        this.upgradeOODCommand.setEnabled(false);
        this.rebuildSignatureRegistryCommand.setEnabled(false);
        this.leftButtonCommands = new Command[]{this.installCommand, this.reinstallCommand, this.upgradeCommand, this.downgradeCommand, this.cancelInstallCommand, this.cancelUpgradeCommand, this.cancelUpgradeCommand, this.cancelDowngradeCommand};
        this.rightButtonCommands = new Command[]{this.uninstallCommand, this.cancelUninstallCommand};
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
        this.linkTo((BComponent)this.table, (Slot)BTable.tableModified, (Slot)handleTableModified);
        Insets buttonInsets = new Insets(4.0, 3.0, 4.0, 3.0);
        BFlowPane buttonPane = new BFlowPane(BHalign.center);
        button = new BButton((Command)this.upgradeOODCommand, true, false);
        buttonPane.add("upgradeOOD", (BValue)button);
        button.setPadding(BInsets.make((IInsets)buttonInsets));
        button = new BButton((Command)this.rebuildSignatureRegistryCommand, true, false);
        buttonPane.add("rebuildSignatureRegistryButton", (BValue)button);
        button.setPadding(BInsets.make((IInsets)buttonInsets));
        buttonPane.add("spacer1", (BValue)new BBox(3.0, 0.0));
        button = new BButton((Command)new ImportSoftwareCommand(), true, false);
        button.setPadding(BInsets.make((IInsets)buttonInsets));
        button.setMenuController((BAbstractButton.MenuController)new ImportMenuController());
        buttonPane.add("import", (BValue)button);
        buttonPane.add("spacer2", (BValue)new BBox(3.0, 0.0));
        this.leftButton = new BButton((Command)this.installCommand, true, false);
        buttonPane.add("leftButton", (BValue)this.leftButton);
        this.leftButton.setPadding(BInsets.make((IInsets)buttonInsets));
        this.rightButton = new BButton((Command)this.uninstallCommand, true, false);
        buttonPane.add("rightButton", (BValue)this.rightButton);
        this.rightButton.setPadding(BInsets.make((IInsets)buttonInsets));
        BButton resetButton = new BButton((Command)this.resetCommand, true, false);
        buttonPane.add("resetButton", (BValue)resetButton);
        resetButton.setPadding(BInsets.make((IInsets)buttonInsets));
        BButton commitButton = new BButton((Command)this.commitCommand, true, false);
        buttonPane.add("commitButton", (BValue)commitButton);
        commitButton.setPadding(BInsets.make((IInsets)buttonInsets));
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)topPane, 0.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)buttonPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT), 0.0, 4.0, 0.0, 0.0)));
    }

    @Override
    protected final void doLoadSession(BDaemonSession value, Context cx) throws AuthenticationException {
        try {
            LocalInstallableRegistry.getInstance().init((DaemonSessionTaskListener)this);
            this.tableModel.init(value, this);
            this.currentFreeSpace = DaemonFileUtil.getFilesystemAttributes((BDaemonSession)value, (FilePath)SystemFilePaths.getModulesPath((boolean)value.getHostProperties().getIsNiagaraHomeReadonly())).getFreeSpace();
            this.currentSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(this.currentFreeSpace));
            this.spaceDeltaLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(0L));
            this.afterSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(this.currentFreeSpace));
        }
        catch (ConnectException connectException) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected BSoftwareManagerFilter loadFilter() {
        BSoftwareManagerFilter result;
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            result = (BSoftwareManagerFilter)options.get("filter");
            if (result == null) {
                result = new BSoftwareManagerFilter();
            }
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.WARNING, "Failed to load filter, returning default", e);
            result = new BSoftwareManagerFilter();
        }
        return result;
    }

    protected void saveFilter(BSoftwareManagerFilter filter) {
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            if (options.get("filter") == null) {
                options.add("filter", filter.newCopy());
            } else {
                options.set("filter", filter.newCopy());
            }
            options.save();
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.WARNING, "Failed to save filter", e);
        }
    }

    public void doHandleTableModified() {
        boolean enableCommit = false;
        boolean enableUpgradeOOD = false;
        if (!this.getDaemonSession().usesLocalNiagaraHome() && !this.getDaemonSession().getHostProperties().getIsSoftwareReadonly()) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                int status;
                if (this.tableModel.getInstallStatusAt(i) != BPartInstallStatus.noChange && this.tableModel.getInstallStatusAt(i) != BPartInstallStatus.notFound) {
                    enableCommit = true;
                }
                if ((status = this.tableModel.getStatusAt(i)) == 3 || status == 4) {
                    enableUpgradeOOD = true;
                }
                if (enableCommit && enableUpgradeOOD) break;
            }
        }
        this.commitCommand.setEnabled(enableCommit);
        this.upgradeOODCommand.setEnabled(enableUpgradeOOD);
        Version remoteVersion = new Version(this.getDaemonSession().getHostProperties().getDaemonVersion());
        this.rebuildSignatureRegistryCommand.setEnabled(remoteVersion.compareTo(REBUILD_SIGNATURE_REGISTRY_MIN_VERSION) >= 0);
        long freeSpaceDeltaKb = (int)(this.tableModel.getSizeDeltaOnCommit() / 1024L);
        this.spaceDeltaLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(freeSpaceDeltaKb));
        long proposedFreeSpace = this.currentFreeSpace - freeSpaceDeltaKb;
        this.afterSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(proposedFreeSpace));
        this.handleSelectionModified();
    }

    public void doHandleSelectionModified() {
        if (!this.trapSelectionModified) {
            return;
        }
        boolean isSoftwareReadonly = this.getDaemonSession().getHostProperties().getIsSoftwareReadonly();
        this.resetCommand.setEnabled(!isSoftwareReadonly);
        int[] rows = this.table.getSelection().getRows();
        if (rows.length == 0) {
            this.setLeftButtonCommand((Command)this.installCommand, false);
            this.setRightButtonCommand((Command)this.uninstallCommand, false);
            return;
        }
        if (rows.length > 1) {
            BPartInstallStatus testAction = this.tableModel.getInstallStatusAt(rows[0]);
            for (int i = 1; i < rows.length; ++i) {
                if (this.tableModel.getInstallStatusAt(rows[i]) == testAction) continue;
                this.setLeftButtonCommand((Command)this.installCommand, false);
                this.setRightButtonCommand((Command)this.uninstallCommand, false);
                return;
            }
        }
        if (this.tableModel.getInstallStatusAt(rows[0]) == BPartInstallStatus.noChange || this.tableModel.getInstallStatusAt(rows[0]) == BPartInstallStatus.notFound) {
            AsyncCommand lc = null;
            boolean lcEnable = !isSoftwareReadonly;
            boolean rcEnable = !isSoftwareReadonly;
            boolean anyCurrent = false;
            for (int row : rows) {
                int rowStatus = this.tableModel.getStatusAt(row);
                if (this.tableModel.getInstallableVersionAt(row) == null) {
                    lc = this.installCommand;
                    lcEnable = false;
                } else {
                    switch (rowStatus) {
                        case 7: 
                        case 9: {
                            lc = this.installCommand;
                            lcEnable = false;
                            break;
                        }
                        case 0: 
                        case 6: 
                        case 13: {
                            lc = this.installCommand;
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 5: 
                        case 8: {
                            if (lc != null) break;
                            lc = this.reinstallCommand;
                            break;
                        }
                        case 3: 
                        case 12: {
                            if (lc != null) break;
                            lc = this.upgradeCommand;
                            break;
                        }
                        default: {
                            if (lc != null) break;
                            lc = this.downgradeCommand;
                        }
                    }
                }
                if (this.getDaemonSession().usesLocalNiagaraHome()) {
                    rcEnable = false;
                    lcEnable = false;
                    continue;
                }
                if (rowStatus == 0 || rowStatus == 6) {
                    rcEnable = false;
                    continue;
                }
                if (!rcEnable) continue;
                anyCurrent = true;
                if (this.tableModel.isModule(row)) {
                    BModulePart mp = (BModulePart)this.tableModel.getCurrentPartAt(row);
                    if (mp != null && !mp.getPartName().equals("wbapplet") && !mp.getPartName().equals("build")) continue;
                    rcEnable = false;
                    continue;
                }
                rcEnable = false;
            }
            if (lc == null) {
                this.setLeftButtonCommand((Command)this.installCommand, false);
            } else {
                this.setLeftButtonCommand((Command)lc, lcEnable);
            }
            this.setRightButtonCommand((Command)this.uninstallCommand, rcEnable && anyCurrent);
        } else {
            switch (this.tableModel.getInstallStatusAt(rows[0]).getOrdinal()) {
                case 2: {
                    this.setLeftButtonCommand((Command)this.cancelInstallCommand, !isSoftwareReadonly);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 3: {
                    this.setLeftButtonCommand((Command)this.cancelUpgradeCommand, !isSoftwareReadonly);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 5: {
                    this.setLeftButtonCommand((Command)this.cancelDowngradeCommand, !isSoftwareReadonly);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 4: {
                    this.setLeftButtonCommand((Command)this.cancelReinstallCommand, !isSoftwareReadonly);
                    this.setRightButtonCommand((Command)this.uninstallCommand, false);
                    return;
                }
                case 6: {
                    this.setLeftButtonCommand((Command)this.installCommand, false);
                    this.setRightButtonCommand((Command)this.cancelUninstallCommand, !isSoftwareReadonly);
                    return;
                }
            }
            BDaemonSessionView.log.warning("unrecognized action " + this.tableModel.getInstallStatusAt(rows[0]));
        }
    }

    private static String getSwPath() {
        if (swPath == null) {
            try {
                swPath = BFileSystem.INSTANCE.pathToLocalFile(new FilePath("!sw")).getCanonicalPath();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return swPath;
    }

    private void setLeftButtonCommand(Command command, boolean enable) {
        for (Command leftButtonCommand : this.leftButtonCommands) {
            leftButtonCommand.setEnabled(leftButtonCommand == command && enable);
        }
        if (command != this.leftButton.getCommand()) {
            this.leftButton.setCommand(command, true, false);
            this.leftButton.relayout();
            this.relayout();
        }
    }

    private void setRightButtonCommand(Command command, boolean enable) {
        for (Command rightButtonCommand : this.rightButtonCommands) {
            rightButtonCommand.setEnabled(rightButtonCommand == command && enable);
        }
        if (command != this.rightButton.getCommand()) {
            this.rightButton.setCommand(command, true, false);
            this.rightButton.relayout();
            this.relayout();
        }
    }

    protected BOrd loadImportDirectory() {
        try {
            BOptions options = BOptions.load((Type)TYPE);
            return (BOrd)options.get("importDir");
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.SEVERE, "Failed to load import directory", e);
            return null;
        }
    }

    protected void saveImportDirectory(BOrd dir) {
        if (dir == null) {
            return;
        }
        try {
            BOptions options = BOptions.load((Type)TYPE);
            if (options.get("importDir") == null) {
                options.add("importDir", (BValue)dir);
            } else {
                options.set("importDir", (BValue)dir);
            }
            options.save();
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.SEVERE, "Failed to save import directory", e);
        }
    }

    private class ModuleTableController
    extends TableController {
        private ModuleTableController() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    new DetailCommand(row).invoke();
                } else {
                    super.cellPressed(event, row, column);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            boolean isSoftwareReadonly = BSoftwareManager.this.getDaemonSession().getHostProperties().getIsSoftwareReadonly();
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)new DetailCommand(row)), null);
            if (BSoftwareManager.this.table.getSelection().getRowCount() == 1 && (BSoftwareManager.this.tableModel.getInstallStatusAt(row) == BPartInstallStatus.noChange || BSoftwareManager.this.tableModel.getInstallStatusAt(row) == BPartInstallStatus.notFound)) {
                try {
                    HashMap rejected = new HashMap();
                    for (BInstallable inst : LocalInstallableRegistry.getInstance().getInstallables(BDependency.forModule((String)BSoftwareManager.this.tableModel.getNameAt(row)), (DaemonSessionTaskListener)BSoftwareManager.this)) {
                        if (!InstallScenario.listModule((InstallScenario)BSoftwareManager.this.tableModel.scenario, (BModuleInstallable)((BModuleInstallable)inst), rejected)) continue;
                        InstallVersionCommand installVersionCommand = new InstallVersionCommand(BSoftwareManager.this.tableModel, inst);
                        installVersionCommand.setEnabled(!isSoftwareReadonly);
                        menu.add(null, (BValue)new BActionMenuItem((Command)installVersionCommand), null);
                    }
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.WARNING, "Failed to build popup menu install version item", e);
                }
            } else {
                menu.add(null, (BValue)new BActionMenuItem(BSoftwareManager.this.leftButton.getCommand()), null);
            }
            menu.add(null, (BValue)new BActionMenuItem(BSoftwareManager.this.rightButton.getCommand()), null);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (BValue)new BActionMenuItem((Command)BSoftwareManager.this.upgradeOODCommand), null);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (BValue)new BActionMenuItem((Command)BSoftwareManager.this.commitCommand), null);
            menu.add(null, (BValue)new BActionMenuItem((Command)BSoftwareManager.this.resetCommand), null);
            menu.open((BWidget)BSoftwareManager.this.table, event.getX(), event.getY());
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }

    private class DetailCommand
    extends Command {
        private final int row;

        public DetailCommand(int pRow) {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.details");
            this.row = pRow;
        }

        public CommandArtifact doInvoke() {
            try {
                BPartDetailsPane detail = new BPartDetailsPane(BSoftwareManager.this.tableModel.getCertValidator(), BSoftwareManager.this.tableModel.getModuleVerificationMode());
                detail.loadValue(BSoftwareManager.this.tableModel.getCurrentPartAt(this.row), BSoftwareManager.this.tableModel.getInstallablePartAt(this.row), BSoftwareManager.this.tableModel.getTypeAt(this.row), BSoftwareManager.this.tableModel.getForwardDependenciesAt(this.row), BSoftwareManager.this.tableModel.getDependentPartsAt(this.row));
                BBrush bgcolor = Theme.scrollPane().getControlBackground();
                BScrollPane scrollpane = new BScrollPane((BWidget)new BBorderPane((BWidget)detail, 10.0, 10.0, 5.0, 10.0));
                scrollpane.setViewportBackground(bgcolor);
                scrollpane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane dlgContent = new BConstrainedPane((BWidget)scrollpane);
                dlgContent.setFixedSize(500.0, 350.0);
                BDialog.message((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.details.dlgTitle"), (Object)dlgContent);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class EditFilterCommand
    extends Command {
        public EditFilterCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.editFilter");
        }

        public CommandArtifact doInvoke() {
            try {
                BSoftwareManagerFilter filter = BInstallerTableFilterPrompt.getFilter((BWidget)BSoftwareManager.this, (BSoftwareManagerFilter)BSoftwareManager.this.tableModel.getFilter());
                if (filter != null) {
                    BSoftwareManager.this.tableModel.setFilter(filter);
                    BSoftwareManager.this.saveFilter(filter);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class ImportDirCommand
    extends AsyncCommand {
        public ImportDirCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.importDir");
        }

        public void doInvokeAsync() {
            try {
                BDirectoryChooser chooser = BDirectoryChooser.make((BWidget)BSoftwareManager.this);
                BOrd defDir = BSoftwareManager.this.loadImportDirectory();
                if (defDir != null) {
                    try {
                        chooser.setCurrentDirectory(defDir);
                    }
                    catch (UnresolvedException e) {
                        BOptions options = BOptions.load((Type)TYPE);
                        options.remove("importDir");
                        options.save();
                    }
                }
                chooser.setSpaces((BSpace[])new BFileSystem[]{BFileSystem.INSTANCE});
                BOrd ord = chooser.show();
                if (ord != null) {
                    BSoftwareManager.this.saveImportDirectory(chooser.getCurrentDirectory());
                    BDirectory d = (BDirectory)ord.get();
                    String filePath = ((BLocalFileStore)d.getStore()).getLocalFile().getCanonicalPath();
                    if (filePath.startsWith(BSoftwareManager.getSwPath())) {
                        BDialog.warning((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.title"), (Object)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.message", new Object[]{d.getFileName()}));
                        return;
                    }
                    LocalInstallableRegistry.getInstance().importDirectory(d, (DaemonSessionTaskListener)BSoftwareManager.this);
                    BSoftwareManager.this.tableModel.reload();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class ImportFileCommand
    extends AsyncCommand {
        public ImportFileCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.importFile");
        }

        public void doInvokeAsync() {
            try {
                BFileChooser chooser = BFileChooser.makeOpen((BWidget)BSoftwareManager.this);
                BOrd defDir = BSoftwareManager.this.loadImportDirectory();
                if (defDir != null) {
                    try {
                        chooser.setCurrentDirectory(defDir);
                    }
                    catch (UnresolvedException e) {
                        BOptions options = BOptions.load((Type)TYPE);
                        options.remove("importDir");
                        options.save();
                    }
                }
                chooser.setSpaces((BSpace[])new BFileSystem[]{BFileSystem.INSTANCE});
                BOrd[] ords = chooser.show(true);
                if (ords != null && ords.length > 0) {
                    BSoftwareManager.this.saveImportDirectory(chooser.getCurrentDirectory());
                    boolean anyRegistered = false;
                    for (BOrd ord1 : ords) {
                        BIFile f;
                        BObject o = ord1.get();
                        if (o instanceof BZipSpace) {
                            OrdQuery[] q = ord1.parse();
                            BOrd ord = BOrd.make((OrdQuery[])q, (int)0, (int)(q.length - 1));
                            f = (BIFile)ord.get();
                        } else {
                            f = (BIFile)o;
                        }
                        String filePath = ((BLocalFileStore)f.getStore()).getLocalFile().getCanonicalPath();
                        if (filePath.startsWith(BSoftwareManager.getSwPath())) {
                            BDialog.warning((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.title"), (Object)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.invalidSource.message", new Object[]{f.getFileName()}));
                            return;
                        }
                        BInstallable inst = BInstallable.make((BIFile)f);
                        if (inst == null) {
                            BDialog.warning((BWidget)BSoftwareManager.this, (String)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.notInstallable.title"), (Object)BSoftwareManager.this.getLexicon().getText("SoftwareManager.command.importSoftware.notInstallable.message", new Object[]{f.getFileName()}));
                            continue;
                        }
                        LocalInstallableRegistry.getInstance().register(inst, (DaemonSessionTaskListener)BSoftwareManager.this);
                        anyRegistered = true;
                    }
                    if (anyRegistered) {
                        BSoftwareManager.this.tableModel.reload();
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class ImportSoftwareCommand
    extends AsyncCommand {
        public ImportSoftwareCommand() {
            super((BWidget)BSoftwareManager.this, TYPE.getModule(), "SoftwareManager.command.importSoftware");
        }

        public void doInvokeAsync() {
        }
    }

    private class ImportMenuController
    implements BAbstractButton.MenuController {
        public boolean isMenuDistinct() {
            return false;
        }

        public BMenu getMenu(BAbstractButton button) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new ImportFileCommand());
            menu.add(null, (Command)new ImportDirCommand());
            if (BSoftwareManager.this.getDaemonSession().getHostProperties().isNiagara4()) {
                menu.add(null, (Command)new ImportFromPlatformCommand(BSoftwareManager.this));
            }
            return menu;
        }
    }
}

