/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.Jre8AzulDistLicenseFeatureFilter;
import com.tridium.install.Qnx7DistLicenseFeatureFilter;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.distinstall.BDistInstaller;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import java.security.AccessController;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.TableModel;

public class DistInstallerTableModel
extends TableModel {
    public static final int FILE_NAME_COL = 0;
    public static final int VERSION_COL = 1;
    public static final int STATUS_COL = 2;
    public static final int DESC_COL = 3;
    public static final int STATUS_DIFFERENT = 0;
    public static final int STATUS_WRONG_TARGET = 1;
    public static final int STATUS_SAME = 2;
    public static final int STATUS_UNMET_DEPS = 3;
    public static final int STATUS_INSUFFICIENT_PRIVS = 4;
    public static final int STATUS_OOD_DEPS = 5;
    public static final int STATUS_INVALID_FILE = 6;
    public static final int STATUS_EXCLUDED = 7;
    public static final int STATUS_NOT_INDEPENDENT = 8;
    private static final BIcon DIST_FILE_ICON_REF = BIcon.std((String)"modules.png");
    private BDaemonSession session = null;
    private BDirectory sourceDir = null;
    private Array<DistRow> distFiles = new Array(DistRow.class);
    private StoreCache storeCache;
    private DaemonSessionTaskListener taskListener;
    private ICancelHint cancelHint;
    private boolean isAdmin = false;
    private CertificateChainValidator certValidator;
    private List<LicenseInfo> licenses;

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.fileName");
            }
            case 1: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.version");
            }
            case 2: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.status");
            }
            case 3: {
                return BDaemonSessionView.lexicon.getText("DistInstaller.column.desc");
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getRowCount() {
        return this.distFiles.size();
    }

    public BDirectory getSourceDirectory() {
        return this.sourceDir;
    }

    public BRemoteDaemonPlatform getDaemonPlatform() {
        if (this.session == null) {
            return null;
        }
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.taskListener);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.getRow((int)row).dist.getInstallableFileName();
            }
            case 1: {
                return this.getRow((int)row).dist.getVersion();
            }
            case 2: {
                switch (this.getRow((int)row).status) {
                    case 5: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.oodDeps");
                    }
                    case 2: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.same");
                    }
                    case 1: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.wrongTarget");
                    }
                    case 3: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.unmetDeps");
                    }
                    case 0: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.different");
                    }
                    case 4: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.insufficientPrivs");
                    }
                    case 6: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.invalidFile");
                    }
                    case 7: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.excluded");
                    }
                    case 8: {
                        return BDistInstaller.TYPE.getModule().getLexicon().getText("DistInstaller.status.notIndependent");
                    }
                }
                return "";
            }
            case 3: {
                return this.getRow((int)row).dist.getDescription();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void init(BDaemonSession session, BDirectory sourceDirectory, DaemonSessionTaskListener taskListener, ICancelHint cancelHint) {
        this.taskListener = taskListener;
        this.session = session;
        this.sourceDir = sourceDirectory;
        this.storeCache = new StoreCache();
        this.cancelHint = cancelHint;
        this.isAdmin = session.getHostProperties().hasFullAccess();
        this.certValidator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(session));
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() throws AuthenticationException {
        if (this.session == null) {
            return;
        }
        long t0 = Clock.ticks();
        SignedDistFilter.resetVerificationCache();
        this.licenses = this.session.fetchLicenses();
        this.distFiles.clear();
        this.updateTable();
        Array newDist = new Array(DistRow.class);
        if (this.sourceDir != null) {
            BIFile[] files = this.sourceDir.listFiles();
            int total = 0;
            for (BIFile file : files) {
                if (file.isDirectory() || file.getExtension() == null || !file.getExtension().equalsIgnoreCase("dist")) continue;
                ++total;
            }
            if (total <= 1) {
                total = -1;
            }
            CancelableDaemonSessionTask task = new CancelableDaemonSessionTask(BDaemonSessionView.lexicon, "DistInstallerTableModel.loading.title", "DistInstallerTableModel.loading.message", total, this.cancelHint);
            try {
                this.taskListener.taskStarted((DaemonSessionTask)task);
                int progress = 0;
                for (int i = 0; i < files.length && !task.isCanceled(); ++i) {
                    try {
                        if (files[i].isDirectory() || files[i].getExtension() == null || !files[i].getExtension().equalsIgnoreCase("dist")) continue;
                        BDistribution dist = new BDistribution(files[i], (ICancelHint)task);
                        newDist.add((Object)new DistRow(dist, (ICancelHint)task));
                        task.setProgress(++progress);
                        this.taskListener.taskUpdated((DaemonSessionTask)task);
                        continue;
                    }
                    catch (ICancelHint.CanceledException | AuthenticationException ce) {
                        throw ce;
                    }
                    catch (Exception e) {
                        BDialog.error((BWidget)this.getTable(), (String)BDaemonSessionView.lexicon.getText("DistInstallerTableModel.readError.dlgTitle"), (Object)BDaemonSessionView.lexicon.getText("DistInstallerTableModel.readError.dlgMessage", new Object[]{files[i].getFilePath().getBody()}), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (task.isCanceled()) {
                    throw new ICancelHint.CanceledException();
                }
            }
            finally {
                this.taskListener.taskFinished((DaemonSessionTask)task);
            }
        }
        this.distFiles = newDist;
        this.updateTable(true);
        if (Logger.getLogger("platform.daemonTuning").isLoggable(Level.FINE)) {
            Logger.getLogger("platform.daemonTuning").fine("DistInstallerTableModel.rebuild() complete " + (Clock.ticks() - t0) + "ms");
        }
    }

    public void reload() throws Exception {
        this.storeCache.clear();
        this.getTable().getSelection().deselectAll();
        if (this.session != null) {
            BRemoteDaemonPlatform platform = this.getDaemonPlatform();
            platform.getModuleList().reload(this.taskListener);
            platform.loadPreferredVerificationMode();
            this.session.reloadHostProperties();
        }
        this.rebuild();
    }

    public void setSourceDirectory(BDirectory value) {
        this.sourceDir = value;
        this.rebuild();
    }

    protected DistRow getRow(int row) {
        return (DistRow)this.distFiles.get(row);
    }

    public BDistribution getDistribution(int row) {
        return this.getRow((int)row).dist;
    }

    public BDependency[] getUnmetDependencies(int row) {
        return this.getRow((int)row).unmetDependencies;
    }

    public UnmeetableDependency[] getUnmeetableDependencies(int row) {
        return this.getRow((int)row).unmeetableDependencies;
    }

    public Map<BDependency, BPart> getExcludedPlatformParts(int row) {
        return this.getRow((int)row).excludedPlatformParts;
    }

    public boolean isForTarget(int row) {
        return this.getRow((int)row).forTarget;
    }

    public boolean canInstall(int row) {
        return this.isForTarget(row) && this.getStatus(row) != 4;
    }

    public int getStatus(int row) {
        return this.getRow((int)row).status;
    }

    public BImage getRowIcon(int row) {
        return this.isForTarget(row) ? BImage.make((BIcon)DIST_FILE_ICON_REF) : BImage.make((BIcon)DIST_FILE_ICON_REF).getDisabledImage();
    }

    public StoreCache getCache() {
        return this.storeCache;
    }

    protected class DistRow {
        public BDependency[] unmetDependencies;
        public UnmeetableDependency[] unmeetableDependencies;
        public int status;
        public BDistribution dist;
        public boolean forTarget = true;
        public Map<BDependency, BPart> excludedPlatformParts;

        public DistRow(BDistribution pDist, ICancelHint cancelHint) throws Exception {
            this.dist = pDist;
            if (!this.dist.getIsValid()) {
                this.status = 6;
                this.forTarget = false;
                this.unmetDependencies = new BDependency[0];
                this.unmeetableDependencies = new UnmeetableDependency[0];
                return;
            }
            BRemoteDaemonPlatform platform = DistInstallerTableModel.this.getDaemonPlatform();
            SolutionParameters parameters = new SolutionParameters(DistInstallerTableModel.this.taskListener);
            if (platform != null && !platform.getIsNpsdk()) {
                Qnx7DistLicenseFeatureFilter qnx7Filter = new Qnx7DistLicenseFeatureFilter();
                Jre8AzulDistLicenseFeatureFilter jre8AzulFilter = new Jre8AzulDistLicenseFeatureFilter();
                qnx7Filter.setLicenses((Collection)DistInstallerTableModel.this.licenses);
                jre8AzulFilter.setLicenses((Collection)DistInstallerTableModel.this.licenses);
                parameters.addFilter((InstallableFilter)qnx7Filter);
                parameters.addFilter((InstallableFilter)jre8AzulFilter);
            }
            DistInstallerTableModel.this.certValidator.setLaxValidation(this.dist.getInstallableName().equals("backupdist"));
            InstallScenario solution = InstallScenario.solve((BDaemonPlatform)platform, null, null, (BInstallable[])new BInstallable[]{this.dist}, (SolutionParameters)parameters, null, (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)DistInstallerTableModel.this.certValidator);
            BInstallable[] exclInst = solution.getExcludedInstallables();
            if (exclInst.length > 0) {
                this.excludedPlatformParts = new TreeMap<BDependency, BPart>(BDependency.COMPARATOR);
                for (BInstallable anExclInst : exclInst) {
                    BDependency[] excl;
                    for (BDependency anExcl : excl = anExclInst.getAllExclusions()) {
                        BPart platPart = platform.getPart(anExcl);
                        if (platPart == null || !platPart.meets(anExcl)) continue;
                        this.excludedPlatformParts.put(anExcl, platPart);
                    }
                }
                this.status = 7;
                this.forTarget = false;
            } else {
                this.unmetDependencies = solution.getUnmetDependencies();
                this.unmeetableDependencies = solution.getUnmeetableDependencies();
                if (this.unmetDependencies.length == 0) {
                    long flags = solution.getProcessingFlags();
                    if (!(DistInstallerTableModel.this.isAdmin || (flags & 0x10000L) <= 0L && (flags & 0x80000L) <= 0L && (flags & 0x20000L) <= 0L)) {
                        this.status = 4;
                        this.forTarget = false;
                    } else if (this.dist.hasFileUpdates((BDaemonPlatform)platform, DistInstallerTableModel.this.getCache(), cancelHint, DistInstallerTableModel.this.taskListener)) {
                        if (this.dist.getPart() != null && !AccessController.doPrivileged(() -> Boolean.getBoolean("distinstaller.showall")).booleanValue()) {
                            this.status = 8;
                            this.forTarget = false;
                            this.unmetDependencies = new BDependency[0];
                        } else {
                            this.status = 0;
                        }
                    } else if (solution.getToInstall().length > 1) {
                        BInstallable[] toInstall;
                        for (BInstallable aToInstall : toInstall = solution.getToInstall()) {
                            if (aToInstall == this.dist || !BDistribution.LOG.isLoggable(Level.FINE)) continue;
                            BDistribution.LOG.fine("ood dep on " + aToInstall.getInstallableName() + " from " + this.dist.getInstallableName());
                        }
                        this.status = 5;
                    } else if (this.dist.getPart() != null && !AccessController.doPrivileged(() -> Boolean.getBoolean("distinstaller.showall")).booleanValue()) {
                        this.status = 8;
                        this.forTarget = false;
                        this.unmetDependencies = new BDependency[0];
                    } else {
                        this.status = 2;
                    }
                } else {
                    this.forTarget = false;
                    this.status = 3;
                    for (BDependency unmetDependency : this.unmetDependencies) {
                        BPart p;
                        if (!unmetDependency.canSolveWith("default") && (p = platform.getPart(unmetDependency)) != null && p.matchesName(unmetDependency.getPartName())) {
                            this.status = 8;
                            continue;
                        }
                        if (!unmetDependency.isPlatformDependency((BDaemonPlatform)platform)) continue;
                        this.status = 1;
                        break;
                    }
                }
            }
        }
    }
}

