/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.BDistributionView;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallerCellRenderer;
import com.tridium.platDaemon.ui.distinstall.DistInstallerTableModel;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.FavoriteDirectory;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@NiagaraActions(value={@NiagaraAction(name="handleInstallSourceChanged"), @NiagaraAction(name="handleTableModified"), @NiagaraAction(name="handleSelectionModified")})
public class BDistInstaller
extends BDaemonSessionView {
    @Generated
    public static final Action handleInstallSourceChanged = BDistInstaller.newAction((int)0, null);
    @Generated
    public static final Action handleTableModified = BDistInstaller.newAction((int)0, null);
    @Generated
    public static final Action handleSelectionModified = BDistInstaller.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDistInstaller.class);
    DistInstallerTableModel tableModel;
    BWidget tablePane;
    private BLabel messageLabel;
    private BButton button;
    private BDirectory defaultDir = null;
    private BDirectoryChoice dirChoice;
    boolean trapSelectionModified = true;
    private Command installCommand = new InstallDistCommand("DistInstaller.command.install");
    private Command reinstallCommand = new InstallDistCommand("DistInstaller.command.reinstall");

    @Generated
    public void handleInstallSourceChanged() {
        this.invoke(handleInstallSourceChanged, null, null);
    }

    @Generated
    public void handleTableModified() {
        this.invoke(handleTableModified, null, null);
    }

    @Generated
    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDistInstaller() {
        BGridPane upperGrid = new BGridPane(1);
        upperGrid.setHalign(BHalign.left);
        upperGrid.setRowGap(4.0);
        BButtonPane dirPane = new BButtonPane();
        dirPane.setUniformColumnWidth(false);
        dirPane.setButtonStyle(BButtonStyle.toolBar);
        upperGrid.add("dirPane", (BValue)dirPane);
        this.messageLabel = new BLabel();
        upperGrid.add("dirMessage", (BValue)this.messageLabel);
        this.dirChoice = new BDirectoryChoice(false, 60);
        this.dirChoice.getChangeDirectoryCommand().setLabel(Lexicon.make((String)"platDaemon").getText("DistInstaller.command.chooseDirectory.label"));
        this.dirChoice.getChangeDirectoryCommand().setDescription(Lexicon.make((String)"platDaemon").getText("DistInstaller.command.chooseDirectory.description"));
        dirPane.add((BWidget)this.dirChoice);
        BIBeamPane bottomPane = new BIBeamPane();
        BGridPane buttonPane = new BGridPane(4);
        bottomPane.setCenter((BWidget)buttonPane);
        buttonPane.setColumnAlign(BHalign.center);
        buttonPane.add(null, (BValue)new BButton((Command)this.dirChoice.getChangeDirectoryCommand()));
        buttonPane.add(null, (BValue)new BButton((Command)new CleanDistsCommand()));
        buttonPane.add(null, (BValue)new BButton((Command)new ConversionsCommand()));
        buttonPane.add(null, (BValue)new BButton((Command)new BackupsCommand()));
        BGridPane rightPane = new BGridPane(1);
        this.button = new BButton(this.installCommand);
        rightPane.add(null, (BValue)this.button);
        rightPane.setColumnAlign(BHalign.fill);
        rightPane.setHalign(BHalign.center);
        bottomPane.setRight((BWidget)rightPane);
        this.installCommand.setEnabled(false);
        this.reinstallCommand.setEnabled(false);
        this.button.setVisible(false);
        this.tableModel = new DistInstallerTableModel();
        BTable table = new BTable((TableModel)this.tableModel);
        table.setCellRenderer((TableCellRenderer)new DistInstallerCellRenderer());
        table.setMultipleSelection(false);
        table.setController((TableController)new Controller());
        this.linkTo((BComponent)table, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
        this.linkTo((BComponent)table, (Slot)BTable.tableModified, (Slot)handleTableModified);
        this.tablePane = new BBorderPane((BWidget)table, BBorder.inset, BInsets.DEFAULT);
        this.tablePane.setVisible(false);
        this.setContent((BWidget)new BEdgePane((BWidget)upperGrid, (BWidget)new BBorderPane((BWidget)bottomPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane(this.tablePane, 4.0, 0.0, 0.0, 4.0)));
    }

    @Override
    protected final void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        try {
            LocalInstallableRegistry.getInstance().init((DaemonSessionTaskListener)this);
            BDirectory dir = this.loadSelectedDirectory(session);
            this.dirChoice.setDirectory(dir);
            if (this.getProperty("lkDirChanged") == null) {
                this.linkTo("lkDirChanged", (BComponent)this.dirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleInstallSourceChanged);
            }
            this.tableModel.init(this.getDaemonSession(), dir, this, this);
            if (this.tableModel.getRowCount() == 0) {
                this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.noDists", new Object[]{this.dirChoice.getDisplayPath()}));
                this.tablePane.setVisible(false);
                this.button.setVisible(false);
            } else {
                this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.foundDists", new Object[]{this.tableModel.getRowCount(), this.dirChoice.getDisplayPath()}));
                this.tablePane.setVisible(true);
                this.button.setVisible(true);
            }
        }
        catch (ICancelHint.CanceledException icce) {
            this.tablePane.setVisible(false);
            this.button.setVisible(false);
            this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.canceled"));
            this.resetCanceled();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected BDirectory loadSelectedDirectory(BDaemonSession session) throws Exception {
        if (!session.getHostProperties().isNiagara4()) {
            this.defaultDir = BFileSystem.INSTANCE.makeDir(new FilePath("!conversion"));
            return this.defaultDir;
        }
        BDirectory result = FavoriteDirectory.loadByPath((String)this.getType().toString(), (String)"distDir", null);
        if (result == null) {
            result = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("~backups"));
            if (result != null && result.listFiles().length == 0) {
                result = null;
            }
            if (result == null) {
                result = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist"));
            }
            if (result == null) {
                BDaemonPlatform platform = this.getDaemonPlatform();
                for (BInstallable candidate : LocalInstallableRegistry.getInstance().getInstallables(true, (DaemonSessionTaskListener)this, "nre-config*")) {
                    boolean meetsDepends = true;
                    for (BDependency dependency : candidate.getAllDependencies()) {
                        if (platform.meets(dependency)) continue;
                        meetsDepends = false;
                        break;
                    }
                    if (!meetsDepends) continue;
                    FilePath resultPath = BFileSystem.INSTANCE.localFileToPath(candidate.getLocalInstallableFile()).getParent();
                    result = (BDirectory)BFileSystem.INSTANCE.findFile(resultPath);
                    break;
                }
            }
            if (result == null) {
                result = BFileSystem.INSTANCE.makeDir(new FilePath("!sw"));
            }
        }
        this.defaultDir = result;
        return result;
    }

    protected void saveSelectedDirectory() {
        if (this.dirChoice.getDirectory() != null && this.defaultDir != null && !this.dirChoice.getDirectory().getFilePath().getBody().equals(this.defaultDir.getFilePath().getBody())) {
            FavoriteDirectory.savePath((String)this.getType().toString(), (String)"distDir", (BDirectory)this.dirChoice.getDirectory());
        }
    }

    public void doHandleInstallSourceChanged() throws Exception {
        this.tablePane.setVisible(false);
        this.button.setVisible(false);
        this.messageLabel.setText("");
        this.tableModel.setSourceDirectory(this.dirChoice.getDirectory());
        if (this.tableModel.getRowCount() == 0) {
            this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.noDists", new Object[]{this.dirChoice.getDisplayPath()}));
        } else {
            this.messageLabel.setText(this.getLexicon().getText("DistInstaller.label.foundDists", new Object[]{this.tableModel.getRowCount(), this.dirChoice.getDisplayPath()}));
            this.tablePane.setVisible(true);
            this.button.setVisible(true);
        }
        this.saveSelectedDirectory();
    }

    public void doHandleTableModified() {
        this.handleSelectionModified();
    }

    public void doHandleSelectionModified() {
        if (!this.trapSelectionModified) {
            return;
        }
        int[] rows = this.tableModel.getTable().getSelection().getRows();
        boolean enable = false;
        if (rows.length == 0) {
            enable = false;
            this.button.setCommand(this.installCommand, true, true);
        } else if (rows.length == 1) {
            if (this.tableModel.canInstall(rows[0])) {
                enable = true;
                if (this.tableModel.getStatus(rows[0]) == 2) {
                    this.button.setCommand(this.reinstallCommand, true, true);
                } else {
                    this.button.setCommand(this.installCommand, true, true);
                }
            } else {
                enable = false;
                this.button.setCommand(this.installCommand, true, true);
            }
        }
        this.installCommand.setEnabled(enable);
        this.reinstallCommand.setEnabled(enable);
    }

    @Override
    public void deactivated() {
        super.deactivated();
        SignedDistFilter.resetVerificationCache();
    }

    private class BackupsCommand
    extends Command {
        public BackupsCommand() {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), "DistInstaller.command.backups");
            if (BFileSystem.INSTANCE.findFile(new FilePath("~backups")) == null) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            BDistInstaller.this.dirChoice.setDirectory((BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("~backups")));
            return null;
        }
    }

    private class ConversionsCommand
    extends Command {
        public ConversionsCommand() {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), "DistInstaller.command.conversion");
            if (BFileSystem.INSTANCE.findFile(new FilePath("!conversion")) == null) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            BDistInstaller.this.dirChoice.setDirectory((BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!conversion")));
            return null;
        }
    }

    private class CleanDistsCommand
    extends Command {
        public CleanDistsCommand() {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), "DistInstaller.command.cleanDists");
            if (BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist")) == null) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            BDistInstaller.this.dirChoice.setDirectory((BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!cleanDist")));
            return null;
        }
    }

    private class InstallDialogCommand
    extends DialogCommand {
        protected InstallDialogCommand() {
            super((BWidget)BDistInstaller.this, 1, BDistInstaller.this.getType().getModule(), "DistInstaller.command.install");
            this.setEnabled(BDistInstaller.this.installCommand.isEnabled());
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BDistributionView distView = new BDistributionView(BDistInstaller.this.tableModel.getUnmeetableDependencies(row), BDistInstaller.this.tableModel.getExcludedPlatformParts(row));
            BConstrainedPane dialogContent = new BConstrainedPane((BWidget)new BBorderPane((BWidget)distView, 4.0, 4.0, 4.0, 4.0));
            dialogContent.setFixedSize(550.0, 600.0);
            distView.loadValue((BObject)BDistInstaller.this.tableModel.getDistribution(row));
            if (1 == BCommandDialog.open((BWidget)BDistInstaller.this, (String)BDistInstaller.this.tableModel.getDistribution(row).getInstallableFileName(), (Object)dialogContent, (DialogCommand[])new DialogCommand[]{new InstallDialogCommand(), DialogCommand.makeCancel((BWidget)BDistInstaller.this)})) {
                BDistInstaller.this.installCommand.invoke();
            }
        }
    }

    private class InstallDistCommand
    extends AsyncCommand {
        protected InstallDistCommand(String lexKey) {
            super((BWidget)BDistInstaller.this, BDistInstaller.this.getType().getModule(), lexKey);
        }

        public void doInvokeAsync() {
            BWbShell shell = BDistInstaller.this.getWbShell();
            BDaemonSession session = BDistInstaller.this.getDaemonSession();
            try {
                BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), session.getHost());
                if (shell != null) {
                    shell.enterBusy();
                }
                DistInstallWizardModel model = new DistInstallWizardModel(this.getOwner(), BDistInstaller.this.tableModel.getDistribution(BDistInstaller.this.tableModel.getTable().getSelection().getRow()), session);
                if (shell != null) {
                    shell.exitBusy();
                }
                if (model.hasNoSteps()) {
                    model.finish();
                } else {
                    BWizard.open((BWidget)this.getOwner(), (WizardModel)model);
                }
                if (!model.isCanceled()) {
                    if (shell != null && (model.getProcessingFlags() & 0x40000L) > 0L) {
                        shell.hyperlink(session.getAbsoluteOrd());
                    } else if (session.isConnected()) {
                        BDistInstaller.this.tableModel.reload();
                    }
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            finally {
                if (shell != null) {
                    shell.exitBusy();
                }
                BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), session.getHost());
            }
        }
    }
}

