/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.GroupAccount;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.acctmgt.FileDomainPasswordController;
import com.tridium.platDaemon.ui.acctmgt.QnxUserNameController;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.AuthenticationInfoMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.UpdateFileAuthenticationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.InputStream;
import java.net.ConnectException;
import java.security.AccessController;
import java.util.Set;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class ChangeDefaultsWizardModel
extends WizardModel {
    XElem authInfo = null;
    Set<String> authTypesSupported = null;
    boolean authReadonly = false;
    String currentAuthType = null;
    boolean defaultCredentialsPresent = false;
    boolean usingDefaultCredentials = false;
    String defaultUserName = null;
    boolean usingNativeDomain = false;
    boolean supportsAccountManagement = false;
    XElem[] existingAdminUsers = null;
    GroupAccount nativeAdminGroup = null;
    UserAccount newNativeUserAccountToAdd = null;
    UserAccount defaultNativeUserAccountToRemove = null;
    boolean usingFileDomain = false;
    String replacementAdminUserName = null;
    BPassword replacementAdminPassword = null;
    XElem systemPassphraseInfo = null;
    boolean defaultSystemPassphrasePresent = false;
    boolean systemPassphraseReadonly = false;
    BPassword newSystemPassphrase = null;
    BPassword oldSystemPassphrase = null;
    boolean fipsModeAvailable = false;
    boolean fipsModeSelected = false;
    private boolean isBootstrap = false;
    private BDaemonSession daemonSession = null;
    private BUsernameAndPassword currentSessionCredentials = null;
    private BUsernameAndPassword newSessionCredentials = null;
    private ChangeDefaultsWizardStep currentStep = null;
    private boolean canceled = false;
    private static final BImage WIZ_IMAGE = BImage.make((String)"module://icons/x32/wizard.png");
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");

    public ChangeDefaultsWizardModel(BDaemonSession daemonSession, boolean removeDefaultCredentials, boolean removeDefaultSystemPassphrase) throws Exception {
        this(daemonSession, removeDefaultCredentials, removeDefaultSystemPassphrase, false);
    }

    public ChangeDefaultsWizardModel(BDaemonSession daemonSession, boolean removeDefaultCredentials, boolean removeDefaultSystemPassphrase, boolean isBootstrap) throws Exception {
        this.daemonSession = daemonSession;
        this.isBootstrap = isBootstrap;
        this.fipsModeAvailable = FipsOptionsHelper.getInstance().showFipsOption(daemonSession, isBootstrap);
        this.defaultCredentialsPresent = removeDefaultCredentials;
        this.defaultSystemPassphrasePresent = removeDefaultSystemPassphrase;
        this.currentSessionCredentials = (BUsernameAndPassword)daemonSession.getCredentials();
        if (this.defaultSystemPassphrasePresent) {
            try {
                this.systemPassphraseInfo = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new SystemPasswordMessage())).parse();
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            this.systemPassphraseReadonly = this.systemPassphraseInfo.getb("readonly", false);
        }
        if (this.defaultCredentialsPresent) {
            try {
                this.authInfo = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new AuthenticationInfoMessage(false), AuthenticationInfoMessage.AUTH_INFO_MESSAGE_TIMEOUT, "text/xml")).parse();
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            XElem authElem = this.authInfo.elem("auth");
            assert (authElem != null);
            this.currentAuthType = authElem.get("type");
            this.authReadonly = authElem.getb("readonly", false);
            XElem userElem = authElem.elem("user");
            assert (userElem != null);
            this.defaultUserName = userElem.get("name");
            if (NativeAccount.fullyQualifiedToUsername((String)this.currentSessionCredentials.getUsername()).equalsIgnoreCase(this.defaultUserName)) {
                this.usingDefaultCredentials = true;
            }
            if (DaemonAuthUtil.isFileScheme((String)this.currentAuthType)) {
                this.usingFileDomain = true;
            } else if (DaemonAuthUtil.isNativeScheme((String)this.currentAuthType)) {
                this.usingNativeDomain = true;
                this.supportsAccountManagement = daemonSession.getHostProperties().supportsServlet("acctmgt");
                if (this.supportsAccountManagement) {
                    XElem[] remoteGroups;
                    XElem elem = authElem.elem("admingroup");
                    if (elem != null) {
                        this.nativeAdminGroup = new GroupAccount(elem.get("name"), elem.get("id"));
                    }
                    XElem accountInfo = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                    for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                        if (!currentGroup.get("name").equals(this.nativeAdminGroup.getFullyQualifiedName())) continue;
                        this.existingAdminUsers = currentGroup.elems("user");
                    }
                }
            }
        }
        FirstStep firstStep = new FirstStep();
        ChooseFipsStep chooseFipsStep = new ChooseFipsStep();
        ChangeSystemPassphraseStep passphraseStep = new ChangeSystemPassphraseStep();
        ChangeCredentialsStep credentialsStep = new ChangeCredentialsStep();
        ReviewStep reviewStep = new ReviewStep();
        this.currentStep = firstStep;
        firstStep.setNextStep(chooseFipsStep);
        chooseFipsStep.setPriorStep(firstStep);
        chooseFipsStep.setNextStep(passphraseStep);
        passphraseStep.setPriorStep(chooseFipsStep);
        passphraseStep.setNextStep(credentialsStep);
        credentialsStep.setPriorStep(passphraseStep);
        credentialsStep.setNextStep(reviewStep);
        reviewStep.setPriorStep(credentialsStep);
    }

    public String getTitle() {
        return LEX.getText("ChangeDefaultsWizard.title");
    }

    public boolean cancel() {
        if (this.getCurrentStep().getMode() == 0 || BDialog.confirm((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.cancel.title"), (Object)LEX.getText("ChangeDefaultsWizard.cancel.message")) == 4 && this.getCurrentStep().cancel()) {
            this.canceled = true;
            return true;
        }
        this.canceled = false;
        return false;
    }

    public void init() {
        ChangeDefaultsWizardStep step = this.currentStep;
        while (step != null && step.isSkipped()) {
            step = step.nextStep;
        }
        this.update(0);
        if (step != null) {
            step.enter();
            this.update(step);
        }
    }

    public void back() {
        ChangeDefaultsWizardStep step = this.getCurrentStep().getPriorStep();
        if (step != null && this.getCurrentStep().exit(1)) {
            this.update(step);
            step.enter();
        }
    }

    public void next() {
        ChangeDefaultsWizardStep step = this.getCurrentStep().getNextStep();
        if (step != null && this.getCurrentStep().exit(2)) {
            while (step != null && step.isSkipped()) {
                step = step.getNextStep();
            }
            assert (step != null);
            step.setPriorStep(this.getCurrentStep());
            this.update(step);
            step.enter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish() {
        boolean updateFileDomainUserCookie;
        boolean deleteDefaultUserCookie;
        boolean addNewNativeUserCookie;
        boolean addPassphraseCookie;
        boolean hasFileChange;
        block30: {
            hasFileChange = false;
            addPassphraseCookie = false;
            addNewNativeUserCookie = false;
            deleteDefaultUserCookie = false;
            updateFileDomainUserCookie = false;
            if (this.newSystemPassphrase != null) {
                try {
                    this.daemonSession.sendMessage((DaemonMessage)new SystemPasswordMessage(this.newSystemPassphrase, this.oldSystemPassphrase, false, this.daemonSession.generateSharedSecretKey("changeDefaultsWizard_setSysPw")));
                    addPassphraseCookie = true;
                    hasFileChange = true;
                }
                catch (Throwable t) {
                    BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.systemPassphraseError.title"), (Object)LEX.getText("ChangeDefaultsWizard.systemPassphraseError.message"), (Throwable)t);
                }
            }
            if (this.usingNativeDomain && this.supportsAccountManagement) {
                if (this.newNativeUserAccountToAdd != null || this.defaultNativeUserAccountToRemove != null) {
                    if (this.newNativeUserAccountToAdd != null) {
                        try {
                            AddUserMessage addUserMessage = new AddUserMessage(this.newNativeUserAccountToAdd);
                            addUserMessage.setSharedKey(this.daemonSession.generateSharedSecretKey("changeDefaultsWizard_addUser"));
                            AddMemberMessage addMemberMessage = new AddMemberMessage(this.nativeAdminGroup, this.newNativeUserAccountToAdd);
                            this.daemonSession.sendMessage((DaemonMessage)addUserMessage);
                            this.daemonSession.sendMessage((DaemonMessage)addMemberMessage);
                            addNewNativeUserCookie = true;
                            hasFileChange = true;
                        }
                        catch (Throwable t) {
                            BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.addUserError.title"), (Object)LEX.getText("ChangeDefaultsWizard.addUserError.message", new Object[]{this.newNativeUserAccountToAdd.getAccountName()}), (Throwable)t);
                            break block30;
                        }
                        try {
                            DaemonCredentialsManager.setCredentials(this.daemonSession, (BICredentials)this.newSessionCredentials);
                            this.daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
                        }
                        catch (Throwable t) {
                            BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.switchUserError.title"), (Object)LEX.getText("ChangeDefaultsWizard.switchUserError.message", new Object[]{this.newNativeUserAccountToAdd.getAccountName()}), (Throwable)t);
                            break block30;
                        }
                    }
                    if (this.defaultNativeUserAccountToRemove != null) {
                        try {
                            DeleteMemberMessage deleteMemberMessage = new DeleteMemberMessage(this.nativeAdminGroup, this.defaultNativeUserAccountToRemove);
                            DeleteUserMessage deleteUserMessage = new DeleteUserMessage(this.defaultNativeUserAccountToRemove);
                            this.daemonSession.sendMessage((DaemonMessage)deleteMemberMessage);
                            this.daemonSession.sendMessage((DaemonMessage)deleteUserMessage);
                            deleteDefaultUserCookie = true;
                            hasFileChange = true;
                        }
                        catch (Throwable t) {
                            BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.removeUserError.title"), (Object)LEX.getText("ChangeDefaultsWizard.removeUserError.message", new Object[]{this.defaultNativeUserAccountToRemove.getAccountName()}), (Throwable)t);
                        }
                    }
                }
            } else if (this.usingFileDomain && this.replacementAdminUserName != null && this.replacementAdminPassword != null) {
                try {
                    UpdateFileAuthenticationMessage updateAuthMessage = new UpdateFileAuthenticationMessage(this.currentAuthType, this.replacementAdminUserName, this.replacementAdminPassword, this.daemonSession.generateSharedSecretKey("changeDefaultsWizard_updateUser"));
                    this.daemonSession.sendMessage((DaemonMessage)updateAuthMessage);
                    updateFileDomainUserCookie = true;
                    hasFileChange = true;
                }
                catch (Throwable t) {
                    BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.updateUserError.title"), (Object)LEX.getText("ChangeDefaultsWizard.updateUserError.message", new Object[]{this.replacementAdminUserName}), (Throwable)t);
                    break block30;
                }
                try {
                    DaemonCredentialsManager.setCredentials(this.daemonSession, (BICredentials)this.newSessionCredentials);
                    this.daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
                }
                catch (Throwable t) {
                    BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.switchUserError.title"), (Object)LEX.getText("ChangeDefaultsWizard.switchUserError.message", new Object[]{this.replacementAdminUserName}), (Throwable)t);
                }
            }
        }
        String username = "(none)";
        BDefaultDaemonFileSpace bootstrapFileSpace = null;
        try {
            if (hasFileChange && this.isBootstrap) {
                bootstrapFileSpace = new BDefaultDaemonFileSpace();
                this.attachBootstrapFileSpace(bootstrapFileSpace);
            }
            if (addPassphraseCookie) {
                FipsOptionsHelper.getInstance().updateSystemPassphraseCookie(this.fipsModeSelected, this.daemonSession);
            }
            if (addNewNativeUserCookie) {
                username = this.newNativeUserAccountToAdd.getAccountName();
                FipsOptionsHelper.getInstance().updateUserCookie(username, this.fipsModeSelected, this.daemonSession);
            }
            if (deleteDefaultUserCookie) {
                username = this.defaultNativeUserAccountToRemove.getAccountName();
                FipsOptionsHelper.getInstance().updateUserCookie(username, false, this.daemonSession);
            }
            if (updateFileDomainUserCookie) {
                username = this.replacementAdminUserName;
                FipsOptionsHelper.getInstance().updateUserCookie(username, this.fipsModeSelected, this.daemonSession);
            }
        }
        catch (ConnectException e) {
            BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("ChangeDefaultsWizard.setFipsCookiesError.title"), (Object)LEX.getText("ChangeDefaultsWizard.setFipsCookiesError.message", new Object[]{username}), (Throwable)e);
        }
        finally {
            if (hasFileChange && this.isBootstrap) {
                this.detachBootstrapSession(bootstrapFileSpace);
            }
        }
        return true;
    }

    private void attachBootstrapFileSpace(BDefaultDaemonFileSpace fileSpace) {
        fileSpace.setBootstrapDaemonSession(this.daemonSession);
        this.daemonSession.setBootstrapFileSpace(fileSpace);
    }

    private void detachBootstrapSession(BDefaultDaemonFileSpace fileSpace) {
        fileSpace.setBootstrapDaemonSession(null);
        this.daemonSession.setBootstrapFileSpace(null);
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(500.0, 300.0);
    }

    private ChangeDefaultsWizardStep getCurrentStep() {
        return this.currentStep;
    }

    private void update(ChangeDefaultsWizardStep step) {
        this.currentStep = step;
        this.update(step.getWidget(), step.getMode());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    static /* synthetic */ BImage access$100() {
        return WIZ_IMAGE;
    }

    public class ReviewStep
    extends ChangeDefaultsWizardStep {
        private int mode;

        public ReviewStep() {
            this.mode = 0;
        }

        @Override
        public String getStepName() {
            return "review";
        }

        @Override
        public void enter() {
            try {
                this.mode = 0;
                this.wizardModel.update(0);
                BIndentPane indent = new BIndentPane();
                BLabel headerLabel = LabelUtil.makeLabel((String)LEX.getText("ChangeDefaultsWizard.review.header"), (boolean)false);
                indent.add((BWidget)headerLabel);
                indent.add((BWidget)new BBox(0.0, 10.0));
                if (this.wizardModel.defaultSystemPassphrasePresent && this.wizardModel.newSystemPassphrase != null && this.wizardModel.oldSystemPassphrase != null) {
                    indent.add((BWidget)LabelUtil.makeLabel((String)LEX.getText("ChangeDefaultsWizard.review.changeSystemPassphrase"), (boolean)true));
                }
                if (this.wizardModel.defaultCredentialsPresent) {
                    BGridPane grid;
                    if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                        BIndentPane subIndent;
                        if (ChangeDefaultsWizardModel.this.newNativeUserAccountToAdd != null) {
                            indent.add((BWidget)LabelUtil.makeLabel((String)LEX.getText("ChangeDefaultsWizard.review.changeCredentials.add.header"), (boolean)true));
                            indent.indent();
                            grid = new BGridPane(2);
                            grid.setValign(BValign.top);
                            grid.setHalign(BHalign.left);
                            subIndent = new BIndentPane();
                            subIndent.add(this.wizardModel.newNativeUserAccountToAdd.getAccountName());
                            grid.add(null, (BValue)subIndent);
                            indent.add((BWidget)grid);
                            indent.unindent();
                        }
                        if (ChangeDefaultsWizardModel.this.defaultNativeUserAccountToRemove != null) {
                            indent.add((BWidget)LabelUtil.makeLabel((String)LEX.getText("ChangeDefaultsWizard.review.changeCredentials.remove.header"), (boolean)true));
                            indent.indent();
                            grid = new BGridPane(2);
                            grid.setValign(BValign.top);
                            grid.setHalign(BHalign.left);
                            subIndent = new BIndentPane();
                            subIndent.add(this.wizardModel.defaultNativeUserAccountToRemove.getAccountName() + " " + LEX.getText("ChangeDefaultsWizard.review.changeCredentials.toRemove.label.default"));
                            grid.add(null, (BValue)subIndent);
                            indent.add((BWidget)grid);
                            indent.unindent();
                        }
                    } else if (ChangeDefaultsWizardModel.this.usingFileDomain) {
                        indent.add((BWidget)LabelUtil.makeLabel((String)LEX.getText("ChangeDefaultsWizard.review.changeCredentials.replace.header"), (boolean)true));
                        indent.indent();
                        grid = new BGridPane(2);
                        grid.setValign(BValign.top);
                        grid.setHalign(BHalign.left);
                        BIndentPane subIndent = new BIndentPane();
                        BGridPane subIndentGrid = new BGridPane(2);
                        subIndentGrid.setValign(BValign.top);
                        subIndentGrid.setHalign(BHalign.left);
                        LabelUtil.addLabelWidgetPair((BPane)subIndentGrid, (String)LEX.getText("ChangeDefaultsWizard.review.changeCredentials.replaceWith.label"), (BWidget)new BLabel(this.wizardModel.replacementAdminUserName), (boolean)false);
                        subIndent.add((BWidget)subIndentGrid);
                        grid.add(null, (BValue)subIndent);
                        indent.add((BWidget)grid);
                        indent.unindent();
                    }
                }
                this.mode = 5;
                this.wizardModel.update(5);
                BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 4.0, 4.0, 4.0, 4.0));
                scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                this.setContent((BWidget)scrollPane);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public boolean exit(int direction) {
            return true;
        }

        @Override
        public int getMode() {
            return this.mode;
        }
    }

    public class ChangeCredentialsStep
    extends ChangeDefaultsWizardStep {
        BTextField userNameField;
        BTextField commentField;
        BPasswordFE passwordFE1;
        BPasswordFE passwordFE2;

        public ChangeCredentialsStep() throws Exception {
            this.userNameField = new BTextField("", 20);
            this.commentField = new BTextField("", 20);
            this.passwordFE1 = new BPasswordFE();
            this.passwordFE2 = new BPasswordFE();
            if (!ChangeDefaultsWizardModel.this.defaultCredentialsPresent) {
                return;
            }
            if (ChangeDefaultsWizardModel.this.authReadonly) {
                return;
            }
            if (ChangeDefaultsWizardModel.this.usingNativeDomain && !ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                return;
            }
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            BGridPane header = new BGridPane(1);
            header.setHalign(BHalign.left);
            header.add(null, (BValue)new BLabel(LEX.getText("ChangeDefaultsWizard.changeCredentials.header"), BHalign.left));
            if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                this.wizardModel.defaultNativeUserAccountToRemove = new UserAccount(this.wizardModel.nativeAdminGroup.getDomain() + "\\" + this.wizardModel.defaultUserName, null, null, null);
            }
            this.userNameField = new BTextField("", 20);
            if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                this.commentField = new BTextField("", 20);
            }
            this.passwordFE1 = new BPasswordFE();
            this.passwordFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeCredentials.label.name"), (BWidget)this.userNameField);
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeCredentials.label.password"), (BWidget)this.passwordFE1);
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeCredentials.label.password2"), (BWidget)this.passwordFE2);
            if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeCredentials.label.comment"), (BWidget)this.commentField);
            }
            ((BTextField)this.passwordFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.passwordFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            boolean QNX = this.wizardModel.daemonSession.getHostProperties().getOsName().toLowerCase().contains("qnx");
            if (QNX && ChangeDefaultsWizardModel.this.usingFileDomain) {
                ((BTextField)this.passwordFE1.getContent()).setController((TextController)new FileDomainPasswordController());
                ((BTextField)this.passwordFE2.getContent()).setController((TextController)new FileDomainPasswordController());
            }
            this.userNameField.setModel((TextModel)new ModeControlModel(this));
            if (QNX) {
                this.userNameField.setController((TextController)new QnxUserNameController());
            }
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)header, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "changeCredentials";
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            try {
                BPassword pw2;
                BPassword pw1;
                String comment;
                String fullyQualifiedName;
                String accountName;
                block29: {
                    block28: {
                        accountName = this.userNameField.getText().trim();
                        if (accountName.length() == 0) {
                            BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.nameRequired"));
                            return false;
                        }
                        if (BNativeUserTable.isReserved(accountName)) {
                            BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.userReserved", new Object[]{accountName}));
                            return false;
                        }
                        if (accountName.equals(ChangeDefaultsWizardModel.this.defaultUserName)) {
                            BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.nonDefaultRequired", new Object[]{accountName}));
                            return false;
                        }
                        fullyQualifiedName = null;
                        comment = null;
                        if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                            if (!NativeAccount.isAccountNameFullyQualified((String)accountName)) {
                                fullyQualifiedName = this.wizardModel.nativeAdminGroup.getDomain() + "\\" + accountName;
                            } else {
                                fullyQualifiedName = accountName;
                                accountName = NativeAccount.fullyQualifiedToUsername((String)accountName);
                            }
                            boolean alreadyExists = false;
                            if (ChangeDefaultsWizardModel.this.existingAdminUsers == null) {
                                XElem[] remoteGroups;
                                XElem accountInfo = XParser.make((InputStream)this.wizardModel.daemonSession.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                                for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                                    if (!currentGroup.get("name").equals(this.wizardModel.nativeAdminGroup.getFullyQualifiedName())) continue;
                                    ChangeDefaultsWizardModel.this.existingAdminUsers = currentGroup.elems("user");
                                }
                            }
                            if (ChangeDefaultsWizardModel.this.existingAdminUsers != null) {
                                for (XElem adminUser : ChangeDefaultsWizardModel.this.existingAdminUsers) {
                                    if (!UserAccount.fullyQualifiedToUsername((String)adminUser.get("name")).equals(accountName)) continue;
                                    alreadyExists = true;
                                }
                            }
                            if (alreadyExists) {
                                BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.userAlreadyExists", new Object[]{accountName}));
                                return false;
                            }
                            comment = this.commentField.getText().trim();
                            for (int i = 0; i < comment.length(); ++i) {
                                char c = comment.charAt(i);
                                if (!"-=+()@._ ".contains(String.valueOf(c)) && !Character.isLetterOrDigit(c)) {
                                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.invalidCommentCharacter", new Object[]{String.valueOf(c)}));
                                    return false;
                                }
                                if (i < 64) continue;
                                BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.commentTooLong"));
                                return false;
                            }
                        }
                        pw1 = (BPassword)this.passwordFE1.saveValue();
                        pw2 = (BPassword)this.passwordFE2.saveValue();
                        if (pw1 == null) break block28;
                        if (AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()).trim().length() == 0 || pw2 == null) break block28;
                        if (AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()).trim().length() != 0) break block29;
                    }
                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.passwordRequired"));
                    return false;
                }
                if (!BNativeUserTable.validatePassword((BWidget)ChangeDefaultsWizardModel.this.getWizard(), pw1, FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(ChangeDefaultsWizardModel.this.fipsModeSelected, ChangeDefaultsWizardModel.this.daemonSession))) {
                    return false;
                }
                if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)pw2).getValue()))) {
                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.passwordMismatch"));
                    return false;
                }
                if (ChangeDefaultsWizardModel.this.usingDefaultCredentials) {
                    BPassword defaultPassword = ChangeDefaultsWizardModel.this.currentSessionCredentials.getPassword();
                    if (SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)defaultPassword).getValue()))) {
                        BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeCredentials.error.passwordUnchanged"));
                        return false;
                    }
                }
                if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                    this.wizardModel.newNativeUserAccountToAdd = new UserAccount(fullyQualifiedName, null, comment, LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (int)0));
                    this.wizardModel.newSessionCredentials = new BUsernameAndPassword(ChangeDefaultsWizardModel.this.newNativeUserAccountToAdd.getAccountName(), AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()));
                } else if (ChangeDefaultsWizardModel.this.usingFileDomain) {
                    this.wizardModel.replacementAdminUserName = accountName;
                    this.wizardModel.replacementAdminPassword = pw1;
                    this.wizardModel.newSessionCredentials = new BUsernameAndPassword(ChangeDefaultsWizardModel.this.replacementAdminUserName, ChangeDefaultsWizardModel.this.replacementAdminPassword);
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            return true;
        }

        @Override
        public int getMode() {
            int mode = 1;
            if (this.userNameField.getText().trim().length() == 0 || ((BTextField)this.passwordFE1.getContent()).getText().trim().length() == 0 || ((BTextField)this.passwordFE2.getContent()).getText().trim().length() == 0) {
                return mode;
            }
            return mode | 2;
        }

        @Override
        public boolean isSkipped() {
            if (!this.wizardModel.defaultCredentialsPresent) {
                return true;
            }
            if (this.wizardModel.authReadonly) {
                return true;
            }
            if (ChangeDefaultsWizardModel.this.usingNativeDomain) {
                if (!ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                    return true;
                }
                if (!ChangeDefaultsWizardModel.this.usingDefaultCredentials) {
                    return true;
                }
            } else if (ChangeDefaultsWizardModel.this.usingFileDomain && !ChangeDefaultsWizardModel.this.usingDefaultCredentials) {
                return true;
            }
            return false;
        }

        private class ModeControlModel
        extends TextModel {
            private final ChangeDefaultsWizardStep step;

            public ModeControlModel(ChangeDefaultsWizardStep pStep) {
                this.step = pStep;
            }

            protected void textModified() {
                this.step.wizardModel.update(this.step.getMode());
            }
        }
    }

    public class ChangeSystemPassphraseStep
    extends ChangeDefaultsWizardStep {
        private SharedSecretKey sharedKey;
        boolean currentSystemPassphraseMatchesSession;
        BPasswordFE currentPassphraseFE;
        BPasswordFE newPassphraseFE1;
        BPasswordFE newPassphraseFE2;

        public ChangeSystemPassphraseStep() {
            this.sharedKey = null;
            this.currentSystemPassphraseMatchesSession = false;
            this.currentPassphraseFE = null;
            this.newPassphraseFE1 = null;
            this.newPassphraseFE2 = null;
            if (!ChangeDefaultsWizardModel.this.defaultSystemPassphrasePresent) {
                return;
            }
            if (ChangeDefaultsWizardModel.this.systemPassphraseReadonly) {
                return;
            }
            BGridPane grid = new BGridPane(2);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            grid.setStretchColumn(1);
            BGridPane header = new BGridPane(1);
            header.setHalign(BHalign.left);
            try {
                this.sharedKey = this.wizardModel.daemonSession.generateSharedSecretKey("changeDefaultWizard_systemPassphrase");
                if (BNativeUserTable.checkStatus((BWidget)ChangeDefaultsWizardModel.this.getWizard(), this.wizardModel.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(null, ChangeDefaultsWizardModel.this.currentSessionCredentials.getPassword(), true, this.sharedKey))) {
                    this.currentSystemPassphraseMatchesSession = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currentSystemPassphraseMatchesSession) {
                header.add(null, (BValue)new BLabel(LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.create.header"), BHalign.left));
            } else {
                header.add(null, (BValue)new BLabel(LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.change.header"), BHalign.left));
                BLabel noticeLabel = new BLabel(LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.defaultNotice"), BHalign.left);
                noticeLabel.setForeground(BColor.red.toBrush());
                header.add(null, (BValue)noticeLabel);
                this.currentPassphraseFE = new BPasswordFE();
                LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.oldPassphrase.label"), (BWidget)this.currentPassphraseFE);
            }
            this.newPassphraseFE1 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.newPassphrase.label"), (BWidget)this.newPassphraseFE1);
            this.newPassphraseFE2 = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)grid, (String)LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.newPassphrase2.label"), (BWidget)this.newPassphraseFE2);
            ((BTextField)this.newPassphraseFE1.getContent()).setModel((TextModel)new ModeControlModel(this));
            ((BTextField)this.newPassphraseFE2.getContent()).setModel((TextModel)new ModeControlModel(this));
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)header, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "changeSystemPassphrase";
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            try {
                BPassword npw2;
                BPassword npw1;
                BPassword opw;
                block12: {
                    block11: {
                        opw = this.currentSystemPassphraseMatchesSession ? ChangeDefaultsWizardModel.this.currentSessionCredentials.getPassword() : (BPassword)this.currentPassphraseFE.saveValue();
                        npw1 = (BPassword)this.newPassphraseFE1.saveValue();
                        npw2 = (BPassword)this.newPassphraseFE2.saveValue();
                        if (opw == null) break block11;
                        if (AccessController.doPrivileged(() -> ((BPassword)opw).getValue()).trim().length() == 0 || npw1 == null) break block11;
                        if (AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()).trim().length() == 0 || npw2 == null) break block11;
                        if (AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()).trim().length() != 0) break block12;
                    }
                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.error.fieldRequired"));
                    return false;
                }
                if (!BNativeUserTable.validatePassword((BWidget)ChangeDefaultsWizardModel.this.getWizard(), npw1, FipsOptionsHelper.getInstance().getPasswordStrengthRequirements(ChangeDefaultsWizardModel.this.fipsModeSelected, ChangeDefaultsWizardModel.this.daemonSession))) {
                    return false;
                }
                if (!this.currentSystemPassphraseMatchesSession && !BNativeUserTable.checkStatus((BWidget)ChangeDefaultsWizardModel.this.getWizard(), ChangeDefaultsWizardModel.this.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(null, opw, true, this.sharedKey))) {
                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("SystemPassword.error.badPassword"));
                    return false;
                }
                if (!BNativeUserTable.checkStatus((BWidget)ChangeDefaultsWizardModel.this.getWizard(), ChangeDefaultsWizardModel.this.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(npw1, null, true, this.sharedKey))) {
                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.error.invalidPassphraseDefault"));
                    return false;
                }
                if (!SecurityUtil.equals((String)AccessController.doPrivileged(() -> ((BPassword)npw1).getValue()), (String)AccessController.doPrivileged(() -> ((BPassword)npw2).getValue()))) {
                    BDialog.error((BWidget)ChangeDefaultsWizardModel.this.getWizard(), (Object)LEX.getText("ChangeDefaultsWizard.changeSystemPassphrase.error.passphraseMismatch"));
                    return false;
                }
                this.wizardModel.newSystemPassphrase = npw1;
                this.wizardModel.oldSystemPassphrase = opw;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            return true;
        }

        @Override
        public int getMode() {
            int mode = 1;
            if (((BTextField)this.newPassphraseFE1.getContent()).getText().trim().length() == 0 || ((BTextField)this.newPassphraseFE2.getContent()).getText().trim().length() == 0) {
                return mode;
            }
            return mode | 2;
        }

        @Override
        public boolean isSkipped() {
            if (!this.wizardModel.defaultSystemPassphrasePresent) {
                return true;
            }
            return this.wizardModel.systemPassphraseReadonly;
        }

        private class ModeControlModel
        extends TextModel {
            private final ChangeDefaultsWizardStep step;

            public ModeControlModel(ChangeDefaultsWizardStep pStep) {
                this.step = pStep;
            }

            protected void textModified() {
                this.step.wizardModel.update(this.step.getMode());
            }
        }
    }

    public class ChooseFipsStep
    extends ChangeDefaultsWizardStep {
        private BCheckBox fipsModeCheckBox;

        public ChooseFipsStep() {
            this.fipsModeCheckBox = null;
            if (!ChangeDefaultsWizardModel.this.fipsModeAvailable) {
                return;
            }
            BGridPane header = new BGridPane(1);
            header.setHalign(BHalign.left);
            header.add(null, (BValue)new BLabel(LEX.getText("ChangeDefaultsWizard.chooseFips.header"), BHalign.left));
            BGridPane grid = new BGridPane(1);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            this.fipsModeCheckBox = new BCheckBox(LEX.getText("ChangeDefaultsWizard.chooseFips.fipsMode"), FipsOptionsHelper.getInstance().checkFipsOption(ChangeDefaultsWizardModel.this.daemonSession));
            this.fipsModeCheckBox.setEnabled(!FipsOptionsHelper.getInstance().fipsOptionReadOnly(ChangeDefaultsWizardModel.this.daemonSession));
            grid.add(null, (BValue)this.fipsModeCheckBox);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)header, 4.0, 0.0, 8.0, 0.0), null, null, null, (BWidget)grid));
        }

        @Override
        public String getStepName() {
            return "chooseFips";
        }

        @Override
        public boolean exit(int direction) {
            boolean back;
            boolean bl = back = direction == 1;
            if (back) {
                return true;
            }
            ChangeDefaultsWizardModel.this.fipsModeSelected = this.fipsModeCheckBox != null && this.fipsModeCheckBox.getSelected();
            return true;
        }

        @Override
        public int getMode() {
            return 3;
        }

        @Override
        public boolean isSkipped() {
            return !this.wizardModel.fipsModeAvailable;
        }
    }

    public class FirstStep
    extends ChangeDefaultsWizardStep {
        public FirstStep() {
            BIndentPane indent = new BIndentPane();
            indent.add(LEX.getText("ChangeDefaultsWizard.welcome.header1"));
            indent.indent();
            indent.add((BWidget)new BBox(0.0, 3.0));
            if (ChangeDefaultsWizardModel.this.fipsModeAvailable) {
                indent.add(LEX.getText("ChangeDefaultsWizard.welcome.chooseFips"));
            }
            if (ChangeDefaultsWizardModel.this.defaultSystemPassphrasePresent && !ChangeDefaultsWizardModel.this.systemPassphraseReadonly) {
                indent.add(LEX.getText("ChangeDefaultsWizard.welcome.changeSystemPassphrase"));
            }
            if (ChangeDefaultsWizardModel.this.defaultCredentialsPresent && !ChangeDefaultsWizardModel.this.authReadonly) {
                if (ChangeDefaultsWizardModel.this.usingFileDomain) {
                    indent.add(LEX.getText("ChangeDefaultsWizard.welcome.replaceDefaultAccount"));
                } else if (ChangeDefaultsWizardModel.this.usingNativeDomain && ChangeDefaultsWizardModel.this.supportsAccountManagement) {
                    if (ChangeDefaultsWizardModel.this.usingDefaultCredentials) {
                        indent.add(LEX.getText("ChangeDefaultsWizard.welcome.createNewAccount"));
                    }
                    indent.add(LEX.getText("ChangeDefaultsWizard.welcome.removeDefaultAccount"));
                }
            }
            indent.add((BWidget)new BBox(0.0, 6.0));
            indent.unindent();
            indent.add(LEX.getText("ChangeDefaultsWizard.welcome.header2"));
            this.setContent((BWidget)indent);
        }

        @Override
        public String getStepName() {
            return "welcome";
        }

        @Override
        public boolean exit(int direction) {
            return true;
        }

        @Override
        public int getMode() {
            return 2;
        }
    }

    public abstract class ChangeDefaultsWizardStep {
        private final BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private final BEdgePane widget = new BEdgePane((BWidget)new BWizardHeader(ChangeDefaultsWizardModel.access$100(), ChangeDefaultsWizardModel.access$200().getText("ChangeDefaultsWizard.headerTitle"), ChangeDefaultsWizardModel.access$200().getText("ChangeDefaultsWizard." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        private ChangeDefaultsWizardStep priorStep = null;
        private ChangeDefaultsWizardStep nextStep = null;
        protected ChangeDefaultsWizardModel wizardModel;

        public ChangeDefaultsWizardStep() {
            this.wizardModel = ChangeDefaultsWizardModel.this;
        }

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget content) {
            this.contentPane.setCenter(content);
        }

        public int getMode() {
            int result = 0;
            ChangeDefaultsWizardStep step = this.priorStep;
            while (step != null && step.isSkipped()) {
                step = step.priorStep;
            }
            if (step != null) {
                result = 1;
            }
            step = this.nextStep;
            while (step != null && step.isSkipped()) {
                step = step.nextStep;
            }
            result = step == null ? (result |= 4) : (result |= 2);
            return result;
        }

        public ChangeDefaultsWizardStep getPriorStep() {
            return this.priorStep;
        }

        public ChangeDefaultsWizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(ChangeDefaultsWizardStep step) {
            this.nextStep = step;
        }

        public void enter() {
        }

        public boolean exit(int direction) {
            return true;
        }

        public void setPriorStep(ChangeDefaultsWizardStep step) {
            this.priorStep = step;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }
}

