/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platDaemon.ui.config.BPlatformAdministration;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetQnxSystemLogMessage;
import com.tridium.platform.daemon.message.GetSystemLogMessage;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BTextOutputPane;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.text.Position;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

@NiagaraType
public class BSystemLogDialog
extends BFrame {
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemLogDialog.class);
    boolean isQnx;
    boolean isQnx7;
    boolean useSystemLogServlet;
    private final BTextOutputPane logOutputPane;
    private final BTextOutputPane qnxLogOutputPane;
    private final BTextOutputPane qnxLog1OutputPane;
    private final BTextOutputPane qnxLog2OutputPane;
    private final BDaemonSession daemonSession;
    private static final Lexicon lex = TYPE.getModule().getLexicon();
    private static final Logger log = BPlatformAdministration.log;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemLogDialog() {
        throw new UnsupportedOperationException();
    }

    public BSystemLogDialog(BWidget owner, BDaemonSession session) throws AuthenticationException {
        super(lex.getText("SystemLogDialog.title", new Object[]{session.getRemoteAddressString()}));
        BTextOutputPane targetPane;
        this.daemonSession = session;
        this.setIconImage(BImage.make((String)lex.getText("SystemLogDialog.icon")));
        BButtonPane buttonPane = new BButtonPane();
        buttonPane.add((Command)new CloseCommand());
        RefreshCommand refreshCommand = new RefreshCommand();
        buttonPane.add((Command)refreshCommand);
        BHostProperties hostProperties = this.daemonSession.getHostProperties();
        if (hostProperties.supportsServlet("qnx")) {
            this.isQnx = true;
            this.isQnx7 = hostProperties.getOsName().startsWith("tridium-qnx7");
            this.useSystemLogServlet = hostProperties.supportsServlet("systemlog");
            this.logOutputPane = null;
            BTabbedPane logPane = new BTabbedPane();
            this.qnxLogOutputPane = new BTextOutputPane();
            logPane.addPane(new BLabel(lex.get("SystemLogDialog.currentLogs")), (BWidget)this.qnxLogOutputPane);
            this.qnxLog1OutputPane = new BTextOutputPane();
            logPane.addPane(new BLabel(lex.get("SystemLogDialog.log1")), (BWidget)this.qnxLog1OutputPane);
            this.qnxLog2OutputPane = new BTextOutputPane();
            logPane.addPane(new BLabel(lex.get("SystemLogDialog.log2")), (BWidget)this.qnxLog2OutputPane);
            targetPane = logPane;
        } else {
            this.isQnx = false;
            this.isQnx7 = false;
            this.useSystemLogServlet = true;
            this.qnxLogOutputPane = null;
            this.qnxLog1OutputPane = null;
            this.qnxLog2OutputPane = null;
            targetPane = this.logOutputPane = new BTextOutputPane();
        }
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)targetPane, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        try {
            refreshCommand.doInvoke();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load SystemLogDialog content", e);
        }
    }

    private void loadBounds() {
        try {
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BComponent bounds = (BComponent)options.get("bounds");
            if (bounds == null) {
                Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
                this.setPreferredSize((int)(0.9 * ss.getWidth()), (int)(0.9 * ss.getHeight()));
                this.setBoundsCenteredOnScreen();
            } else {
                this.setScreenBounds(bounds.getInt(bounds.getProperty("x")), bounds.getInt(bounds.getProperty("y")), bounds.getInt(bounds.getProperty("width")), bounds.getInt(bounds.getProperty("height")));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load SystemLogDialog bounds", e);
        }
    }

    public void setBoundsCenteredOnScreen() {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)sd.width, (double)sd.height));
    }

    public void setBoundsCenteredOn(RectGeom screenRect) {
        this.computePreferredSize();
        double w = this.getPreferredWidth() + 8.0;
        double h = this.getPreferredHeight() + 27.0;
        double x = screenRect.x + (screenRect.width - w) / 2.0;
        double y = screenRect.y + (screenRect.height - h) / 2.0;
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        double sw = ss.width;
        double sh = ss.height;
        if (x + w > sw) {
            x = sw - w;
        }
        if (y + h > sh) {
            y = sh - h;
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        this.setScreenBounds(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.stopLogPane(this.logOutputPane);
            this.stopLogPane(this.qnxLogOutputPane);
            this.stopLogPane(this.qnxLog1OutputPane);
            this.stopLogPane(this.qnxLog2OutputPane);
            BOptions options = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BFolder bounds = new BFolder();
            IRectGeom screenBounds = this.getScreenBounds();
            bounds.add("x", (BValue)BInteger.make((int)((int)screenBounds.x())));
            bounds.add("y", (BValue)BInteger.make((int)((int)screenBounds.y())));
            bounds.add("width", (BValue)BInteger.make((int)((int)screenBounds.width())));
            bounds.add("height", (BValue)BInteger.make((int)((int)screenBounds.height())));
            if (options.get("bounds") == null) {
                options.add("bounds", (BValue)bounds);
            } else {
                options.set("bounds", (BValue)bounds);
            }
            options.save();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to close SystemLogDialog", e);
        }
        finally {
            super.close();
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    private String refreshLog(boolean useLegacyQnxServlet, String logContext) {
        GetQnxSystemLogMessage logMessage = useLegacyQnxServlet ? new GetQnxSystemLogMessage(logContext) : new GetSystemLogMessage(logContext);
        StringBuilder logContents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.daemonSession.getInputStream((DaemonMessage)logMessage)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                logContents.append(line).append("\n");
            }
        }
        catch (Exception e) {
            logContents = new StringBuilder();
            logContents.append("Error reading log contents: ").append(e);
            log.log(Level.SEVERE, "Error reading log contents", e);
        }
        return logContents.toString();
    }

    private void stopLogPane(BTextOutputPane logOutputPane) {
        if (logOutputPane != null) {
            logOutputPane.stop();
        }
    }

    private void repaintLogPane(BTextOutputPane logOutputPane) {
        if (logOutputPane != null) {
            logOutputPane.repaint();
        }
    }

    private void moveVisibleToBottomLeft(BTextOutputPane logOutputPane) {
        if (logOutputPane != null) {
            Position bottomLeft = new Position(logOutputPane.getEditor().getModel().getLineCount() - 1, 0);
            logOutputPane.getEditor().scrollToVisible(bottomLeft);
            logOutputPane.getEditor().setCaretBlinking(false);
        }
    }

    public void scrollToBottom() {
        this.moveVisibleToBottomLeft(this.logOutputPane);
        this.moveVisibleToBottomLeft(this.qnxLogOutputPane);
        this.moveVisibleToBottomLeft(this.qnxLog1OutputPane);
        this.moveVisibleToBottomLeft(this.qnxLog2OutputPane);
    }

    private class RefreshCommand
    extends Command {
        public RefreshCommand() {
            super((BWidget)BSystemLogDialog.this, TYPE.getModule(), "SystemLogDialog.command.refresh");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BSystemLogDialog.this.isQnx) {
                if (BSystemLogDialog.this.useSystemLogServlet) {
                    BSystemLogDialog.this.qnxLogOutputPane.setText(BSystemLogDialog.this.refreshLog(false, ""));
                    BSystemLogDialog.this.qnxLog1OutputPane.setText(BSystemLogDialog.this.refreshLog(false, "log1"));
                    BSystemLogDialog.this.qnxLog2OutputPane.setText(BSystemLogDialog.this.refreshLog(false, "log2"));
                } else if (BSystemLogDialog.this.isQnx7) {
                    BSystemLogDialog.this.qnxLogOutputPane.setText(BSystemLogDialog.this.refreshLog(true, "viewlog"));
                    BSystemLogDialog.this.qnxLog1OutputPane.setText(BSystemLogDialog.this.refreshLog(true, "viewlog!log1"));
                    BSystemLogDialog.this.qnxLog2OutputPane.setText(BSystemLogDialog.this.refreshLog(true, "viewlog!log2"));
                } else {
                    BSystemLogDialog.this.qnxLogOutputPane.setText(BSystemLogDialog.this.refreshLog(true, "sloginfo"));
                    BSystemLogDialog.this.qnxLog1OutputPane.setText(BSystemLogDialog.this.refreshLog(true, "sloginfo!/var/slog/log1"));
                    BSystemLogDialog.this.qnxLog2OutputPane.setText(BSystemLogDialog.this.refreshLog(true, "sloginfo!/var/slog/log2"));
                }
            } else {
                BSystemLogDialog.this.logOutputPane.setText(BSystemLogDialog.this.refreshLog(false, ""));
            }
            BSystemLogDialog.this.scrollToBottom();
            BSystemLogDialog.this.repaintLogPane(BSystemLogDialog.this.logOutputPane);
            BSystemLogDialog.this.repaintLogPane(BSystemLogDialog.this.qnxLogOutputPane);
            BSystemLogDialog.this.repaintLogPane(BSystemLogDialog.this.qnxLog1OutputPane);
            BSystemLogDialog.this.repaintLogPane(BSystemLogDialog.this.qnxLog2OutputPane);
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BSystemLogDialog.this, TYPE.getModule(), "SystemLogDialog.command.close");
        }

        public CommandArtifact doInvoke() throws Exception {
            BSystemLogDialog.this.close();
            return null;
        }
    }
}

