/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.cert.NoOpCertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.DependencyUtil;
import com.tridium.install.DistLicenseFeatureFilter;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.PartSpec;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.BModuleTypeFilter;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.commissioningwizard.DistStep;
import com.tridium.platDaemon.ui.commissioningwizard.LexiconSourceModel;
import com.tridium.platDaemon.ui.softwaremanager.BPartDetailsPane;
import com.tridium.platDaemon.ui.softwaremanager.CancelInstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallerCellRenderer;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import com.tridium.platDaemon.ui.softwaremanager.ResetCommand;
import com.tridium.platDaemon.ui.softwaremanager.UpgradeOutOfDateCommand;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class ModuleStep
extends CommissioningWizardStep
implements AsyncGroup.AsyncGroupMember {
    private BDirectory lastStationDir = null;
    private Set<RuntimeProfile> lastEnabledRuntimeProfiles = Collections.emptySet();
    private Version lastMaxCoreVersion = Version.ZERO;
    private DependencyUtil.AnalysisResults analysisResults = null;
    private final TreeSet<BModuleInstallable> lexiconModules;
    private final BTable table;
    private final ModuleTableModel tableModel = new ModuleTableModel();
    private final UpgradeOutOfDateCommand upgradeOODCommand;
    private long currentFreeSpace;
    private final BLabel currentSpaceLabel;
    private final BLabel spaceDeltaLabel;
    private final BLabel afterSpaceLabel;
    private AsyncGroup asyncGroup;
    private boolean asyncGroupActive = false;
    public static final int MT_PART_NAME_COL = 0;
    public static final int MT_CURRENT_VER_COL = 1;
    public static final int MT_AVAIL_VER_COL = 2;
    public static final int MT_COMMENT_COL = 3;
    public static final int REQUIRED_PLATFORM = 3;
    public static final int REQUIRED_STATION = 2;
    public static final int REQUIRED_RUNTIME_PROFILE = 4;
    public static final int REQUIRED_LEXICON = 1;
    private static final String CACERTS_ENTRY = "META-INF/install/cacerts";
    private static final String CACERTS_FIPS_ENTRY = "META-INF/install/cacerts.bcfks";
    private static final String STANDARD_STORE_TYPE = "JKS";
    private static final String FIPS_STORE_TYPE = "BCFKS";
    private static final String CACERTS_KEY = "jiUz!rHw2d8&i3kI";
    private static final Logger log = Logger.getLogger("platDaemon");

    public ModuleStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        this.table = new BTable((TableModel)this.tableModel);
        this.table.setController((TableController)new ModuleTableController());
        this.table.setMultipleSelection(false);
        this.tableModel.setFilter(new BModuleTypeFilter());
        this.table.setCellRenderer((TableCellRenderer)new ModuleCellRenderer());
        BButtonPane buttons = new BButtonPane();
        BInsets buttonInsets = BInsets.make((double)4.0, (double)3.0, (double)4.0, (double)3.0);
        this.asyncGroup = new AsyncGroup();
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this);
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this.tableModel);
        this.upgradeOODCommand = new UpgradeOutOfDateCommand(wizardModel.owner, this.tableModel);
        BButton button = new BButton((Command)this.upgradeOODCommand);
        buttons.add((BWidget)button);
        button.setPadding(buttonInsets);
        ResetCommand resetCommand = new ResetCommand(wizardModel.owner, this.tableModel);
        button = new BButton((Command)resetCommand);
        buttons.add((BWidget)button);
        button.setPadding(buttonInsets);
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upgradeOODCommand);
        this.asyncGroup.add((AsyncGroup.AsyncGroupMember)resetCommand);
        BGridPane spacePane = new BGridPane(6);
        BLabel bigSpaceLabel = new BLabel(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(88888888L));
        bigSpaceLabel.computePreferredSize();
        BLabel smallSpaceLabel = new BLabel(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(88888L));
        smallSpaceLabel.computePreferredSize();
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)bigSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)smallSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.add(null, (BValue)new BNullWidget());
        spacePane.add(null, (BValue)new BBox((double)((int)bigSpaceLabel.getPreferredWidth() + 5), 0.0));
        spacePane.setHalign(BHalign.left);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)spacePane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane headers = new BGridPane(1);
        headers.setHalign(BHalign.left);
        headers.setValign(BValign.top);
        headers.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.moduleUpgrades.header.standard"), BHalign.left));
        this.setContent((BWidget)new BEdgePane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)spacePane, 3.0, 0.0, 7.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)headers, BBorder.make((String)"bottom(groove)"), BInsets.make((double)4.0, (double)0.0, (double)8.0, (double)0.0))), (BWidget)new BBorderPane((BWidget)buttons, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT)));
        UnavailableModuleStep unavailableStep = new UnavailableModuleStep(wizardModel);
        SignatureWarningStep signatureWarningStep = new SignatureWarningStep(wizardModel);
        ExistingModuleSignatureErrorsStep existingSignatureErrorStep = new ExistingModuleSignatureErrorsStep(wizardModel);
        this.nextStep = unavailableStep;
        unavailableStep.priorStep = this;
        unavailableStep.nextStep = existingSignatureErrorStep;
        existingSignatureErrorStep.priorStep = unavailableStep;
        existingSignatureErrorStep.nextStep = signatureWarningStep;
        signatureWarningStep.priorStep = existingSignatureErrorStep;
        this.lastStep = signatureWarningStep;
        this.lexiconModules = new TreeSet();
    }

    @Override
    public void enter() {
        this.initStep();
    }

    @Override
    public boolean exit(int direction) {
        if (this.tableModel == null || this.tableModel.getScenario() == null) {
            this.wizardModel.moduleScenario = null;
            this.wizardModel.moduleScenarioHasDists = false;
        } else {
            this.wizardModel.moduleScenarioHasDists = ModuleStep.scenarioHasDists(this.tableModel.getScenario());
            this.wizardModel.moduleScenario = this.tableModel.getScenario();
        }
        this.wizardModel.distSolution = null;
        return true;
    }

    @Override
    public boolean isSkipped() {
        this.initStep();
        return this.wizardModel.skipModules || !this.wizardModel.initialScenario.canCommit();
    }

    @Override
    public int getMode() {
        return this.asyncGroupActive ? 0 : 3;
    }

    @Override
    public String getStepName() {
        return "moduleUpgrades";
    }

    @Override
    public String getSectionName() {
        return "module";
    }

    public void startActive() {
        this.asyncGroupActive = true;
        this.wizardModel.update(0);
    }

    public void stopActive() {
        this.asyncGroupActive = false;
        if (!this.wizardModel.isCanceled()) {
            this.wizardModel.update(3);
        }
    }

    public void setAsyncGroup(AsyncGroup group) {
        this.asyncGroup = group;
    }

    public AsyncGroup getAsyncGroup() {
        return this.asyncGroup;
    }

    private void initStep() {
        try {
            AsyncGroup grp = this.tableModel.getAsyncGroup();
            if (grp != null) {
                grp.startActive();
            }
            BRemoteDaemonPlatform platform = this.wizardModel.getPlatform();
            this.currentFreeSpace = DaemonFileUtil.getFilesystemAttributes((BDaemonSession)this.wizardModel.daemonSession, (FilePath)SystemFilePaths.getModulesPath((boolean)platform.getIsNiagaraHomeReadonly())).getFreeSpace();
            if (this.currentSpaceLabel != null) {
                this.currentSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(this.currentFreeSpace));
            }
            if (this.wizardModel.initialScenario == null || this.analysisResults == null || !this.lastEnabledRuntimeProfiles.equals(this.wizardModel.enabledRuntimeProfiles) || this.lastStationDir != this.wizardModel.stationDir || !this.lastMaxCoreVersion.equals((Object)this.wizardModel.getMaxCoreVersion())) {
                platform.loadPreferredVerificationMode();
                ArrayList<BDirectory> stationDirs = new ArrayList<BDirectory>();
                if (this.wizardModel.stationDir != null) {
                    stationDirs.add(this.wizardModel.stationDir);
                }
                boolean skipRemoteStationSolution = false;
                if (platform.getNrePart() != null && !platform.getNrePart().isNull()) {
                    BAppSurrogate[] remoteNreVersion = platform.getNrePart().getVersion();
                    if (remoteNreVersion.meetsVersionRequirement(new BVersion("4.0"), BVersionRelation.minimum) && remoteNreVersion.meetsVersionRequirement(new BVersion("4.5.74.999"), BVersionRelation.maximum)) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Skipping remote Niagara Station in ModuleStep solution, remote NRE version '" + remoteNreVersion + "' does not meet transcoder requirements");
                        }
                        skipRemoteStationSolution = true;
                    } else if (log.isLoggable(Level.FINE)) {
                        log.fine("Including remote Niagara Station in ModuleStep solution, remote NRE version '" + remoteNreVersion + "' meets transcoder requirements");
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("Remote NRE part not defined, including remote Niagara Station in ModuleStep solution");
                }
                if (!skipRemoteStationSolution) {
                    for (BAppSurrogate appSurrogate : this.wizardModel.getSurrogates()) {
                        if (!(appSurrogate instanceof BStationSurrogate) || this.wizardModel.stationsToDelete.contains(appSurrogate)) continue;
                        BStationSurrogate station = (BStationSurrogate)appSurrogate;
                        stationDirs.add((BDirectory)this.wizardModel.daemonSession.getFileSpace().findFile(new FilePath("~stations/" + station.getStationName())));
                    }
                }
                BDirectory[] stationDirsArray = stationDirs.toArray(new BDirectory[0]);
                CertificateChainValidator certValidator = this.makeCertificateChainValidator((BDaemonPlatform)platform, stationDirsArray);
                this.analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, (BDirectory[])stationDirsArray, this.wizardModel.enabledRuntimeProfiles, (SolutionParameters)this.wizardModel.solutionParams, (CertificateChainValidator)certValidator);
                this.wizardModel.initialScenario = this.analysisResults.getSolution();
                this.lexiconModules.clear();
                for (LexiconSourceModel lsm : this.wizardModel.lexLocalesToInstall) {
                    lsm.lexModules.stream().filter(m -> this.wizardModel.enabledRuntimeProfiles.contains(m.getRuntimeProfile())).forEach(m -> {
                        BModuleInstallable mInstallable = BModuleInstallable.make((NModuleInfo)m);
                        if (mInstallable != null) {
                            if (ModuleStep.isExistingLexiconModuleValid(m.getModulePartName())) {
                                this.lexiconModules.add(mInstallable);
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(" Request lexicon module: " + m.getModulePartName());
                                }
                            } else if (log.isLoggable(Level.FINE)) {
                                log.fine(" Excluding invalid lexicon module: " + m.getModulePartName());
                            }
                        }
                    });
                }
                this.wizardModel.moduleScenario = this.wizardModel.initialScenario;
                this.wizardModel.moduleScenarioHasDists = false;
                this.wizardModel.distSolution = null;
                for (BInstallable inst : this.wizardModel.initialScenario.getToInstall()) {
                    if (!(inst instanceof BDistribution)) continue;
                    this.wizardModel.moduleScenarioHasDists = true;
                    break;
                }
                this.lastStationDir = this.wizardModel.stationDir;
                this.lastEnabledRuntimeProfiles = this.wizardModel.enabledRuntimeProfiles;
                this.lastMaxCoreVersion = this.wizardModel.getMaxCoreVersion();
                if (this.wizardModel.initialScenario.canCommit()) {
                    this.tableModel.init(this.wizardModel.daemonSession, this.wizardModel.sessionTaskHandler, true);
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            AsyncGroup grp = this.tableModel.getAsyncGroup();
            if (grp != null) {
                grp.stopActive();
            }
        }
    }

    private CertificateChainValidator makeCertificateChainValidator(BDaemonPlatform platform, BDirectory[] stationDirs) throws Exception {
        if (platform.getIsNpsdk()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Relaxing certificate validation for NPSDK platform.");
            }
            CertificateChainValidator validator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(this.wizardModel.daemonSession));
            validator.setLaxValidation(true);
            return validator;
        }
        DependencyUtil.AnalysisResults results = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, (BDirectory[])stationDirs, this.wizardModel.enabledRuntimeProfiles, (SolutionParameters)this.wizardModel.solutionParams, (CertificateChainValidator)new NoOpCertificateChainValidator());
        InstallScenario scenario = results.getSolution();
        if (!this.wizardModel.skipDist) {
            InstallScenario distScenario = DistStep.getDistScenario(scenario, ModuleStep.scenarioHasDists(scenario), platform, this.wizardModel, null);
            scenario = distScenario != null ? distScenario : scenario;
        }
        KeyStore cacerts = null;
        block2: for (BInstallable inst : scenario.getToInstall()) {
            if (!(inst instanceof BDistribution)) continue;
            SlotCursor p = inst.getParts().getProperties();
            while (p.next()) {
                BPart part = (BPart)p.get();
                Type type = part.getType();
                if (!type.is(BVmPart.TYPE)) continue;
                cacerts = ModuleStep.extractCacerts(inst);
                continue block2;
            }
        }
        BPlatCryptoManager cryptoManager = new BPlatCryptoManager(this.wizardModel.daemonSession);
        try {
            CertificateChainValidator validator = new CertificateChainValidator();
            validator.addTrustAnchors(cryptoManager.getUserTrustStore());
            if (cacerts != null) {
                validator.addTrustAnchors(cacerts);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cacerts not found in InstallScenario, using current platform system trust store.");
                }
                validator.addTrustAnchors(cryptoManager.getSystemTrustStore());
            }
            return validator;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error adding trust anchors to CertificateChainValidator.", e);
            return CertificateChainValidator.make((ICoreCryptoManager)cryptoManager);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore extractCacerts(BInstallable jreDist) {
        try {
            String keystoreType;
            String cacertsEntryName;
            BIFile distFile = AccessController.doPrivileged(() -> (BIFile)jreDist.getInstallableFileOrd().get());
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("Searching for cacerts in JRE dist '%s'", distFile.getFilePath()));
            }
            if (SecurityInitializer.getInstance().isFips()) {
                cacertsEntryName = CACERTS_FIPS_ENTRY;
                keystoreType = FIPS_STORE_TYPE;
            } else {
                cacertsEntryName = CACERTS_ENTRY;
                keystoreType = STANDARD_STORE_TYPE;
            }
            try (ZipInputStream in = new ZipInputStream(AccessController.doPrivileged(() -> ((BIFile)distFile).getInputStream()));){
                ZipEntry zipEntry;
                while ((zipEntry = in.getNextEntry()) != null) {
                    if (!zipEntry.getName().equalsIgnoreCase(cacertsEntryName)) continue;
                    try {
                        KeyStore cacerts = KeyStore.getInstance(keystoreType);
                        cacerts.load(in, CACERTS_KEY.toCharArray());
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Loading cacerts from " + cacertsEntryName);
                        }
                        KeyStore keyStore = cacerts;
                        return keyStore;
                    }
                    catch (Exception exception) {
                    }
                }
                log.warning(String.format("Unable to find '%s' in JRE dist.", cacertsEntryName));
                KeyStore keyStore = null;
                return keyStore;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error searching for cacerts in JRE dist.", e);
            return null;
        }
    }

    private static boolean scenarioHasDists(InstallScenario scenario) {
        for (BInstallable inst : scenario.getToInstall()) {
            if (!(inst instanceof BDistribution)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isExistingLexiconModuleValid(String modulePartName) {
        try {
            File moduleFile = Nre.bootEnv.findDependency(modulePartName);
            try (ZipFile moduleJar = new ZipFile(moduleFile);){
                ZipEntry zipEntry = moduleJar.getEntry("META-INF/module.xml");
                if (zipEntry == null) {
                    zipEntry = moduleJar.getEntry("meta-inf/module.xml");
                }
                if (zipEntry == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Module does not include manifest: " + modulePartName);
                    }
                    boolean bl = false;
                    return bl;
                }
                XElem manifest = XParser.make((InputStream)moduleJar.getInputStream(zipEntry)).parse();
                XElem lexElem = manifest.elem("lexicons");
                boolean isExternalModuleReferenced = false;
                if (lexElem != null) {
                    for (XElem elem : lexElem.elems("lexicon")) {
                        if (elem.get("module", "").equals(modulePartName)) continue;
                        isExternalModuleReferenced = true;
                        break;
                    }
                }
                if (isExternalModuleReferenced) return true;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(" ModuleStep - lexicon does not reference external module: " + modulePartName);
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (ModuleNotFoundException e) {
            return false;
        }
        catch (ModuleException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class LicenseCommand
    extends Command {
        public LicenseCommand() {
            super(ModuleStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.dist.goLicense"), null, null, null);
        }

        public CommandArtifact doInvoke() {
            if (ModuleStep.this.exit(1)) {
                ModuleStep.this.wizardModel.licenseStep.enter();
                ModuleStep.this.wizardModel.update(ModuleStep.this.wizardModel.licenseStep);
            }
            return null;
        }
    }

    private class ModuleTableController
    extends TableController {
        private ModuleTableController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    new ModuleDetailCommand(row).invoke();
                } else {
                    super.cellPressed(event, row, column);
                }
                return;
            }
            ModuleRow rowObj = ModuleStep.this.tableModel.getModuleRow(row);
            if (rowObj != null && rowObj.isSelectEnabled() && ModuleStep.this.tableModel.isRowSelectEnabled()) {
                try {
                    AsyncGroup grp = ModuleStep.this.tableModel.getAsyncGroup();
                    if (grp != null) {
                        grp.startActive();
                    }
                    if (rowObj.isSelected()) {
                        CancelInstallCommand.cancelInstall(ModuleStep.this.wizardModel.owner, ModuleStep.this.tableModel, new int[]{row});
                    } else {
                        BWbShell shell = BWbShell.getWbShell((BWidget)ModuleStep.this.wizardModel.owner);
                        try {
                            InstallScenario solution;
                            Map failed;
                            if (shell != null) {
                                shell.enterBusy();
                            }
                            if (!(failed = (solution = ModuleStep.this.tableModel.getScenario().solve(ModuleStep.this.tableModel.getTaskListener(), null, null, new BInstallable[]{ModuleStep.this.tableModel.getInstallableAt(row)}, (InstallableRegistry)LocalInstallableRegistry.getInstance())).getSignatureFailures()).isEmpty()) {
                                BDialog.error((BWidget)ModuleStep.this.wizardModel.owner, (String)CommissioningWizardStep.LEX.getText("InstallCommand.signingError.title"), (Object)InstallCommand.makeSigningErrorDialog(failed, ModuleStep.this.tableModel.getModuleVerificationMode()));
                            } else if (solution.canCommit()) {
                                ModuleStep.this.tableModel.setScenario(solution);
                            } else {
                                BInstallable[] excluded;
                                BIndentPane indent = new BIndentPane();
                                boolean anyUnmeetable = false;
                                boolean anyFailedFilters = false;
                                for (UnmeetableDependency unmeetable : solution.getUnmeetableDependencies()) {
                                    StringBuilder text = new StringBuilder(unmeetable.toString());
                                    if (unmeetable.failedFilter != null) {
                                        text.append(" *");
                                        anyFailedFilters = true;
                                    }
                                    if (!anyUnmeetable) {
                                        indent.add((BWidget)new BLabel(CommissioningWizardStep.LEX.getText("CommissioningWizard.module.unmetDeps.message", new Object[]{ModuleStep.this.tableModel.getNameAt(row)})));
                                        indent.add((BWidget)new BBox(0.0, 3.0));
                                        indent.indent();
                                        anyUnmeetable = true;
                                    }
                                    indent.add((BWidget)new BLabel(BImage.make((BIcon)unmeetable.getIcon()), text.toString()));
                                }
                                indent.unindent();
                                if (anyFailedFilters) {
                                    indent.add((BWidget)new BBox(0.0, 3.0));
                                    indent.add(LexiconText.make((String)"platDaemon", (String)"CommissioningWizard.module.unlicensed.message"));
                                }
                                if ((excluded = solution.getExcludedInstallables()).length > 0) {
                                    if (anyUnmeetable) {
                                        indent.add((BWidget)new BBox(0.0, 3.0));
                                    }
                                    indent.add((BWidget)new BLabel(CommissioningWizardStep.LEX.getText("CommissioningWizard.module.exclusions.message", new Object[]{ModuleStep.this.tableModel.getNameAt(row)})));
                                    indent.add((BWidget)new BBox(0.0, 3.0));
                                    indent.indent();
                                    BDependency excl = solution.getFailedExclusion(excluded[0]);
                                    indent.add((BWidget)new BLabel(BImage.make((BIcon)excl.getIcon()), excl.getPartName()));
                                } else if (!anyUnmeetable) {
                                    indent.add((BWidget)new BLabel(CommissioningWizardStep.LEX.getText("CommissioningWizard.module.unmetDeps.message", new Object[]{ModuleStep.this.tableModel.getNameAt(row)})));
                                    indent.add((BWidget)new BBox(0.0, 3.0));
                                    indent.indent();
                                    for (BDependency unmet : solution.getInstallableCandidates().getDependencies()) {
                                        indent.add((BWidget)new BLabel(BImage.make((BIcon)unmet.getIcon()), unmet.toString()));
                                    }
                                }
                                BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 4.0, 4.0, 4.0, 4.0));
                                scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                                scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                                BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)scrollPane);
                                constrainedPane.setMinHeight(200.0);
                                constrainedPane.setMaxHeight(200.0);
                                BDialog.warning((BWidget)ModuleStep.this.wizardModel.owner, (String)CommissioningWizardStep.LEX.getText("CommissioningWizard.module.unmetDeps.title"), (Object)constrainedPane);
                            }
                        }
                        finally {
                            if (shell != null) {
                                shell.exitBusy();
                            }
                        }
                    }
                    if (grp != null) {
                        grp.stopActive();
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
                ModuleStep.this.tableModel.updateTable();
            } else {
                super.cellPressed(event, row, column);
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)new ModuleDetailCommand(row)), null);
            menu.open((BWidget)ModuleStep.this.table, event.getX(), event.getY());
        }
    }

    private class ModuleDetailCommand
    extends Command {
        private final int row;

        public ModuleDetailCommand(int pRow) {
            super(ModuleStep.this.wizardModel.owner, CommissioningWizardStep.LEX, "SoftwareManager.command.details");
            this.row = pRow;
        }

        public CommandArtifact doInvoke() {
            try {
                BPartDetailsPane detail = new BPartDetailsPane(ModuleStep.this.tableModel.getCertValidator(), ModuleStep.this.tableModel.getModuleVerificationMode());
                detail.loadValue(ModuleStep.this.tableModel.getCurrentPartAt(this.row), ModuleStep.this.tableModel.getInstallablePartAt(this.row), ModuleStep.this.tableModel.getTypeAt(this.row), ModuleStep.this.tableModel.getForwardDependenciesAt(this.row), ModuleStep.this.tableModel.getDependentPartsAt(this.row));
                BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)detail, 4.0, 4.0, 4.0, 4.0));
                scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)scrollPane);
                constrainedPane.setFixedSize(600.0, 480.0);
                BDialog.message((BWidget)ModuleStep.this.wizardModel.owner, (String)CommissioningWizardStep.LEX.getText("SoftwareManager.command.details.dlgTitle"), (Object)constrainedPane);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    public class ModuleCellRenderer
    extends InstallerCellRenderer {
        public ModuleTableModel getModuleTableModel() {
            return (ModuleTableModel)this.getTable().getModel();
        }

        @Override
        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 3) {
                switch (this.getModuleTableModel().getRequirementAt(cell.row)) {
                    case 2: 
                    case 3: {
                        return BColor.red.toBrush();
                    }
                    case 1: {
                        return BColor.chocolate.toBrush();
                    }
                }
            }
            return super.getForeground(this.getModuleTableModel().translateCell(cell));
        }

        @Override
        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 3) {
                switch (this.getModuleTableModel().getRequirementAt(cell.row)) {
                    case 2: 
                    case 3: {
                        return BColor.red.toBrush();
                    }
                    case 1: {
                        return BColor.chocolate.toBrush();
                    }
                }
            }
            return super.getSelectionForeground(this.getModuleTableModel().translateCell(cell));
        }

        @Override
        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                String s = this.getCellText(cell);
                return Theme.table().getCellFont().width(s) + 14.0;
            }
            return super.getPreferredCellWidth(this.getModuleTableModel().translateCell(cell));
        }

        @Override
        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                double x;
                ModuleTableModel model = this.getModuleTableModel();
                ModuleRow rowObj = model.getModuleRow(cell.row);
                this.paintCellBackground(g, cell);
                BFont font = Theme.table().getCellFont();
                double cx = x = 2.0;
                double cy = (cell.height - font.getHeight()) / 2.0;
                double cw = 10.0;
                double ch = 10.0;
                if (rowObj.isSelectEnabled() && model.isRowSelectEnabled()) {
                    g.setBrush(BColor.black.toBrush());
                } else {
                    g.setBrush(BColor.gray.toBrush());
                }
                g.strokeRect(cx, cy, cw, ch);
                if (rowObj.isSelected()) {
                    g.strokeLine(cx, cy, cx + cw, cy + ch);
                    g.strokeLine(cx, cy + cw, cx + cw, cy);
                }
                if (cell.selected) {
                    g.setBrush(this.getSelectionForeground(cell));
                } else {
                    g.setBrush(this.getForeground(cell));
                }
                String s = this.getCellText(cell);
                switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                    case 2: {
                        x = cell.width - 2.0 - font.width(s);
                        break;
                    }
                    case 1: {
                        x = (cell.width - font.width(s)) / 2.0;
                    }
                }
                g.setFont(font);
                g.drawString(s, x + 14.0, font.getAscent() + 2.0);
            } else {
                super.paintCell(g, cell);
            }
        }
    }

    class ModuleTableModel
    extends InstallerTableModel
    implements AsyncGroup.AsyncGroupMember {
        private AsyncGroup asyncGroup;
        private boolean isRowSelectEnabled = true;

        ModuleTableModel() {
        }

        @Override
        public void init(BDaemonSession targetSession, DaemonSessionTaskListener taskListener, boolean sort) throws AuthenticationException {
            this.scenario = ModuleStep.this.wizardModel.initialScenario;
            this.certValidator = this.scenario.getCertValidator();
            this.taskListener = taskListener;
            try {
                this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            this.rebuild(sort);
        }

        @Override
        public void resetScenario() {
            this.scenario = ModuleStep.this.wizardModel.initialScenario;
            try {
                this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            this.rebuild(true);
        }

        @Override
        public BModuleContent getTargetModuleContent() {
            return this.scenario.getTargetPlatform().getModuleContent();
        }

        @Override
        public void updateTable(boolean resizeColumns) {
            super.updateTable(resizeColumns);
            if (ModuleStep.this.upgradeOODCommand != null) {
                boolean enableUpgradeOOD = false;
                for (int i = 0; i < ModuleStep.this.tableModel.getRowCount(); ++i) {
                    int status = ModuleStep.this.tableModel.getStatusAt(i);
                    if (status != 3 && status != 4 && status != 12) continue;
                    enableUpgradeOOD = true;
                    break;
                }
                ModuleStep.this.upgradeOODCommand.setEnabled(enableUpgradeOOD);
            }
            if (ModuleStep.this.spaceDeltaLabel != null) {
                long freeSpaceDeltaKb = (int)(this.getSizeDeltaOnCommit() / 1024L);
                ModuleStep.this.spaceDeltaLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(freeSpaceDeltaKb));
                if (ModuleStep.this.afterSpaceLabel != null) {
                    long proposedFreeSpace = ModuleStep.this.currentFreeSpace - freeSpaceDeltaKb;
                    ModuleStep.this.afterSpaceLabel.setText(((DecimalFormat)DaemonFileUtil.kbFormat.get()).format(proposedFreeSpace));
                }
            }
        }

        @Override
        protected void updateValues(boolean sort) {
            if (ModuleStep.this.wizardModel.initialScenario == null) {
                return;
            }
            for (BInstallable inst : ModuleStep.this.wizardModel.initialScenario.getToInstall()) {
                PartSpec spec = inst.getPartSpec();
                if (!spec.getPartType().equals((Object)BModulePart.TYPE.getTypeSpec())) continue;
                if (ModuleStep.this.analysisResults.isPlatformModule(spec.getPartName())) {
                    ((ModuleRow)this.getRow(spec)).requirement = 3;
                    continue;
                }
                if (ModuleStep.this.analysisResults.isStationModule(spec.getPartName())) {
                    ((ModuleRow)this.getRow(spec)).requirement = 2;
                    continue;
                }
                if (ModuleStep.this.analysisResults.isMissing(spec.getPartName())) {
                    ((ModuleRow)this.getRow(spec)).requirement = 4;
                    continue;
                }
                if (inst instanceof BModuleInstallable && ModuleStep.this.lexiconModules.contains(inst)) {
                    ModuleStep.this.lexiconModules.remove(inst);
                    continue;
                }
                throw new IllegalStateException(spec + " is installed in initial scenario, but reason is unknown");
            }
            for (BModuleInstallable lexiconModule : ModuleStep.this.lexiconModules) {
                PartSpec spec = lexiconModule.getPartSpec();
                ModuleRow lexRow = (ModuleRow)this.getRow(spec);
                if (lexRow == null) continue;
                lexRow.requirement = 1;
            }
            super.updateValues(sort);
        }

        public ModuleRow getModuleRow(int row) {
            return (ModuleRow)this.getRow(row);
        }

        public int getRequirementAt(int row) {
            return this.getModuleRow(row).getRequirement();
        }

        @Override
        protected InstallerTableRow makeRow() {
            return new ModuleRow(this);
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public void sortByColumn(int col, boolean ascending) {
            super.sortByColumn(this.translateColumn(col), ascending);
        }

        public TableCellRenderer.Cell translateCell(TableCellRenderer.Cell cell) {
            TableCellRenderer.Cell result = new TableCellRenderer.Cell();
            result.row = cell.row;
            result.column = this.translateColumn(cell.column);
            result.value = cell.value;
            result.width = cell.width;
            result.height = cell.height;
            result.selected = cell.selected;
            return result;
        }

        public int translateColumn(int col) {
            switch (col) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.moduleTable.column.partName");
                }
                case 1: {
                    return CommissioningWizardStep.LEX.getText("SoftwareManager.column.currentVersion");
                }
                case 2: {
                    return CommissioningWizardStep.LEX.getText("SoftwareManager.column.availableVersion");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return super.getValueAt(row, this.translateColumn(col));
        }

        public synchronized void startActive() {
            this.isRowSelectEnabled = false;
        }

        public synchronized void stopActive() {
            this.isRowSelectEnabled = true;
        }

        public synchronized boolean isRowSelectEnabled() {
            return this.isRowSelectEnabled;
        }

        public void setAsyncGroup(AsyncGroup group) {
            this.asyncGroup = group;
        }

        public AsyncGroup getAsyncGroup() {
            return this.asyncGroup;
        }
    }

    class ModuleRow
    extends InstallerTableRow {
        private int requirement;

        public ModuleRow(ModuleTableModel model) {
            super(model);
            this.requirement = 0;
        }

        @Override
        public String getComment() {
            switch (this.getRequirement()) {
                case 2: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.moduleTable.requiredStation", new Object[]{this.getInstallable().getVersion()});
                }
                case 3: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.moduleTable.requiredPlatform", new Object[]{this.getInstallable().getVersion()});
                }
                case 4: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.moduleTable.requiredModuleContent", new Object[]{this.getInstallable().getVersion()});
                }
                case 1: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.moduleTable.requiredLexicon", new Object[]{this.getInstallable().getVersion()});
                }
            }
            if (!(this.getInstallStatus() != BPartInstallStatus.noChange && this.getInstallStatus() != BPartInstallStatus.notFound || this.getStatus() != 12 && this.getStatus() != 13)) {
                if (this.getStatus() == 12) {
                    return BDaemonSessionView.lexicon.getText("CommissioningWizard.moduleTable.coreRequiredOod");
                }
                if (this.getStatus() == 13) {
                    return BDaemonSessionView.lexicon.getText("CommissioningWizard.moduleTable.coreRequiredMissing");
                }
            }
            return super.getComment();
        }

        @Override
        public void setInstallable(BInstallable value) {
            super.setInstallable(value);
        }

        @Override
        public void setCurrentPart(BPart value) {
            super.setCurrentPart(value);
        }

        public int getRequirement() {
            return this.requirement;
        }

        @Override
        public int compareComment(InstallerTableRow pRow) {
            boolean rowOutOfDate;
            ModuleRow row = (ModuleRow)pRow;
            if (this.getRequirement() == 1) {
                if (row.getRequirement() != 1) {
                    return -1;
                }
            } else if (row.getRequirement() == 1) {
                return 1;
            }
            boolean thisOutOfDate = this.getStatus() == 3 || this.getStatus() == 4;
            boolean bl = rowOutOfDate = row.getStatus() == 3 || row.getStatus() == 4;
            if (thisOutOfDate < rowOutOfDate) {
                return 1;
            }
            if (thisOutOfDate > rowOutOfDate) {
                return -1;
            }
            if (this.getRequirement() < row.getRequirement()) {
                return 1;
            }
            if (this.getRequirement() > row.getRequirement()) {
                return -1;
            }
            return super.compareComment(row);
        }

        public boolean isSelectEnabled() {
            return this.getRequirement() <= 1;
        }

        public boolean isSelected() {
            return this.getInstallStatus() != BPartInstallStatus.noChange && this.getInstallStatus() != BPartInstallStatus.notFound;
        }
    }

    private static class SignatureWarningStep
    extends CommissioningWizardStep {
        private boolean shouldSkip = false;
        private static final int WORD_WRAP_LABEL_BUFFER = 45;

        public SignatureWarningStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
        }

        @Override
        public String getSectionName() {
            return "module";
        }

        @Override
        public int getMode() {
            return 3;
        }

        @Override
        public String getStepName() {
            return "signatureWarning";
        }

        @Override
        public void enter() {
            this.initStep();
        }

        @Override
        public boolean exit(int direction) {
            return true;
        }

        @Override
        public boolean isSkipped() {
            this.initStep();
            return this.wizardModel.skipModules || this.shouldSkip;
        }

        private void initStep() {
            int targetWidth;
            BIndentPane indent = new BIndentPane();
            indent.add(this.getLexiconText("CommissioningWizard.signatureWarning.header"));
            indent.add((BWidget)new BBox(0.0, 5.0));
            indent.indent();
            InstallScenario scenario = this.wizardModel.moduleScenario;
            HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
            BInstallable[] toInstall = scenario.getToInstall();
            Arrays.sort(toInstall, Comparator.comparing(BInstallable::getInstallableName));
            for (BInstallable installable : toInstall) {
                BModulePart part;
                List statuses;
                if (!(installable instanceof BModuleInstallable) || (statuses = (part = ((BModuleInstallable)installable).getModulePart()).getSignatureStatus(scenario.getCertValidator())).contains(ModuleSignatureStatusEnum.OK)) continue;
                for (ModuleSignatureStatusEnum status : statuses) {
                    warnings.computeIfAbsent(status, k -> new ArrayList()).add(installable.toString());
                }
            }
            if (!warnings.isEmpty()) {
                targetWidth = (int)this.wizardModel.getWizard().getPreferredWidth() - 45;
                for (Map.Entry entry : warnings.entrySet()) {
                    BLabel label = new BLabel(LEX.getText("InstallCommand." + ((ModuleSignatureStatusEnum)entry.getKey()).toString() + ".warning"));
                    label.setWordWrapEnabled(true, (double)(targetWidth - indent.getIndentWidth()));
                    label.setHalign(BHalign.left);
                    indent.add((BWidget)label);
                    indent.indent();
                    for (String module : (List)entry.getValue()) {
                        indent.add((BWidget)new BLabel(module));
                    }
                    indent.unindent();
                    indent.add((BWidget)new BBox(0.0, 5.0));
                }
            } else {
                this.shouldSkip = true;
                return;
            }
            indent.unindent();
            BLabel label = new BLabel(LEX.getText("CommissioningWizard.signatureWarning.continue"));
            label.setWordWrapEnabled(true, (double)targetWidth);
            label.setHalign(BHalign.left);
            indent.add((BWidget)label);
            BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 4.0, 4.0, 4.0, 4.0));
            scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            this.setContent((BWidget)scrollPane);
        }
    }

    private static class ExistingModuleSignatureErrorsStep
    extends CommissioningWizardStep {
        private boolean shouldSkip = true;
        private static final int WORD_WRAP_LABEL_BUFFER = 45;

        public ExistingModuleSignatureErrorsStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
        }

        @Override
        public String getSectionName() {
            return "module";
        }

        @Override
        public int getMode() {
            return 1;
        }

        @Override
        public String getStepName() {
            return "existingSignatureErrors";
        }

        @Override
        public void enter() {
            this.initStep();
        }

        @Override
        public boolean exit(int direction) {
            return true;
        }

        @Override
        public boolean isSkipped() {
            this.initStep();
            return this.shouldSkip;
        }

        private void initStep() {
            InstallScenario scenario = this.wizardModel.moduleScenario;
            BDaemonPlatform platform = scenario.getTargetPlatform();
            HashMap<String, BModuleInstallable> existingModuleMap = new HashMap<String, BModuleInstallable>();
            BVector existingModules = platform.getModuleList().getModules();
            SlotCursor slotCursor = existingModules.getProperties();
            while (slotCursor.next(BModuleInstallable.class)) {
                BModuleInstallable installable = (BModuleInstallable)slotCursor.get();
                existingModuleMap.put(installable.getInstallableName(), installable);
            }
            for (BInstallable bInstallable : scenario.getToInstall()) {
                if (!(bInstallable instanceof BModuleInstallable)) continue;
                existingModuleMap.remove(bInstallable.getInstallableName());
            }
            for (String string : scenario.getModulesToUninstall()) {
                existingModuleMap.remove(string);
            }
            ModuleVerificationMode moduleVerificationMode = scenario.getVerificationMode();
            HashMap<ModuleSignatureStatusEnum, List> errors = new HashMap<ModuleSignatureStatusEnum, List>();
            for (Map.Entry entry : existingModuleMap.entrySet()) {
                BModuleInstallable installable = (BModuleInstallable)entry.getValue();
                BModulePart bModulePart = installable.getModulePart();
                List statuses = bModulePart.getSignatureStatus(scenario.getCertValidator());
                for (ModuleSignatureStatusEnum status : statuses) {
                    if (status.isAcceptable(moduleVerificationMode)) continue;
                    errors.computeIfAbsent(status, k -> new ArrayList()).add(installable.toString());
                }
            }
            if (!errors.isEmpty()) {
                this.shouldSkip = false;
                BIndentPane indent = new BIndentPane();
                indent.add(this.getLexiconText("CommissioningWizard.existingModuleSignatureErrors.header"));
                indent.add((BWidget)new BBox(0.0, 5.0));
                indent.indent();
                int n = (int)this.wizardModel.getWizard().getPreferredWidth() - 45;
                for (Map.Entry entry : errors.entrySet()) {
                    BLabel label = new BLabel(LEX.getText("CommissioningWizard.existingModuleSignatureErrors." + ((ModuleSignatureStatusEnum)entry.getKey()).toString()));
                    label.setWordWrapEnabled(true, (double)(n - indent.getIndentWidth()));
                    label.setHalign(BHalign.left);
                    indent.add((BWidget)label);
                    indent.indent();
                    for (String module : (List)entry.getValue()) {
                        indent.add((BWidget)new BLabel(module));
                    }
                    indent.unindent();
                    indent.add((BWidget)new BBox(0.0, 5.0));
                }
                BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 4.0, 4.0, 4.0, 4.0));
                scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                this.setContent((BWidget)scrollPane);
            } else {
                this.shouldSkip = true;
            }
        }
    }

    private class UnavailableModuleStep
    extends CommissioningWizardStep {
        private static final int WORD_WRAP_LABEL_BUFFER = 45;

        public UnavailableModuleStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
        }

        @Override
        public String getSectionName() {
            return "module";
        }

        @Override
        public int getMode() {
            return 1;
        }

        @Override
        public String getStepName() {
            return "unavailableModules";
        }

        @Override
        public void enter() {
            this.initStep();
        }

        @Override
        public boolean exit(int direction) {
            return true;
        }

        @Override
        public boolean isSkipped() {
            this.initStep();
            return this.wizardModel.skipModules || this.wizardModel.initialScenario.canCommit();
        }

        private void initStep() {
            if (this.wizardModel.initialScenario.canCommit()) {
                return;
            }
            BIndentPane indent = new BIndentPane();
            InstallScenario scenario = this.wizardModel.initialScenario;
            Map failed = scenario.getSignatureFailures();
            if (!failed.isEmpty()) {
                HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
                for (Map.Entry entry : failed.entrySet()) {
                    List statuses = (List)entry.getValue();
                    Iterator iterator = statuses.iterator();
                    while (iterator.hasNext()) {
                        ModuleSignatureStatusEnum status = (ModuleSignatureStatusEnum)iterator.next();
                        if (status.isAcceptable(scenario.getVerificationMode())) continue;
                        warnings.computeIfAbsent(status, k -> new ArrayList()).add(((BModuleInstallable)entry.getKey()).toString());
                    }
                }
                int targetWidth = (int)this.wizardModel.getWizard().getPreferredWidth() - 45;
                BLabel error = new BLabel(LEX.getText("CommissioningWizard.signatureErrors.header"));
                error.setWordWrapEnabled(true, (double)targetWidth);
                error.setHalign(BHalign.left);
                indent.add((BWidget)error);
                indent.add((BWidget)new BBox(0.0, 5.0));
                indent.indent();
                for (Map.Entry entry : warnings.entrySet()) {
                    BLabel label = new BLabel(LEX.getText("InstallCommand." + ((ModuleSignatureStatusEnum)entry.getKey()).toString() + ".error"));
                    label.setWordWrapEnabled(true, (double)(targetWidth - indent.getIndentWidth()));
                    label.setHalign(BHalign.left);
                    indent.add((BWidget)label);
                    indent.indent();
                    for (String module : (List)entry.getValue()) {
                        indent.add((BWidget)new BLabel(module));
                    }
                    indent.unindent();
                    indent.add((BWidget)new BBox(0.0, 5.0));
                }
            } else if (scenario.getUnmeetableDependencies().length > 0) {
                indent.add(this.getLexiconText("CommissioningWizard.unavailableModules.header"));
                indent.indent();
                ArrayList<InstallableFilter> failedFilters = new ArrayList<InstallableFilter>();
                for (UnmeetableDependency unmeetableDependency : ModuleStep.this.analysisResults.getSolution().getUnmeetableDependencies()) {
                    StringBuilder text = new StringBuilder(unmeetableDependency.toString());
                    if (unmeetableDependency.failedFilter != null) {
                        int index = failedFilters.indexOf(unmeetableDependency.failedFilter);
                        if (index < 0) {
                            failedFilters.add(unmeetableDependency.failedFilter);
                            index = failedFilters.indexOf(unmeetableDependency.failedFilter);
                        }
                        text.append(" ");
                        for (int i = 0; i <= index; ++i) {
                            text.append("*");
                        }
                    }
                    indent.add((BWidget)new BLabel(BImage.make((BIcon)unmeetableDependency.getIcon()), text.toString()));
                }
                indent.unindent();
                boolean addLicenseButton = false;
                StringBuilder prefix = new StringBuilder();
                for (InstallableFilter installableFilter : failedFilters) {
                    prefix.append("*");
                    if (installableFilter instanceof SignedDistFilter) {
                        indent.add((BWidget)new BBox(0.0, 3.0));
                        indent.add("(" + prefix + ") " + this.getLexiconText("CommissioningWizard.dist.failedSignature").getText(null));
                        continue;
                    }
                    if (installableFilter instanceof DistLicenseFeatureFilter) {
                        addLicenseButton = true;
                        indent.add((BWidget)new BBox(0.0, 3.0));
                        String features = String.join((CharSequence)", ", ((DistLicenseFeatureFilter)installableFilter).getSatisfyingFeatures());
                        BLabel missingFeatureLabel = new BLabel("(" + prefix + ") " + this.getLexiconText("CommissioningWizard.unavailableModules.missingFeature").getText(null, new Object[]{features}));
                        int targetWidth = (int)this.wizardModel.getWizard().getPreferredWidth() - 45;
                        missingFeatureLabel.setWordWrapEnabled(true, (double)targetWidth);
                        missingFeatureLabel.setHalign(BHalign.left);
                        indent.add((BWidget)missingFeatureLabel);
                        continue;
                    }
                    addLicenseButton = true;
                    indent.add((BWidget)new BBox(0.0, 3.0));
                    indent.add("(" + prefix + ") " + this.getLexiconText("CommissioningWizard.unavailableModules.unlicensed.part1").getText(null));
                }
                if (addLicenseButton) {
                    BFlowPane flow = new BFlowPane(BHalign.left);
                    flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.unavailableModules.unlicensed.part2")));
                    BButton bButton = new BButton((Command)new LicenseCommand(), true, false);
                    bButton.setFont(Theme.widget().getTextFont());
                    bButton.setPadding(BInsets.make((double)3.0, (double)6.0, (double)3.0, (double)6.0));
                    flow.add(null, (BValue)bButton);
                    flow.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.unavailableModules.unlicensed.part3")));
                    indent.add((BWidget)flow);
                }
            }
            BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 4.0, 4.0, 4.0, 4.0));
            scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            this.setContent((BWidget)scrollPane);
        }
    }
}

