/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platcrypto.ui.CertificateWizardModel;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.commands.SessionInfoCommand;
import com.tridium.workbench.nav.BSessionMenuAgent;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
@NiagaraSingleton
public class BDaemonSessionMenuAgent
extends BSessionMenuAgent {
    @Generated
    public static final BDaemonSessionMenuAgent INSTANCE = new BDaemonSessionMenuAgent();
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSessionMenuAgent.class);
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BISession session = (BISession)target;
        SessionInfoCommand info = new SessionInfoCommand(owner, target);
        BMenu menu = super.doMakeMenu(owner, target, cx);
        menu.add(null, (Command)info);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, (BValue)new BActionMenuItem((Command)new CommissioningWizardCommand(owner, (BDaemonSession)target)), null);
        menu.add(null, (BValue)new BActionMenuItem((Command)new CertificateWizardCommand(owner, (BDaemonSession)target)), null);
        if (!session.isConnected()) {
            info.setEnabled(false);
        }
        return menu;
    }

    private static class CertificateWizardCommand
    extends Command {
        private final BDaemonSession session;

        public CertificateWizardCommand(BWidget pOwner, BDaemonSession pSession) {
            super(pOwner, lex, "CertWizard.openWizard");
            this.session = pSession;
            try {
                this.setEnabled(this.session.isConnected() && this.session.getHostProperties().isNiagara4());
            }
            catch (Exception e) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            try {
                BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CertificateWizardModel(this.session));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
            }
            return null;
        }
    }

    private static class CommissioningWizardCommand
    extends Command {
        private final BDaemonSession session;

        public CommissioningWizardCommand(BWidget pOwner, BDaemonSession pSession) {
            super(pOwner, lex, "DaemonSessionMenuAgent.openWizard");
            this.session = pSession;
            try {
                this.setEnabled(this.session.isConnected() && this.session.getHostProperties().isNiagara4() && this.session.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full) && !this.session.getHostProperties().getNiagaraR2Enabled() && !this.session.usesLocalNiagaraHome());
            }
            catch (Exception e) {
                this.setEnabled(false);
            }
        }

        public CommandArtifact doInvoke() {
            if (!CommissioningWizardModel.hostModelAllowsCommissioning(this.session)) {
                BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("CommissioningWizard.cannotCommission", new Object[]{this.session.getHostProperties().getModelName()}));
                return null;
            }
            try {
                BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), this.session, false));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), this.session.getHost());
            }
            return null;
        }
    }
}

