/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platform.ui.util.BIndentPane;
import java.util.List;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public abstract class HostNotFipsReadyItem {
    public abstract String getDescription();

    public BWidget getDescriptionWidget() {
        return new BLabel(this.getDescription());
    }

    public static class HostNotFipsReadyExceptionItem
    extends HostNotFipsReadyItem {
        private Exception e;

        public HostNotFipsReadyExceptionItem(Exception e) {
            this.e = e;
        }

        @Override
        public String getDescription() {
            String description;
            Lexicon lexicon = Lexicon.make(HostNotFipsReadyExceptionItem.class);
            String string = description = this.e.getLocalizedMessage() != null ? this.e.getLocalizedMessage() : this.e.getMessage();
            if (description == null) {
                description = lexicon.get("HostNotFipsReadyItem.exception.details.unknown", "Cause unknown");
            }
            return lexicon.getText("HostNotFipsReadyItem.exception.details", new Object[]{description});
        }
    }

    public static class UsersNotFipsReady
    extends HostNotFipsReadyItem {
        private List<String> userList;

        public UsersNotFipsReady(List<String> userList) {
            this.userList = userList;
        }

        @Override
        public String getDescription() {
            StringBuilder builder = new StringBuilder(Lexicon.make(HostNotFipsReadyItem.class).getText("HostNotFipsReadyItem.users.details"));
            for (String user : this.userList) {
                builder.append("\n   " + user);
            }
            return builder.toString();
        }

        @Override
        public BWidget getDescriptionWidget() {
            BIndentPane indentPane = new BIndentPane();
            indentPane.add(Lexicon.make(HostNotFipsReadyItem.class).getText("HostNotFipsReadyItem.users.details"));
            indentPane.indent();
            for (String user : this.userList) {
                indentPane.add(user);
            }
            return indentPane;
        }

        public List<String> getUserList() {
            return this.userList;
        }
    }

    public static class NativeAccountManagementNotSupported
    extends HostNotFipsReadyItem {
        @Override
        public String getDescription() {
            return Lexicon.make(HostNotFipsReadyItem.class).getText("HostNotFipsReadyItem.fileAuthenticationDomain.details");
        }
    }

    public static class NPSDKNotFipsReady
    extends HostNotFipsReadyItem {
        @Override
        public String getDescription() {
            return Lexicon.make(HostNotFipsReadyItem.class).getText("HostNotFipsReadyItem.npsdk.details");
        }
    }

    public static class SystemPassphraseNotFipsReady
    extends HostNotFipsReadyItem {
        @Override
        public String getDescription() {
            return Lexicon.make(HostNotFipsReadyItem.class).getText("HostNotFipsReadyItem.systemPassphrase.details");
        }
    }
}

