/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.install.installable.BFileInstallable;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platform:FileInstallable"})})
@NiagaraAction(name="handleTextModified")
public class BFileInstallableView
extends BWbView {
    @Generated
    public static final Action handleTextModified = BFileInstallableView.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFileInstallableView.class);
    private BLabel fileNameLabel;
    private BLabel fileSizeLabel;
    private BTextField destDirTextField;
    private BEdgePane contentPane;
    private BToolBar toolBar;
    private Command saveCommand;

    @Generated
    public void handleTextModified() {
        this.invoke(handleTextModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFileInstallableView() {
        BGridPane ledger = new BGridPane(2);
        ledger.setStretchColumn(1);
        this.fileNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.fileName"), (BWidget)this.fileNameLabel);
        this.fileSizeLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"DistributionFileView.fileSize"), (BWidget)this.fileSizeLabel);
        this.destDirTextField = new BTextField("", 40, true);
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"FileInstallableView.destDir"), (BWidget)this.destDirTextField);
        this.linkTo((BComponent)this.destDirTextField, (Slot)BTextField.textModified, (Slot)handleTextModified);
        BScrollPane topScroll = new BScrollPane((BWidget)new BBorderPane((BWidget)new BEdgePane(null, null, null, null, (BWidget)ledger), 4.0, 4.0, 4.0, 4.0));
        topScroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        topScroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.contentPane = new BEdgePane(null, null, null, null, (BWidget)topScroll);
        this.toolBar = new BToolBar();
        this.saveCommand = new SaveCommand();
        this.toolBar.add(null, (BValue)new BButton(this.saveCommand, false, true));
    }

    public void doHandleTextModified() {
        if (!this.isModifiedStateLocked()) {
            this.setModified();
            this.saveCommand.setEnabled(true);
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.getShell() instanceof BDialog) {
            this.contentPane.setTop((BWidget)this.toolBar);
            ((BDialog)this.getShell()).setBoundsCenteredOnOwner();
        }
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        BFileInstallable inst = (BFileInstallable)value;
        this.fileNameLabel.setText(inst.getInstallableFileName());
        this.destDirTextField.setText(inst.getDestinationDirPathBody());
        this.fileSizeLabel.setText(DaemonFileUtil.fileSize((long)inst.getInstallableFileSize()));
        this.setContent((BWidget)this.contentPane);
    }

    protected BObject doSaveValue(BObject value, Context context) throws Exception {
        BFileInstallable inst = (BFileInstallable)value;
        new FilePath(this.destDirTextField.getText());
        inst.setDestinationDirPathBody(this.destDirTextField.getText());
        return value;
    }

    private class SaveCommand
    extends Command {
        public SaveCommand() {
            super((BWidget)BFileInstallableView.this, "", BImage.make((BIcon)BIcon.std((String)"save.png")), null, "");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BFileInstallableView.this.saveValue();
                this.setEnabled(false);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }
}

