/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.commissioning;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BRemoteModuleList;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.SignedDistFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.niagarad.util.DaemonAuthUtil;
import com.tridium.nre.auth.NativeAccount;
import com.tridium.nre.auth.UserAccount;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.nre.util.LicenseMode;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.LicenseSelection;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopierOptions;
import com.tridium.platDaemon.ui.widget.DaemonCredentialsManager;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.DaemonResponseException;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.AccountManagementMessage;
import com.tridium.platform.daemon.message.AddMemberMessage;
import com.tridium.platform.daemon.message.AddUserMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.DeleteMemberMessage;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.DeleteUserMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.InitializeSessionMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.UpdateFileAuthenticationMessage;
import com.tridium.platform.daemon.message.UpdateNativeAuthenticationMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.platform.ui.util.BDirectoryTree;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.sys.Nre;
import com.tridium.sys.license.dom.LicenseDatabase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BWidget;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.PatternFilter;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class PlatformCommissioner
implements DaemonSessionTaskListener,
ICancelHint,
InstallableFilter {
    private TaskItem stopAppsItem;
    private TaskItem deleteStationsItem;
    private TaskItem installItem;
    private TaskItem tcpItem;
    private TaskItem osInstallItem;
    private TaskItem dateTimeItem;
    private TaskItem systemPasswordItem;
    private TaskItem authChangeItem;
    private TaskItem rebootItem;
    private TaskItem updateDaemonItem;
    private TaskItem startAppItem;
    private TaskItem reconnectItem;
    private TaskItem importFromPlatformItem;
    private TaskItem cleanAndUpdatePlatformOsAndJvmItem;
    private TaskItem lowMemoryRebootItem;
    private TaskItem lowMemoryReconnectItem;
    private List<TaskItem> items = null;
    private static Logger log = Logger.getLogger("platformDaemon.PlatformCommissioner");
    private BDaemonSession daemonSession;
    private BRemoteDaemonPlatform remotePlatform;
    private HashMap<Type, HashSet<String>> stoppedApps = new HashMap();
    private BTcpIpHostSettings tcpIpSettings = null;
    private BTcpIpHostSettings originalTcpIpSettings = null;
    private boolean hostFileDirty = false;
    private BDhcpdHostSettings dhcpdHostSettings = null;
    private BLinkCfgHostSettings linkCfgHostSettings = null;
    private BPassword newSystemPassword = null;
    private BPassword oldSystemPassword = null;
    private String newUserName;
    private String newUserPassword;
    private String oldUserPassword;
    private String newUserComment;
    private String systemUser;
    private boolean stationPassPhraseRequired;
    private BDirectory stationDir = null;
    private boolean autostartStation = false;
    private String targetStationName = null;
    private boolean startStation = false;
    private boolean deleteStations = false;
    private List<BStationSurrogate> stationsToDelete = new ArrayList<BStationSurrogate>();
    private boolean skipStation = false;
    private SecretChars stationBogPassphrase = null;
    private BStationSurrogate stationSurrogate = null;
    private PBEEncodingInfo encodingInfo = null;
    Set<RuntimeProfile> enabledRuntimeProfiles = null;
    private boolean restartEnabled = true;
    private boolean requireDistStep = true;
    private boolean updateAllOutOfDate = true;
    private SolutionParameters solutionParms;
    protected CommissioningWizardModel wizardModel = null;
    private BDirectory lastStationDir = null;
    private Set<RuntimeProfile> lastEnabledRuntimeProfiles = Collections.emptySet();
    private Version lastMaxCoreVersion = Version.ZERO;
    private DependencyUtil.AnalysisResults analysisResults = null;
    private CertificateChainValidator certValidator;
    private final Map<String, Version> installModuleVersions = new HashMap<String, Version>();
    private final Map<String, Version> remotePlatformModules = new HashMap<String, Version>();
    private final List<BDistribution> installDists = new ArrayList<BDistribution>();
    private final Set<String> uninstallModuleNames = new HashSet<String>();
    private boolean mustReboot = false;
    BRemoteModuleList remoteModules;
    List<BDependency> modulesToRestore;
    List<BInstallable> jreAndOsInstallables = new ArrayList<BInstallable>();
    private final TreeSet<BModuleInstallable> lexiconModules = new TreeSet();
    List<CertificateInfo> certificatesToInstall = new ArrayList<CertificateInfo>();
    private String lastText = null;

    protected PlatformCommissioner(BRemoteDaemonPlatform remotePlatform, BDaemonSession daemonSession, CommissioningWizardModel wizardModel) {
        log.log(Level.FINE, "PlatformCommissioner:: Entering Constructor");
        this.setDaemonSession(daemonSession);
        this.setRemotePlatform(remotePlatform);
        log.log(Level.FINE, "PlatformCommissioner:: Getting Wizard Model");
        if (wizardModel == null) {
            try {
                this.wizardModel = new CommissioningWizardModel(this.daemonSession, this.requireDistStep, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log(Level.FINE, e, () -> "OS Update failed for an unknown reason.");
                throw new BajaRuntimeException("OS Update failed for an unknown reason.");
            }
        } else {
            this.wizardModel = wizardModel;
        }
        this.wizardModel.setStationContent(BStationContentEnum.everything);
        this.stopAppsItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.stopApps"));
        this.deleteStationsItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.deleteStations"));
        this.installItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.install"));
        this.tcpItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.updateTcp"));
        this.osInstallItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.osInstall"));
        this.authChangeItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.updateAuth"));
        this.systemPasswordItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.updateSystemPassword"));
        this.dateTimeItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.dateTime"));
        this.rebootItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.reboot"));
        this.updateDaemonItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.updateDaemon"));
        this.startAppItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.startApp"));
        this.reconnectItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.reconnect"));
        this.importFromPlatformItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.importPlatformModules"));
        this.cleanAndUpdatePlatformOsAndJvmItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.cleanAndUpdatePlatformOsAndJvm"));
        this.lowMemoryRebootItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.reboot"));
        this.lowMemoryReconnectItem = new TaskItem(CommissioningWizardModel.lex.getText("CommissioningWizard.finish.item.reconnect"));
        this.certValidator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(daemonSession));
        log.log(Level.FINE, "PlatformCommissioner:: Exiting Constructor");
    }

    public static PlatformCommissioner make(BRemoteDaemonPlatform remotePlatform, BDaemonSession daemonSession) {
        log.log(Level.FINE, "PlatformCommissioner:: Entering make");
        return new PlatformCommissioner(remotePlatform, daemonSession, null);
    }

    public void installModule(String moduleName, Version version) {
        Objects.requireNonNull(moduleName);
        if (version == null) {
            this.installModuleVersions.put(moduleName, Version.NULL);
        } else {
            this.installModuleVersions.put(moduleName, version);
        }
    }

    public void uninstallModule(String moduleName) {
        Objects.requireNonNull(moduleName);
        this.uninstallModuleNames.add(moduleName);
    }

    public Set<String> getUninstallModuleNames() {
        return this.uninstallModuleNames;
    }

    protected void installDistribution(BIFile distFile) throws Exception {
        Objects.requireNonNull(distFile);
        if (!"dist".equals(distFile.getExtension())) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.notDistFile", new Object[]{distFile.getFilePath().getBody()});
        }
        BDistribution dist = new BDistribution(distFile);
        this.installDists.add(dist);
    }

    protected void installDistribution(BDistribution dist) {
        Objects.requireNonNull(dist);
        this.installDists.add(dist);
    }

    protected void updateEnabledRuntimeProfiles(Set<RuntimeProfile> enabledRuntimeProfiles) {
        if (enabledRuntimeProfiles == null) {
            this.enabledRuntimeProfiles = null;
        } else {
            this.enabledRuntimeProfiles = new HashSet<RuntimeProfile>(enabledRuntimeProfiles);
            if (this.enabledRuntimeProfiles.contains(RuntimeProfile.ux) != this.enabledRuntimeProfiles.contains(RuntimeProfile.wb)) {
                this.enabledRuntimeProfiles.add(RuntimeProfile.ux);
                this.enabledRuntimeProfiles.add(RuntimeProfile.wb);
            }
        }
    }

    protected void addDistFile(BIFile distFile) throws Exception {
        Objects.requireNonNull(distFile);
        if ("dist".equals(distFile.getExtension())) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Using Dist File: " + distFile.toString());
            }
        } else {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.notDistFile", new Object[]{distFile.getFilePath().getBody()});
        }
        BDistribution dist = AccessController.doPrivileged(() -> new BDistribution(distFile));
        this.installDists.add(dist);
        this.requireDistStep = true;
    }

    private TaskItem[] makeTaskItems() {
        boolean mustReboot = false;
        boolean mustStopApps = false;
        boolean mustInstallOs = false;
        boolean mustUpdateDaemon = false;
        this.items = new ArrayList<TaskItem>();
        if (!this.wizardModel.isSkipAuth() && (this.wizardModel.isAuthUsersChanged() || this.wizardModel.isAuthMethodChanged())) {
            this.items.add(this.authChangeItem);
        }
        if (!this.wizardModel.isSkipSystemPassword() && this.wizardModel.getNewSystemPassword() != null && this.wizardModel.getOldSystemPassword() != null) {
            this.items.add(this.systemPasswordItem);
        }
        if (!this.wizardModel.isSkipStation() && this.wizardModel.getStationsToDelete().size() > 0) {
            this.items.add(this.deleteStationsItem);
        }
        if (this.wizardModel.getSolution().hasChanges()) {
            block36: {
                try {
                    if (this.wizardModel.getPlatform().getDaemonSession().getHostProperties().getIsNpsdk() || !this.wizardModel.getPlatform().getArchPart().getPartName().contains("ppc")) break block36;
                    boolean rebootAndReconnect = true;
                    try {
                        if (new Version(this.wizardModel.getPlatform().getDaemonSession().getHostProperties().getDaemonVersion()).compareTo(new Version("4.3")) >= 0) {
                            rebootAndReconnect = false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (rebootAndReconnect) {
                        this.items.add(this.lowMemoryRebootItem);
                        this.items.add(this.lowMemoryReconnectItem);
                    }
                    BInstallable[] installList = this.wizardModel.getSolution().getToInstall();
                    boolean useImport = false;
                    boolean foundOs = false;
                    for (BInstallable anInstallList : installList) {
                        if (anInstallList.getPart() instanceof BVmPart) {
                            this.jreAndOsInstallables.add(anInstallList);
                            useImport = true;
                            if (foundOs) break;
                        }
                        if (!(anInstallList.getPart() instanceof BOsPart)) continue;
                        this.jreAndOsInstallables.add(anInstallList);
                        foundOs = true;
                        if (useImport) break;
                    }
                    if (useImport) {
                        this.items.add(this.importFromPlatformItem);
                        this.items.add(this.cleanAndUpdatePlatformOsAndJvmItem);
                        mustReboot = true;
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINE, e, () -> "makeTaskItems:: Failure setting up tasks.");
                }
            }
            this.items.add(this.installItem);
            if ((this.wizardModel.getSolution().getProcessingFlags() & 0x20000L) > 0L) {
                mustInstallOs = true;
                mustReboot = true;
            }
            if ((this.wizardModel.getSolution().getProcessingFlags() & 0x10000L) > 0L) {
                mustReboot = true;
            } else if ((this.wizardModel.getSolution().getProcessingFlags() & 0x40000L) > 0L) {
                mustUpdateDaemon = true;
            }
            mustStopApps = true;
        }
        if (!this.wizardModel.isSkipSyncLocalTime() && this.wizardModel.isSyncLocalTime()) {
            this.items.add(this.dateTimeItem);
        }
        if (!this.wizardModel.isSkipTcp() && (this.wizardModel.isUpdateTcpIpSettings() || this.wizardModel.isUpdateDhcpdSettings() || this.wizardModel.isUpdateLinkSettings())) {
            this.items.add(this.tcpItem);
            mustStopApps = true;
            mustReboot = true;
        }
        if (!this.skipStation && this.stationDir != null && !this.restartEnabled) {
            mustReboot = true;
        }
        if (mustInstallOs) {
            this.items.add(this.osInstallItem);
        }
        if (mustReboot) {
            this.items.add(this.rebootItem);
        } else {
            if (mustStopApps) {
                try {
                    BAppSurrogate[] allApplications;
                    for (BAppSurrogate app : allApplications = BAppSurrogate.makeAll(null, (BDaemonSession)this.daemonSession)) {
                        if (app.isAppStopped()) continue;
                        if (this.wizardModel.isRestartEnabled()) {
                            if (!this.items.contains(this.startAppItem)) {
                                this.items.add(this.startAppItem);
                            }
                        } else if (!this.items.contains(this.rebootItem)) {
                            this.items.add(this.rebootItem);
                        }
                        break;
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            if (mustUpdateDaemon) {
                this.items.add(this.updateDaemonItem);
            } else if (this.targetStationName != null && this.startStation && !this.items.contains(this.startAppItem)) {
                this.items.add(this.startAppItem);
            }
        }
        if (mustStopApps) {
            this.items.add(0, this.stopAppsItem);
        }
        return this.items.toArray(new TaskItem[0]);
    }

    private void setDaemonConfigurationElements() throws Exception {
        BIFile sysProps = this.daemonSession.getFileSpace().findFile(SystemFilePaths.getSystemPropertiesPath((boolean)this.daemonSession.getHostProperties().getIsNiagaraHomeReadonly()));
        BIFile platformBog = this.daemonSession.getFileSpace().findFile(SystemFilePaths.getPlatformBogPath((boolean)this.daemonSession.getHostProperties().isNiagara4(), (boolean)this.daemonSession.getHostProperties().getIsNiagaraHomeReadonly()));
        if (this.wizardModel.isRequireDist() || sysProps == null || platformBog == null) {
            log.log(Level.FINE, "setDaemonConfigurationElements:: Dist Step is required");
            this.wizardModel.setRequireDist(true);
        }
        log.log(Level.FINE, "setDaemonConfigurationElements:: Adding profiles");
        this.enabledRuntimeProfiles = new HashSet<RuntimeProfile>();
        for (String profileName : this.daemonSession.getHostProperties().getEnabledRuntimeProfileNames().split(",")) {
            this.enabledRuntimeProfiles.add(RuntimeProfile.valueOf((String)profileName));
        }
        this.mustReboot = true;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setDaemonConfigurationElements:: User is Admin-- " + this.wizardModel.isAdmin());
        }
    }

    private void stopRemoteApps() throws Exception {
        log.log(Level.FINE, "stopRemoteApps::Stopping Apps...");
        if (this.items.contains(this.stopAppsItem)) {
            BAppSurrogate[] stopResults = BAppSurrogate.stopAllApps((BDaemonSession)this.daemonSession, null, null, null);
            if (stopResults.length == 0) {
                log.log(Level.FINE, "stopRemoteApps::No apps to stop...");
            } else {
                for (BAppSurrogate result : stopResults) {
                    HashSet<String> appsForType = this.stoppedApps.get(result.getType());
                    if (appsForType == null) {
                        appsForType = new HashSet();
                        this.stoppedApps.put(result.getType(), appsForType);
                    }
                    appsForType.add(result.getAppName());
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "stopRemoteApps::Stopped " + stopResults.length + " apps.");
                }
            }
        }
        log.log(Level.FINE, "Exiting stopRemoteApps");
    }

    protected void addAdminUser(String userName, String password, String oldPassword, String userComment) {
        this.newUserName = userName;
        this.newUserPassword = password;
        this.oldUserPassword = oldPassword;
        this.newUserComment = userComment;
    }

    protected void setSystemPassphrase(BPassword oldSystemPassphrase, BPassword systemPassphrase) {
        log.log(Level.FINE, "Setting new system passphrase...");
        this.newSystemPassword = systemPassphrase;
        this.oldSystemPassword = oldSystemPassphrase;
    }

    protected void run() {
        log.log(Level.FINE, "Entering executeScenario");
        try {
            log.log(Level.FINE, "run(): Initializing scenario..");
            this.initializeScenario();
            this.manageDist();
            this.finalizeCommissioning();
            if (!this.wizardModel.getSolution().canCommit()) {
                log.log(Level.FINE, "Unable to commit current solution. Current Solution: ");
                this.dumpScenario(this.wizardModel.getSolution(), "run::Solution::");
                throw new BajaRuntimeException("Unable to commit solution!");
            }
            this.makeTaskItems();
            this.stopRemoteApps();
            this.lowMemoryReboot();
            this.updatePlatformCredentials();
            this.deleteStations();
            this.importRemotePlatformItems();
            this.installItemsToPlatform();
            this.installStationToPlatform();
            this.setDateandTime();
            this.updateTCPdata();
            boolean rebooted = this.updateOSItems();
            if (!rebooted) {
                this.startRemoteApps();
            } else {
                log.log(Level.FINE, "Skipping startRemoteApps due to platform reboot");
            }
            log.log(Level.FINE, "Install Scenario completed...");
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "executeScenario::Unable to execute Install Scenario");
            throw new BajaRuntimeException("executeScenario:: Unable to execute Install Scenario");
        }
        log.log(Level.FINE, "Exiting executeScenario");
    }

    private void initializeScenario() {
        try {
            this.wizardModel.setLicenseSelection(new NoLicenseInstall());
            this.firstStep();
            this.licenseStep();
            this.stationStep();
            this.runtimeProfileStep();
            this.lexiconStep();
            this.initModules();
            this.tcpIpStep();
            this.systemPassphraseStep();
            this.authStep();
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "initializeScenario:: Failed");
            throw new BajaRuntimeException("initializeScenario:: failed");
        }
    }

    private void finalizeCommissioning() {
        try {
            this.wizardModel.setSolution(this.wizardModel.getDistSolution() == null ? this.wizardModel.getModuleScenario() : this.wizardModel.getDistSolution());
            if (this.updateAllOutOfDate) {
                InstallScenario oodScenario = null;
                try {
                    oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.wizardModel.getSolution(), (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e, () -> "finalizeCommissioning:: UpgradeOutOfDate failed...");
                    this.dumpScenario(this.wizardModel.getSolution(), "finalizeCommissioning:Adding All Modules");
                }
                if (null != oodScenario && oodScenario.canCommit()) {
                    this.wizardModel.setSolution(oodScenario);
                }
            }
            if (this.wizardModel.getModuleScenario().hasChanges()) {
                this.wizardModel.setNoChanges(false);
            }
            if (null == this.targetStationName) {
                this.wizardModel.setSkipStation(true);
            }
            if (!this.wizardModel.isSkipStation()) {
                if (!this.wizardModel.isRestartEnabled()) {
                    this.mustReboot = true;
                }
                ArrayList<BFileInstallable> extraInstallables = new ArrayList<BFileInstallable>();
                for (BIFile file : this.getStationTransferContents()) {
                    extraInstallables.add(new BFileInstallable(file, this.getStationDestDir(file.getFilePath())));
                }
                this.wizardModel.setSolution(this.wizardModel.getSolution().solve(null, null, null, extraInstallables.toArray(new BInstallable[0]), (InstallableRegistry)LocalInstallableRegistry.getInstance()));
                this.dumpScenario(this.wizardModel.getSolution(), "finalizeCommissioning");
                if (this.wizardModel.getPlatform().getArchPart().getPartName().contains("ppc")) {
                    BInstallable[] installList = this.wizardModel.getSolution().getToInstall();
                    boolean useImport = false;
                    boolean foundOs = false;
                    for (BInstallable anInstallList : installList) {
                        if (anInstallList.getPart() instanceof BVmPart) {
                            this.jreAndOsInstallables.add(anInstallList);
                            useImport = true;
                            if (foundOs) break;
                        }
                        if (!(anInstallList.getPart() instanceof BOsPart)) continue;
                        this.jreAndOsInstallables.add(anInstallList);
                        foundOs = true;
                        if (useImport) break;
                    }
                    if (useImport) {
                        this.mustReboot = true;
                    }
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "finalizeCommissioning:: Failed");
            throw new BajaRuntimeException("finalizeCommissioning:: failed");
        }
    }

    private void firstStep() {
        if (this.wizardModel.isSoftwareReadonly()) {
            throw new UnsupportedOperationException(CommissioningWizardModel.lex.getText("CommissioningWizard.cannotCommissionReadonly"));
        }
        this.wizardModel.setSkipDist(false);
        this.wizardModel.setEnableDist(true);
        this.wizardModel.setRequireDist(true);
        this.wizardModel.setSkipTcp(true);
        boolean authReadonly = false;
        try {
            XElem authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null) {
                authReadonly = authElem.getb("readonly", false);
            }
        }
        catch (Exception authInfo) {
            // empty catch block
        }
        if (authReadonly) {
            this.wizardModel.setRequireAuth(false);
            this.wizardModel.setForceChangeUsers(false);
            this.wizardModel.setSkipAuth(true);
            this.wizardModel.setEnableAuth(false);
            this.wizardModel.setSkipConfigUsers(true);
            this.wizardModel.setEnableConfigUsers(false);
        } else {
            this.wizardModel.setSkipAuth(true);
            if (this.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                this.wizardModel.setSkipConfigUsers(false);
                this.wizardModel.setSkipAuth(false);
            }
        }
        boolean systemPassphraseReadonly = false;
        try {
            XElem systemPassphraseInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
            systemPassphraseReadonly = systemPassphraseInfo.getb("readonly", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (systemPassphraseReadonly) {
            this.wizardModel.setRequireSystemPassword(false);
            this.wizardModel.setSkipSystemPassword(true);
            this.wizardModel.setEnableSystemPassword(false);
        }
        if (this.wizardModel.isSystemTimeReadonly()) {
            this.wizardModel.setSyncLocalTime(false);
            this.wizardModel.setSkipSyncLocalTime(true);
        } else {
            this.wizardModel.setSyncLocalTime(true);
            this.wizardModel.setSkipSyncLocalTime(false);
        }
        if (!this.wizardModel.isAdmin()) {
            this.wizardModel.setSkipTcp(true);
            this.wizardModel.setEnableTcp(false);
        }
    }

    private void licenseStep() {
        this.wizardModel.setLicenseReadonly(this.daemonSession.getHostProperties().getIsLicenseReadonly());
        this.loadCurrentLicenses();
    }

    private void loadCurrentLicenses() {
        BIFile brandProps;
        BDirectory remoteLicDir;
        String hostId = this.daemonSession.getHostProperties().getHostId();
        boolean isPerpetual = this.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
        boolean isNiagaraHomeReadonly = this.daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
        this.wizardModel.getCurrentLicenses().clear();
        if (this.wizardModel.isLicensesReadonly()) {
            this.wizardModel.setSkipLicense(true);
            this.wizardModel.setRequireLicense(false);
            this.wizardModel.setEnableLicense(false);
        }
        if ((remoteLicDir = (BDirectory)this.daemonSession.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath((boolean)true, (boolean)isPerpetual, (boolean)isNiagaraHomeReadonly))) == null) {
            if (!this.wizardModel.isLicensesReadonly()) {
                this.wizardModel.setSkipLicense(false);
                this.wizardModel.setRequireLicense(true);
                this.wizardModel.setEnableLicense(false);
            }
            return;
        }
        BIFile[] remoteLicenses = remoteLicDir.listFiles();
        if (remoteLicenses == null || remoteLicenses.length == 0) {
            if (!this.wizardModel.isLicensesReadonly()) {
                this.wizardModel.setSkipLicense(false);
                this.wizardModel.setRequireLicense(true);
                this.wizardModel.setEnableLicense(false);
            }
            return;
        }
        BDirectory remoteCertDir = (BDirectory)this.daemonSession.getFileSpace().findFile(SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)isPerpetual, (boolean)isNiagaraHomeReadonly));
        boolean isLocalPerpetual = SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.PERPETUAL;
        this.wizardModel.setLocalCertificates(this.getCertificates((BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)isLocalPerpetual, (boolean)NiagaraFiles.isNiagaraHomeReadonly()))));
        this.wizardModel.setCurrentCertificates(this.getCertificates(remoteCertDir));
        HashSet<String> availableCertVendors = new HashSet<String>();
        this.wizardModel.getLocalCertificates().stream().map(ci -> ci.vendorCertificate.getVendor()).forEach(availableCertVendors::add);
        this.wizardModel.getCurrentCertificates().stream().map(ci -> ci.vendorCertificate.getVendor()).forEach(availableCertVendors::add);
        this.wizardModel.setAvailableCertVendors(availableCertVendors);
        boolean anyMissingCerts = false;
        String brand = null;
        for (BIFile remoteLicense : remoteLicenses) {
            BIFile remoteLicenseFile;
            if (!(remoteLicense instanceof BIFile) || !"license".equalsIgnoreCase((remoteLicenseFile = remoteLicense).getExtension())) continue;
            try {
                LicenseInfo info = new LicenseInfo(remoteLicenseFile);
                if (!hostId.equals(info.vendorLicense.getHostId())) continue;
                if (brand == null) {
                    brand = info.getBrand();
                }
                if (info.vendorLicense.getVendor().equalsIgnoreCase("tridium") && !info.isExpired()) {
                    this.wizardModel.setCurrentLicenseVersion(info.vendorLicense.getVersion());
                }
                this.wizardModel.getCurrentLicenses().add(info);
                if (this.wizardModel.getAvailableCertVendors().contains(info.vendorLicense.getVendor())) continue;
                anyMissingCerts = true;
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Exception occurred while parsing remote license '" + remoteLicenseFile.getFileName() + "'", e);
            }
        }
        if (brand == null && (brandProps = this.daemonSession.getFileSpace().findFile(SystemFilePaths.getBrandPropsPath((boolean)true))) != null) {
            try {
                Properties props = new Properties();
                try (InputStream in = brandProps.getInputStream();){
                    props.load(in);
                    brand = props.getProperty("brand.id", null);
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                if (!this.wizardModel.isLicensesReadonly()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Exception occurred while determining remote brand, forcing license install", e);
                    }
                    this.wizardModel.setSkipLicense(false);
                    this.wizardModel.setRequireLicense(true);
                    this.wizardModel.setEnableLicense(false);
                }
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        if (!this.wizardModel.isLicensesReadonly()) {
            if (this.wizardModel.getCurrentLicenseVersion() == null || anyMissingCerts) {
                this.wizardModel.setSkipLicense(false);
                this.wizardModel.setRequireLicense(true);
                this.wizardModel.setEnableLicense(false);
            } else {
                this.wizardModel.setRequireLicense(true);
                this.wizardModel.setEnableLicense(false);
            }
        }
        this.wizardModel.setBrandId(brand);
    }

    private List<CertificateInfo> getCertificates(BDirectory dir) {
        ArrayList<CertificateInfo> result = new ArrayList<CertificateInfo>();
        if (dir != null) {
            for (BIFile remoteFile : dir.listFiles()) {
                if (remoteFile.getExtension() == null || !remoteFile.getExtension().equals("certificate")) continue;
                try {
                    result.add(new CertificateInfo(remoteFile));
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
        return result;
    }

    private void stationStep() {
        if (!this.wizardModel.isSkipStation()) {
            try {
                BDaemonDirectoryStore store = BDaemonDirectoryStore.make((BDaemonFileSpace)this.daemonSession.getFileSpace(), (FilePath)SystemFilePaths.getStationsDirPath((boolean)true));
                if (store == null) {
                    DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)SystemFilePaths.getStationsDirPath((boolean)true), (BDaemonFileSpace)this.daemonSession.getFileSpace()), null, null);
                    store = BDaemonDirectoryStore.make((BDaemonFileSpace)this.daemonSession.getFileSpace(), (FilePath)SystemFilePaths.getStationsDirPath((boolean)true));
                }
                this.wizardModel.setTargetStationsRoot(new BDirectory((BIFileStore)store));
            }
            catch (ConnectException e) {
                throw new BajaRuntimeException("Unable to access remote host station store.");
            }
            BStationCopierOptions stationCopierOptions = BStationCopierOptions.make();
            String fileExcludeList = stationCopierOptions.getFilePatternExcludeList();
            String directoryExcludeList = stationCopierOptions.getDirectoryPatternExcludeList();
            this.wizardModel.setFileExcludePatterns(PatternFilter.parseList((String)fileExcludeList, (String)" "));
            this.wizardModel.setDirectoryExcludePatterns(PatternFilter.parseList((String)directoryExcludeList, (String)" "));
            if (this.stationDir != null) {
                try {
                    BDirectoryTree.DirectoryTreeNode dataRecoveryNode;
                    BDirectoryTree.DirectoryTreeNode alarmNode;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Station Directory is: " + this.stationDir);
                    }
                    BBogFile stationBog = (BBogFile)this.stationDir.getNavChild("config.bog");
                    this.setEncodingInfo(stationBog);
                    if (this.stationBogPassphrase != null) {
                        try {
                            if (this.encodingInfo.test(this.stationBogPassphrase)) {
                                this.wizardModel.setStationBogPassphrase(this.stationBogPassphrase);
                                this.wizardModel.setEncodingInfo(this.encodingInfo);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "error testing pass phrase value", e);
                        }
                    } else {
                        this.wizardModel.setStationBogPassphrase(null);
                        this.wizardModel.setEncodingInfo(this.encodingInfo);
                    }
                    this.wizardModel.setStationDir(this.getStationDir());
                    this.wizardModel.setTargetStationName(this.targetStationName);
                    this.wizardModel.setStationSurrogate(this.stationSurrogate);
                    this.wizardModel.setAutoStart(this.autostartStation);
                    this.wizardModel.setStartStation(this.startStation);
                    this.wizardModel.setDirectoryTreeModel(new BDirectoryTree.DirectoryTreeModel());
                    this.wizardModel.getDirectoryTreeModel().setRootDirectory(this.wizardModel.getStationDir());
                    BDirectoryTree.DirectoryTreeNode histNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.getDirectoryTreeModel().getRoot(0)).getChild("history");
                    this.wizardModel.setAxMigration(false);
                    if (histNode != null) {
                        if (histNode.getDirectory().getNavChild("history.zip") == null == this.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                            this.wizardModel.setAxMigration(true);
                            histNode.setChecked(true, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                            histNode.setCheckEnabled(true, true);
                            histNode.setExpanded(false);
                        } else {
                            histNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                            histNode.setCheckEnabled(false, true);
                            histNode.setExpanded(false);
                        }
                    }
                    if ((alarmNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.getDirectoryTreeModel().getRoot(0)).getChild("alarm")) != null) {
                        if (alarmNode.getDirectory().getNavChild("alarm.zip") == null == this.daemonSession.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                            this.wizardModel.setAxMigration(true);
                            alarmNode.setChecked(true, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                            alarmNode.setCheckEnabled(true, true);
                            alarmNode.setExpanded(false);
                        } else {
                            alarmNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                            alarmNode.setCheckEnabled(false, true);
                            alarmNode.setExpanded(false);
                        }
                    }
                    if ((dataRecoveryNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.getDirectoryTreeModel().getRoot(0)).getChild("dataRecovery")) != null) {
                        dataRecoveryNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                        dataRecoveryNode.setCheckEnabled(false, true);
                        dataRecoveryNode.setExpanded(false);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        StringBuilder patterns = new StringBuilder();
                        for (PatternFilter fileExcludePattern : this.wizardModel.getFileExcludePatterns()) {
                            patterns.append(fileExcludePattern.getPattern()).append(' ');
                        }
                        log.log(Level.FINE, "Excluding file patterns: \"" + patterns.toString() + "\" in commissioning wizard station step");
                        patterns = new StringBuilder();
                        for (PatternFilter directoryExcludePattern : this.wizardModel.getDirectoryExcludePatterns()) {
                            patterns.append(directoryExcludePattern.getPattern()).append(' ');
                        }
                        log.log(Level.FINE, "Excluding directory patterns: \"" + patterns.toString() + "\" in commissioning wizard station step");
                    }
                    this.wizardModel.getDirectoryTreeModel().setDirectoryStates((BDirectoryTree.DirectoryTreeNode)this.wizardModel.getDirectoryTreeModel().getRoot(0), this.wizardModel.getDirectoryExcludePatterns(), false, false, false);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
    }

    private void runtimeProfileStep() {
        this.wizardModel.setEnabledRuntimeProfiles(this.enabledRuntimeProfiles);
    }

    private void lexiconStep() {
    }

    private void tcpIpStep() {
    }

    private void systemPassphraseStep() {
        if (this.wizardModel.isSkipSystemPassword()) {
            this.wizardModel.setNewSystemPassword(null);
            this.wizardModel.setOldSystemPassword(null);
            return;
        }
        try {
            if (null != this.newSystemPassword) {
                BPassword opw = this.oldSystemPassword;
                BPassword npw1 = this.newSystemPassword;
                if (!BNativeUserTable.validatePassword((BWidget)this.wizardModel.getWizard(), npw1, new BPasswordStrength(this.daemonSession.getPlatformPasswordStrengthRequirements()))) {
                    throw new BajaRuntimeException("Error setting System passphrase -- Invalid new passphrase.");
                }
                if (new Version(this.daemonSession.getHostProperties().getDaemonVersion()).compareTo(new Version("4.0.17.7.650")) != -1 && !BNativeUserTable.checkStatus(null, this.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(null, opw, true, this.daemonSession.generateSharedSecretKey("commissionWizard_check")))) {
                    throw new BajaRuntimeException("Error setting System passphrase -- Failed status.");
                }
                if (!BNativeUserTable.checkStatus(null, this.daemonSession, (XmlResponseMessage)new SystemPasswordMessage(npw1, null, true, this.daemonSession.generateSharedSecretKey("commissionWizard_check")))) {
                    throw new BajaRuntimeException("Error setting System passphrase.");
                }
                this.wizardModel.setNewSystemPassword(npw1);
                this.wizardModel.setOldSystemPassword(opw);
                this.wizardModel.setSkipSystemPassword(false);
            } else {
                this.wizardModel.setSkipSystemPassword(true);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private void authStep() {
        if (this.wizardModel.isSkipAuth()) {
            this.wizardModel.setAuthMethodChanged(false);
            this.wizardModel.setAuthUsersChanged(false);
            return;
        }
        XElem[] existingAdminUsers = null;
        try {
            if (null == this.newUserName) {
                this.wizardModel.setAuthUsersChanged(false);
            } else {
                String fullyQualifiedName;
                if (!NativeAccount.isAccountNameFullyQualified((String)this.newUserName)) {
                    fullyQualifiedName = this.wizardModel.getNativeAdminGroup().getDomain() + "\\" + this.newUserName;
                } else {
                    fullyQualifiedName = this.newUserName;
                    this.newUserName = NativeAccount.fullyQualifiedToUsername((String)this.newUserName);
                }
                if (BNativeUserTable.isReserved(this.newUserName)) {
                    throw new BajaRuntimeException("User name is a reserved name.");
                }
                UserAccount newUser = new UserAccount(fullyQualifiedName, null);
                newUser.setPassword(this.newUserPassword);
                newUser.setComment(this.newUserComment);
                newUser.setOldPassword(this.oldUserPassword);
                boolean alreadyExists = false;
                if (existingAdminUsers == null) {
                    XElem[] remoteGroups;
                    XElem[] accountInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new AccountManagementMessage())).parse();
                    for (XElem currentGroup : remoteGroups = accountInfo.elems("group")) {
                        if (!currentGroup.get("name").equals(this.wizardModel.getNativeAdminGroup().getFullyQualifiedName())) continue;
                        existingAdminUsers = currentGroup.elems("user");
                    }
                }
                if (existingAdminUsers != null) {
                    for (XElem adminUser : existingAdminUsers) {
                        if (!UserAccount.fullyQualifiedToUsername((String)adminUser.get("name")).equals(this.newUserName)) continue;
                        alreadyExists = true;
                    }
                }
                if (alreadyExists) {
                    return;
                }
                for (int i = 0; i < this.newUserComment.length(); ++i) {
                    char c = this.newUserComment.charAt(i);
                    if (!"-=+()@._ ".contains(String.valueOf(c)) && !Character.isLetterOrDigit(c)) {
                        throw new BajaRuntimeException("User Comment contains invalid values.");
                    }
                    if (i < 64) continue;
                    throw new BajaRuntimeException("User Comment is too long.");
                }
                BPassword pw1 = BPassword.make((String)this.newUserPassword);
                if (!BNativeUserTable.validatePassword((BWidget)this.wizardModel.getWizard(), pw1, new BPasswordStrength(this.daemonSession.getPlatformPasswordStrengthRequirements()))) {
                    throw new BajaRuntimeException("Invalid user Password");
                }
                this.wizardModel.setNewNativeUserAccountToAdd(new UserAccount(fullyQualifiedName, null, this.newUserComment, LegacyStorageUtil.encode((String)AccessController.doPrivileged(() -> ((BPassword)pw1).getValue()), (int)0)));
                this.wizardModel.setDefaultNativeUserAccountToRemove(new UserAccount(this.wizardModel.getNativeAdminGroup().getDomain() + "\\" + this.wizardModel.getDefaultAccountUserName(), null, null, null));
                this.wizardModel.setAuthUsersChanged(true);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private void setEncodingInfo(BBogFile stationBog) throws Exception {
        if (stationBog == null) {
            this.stationPassPhraseRequired = false;
            this.encodingInfo = null;
        } else {
            this.encodingInfo = stationBog.getPBEEncodingInfo();
            this.stationPassPhraseRequired = stationBog.usesReversibleEncryptionPassPhrase() && this.encodingInfo != null && (!this.wizardModel.isSkipSystemPassword() || !this.daemonSession.validateSystemPassPhrase((PBEValidator)this.encodingInfo));
        }
    }

    private void installStationToPlatform() throws ConnectException {
        log.log(Level.FINE, "Entering installStationToPlatform");
        if (this.targetStationName != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Installing Station:  " + this.targetStationName);
                log.log(Level.FINE, "Updating Station " + this.targetStationName);
            }
            this.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage());
            this.daemonSession.sendMessage((DaemonMessage)new UpdateStationMessage(this.targetStationName, false, this.startStation, this.autostartStation, true));
        }
        log.log(Level.FINE, "Exiting installStationToPlatform");
    }

    private List<BIFile> getStationTransferContents() {
        ArrayList<BIFile> result = new ArrayList<BIFile>();
        if (this.wizardModel.getStationContent() == BStationContentEnum.selectedDirectories) {
            Iterator i = this.wizardModel.getDirectoryTreeModel().getCheckedDirectories();
            while (i.hasNext()) {
                BIFile[] files;
                BDirectory sd = (BDirectory)i.next();
                for (BIFile file : files = sd.listFiles()) {
                    if (file.isDirectory() || this.ignoreFile(file)) continue;
                    result.add(file);
                }
            }
        } else if (this.wizardModel.getStationContent() == BStationContentEnum.everything) {
            TreeSet<FilePath> exclude = new TreeSet<FilePath>();
            exclude.add(this.wizardModel.getStationDir().getFilePath().merge("history"));
            exclude.add(this.wizardModel.getStationDir().getFilePath().merge("alarm"));
            exclude.add(this.wizardModel.getStationDir().getFilePath().merge("dataRecovery"));
            this.addAllDataFiles(this.wizardModel.getStationDir(), exclude, result);
        } else if (this.wizardModel.getStationContent() == BStationContentEnum.configOnly) {
            result.add((BIFile)this.wizardModel.getStationDir().getNavChild("config.bog"));
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private void addAllDataFiles(BDirectory dir, Set<FilePath> exclude, List<BIFile> result) {
        BIFile[] files;
        for (BIFile file : files = dir.listFiles()) {
            if (exclude.contains(file.getFilePath())) continue;
            if (file.isDirectory()) {
                if (this.ignoreDirectory((BDirectory)file)) continue;
                this.addAllDataFiles((BDirectory)file, exclude, result);
                continue;
            }
            if (this.ignoreFile(file)) continue;
            result.add(file);
        }
    }

    private boolean ignoreFile(BIFile file) {
        for (int i = 0; i < this.wizardModel.getFileExcludePatterns().length; ++i) {
            if (!this.wizardModel.getFileExcludePatterns()[i].accept(file)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreDirectory(BDirectory directory) {
        for (int i = 0; i < this.wizardModel.getDirectoryExcludePatterns().length; ++i) {
            if (!this.wizardModel.getDirectoryExcludePatterns()[i].accept((BIFile)directory)) continue;
            return true;
        }
        return false;
    }

    private FilePath getStationDestDir(FilePath sourcePath) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "TargetStationsRoot: " + this.wizardModel.getTargetStationsRoot().getNavName());
            log.log(Level.FINE, "TargetStationName : " + this.wizardModel.getTargetStationName());
        }
        FilePath result = this.wizardModel.getTargetStationsRoot().getFilePath().merge(this.wizardModel.getTargetStationName());
        for (int i = this.wizardModel.getStationDir().getFilePath().depth(); i < sourcePath.depth() - 1; ++i) {
            result = result.merge(sourcePath.nameAt(i));
        }
        return result;
    }

    private void manageDist() {
        InstallScenario solution = null;
        BDistribution unacceptedDist = null;
        SignedDistFilter.resetVerificationCache();
        try {
            if (this.wizardModel.isModuleScenarioHasDists() && this.wizardModel.isSkipDist()) {
                solution = this.wizardModel.getModuleScenario();
            } else {
                BInstallable[] excludedInstallables;
                InstallScenario initialDistScenario = this.wizardModel.getModuleScenario();
                if (initialDistScenario == null) {
                    initialDistScenario = this.wizardModel.getInitialScenario();
                }
                if (this.wizardModel.isModuleScenarioHasDists()) {
                    ArrayList<BInstallable> toInstallArray = new ArrayList<BInstallable>();
                    Collections.addAll(toInstallArray, initialDistScenario.getToInstall());
                    toInstallArray.removeIf(obj -> !(obj instanceof BModuleInstallable));
                    initialDistScenario = new InstallScenario(initialDistScenario.getTargetPlatform(), null, initialDistScenario.getUnmetDependencies(), toInstallArray.toArray(new BInstallable[0]), null, null, initialDistScenario.getNewModuleContent(), initialDistScenario.getNewEnabledRuntimeProfiles(), initialDistScenario.getSolutionParameters(), (InstallableRegistry)LocalInstallableRegistry.getInstance(), this.certValidator);
                    if (initialDistScenario.getExcludedInstallables().length > 0) {
                        solution = this.wizardModel.getModuleScenario();
                    }
                }
                if ((excludedInstallables = initialDistScenario.getExcludedInstallables()) != null && excludedInstallables.length == 0) {
                    try (LocalInstallableRegistry.InstallableCursor c = (LocalInstallableRegistry.InstallableCursor)LocalInstallableRegistry.getInstance().getInstallables(true, null, this.wizardModel.getPlatform().getConfigDistFileName());){
                        while (c.next(BDistribution.class)) {
                            BDistribution d = (BDistribution)c.get();
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "manageDist(): Evaluating " + d.getInstallableFileName());
                            }
                            boolean acceptedDist = this.wizardModel.acceptInstallable((BInstallable)d);
                            InstallScenario s = initialDistScenario.solve(null, null, null, new BInstallable[]{d}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                            if (s.canCommit()) {
                                s = s.solve(null, null, DependencyUtil.getPlatformModuleDependencies((BDaemonPlatform)this.wizardModel.getPlatform(), (BDistribution)d, (Set)s.getNewEnabledRuntimeProfiles()), null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                            }
                            if (s.canCommit()) {
                                log.log(Level.FINE, "manageDist():Found a solution...");
                                solution = s;
                                break;
                            }
                            if (s.getExcludedInstallables().length != 0 || solution != null && s.getUnmeetableDependencies().length >= solution.getUnmeetableDependencies().length) continue;
                            boolean wrongPlatform = false;
                            for (BDependency dep : s.getUnmetDependencies()) {
                                if (!dep.isPlatformDependency((BDaemonPlatform)this.wizardModel.getPlatform())) continue;
                                wrongPlatform = true;
                                break;
                            }
                            if (wrongPlatform) continue;
                            if (acceptedDist) {
                                solution = s;
                                continue;
                            }
                            if (unacceptedDist != null) continue;
                            unacceptedDist = d;
                        }
                    }
                }
            }
            if (solution == null) {
                log.log(Level.FINE, "manageDist(): No solution found!");
            } else {
                this.wizardModel.setDistSolution(solution);
                log.log(Level.FINE, "Resulting Scenario: ");
                this.dumpScenario(this.wizardModel.getDistSolution(), "manageDist:DistSolution");
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            SignedDistFilter.resetVerificationCache();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExistingLexiconModuleValid(String modulePartName) {
        try {
            File moduleFile = Nre.bootEnv.findDependency(modulePartName);
            try (ZipFile moduleJar = new ZipFile(moduleFile);){
                ZipEntry zipEntry = moduleJar.getEntry("META-INF/module.xml");
                if (zipEntry == null) {
                    zipEntry = moduleJar.getEntry("meta-inf/module.xml");
                }
                if (zipEntry == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Module does not include manifest: " + modulePartName);
                    }
                    boolean bl = false;
                    return bl;
                }
                XElem manifest = XParser.make((InputStream)moduleJar.getInputStream(zipEntry)).parse();
                XElem lexElem = manifest.elem("lexicons");
                boolean isExternalModuleReferenced = false;
                if (lexElem != null) {
                    for (XElem elem : lexElem.elems("lexicon")) {
                        if (elem.get("module", "").equals(modulePartName)) continue;
                        isExternalModuleReferenced = true;
                        break;
                    }
                }
                if (isExternalModuleReferenced) return true;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, " manageDist - Lexicon does not reference external module: " + modulePartName);
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (ModuleNotFoundException e) {
            return false;
        }
        catch (ModuleException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void startRemoteApps() throws ConnectException {
        log.log(Level.FINE, "Entering startRemoteApps");
        if (this.items.contains(this.startAppItem)) {
            BStationSurrogate station;
            SessionSurrogates sessionSurrogates = new SessionSurrogates(this.daemonSession);
            sessionSurrogates.getVector(true);
            for (Type appType : this.stoppedApps.keySet()) {
                HashSet<String> appsForType = this.stoppedApps.get(appType);
                for (String appOfType : appsForType) {
                    BAppSurrogate app = sessionSurrogates.get(appType, appOfType, false);
                    if (app == null) continue;
                    app.startAppAsync();
                }
            }
            if (this.targetStationName != null && this.startStation && (station = (BStationSurrogate)sessionSurrogates.get(BStationSurrogate.TYPE, this.targetStationName, false)) != null && station.getAppStatus() == BStationStatus.idle) {
                station.startAppAsync();
            }
        }
        log.log(Level.FINE, "Exiting startRemoteApps");
    }

    private boolean updateOSItems() throws ConnectException {
        log.log(Level.FINE, "Entering updateOSItems");
        if (this.items.contains(this.osInstallItem)) {
            try {
                if (this.daemonSession.getHostProperties().supportsServlet("osupdate")) {
                    this.daemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
                }
            }
            catch (ConnectException ce) {
                throw new BajaRuntimeException("Remote connection failed.");
            }
            catch (AuthenticationException ae) {
                throw new BajaRuntimeException("Remote authentication failed.");
            }
            catch (DaemonResponseException dre) {
                log.log(Level.FINE, dre, () -> "Daemon Response Exception; cause unknown. Continuing execution.");
            }
            catch (Exception e) {
                log.log(Level.FINE, e, () -> "OS Update failed for an unknown reason.");
                throw new BajaRuntimeException("OS Update failed for an unknown reason.");
            }
        }
        String currentSessionTimestamp = null;
        if (this.items.contains(this.rebootItem)) {
            currentSessionTimestamp = this.daemonSession.getHostProperties().getSessionTimestamp();
            this.daemonSession.sendRebootRequest();
            return true;
        }
        if (this.items.contains(this.updateDaemonItem)) {
            try {
                this.daemonSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
            }
            catch (SocketException socketException) {}
        } else {
            if (this.wizardModel.getLicenseSelection() != null && this.wizardModel.getLicenseSelection().getLicenseSync() != null && !this.wizardModel.getLicenseSelection().getLicenseSync().unchanged()) {
                log.log(Level.FINE, "Reloading license...");
                this.daemonSession.sendMessage((DaemonMessage)new ReloadLicenseMessage());
            }
            if (this.items.contains(this.startAppItem)) {
                BStationSurrogate station;
                SessionSurrogates sessionSurrogates = new SessionSurrogates(this.daemonSession);
                sessionSurrogates.getVector(true);
                for (Type appType : this.stoppedApps.keySet()) {
                    HashSet<String> appsForType = this.stoppedApps.get(appType);
                    for (String appOfType : appsForType) {
                        BAppSurrogate app = sessionSurrogates.get(appType, appOfType, false);
                        if (app == null) continue;
                        app.startAppAsync();
                    }
                }
                if (this.targetStationName != null && this.startStation && (station = (BStationSurrogate)sessionSurrogates.get(BStationSurrogate.TYPE, this.targetStationName, false)) != null && station.getAppStatus() == BStationStatus.idle) {
                    station.startAppAsync();
                }
            }
        }
        try {
            this.daemonSession.reconnect(currentSessionTimestamp, (ICancelHint)this);
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "Unable to reconnect to remote device.");
            throw new BajaRuntimeException("Unable to reconnect to remote device.");
        }
        log.log(Level.FINE, "Exiting updateOSItems");
        return false;
    }

    private void updateTCPdata() throws Exception {
        log.log(Level.FINE, "Entering updateTCPdata");
        if (this.items.contains(this.tcpItem)) {
            if (this.wizardModel.isUpdateTcpIpSettings()) {
                TcpUtil.saveToSession((BTcpIpHostSettings)this.tcpIpSettings, (BDaemonSession)this.daemonSession, (boolean)this.hostFileDirty);
            }
            if (this.wizardModel.isUpdateDhcpdSettings()) {
                DhcpdUtil.saveToSession((BDhcpdHostSettings)this.dhcpdHostSettings, (BDaemonSession)this.daemonSession);
            }
            if (this.wizardModel.isUpdateLinkSettings()) {
                LinkCfgUtil.saveToSession((BLinkCfgHostSettings)this.linkCfgHostSettings, (BDaemonSession)this.daemonSession);
            }
        }
    }

    private void setDateandTime() throws ConnectException {
        log.log(Level.FINE, "Entering setDateandTime");
        if (this.items.contains(this.dateTimeItem)) {
            BTimeZone ostz = BTimeZone.getLocal();
            String tzid = ostz.getId();
            if (!TimeZoneUtil.isSupported((BTimeZone)ostz, (BDstSupportLevel)this.daemonSession.getHostProperties().getTimezoneDayModeSupport())) {
                ostz = BTimeZone.UTC;
            }
            BHostProperties hostProperties = this.daemonSession.getHostProperties();
            BDstSupportLevel tzSupportMode = hostProperties.getTimezoneDayModeSupport();
            ostz = TimeZoneUtil.makeCompatible((BTimeZone)ostz, (BDstSupportLevel)tzSupportMode);
            this.daemonSession.sendMessage((DaemonMessage)new UpdateTimeMessage(BAbsTime.now(), tzid, ostz, false));
        }
        log.log(Level.FINE, "Exiting setDateandTime");
    }

    private void installItemsToPlatform() throws Exception {
        LicenseSync<LicenseInfo> sync;
        Optional<Object> initializer;
        log.log(Level.FINE, "Entering installItemsToPlatform");
        if (this.stationDir == null) {
            initializer = Optional.empty();
        } else {
            log.log(Level.FINE, "Initializing Station Transfer...");
            initializer = Optional.of(DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)this.daemonSession, Optional.ofNullable(this.encodingInfo), Optional.ofNullable(this.stationBogPassphrase)));
        }
        this.dumpScenario(this.wizardModel.getSolution(), "installItemsToPlatform");
        this.wizardModel.getSolution().commit((DaemonSessionTaskListener)this, new StoreCache(), null, false, initializer);
        if (!this.wizardModel.isSkipLicense() && this.wizardModel.getLicenseSelection() != null && (sync = this.wizardModel.getLicenseSelection().getLicenseSync()) != null) {
            int ixLicense;
            for (ixLicense = 0; ixLicense < sync.toAdd.size(); ++ixLicense) {
                LicenseDatabase.LOCAL_INSTANCE.add(((LicenseInfo)sync.toAdd.get((int)ixLicense)).vendorLicense);
            }
            for (ixLicense = 0; ixLicense < sync.toUpdate.size(); ++ixLicense) {
                LicenseDatabase.LOCAL_INSTANCE.add(((LicenseInfo)sync.toUpdate.get((int)ixLicense)).vendorLicense);
            }
        }
        log.log(Level.FINE, "Exiting installItemsToPlatform");
    }

    private void importRemotePlatformItems() {
        log.log(Level.FINE, "Entering importRemotePlatformItems");
        if (this.items.contains(this.importFromPlatformItem)) {
            this.importPlatformModules();
            this.cleanAndUpdatePlatformOsAndJvm();
            this.updateInstallScenario();
        }
        log.log(Level.FINE, "Exiting importRemotePlatformItems");
    }

    private void lowMemoryReboot() throws Exception {
        log.log(Level.FINE, "Entering lowMemoryReboot");
        if (this.items.contains(this.lowMemoryRebootItem)) {
            int i;
            String currentSessionTimestamp = this.daemonSession.getHostProperties().getSessionTimestamp();
            BAppSurrogate[] apps = BAppSurrogate.makeAll(null, (BDaemonSession)this.daemonSession);
            boolean[] mustReEnableAutoStart = new boolean[apps.length];
            for (i = 0; i < apps.length; ++i) {
                if (apps[i].getIsAutoStart()) {
                    mustReEnableAutoStart[i] = true;
                    apps[i].updateSettings(false, apps[i].getIsAutoRestart());
                    continue;
                }
                mustReEnableAutoStart[i] = false;
            }
            this.daemonSession.sendRebootRequest();
            this.daemonSession.reconnect(currentSessionTimestamp, (ICancelHint)this);
            for (i = 0; i < apps.length; ++i) {
                if (!mustReEnableAutoStart[i]) continue;
                apps[i].updateSettings(true, apps[i].getIsAutoRestart());
            }
        }
        log.log(Level.FINE, "Exiting lowMemoryReboot");
    }

    private void cleanAndUpdatePlatformOsAndJvm() {
        ArrayList modulesToTemporarilyUninstall = new ArrayList();
        if (null != this.remoteModules) {
            Set modulesInSolution = Arrays.asList(this.wizardModel.getSolution().getToInstall()).stream().filter(i -> i instanceof BModuleInstallable).map(i -> i.getPart().getPartName()).collect(Collectors.toSet());
            try (IterableCursor cursor = this.remoteModules.getInstallables(false, (DaemonSessionTaskListener)this);){
                this.modulesToRestore = cursor.stream().filter(installable -> installable instanceof BModuleInstallable).map(installable -> (BModuleInstallable)installable).map(BModuleInstallable::getModulePart).peek(modulePart -> modulesToTemporarilyUninstall.add(modulePart.getPartName())).filter(modulePart -> !modulesInSolution.contains(modulePart.getPartName())).map(modulePart -> BDependency.forPart((BPart)modulePart, (BVersionRelation)BVersionRelation.exact)).collect(Collectors.toList());
            }
        }
        try {
            InstallScenario initialUpdateScenario = InstallScenario.solve((BDaemonPlatform)this.wizardModel.getPlatform(), (DaemonSessionTaskListener)this, (String[])modulesToTemporarilyUninstall.toArray(new String[0]), null, (BInstallable[])this.jreAndOsInstallables.toArray(new BInstallable[0]), null, null, (CertificateChainValidator)this.certValidator);
            initialUpdateScenario.commit((DaemonSessionTaskListener)this, null);
            String currentSessionTimestamp = this.daemonSession.getHostProperties().getSessionTimestamp();
            if (this.mustReboot) {
                this.daemonSession.sendRebootRequest();
                this.daemonSession.reconnect(currentSessionTimestamp, (ICancelHint)this);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "cleanAndUpdatePlatfromOSAndJvm:: Failure installing scenario.");
        }
    }

    private void importPlatformModules() {
        try {
            BRemoteDaemonPlatform platform = this.wizardModel.getPlatform();
            this.remoteModules = (BRemoteModuleList)platform.getModuleList();
            this.remoteModules.importUnregisteredModules((DaemonSessionTaskListener)this, null);
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "importPlatformModules:: Importing remote modules failed.");
        }
    }

    private void updateInstallScenario() {
        try {
            InstallScenario oldSolution = this.wizardModel.getSolution();
            BInstallable[] toInstall = oldSolution.getToInstall();
            ArrayList newInstallables = new ArrayList();
            Collections.addAll(newInstallables, toInstall);
            if (this.wizardModel.isModuleScenarioHasDists()) {
                Collections.addAll(newInstallables, this.installDists.toArray(new BDistribution[0]));
            }
            newInstallables.removeAll(this.jreAndOsInstallables);
            BRemoteDaemonPlatform platform = this.wizardModel.getPlatform();
            platform.requestReload();
            platform.loadPreferredVerificationMode();
            HashSet<String> removeFromReinstall = new HashSet<String>(Arrays.asList(oldSolution.getModulesToUninstall()));
            BDependency[] additionalDependencies = (BDependency[])this.modulesToRestore.stream().filter(dep -> !removeFromReinstall.contains(dep.getPartName())).toArray(BDependency[]::new);
            this.wizardModel.setSolution(InstallScenario.solve((BDaemonPlatform)platform, (String[])oldSolution.getModulesToUninstall(), (BDependency[])additionalDependencies, (BInstallable[])newInstallables.toArray(new BInstallable[0]), (SolutionParameters)oldSolution.getSolutionParameters(), (Set)oldSolution.getNewEnabledRuntimeProfiles(), (InstallableRegistry)oldSolution.getInstallableRegistry(), (CertificateChainValidator)this.certValidator));
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "updateInstallScenario:: Update failed.");
        }
    }

    private void deleteStations() throws ConnectException {
        log.log(Level.FINE, "Entering deleteStations");
        if (this.items.contains(this.deleteStationsItem) && this.deleteStations) {
            BStationSurrogate station;
            int i;
            FileTransferMessage message = new FileTransferMessage((BDaemonFileSpace)this.daemonSession.getFileSpace());
            for (i = 0; i < this.stationsToDelete.size(); ++i) {
                station = this.stationsToDelete.get(i);
                message.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(new FilePath("~stations/" + station.getStationName()), (BDaemonFileSpace)this.daemonSession.getFileSpace()));
                HashSet<String> appsForType = this.stoppedApps.get(station.getType());
                if (appsForType == null) continue;
                appsForType.remove(station.getAppName());
            }
            DaemonFileUtil.transfer((BDaemonSession)this.daemonSession, (FileTransferMessage)message, null, (DaemonSessionTaskListener)this);
            for (i = 0; i < this.stationsToDelete.size(); ++i) {
                station = this.stationsToDelete.get(i);
                this.daemonSession.sendMessage((DaemonMessage)new DeleteStationMessage(station.getStationName()));
            }
        }
        log.log(Level.FINE, "Exiting deleteStations");
    }

    private void updatePlatformCredentials() throws Exception {
        log.log(Level.FINE, "Entering updatePlatformCredentials");
        if (this.items.contains(this.authChangeItem)) {
            log.log(Level.FINE, "authChangeItem detected...");
            boolean requiresCredentialsUpdate = false;
            if (DaemonAuthUtil.isNativeScheme((String)this.wizardModel.getAuthMethod())) {
                if (this.wizardModel.isAuthUsersChanged() && this.daemonSession.getHostProperties().supportsServlet("acctmgt")) {
                    log.log(Level.FINE, "acctmgt supported...");
                    if (this.wizardModel.isDefaultAccountPresent()) {
                        log.log(Level.FINE, "Adding New Account...");
                        AddUserMessage addUserMessage = new AddUserMessage(this.wizardModel.getNewNativeUserAccountToAdd());
                        addUserMessage.setSharedKey(this.daemonSession.generateSharedSecretKey("commissioningWizard_finish_addUser"));
                        AddMemberMessage addMemberMessage = new AddMemberMessage(this.wizardModel.getNativeAdminGroup(), this.wizardModel.getNewNativeUserAccountToAdd());
                        this.daemonSession.sendMessage((DaemonMessage)addUserMessage);
                        this.daemonSession.sendMessage((DaemonMessage)addMemberMessage);
                        String encodedPassword = this.wizardModel.getNewNativeUserAccountToAdd().getPassword();
                        String decodedPassword = null;
                        try {
                            decodedPassword = LegacyStorageUtil.decode((String)encodedPassword);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        BUsernameAndPassword newUserCredentials = new BUsernameAndPassword(this.wizardModel.getNewNativeUserAccountToAdd().getAccountName(), BPassword.make((String)decodedPassword));
                        DaemonCredentialsManager.setCredentials(this.daemonSession, (BICredentials)newUserCredentials);
                        this.daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
                        log.log(Level.FINE, "****Removing Default Account...");
                        DeleteMemberMessage deleteMemberMessage = new DeleteMemberMessage(this.wizardModel.getNativeAdminGroup(), this.wizardModel.getDefaultNativeUserAccountToRemove());
                        DeleteUserMessage deleteUserMessage = new DeleteUserMessage(this.wizardModel.getDefaultNativeUserAccountToRemove());
                        this.daemonSession.sendMessage((DaemonMessage)deleteMemberMessage);
                        this.daemonSession.sendMessage((DaemonMessage)deleteUserMessage);
                    }
                    for (XmlResponseMessage currentMessageInQueue : this.wizardModel.getAuthMessageQueue()) {
                        this.daemonSession.sendMessage((DaemonMessage)currentMessageInQueue);
                    }
                    if (this.wizardModel.getNewCredentials() != null) {
                        requiresCredentialsUpdate = true;
                    }
                }
                if (this.wizardModel.isAuthMethodChanged()) {
                    this.daemonSession.sendMessage((DaemonMessage)new UpdateNativeAuthenticationMessage(this.wizardModel.getAuthMethod(), (NativeAccount)this.wizardModel.getNativeAdminGroup()));
                    requiresCredentialsUpdate = true;
                }
            } else if (DaemonAuthUtil.isFileScheme((String)this.wizardModel.getAuthMethod())) {
                this.daemonSession.sendMessage((DaemonMessage)new UpdateFileAuthenticationMessage(this.wizardModel.getAuthMethod(), this.wizardModel.getFileDomainAdminUser(), this.wizardModel.getFileDomainAdminPassword(), this.daemonSession.generateSharedSecretKey("commissioningWizard_finish_updateFile")));
                requiresCredentialsUpdate = true;
            }
            if (requiresCredentialsUpdate && this.wizardModel.getNewCredentials() != null) {
                DaemonCredentialsManager.setCredentials(this.daemonSession, (BICredentials)this.wizardModel.getNewCredentials());
                this.daemonSession.sendMessage((DaemonMessage)new InitializeSessionMessage());
            }
        }
        if (this.items.contains(this.systemPasswordItem)) {
            boolean factoryDefaultSystemPassword = false;
            boolean systemPassphraseReadonly = false;
            if (this.daemonSession.getHostProperties().supportsServlet("systempw")) {
                try {
                    XElem systemPasswordElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
                    factoryDefaultSystemPassword = systemPasswordElem.getb("default", false);
                    systemPassphraseReadonly = systemPasswordElem.getb("readonly", false);
                }
                catch (Exception ignored) {
                    factoryDefaultSystemPassword = false;
                    systemPassphraseReadonly = false;
                }
            }
            if (factoryDefaultSystemPassword && !systemPassphraseReadonly) {
                log.log(Level.FINE, "Changing systemPassphrase...");
                this.daemonSession.sendMessage((DaemonMessage)new SystemPasswordMessage(this.wizardModel.getNewSystemPassword(), this.wizardModel.getOldSystemPassword(), false, this.daemonSession.generateSharedSecretKey("commissionWizard_set")));
            } else {
                log.log(Level.FINE, "System Passphrase already set.");
            }
        } else {
            log.log(Level.FINE, "System Passphrase skipped.");
        }
    }

    private void initModules() {
        try {
            if (this.wizardModel.getInitialScenario() == null || this.analysisResults == null || !this.lastEnabledRuntimeProfiles.equals(this.wizardModel.getEnabledRuntimeProfiles()) || this.lastStationDir != this.wizardModel.getStationDir() || !this.lastMaxCoreVersion.equals((Object)this.wizardModel.getMaxCoreVersion())) {
                BRemoteDaemonPlatform platform = this.wizardModel.getPlatform();
                ArrayList<BDirectory> stationDirs = new ArrayList<BDirectory>();
                if (this.wizardModel.getStationDir() != null) {
                    stationDirs.add(this.wizardModel.getStationDir());
                }
                for (BAppSurrogate bAppSurrogate : this.wizardModel.getSurrogates()) {
                    if (!(bAppSurrogate instanceof BStationSurrogate) || this.wizardModel.getStationsToDelete().contains(bAppSurrogate)) continue;
                    BStationSurrogate station = (BStationSurrogate)bAppSurrogate;
                    stationDirs.add((BDirectory)this.daemonSession.getFileSpace().findFile(new FilePath("~stations/" + station.getStationName())));
                }
                this.analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, (BDirectory[])stationDirs.toArray(new BDirectory[0]), this.wizardModel.getEnabledRuntimeProfiles(), (SolutionParameters)this.wizardModel.getSolutionParams(), (CertificateChainValidator)this.certValidator);
                this.wizardModel.setInitialScenario(this.analysisResults.getSolution());
                this.wizardModel.setModuleScenario(this.wizardModel.getInitialScenario());
                this.wizardModel.setModuleScenarioHasDists(false);
                this.wizardModel.setDistSolution(null);
                for (BAppSurrogate bAppSurrogate : this.wizardModel.getInitialScenario().getToInstall()) {
                    if (!(bAppSurrogate instanceof BDistribution)) continue;
                    this.wizardModel.setModuleScenarioHasDists(true);
                    break;
                }
                this.lastStationDir = this.wizardModel.getStationDir();
                this.lastEnabledRuntimeProfiles = this.wizardModel.getEnabledRuntimeProfiles();
                this.lastMaxCoreVersion = this.wizardModel.getMaxCoreVersion();
            }
            log.log(Level.FINE, "Resulting Scenario: ");
            this.dumpScenario(this.wizardModel.getInitialScenario(), "initModules:initialScenario");
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private void initDependencyComponents() {
        try {
            UnmeetableDependency[] unmet;
            BRemoteDaemonPlatform platform = this.remotePlatform;
            ArrayList<BDirectory> stationDirs = new ArrayList<BDirectory>();
            if (this.stationDir != null) {
                stationDirs.add(this.stationDir);
            }
            this.analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, (BDirectory[])stationDirs.toArray(new BDirectory[0]), this.enabledRuntimeProfiles, (SolutionParameters)this.wizardModel.getSolutionParams(), (CertificateChainValidator)this.certValidator);
            this.wizardModel.setInitialScenario(this.analysisResults.getSolution());
            if (this.wizardModel.getInitialScenario().getToInstall().length == 0) {
                this.installModuleVersions.clear();
                log.log(Level.FINE, "initDependencyComponents::No modules to Install...");
            }
            if ((unmet = this.wizardModel.getInitialScenario().getUnmeetableDependencies()).length > 0) {
                log.log(Level.FINE, "initDependencyComponents::The following dependencies cannot be met");
                for (int i = 0; i < unmet.length; ++i) {
                    log.log(Level.FINE, "  " + unmet[i]);
                }
            }
            this.wizardModel.setModuleScenarioHasDists(false);
            for (BInstallable inst : this.wizardModel.getInitialScenario().getToInstall()) {
                if (!(inst instanceof BDistribution)) continue;
                this.wizardModel.setModuleScenarioHasDists(true);
                break;
            }
        }
        catch (RuntimeException re) {
            log.log(Level.FINE, re, () -> "initDependencyComponents:: Runtime exception.");
            throw re;
        }
        catch (Exception e) {
            log.log(Level.FINE, e, () -> "initDependencyComponents:: General exception.");
            throw new BajaRuntimeException((Throwable)e);
        }
        finally {
            this.wizardModel.setSolution(this.wizardModel.getInitialScenario());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Resulting Scenario: ");
            }
            this.dumpScenario(this.wizardModel.getSolution(), "initDependencyComponents:Solution:");
        }
    }

    private void dumpScenario(InstallScenario scenario, String strTag) {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        if (null == scenario) {
            log.log(Level.FINE, "***" + strTag + ": Scenario is NULL; nothing to print.");
            return;
        }
        log.log(Level.FINE, "***" + strTag + ": Scenario can be committed? " + scenario.canCommit() + "\n\n");
        if (scenario.getToInstall().length == 0) {
            log.log(Level.FINE, "***" + strTag + ": No modules to Install...\n\n");
        } else {
            log.log(Level.FINE, "---" + strTag + ": The following Modules will be installed:");
            for (BInstallable bInstallable : scenario.getToInstall()) {
                log.log(Level.FINE, "---" + strTag + ": " + bInstallable.getInstallableFileName() + " : " + bInstallable.getVersion().toString());
            }
        }
        if (scenario.getUnmeetableDependencies().length > 0) {
            log.log(Level.FINE, "---" + strTag + ": The following dependencies cannot be met");
            for (BInstallable bInstallable : scenario.getUnmeetableDependencies()) {
                log.log(Level.FINE, "---" + strTag + ": " + bInstallable + "; Dependency is unmeetable.");
                log.log(Level.FINE, "---" + strTag + ":       Dependency is unsolveable?:" + bInstallable.isUnsolvable);
                log.log(Level.FINE, "---" + strTag + ":       Dependency is not found?:" + bInstallable.isSoftwareNotFound);
                log.log(Level.FINE, "---" + strTag + ":       Dependency is readonly?:" + bInstallable.isSoftwareReadonly);
                log.log(Level.FINE, "---" + strTag + ":       Dependency signature failure?:" + bInstallable.signatureFailure);
            }
        } else {
            log.log(Level.FINE, "***" + strTag + ": No unmet dependencies...");
        }
        if (scenario.getExcludedInstallables().length == 0) {
            log.log(Level.FINE, "***" + strTag + ": No Excluded modules...\n\n");
        } else {
            log.log(Level.FINE, "---" + strTag + ": The following Modules will be EXCLUDED:");
            for (BInstallable bInstallable : scenario.getExcludedInstallables()) {
                log.log(Level.FINE, "---" + strTag + ": " + bInstallable.getInstallableFileName() + " : " + bInstallable.getVersion().toDebugString());
            }
        }
    }

    public Map<String, Version> getInstallModuleVersions() {
        return this.installModuleVersions;
    }

    private void addPlatformModule(String moduleName, Version version) {
        Objects.requireNonNull(moduleName);
        if (version == null) {
            this.remotePlatformModules.put(moduleName, Version.NULL);
        } else {
            this.remotePlatformModules.put(moduleName, version);
        }
    }

    private FilePath getStationPath(String stationName) {
        FilePath stationsPath = new FilePath("~stations");
        if (stationName == null || stationName.trim().length() == 0) {
            return stationsPath;
        }
        return stationsPath.merge(stationName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addStationToCopy(String stationName, boolean startStation, boolean autoStartStation, Supplier<char[]> passphraseSupplier) {
        BINavNode configBogNode = null;
        log.log(Level.FINE, "Validate platform and session...");
        this.validatePlatformAndSession();
        if (!this.remotePlatform.getNiagaraStationsEnabled()) throw new BajaRuntimeException("Remote host does not support Niagara Stations");
        if (!SlotPath.isValidName((String)stationName)) {
            throw new BajaRuntimeException("Invalid Station Name.");
        }
        log.log(Level.FINE, "Setting station...");
        this.startStation = startStation;
        this.autostartStation = autoStartStation;
        BDirectory stationRoot = (BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getStationsDirPath((boolean)true));
        if (stationRoot != null) {
            for (BIFile kid : stationRoot.listFiles()) {
                if (!(kid instanceof BDirectory) || !kid.getNavName().equalsIgnoreCase(stationName)) continue;
                configBogNode = kid.getNavChild("config.bog");
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Path found: " + kid.getFilePath());
                    log.log(Level.FINE, "Bog: " + configBogNode.getNavName());
                }
                if (configBogNode == null) throw new BajaRuntimeException("Unable to locate station Bog.");
                this.stationDir = (BDirectory)kid;
                break;
            }
        }
        if (this.stationDir != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Station Directory is: " + this.stationDir);
            }
        } else {
            log.log(Level.FINE, "Station directory not found.");
            throw new BajaRuntimeException("Station Bog not found.");
        }
        this.wizardModel.setStationDir(this.stationDir);
        this.wizardModel.setTargetStationName(stationName);
        this.targetStationName = stationName;
        this.stationBogPassphrase = passphraseSupplier != null ? new SecretChars(passphraseSupplier.get(), false) : null;
        this.wizardModel.setStationBogPassphrase(this.stationBogPassphrase);
    }

    protected void addStationToCopy(BDirectory localSourceDirectory, String stationName, boolean startStation, boolean autoStartStation, Supplier<char[]> passphraseSupplier) {
        this.validatePlatformAndSession();
        if (this.remotePlatform.getNiagaraStationsEnabled()) {
            this.startStation = startStation;
            this.autostartStation = autoStartStation;
            this.stationDir = localSourceDirectory;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Station Directory is: " + this.stationDir);
            }
            this.targetStationName = stationName;
            this.stationBogPassphrase = passphraseSupplier != null ? new SecretChars(passphraseSupplier.get(), false) : null;
        } else {
            throw new BajaRuntimeException("Remote host does not support Niagara Stations");
        }
    }

    protected BDirectory getStationDir() {
        return this.stationDir;
    }

    protected void setStationDir(BDirectory stationDir) {
        this.stationDir = stationDir;
    }

    protected boolean isStartStation() {
        return this.startStation;
    }

    protected void setStartStation(boolean startStation) {
        this.startStation = startStation;
    }

    protected boolean isAutostartStation() {
        return this.autostartStation;
    }

    protected void setAutostartStation(boolean autostartStation) {
        this.autostartStation = autostartStation;
    }

    protected void setLaxCertificateValidation(boolean laxCertificateValidation) {
        this.certValidator.setLaxValidation(laxCertificateValidation);
    }

    protected BIFile getFileForDistribution(String filePath) {
        try {
            return AccessController.doPrivileged(() -> (BIFile)BOrd.make((String)filePath).resolve().get());
        }
        catch (PrivilegedActionException e) {
            throw new BajaRuntimeException("Unable to resolve file for path: " + filePath);
        }
    }

    private void validatePlatformAndSession() throws BajaRuntimeException {
        if (this.daemonSession == null) {
            throw new BajaRuntimeException("Session must not be NULL");
        }
        if (this.remotePlatform == null) {
            throw new BajaRuntimeException("remotePlatform must not be NULL");
        }
        if (!this.remotePlatform.getHostId().equalsIgnoreCase(this.daemonSession.getHostProperties().getHostId())) {
            throw new BajaRuntimeException("remotePlatform and Session do not match");
        }
    }

    public void taskStarted(DaemonSessionTask task) {
        if (!task.getMessage().equals(this.lastText)) {
            log.log(Level.INFO, task.getMessage());
            this.lastText = task.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask task) {
        if (!task.getMessage().equals(this.lastText)) {
            log.log(Level.INFO, task.getMessage());
            this.lastText = task.getMessage();
        }
    }

    public void taskFinished(DaemonSessionTask task) {
    }

    protected BDaemonSession getDaemonSession() {
        return this.daemonSession;
    }

    protected void setDaemonSession(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
    }

    protected BRemoteDaemonPlatform getRemotePlatform() {
        return this.remotePlatform;
    }

    protected void setRemotePlatform(BRemoteDaemonPlatform remotePlatform) {
        this.remotePlatform = remotePlatform;
    }

    protected void setLogLevel(Level logLevel) {
        log.setLevel(logLevel);
    }

    protected void setSystemUser(String systemUser) {
        this.systemUser = systemUser;
    }

    public boolean isUpdateAllOutOfDate() {
        return this.updateAllOutOfDate;
    }

    public void setUpdateAllOutOfDate(boolean updateAllOutOfDate) {
        this.updateAllOutOfDate = updateAllOutOfDate;
    }

    public boolean isCanceled() {
        return false;
    }

    public boolean acceptInstallable(BInstallable inst) {
        if (AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.commissioning.ignoreLicenseVersion")).booleanValue()) {
            return true;
        }
        try {
            Version maxCoreVersion = this.wizardModel.getMaxCoreVersion();
            if (inst.getInstallableName().startsWith("nre-core") || inst.getInstallableName().equals("baja")) {
                if (inst.getVersion().getVendorVersion().compareTo(maxCoreVersion) >= 0) {
                    return false;
                }
            } else if (inst instanceof BDistribution && BPart.matchesName((String)inst.getInstallableFileName(), (String)this.getRemotePlatform().getConfigDistFileName())) {
                for (BDependency configDep : inst.getAllDependencies()) {
                    if (configDep.getPartType() != BNrePart.TYPE) continue;
                    if (configDep.getVersion().getVendorVersion().compareTo(maxCoreVersion) < 0) break;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private class NoLicenseInstall
    implements LicenseSelection {
        private NoLicenseInstall() {
        }

        @Override
        public LicenseSync<LicenseInfo> getLicenseSync() {
            return LicenseSync.noChanges();
        }

        @Override
        public String getReviewHeader() {
            return "No Change to Licenses";
        }

        @Override
        public LicenseMode getSelectedLicenseMode() {
            return null;
        }
    }

    protected static class TaskItem {
        public BJobState state = BJobState.unknown;
        public String description;

        public TaskItem(String description) {
            this.description = description;
        }
    }
}

