/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower.ui;

import com.tridium.platPower.BBattery;
import com.tridium.platPower.BNimhBattery;
import com.tridium.platPower.BPowerMonitorPlatformService;
import com.tridium.platPower.ui.BNimhBatteryPlugin;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BRelTimeFE;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platPower:PowerMonitorPlatformService"}, requiredPermissions="W"), @AgentOn(types={"platPower:PowerMonitorPlatformServiceQnx"}, requiredPermissions="W")})
public class BPowerMonitorPlatformServicePlugin
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BPowerMonitorPlatformServicePlugin.class);
    private Version requiredPlatPowerVersion = new Version("3.6.44.2");
    private Version remoteVersion = null;
    private boolean saving = false;
    private boolean loading = false;
    private static final Lexicon lexicon = Lexicon.make((String)"platPower");
    private static final BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    private BLabel primaryPowerPresentLabel = null;
    private boolean primaryPowerPresent = false;
    private BRelTimeFE shutdownDelayFE = null;
    private BWbFieldEditor powerAlarmSupportFE = null;
    private BWbFieldEditor batteryFE = null;
    private BLabel batteryGoodLabel = null;
    private boolean batteryGood = false;
    private BLabel timeOfLastTestLabel = null;
    private BAbsTime timeOfLastTest = BAbsTime.NULL;
    private BWbFieldEditor batteryAlarmSupportFE = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPowerMonitorPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        boolean loadingRestore = this.loading;
        this.loading = true;
        BPowerMonitorPlatformService batteryService = (BPowerMonitorPlatformService)value;
        batteryService.poll();
        batteryService.lease(5);
        this.registerForComponentEvents((BComponent)batteryService, 4);
        BGridPane contentPane = new BGridPane(1);
        contentPane.setRowAlign(BValign.top);
        contentPane.setHalign(BHalign.fill);
        contentPane.setColumnAlign(BHalign.fill);
        contentPane.setValign(BValign.fill);
        contentPane.setStretchColumn(0);
        contentPane.setUniformColumnWidth(true);
        BGridPane powerPane = new BGridPane(2);
        powerPane.setHalign(BHalign.left);
        powerPane.setValign(BValign.top);
        powerPane.setColumnGap(10.0);
        powerPane.setRowGap(6.0);
        powerPane.setColorRows(false);
        this.primaryPowerPresentLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)powerPane, (String)lexicon.getText("labels.primaryPowerPresent"), (BWidget)this.primaryPowerPresentLabel, (boolean)false);
        this.primaryPowerPresent = batteryService.getPrimaryPowerPresent();
        this.primaryPowerPresentLabel.setText(lexicon.getText("labels.primaryPowerPresent." + String.valueOf(this.primaryPowerPresent)));
        this.remoteVersion = (Version)batteryService.fw(404, (Object)"platPower", null, null, null);
        BFacets editorFacets = this.remoteVersion != null && this.remoteVersion.compareTo(this.requiredPlatPowerVersion) >= 0 ? batteryService.getBattery().getShutdownDelayFacets() : batteryService.getSlotFacets((Slot)BPowerMonitorPlatformService.shutdownDelay);
        this.shutdownDelayFE = new BRelTimeFE();
        LabelUtil.addLabelWidgetPair((BPane)powerPane, (String)lexicon.getText("labels.shutdownDelay"), (BWidget)this.shutdownDelayFE, (boolean)false);
        this.shutdownDelayFE.loadValue((BObject)batteryService.getShutdownDelay(), (Context)BFacets.make((BFacets)cx.getFacets(), (BFacets)editorFacets));
        this.linkTo(null, (BComponent)this.shutdownDelayFE, (Slot)BRelTimeFE.pluginModified, (Slot)setModified);
        this.powerAlarmSupportFE = BWbFieldEditor.makeFor((BObject)new BPlatformAlarmSupport(), (Context)BPowerMonitorPlatformService.powerAlarmSupport.getFacets());
        LabelUtil.addLabelWidgetPair((BPane)powerPane, (String)lexicon.getText("labels.powerAlarmSupport"), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.powerAlarmSupportFE), (boolean)false);
        BBorderPane powerBorderPane = new BBorderPane((BWidget)powerPane, new BLabel(lexicon.getText("labels.primaryPowerSettings"), BOLD_TEXT_FONT), BBorder.solid);
        contentPane.add(null, (BValue)powerBorderPane);
        BGridPane nimhPane = new BGridPane(2);
        nimhPane.setHalign(BHalign.left);
        nimhPane.setValign(BValign.top);
        nimhPane.setColumnGap(10.0);
        nimhPane.setRowGap(6.0);
        nimhPane.setColorRows(false);
        this.batteryFE = BWbFieldEditor.makeFor((BObject)batteryService.getBattery(), (Context)BPowerMonitorPlatformService.battery.getFacets());
        LabelUtil.addLabelWidgetPair((BPane)nimhPane, (String)lexicon.getText("labels.battery"), (BWidget)this.batteryFE, (boolean)false);
        this.batteryFE.loadValue((BObject)batteryService.getBattery(), (Context)BFacets.make((BFacets)cx.getFacets(), (BFacets)BPowerMonitorPlatformService.battery.getFacets()));
        this.linkTo(null, (BComponent)this.batteryFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.batteryGoodLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)nimhPane, (String)lexicon.getText("labels.batteryGood"), (BWidget)this.batteryGoodLabel, (boolean)false);
        this.batteryGood = batteryService.getBatteryGood();
        this.batteryGoodLabel.setText(lexicon.getText("labels.batteryGood." + String.valueOf(this.batteryGood)));
        this.timeOfLastTestLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)nimhPane, (String)lexicon.getText("labels.timeOfLastTest"), (BWidget)this.timeOfLastTestLabel, (boolean)false);
        this.timeOfLastTest = batteryService.getTimeOfLastTest();
        this.timeOfLastTestLabel.setText(this.timeOfLastTest.toString(cx));
        this.batteryAlarmSupportFE = BWbFieldEditor.makeFor((BObject)new BPlatformAlarmSupport(), (Context)BPowerMonitorPlatformService.batteryAlarmSupport.getFacets());
        LabelUtil.addLabelWidgetPair((BPane)nimhPane, (String)lexicon.getText("labels.batteryAlarmSupport"), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.batteryAlarmSupportFE), (boolean)false);
        BBorderPane nimhBorderPane = new BBorderPane((BWidget)nimhPane, new BLabel(lexicon.getText("labels.batterySettings"), BOLD_TEXT_FONT), BBorder.solid);
        contentPane.add(null, (BValue)nimhBorderPane);
        BButtonPane buttonPane = new BButtonPane();
        buttonPane.addWorkbenchButtons((BWidget)this);
        BBrush bgcolor = Theme.scrollPane().getControlBackground();
        BScrollPane scrollpane = new BScrollPane((BWidget)new BBorderPane((BWidget)contentPane));
        scrollpane.setViewportBackground(bgcolor);
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 0.0, 5.0), null, null, (BWidget)new BBorderPane((BWidget)scrollpane, BBorder.inset, BInsets.DEFAULT))));
        this.powerAlarmSupportFE.loadValue((BObject)batteryService.getPowerAlarmSupport(), (Context)BFacets.make((BFacets)cx.getFacets(), (BFacets)BPowerMonitorPlatformService.powerAlarmSupport.getFacets()));
        this.linkTo(null, (BComponent)this.powerAlarmSupportFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.batteryAlarmSupportFE.loadValue((BObject)batteryService.getBatteryAlarmSupport(), (Context)BFacets.make((BFacets)cx.getFacets(), (BFacets)BPowerMonitorPlatformService.batteryAlarmSupport.getFacets()));
        this.linkTo(null, (BComponent)this.batteryAlarmSupportFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.loading = loadingRestore;
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.saving = true;
        BPowerMonitorPlatformService batteryService = (BPowerMonitorPlatformService)value;
        batteryService.setPrimaryPowerPresent(this.primaryPowerPresent);
        batteryService.setShutdownDelay((BRelTime)this.shutdownDelayFE.saveValue(cx));
        batteryService.setPowerAlarmSupport((BPlatformAlarmSupport)this.powerAlarmSupportFE.saveValue(cx));
        this.powerAlarmSupportFE.loadValue((BObject)batteryService.getPowerAlarmSupport());
        batteryService.setBattery((BBattery)this.batteryFE.saveValue(cx));
        batteryService.setBatteryGood(this.batteryGood);
        batteryService.setTimeOfLastTest(this.timeOfLastTest);
        batteryService.setBatteryAlarmSupport((BPlatformAlarmSupport)this.batteryAlarmSupportFE.saveValue(cx));
        this.batteryAlarmSupportFE.loadValue((BObject)batteryService.getBatteryAlarmSupport());
        batteryService.savePlatformServiceProperties();
        this.saving = false;
        return value;
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (this.saving || this.loading || evt == null || evt.getSlot() == null || !evt.getSlot().isProperty()) {
            return;
        }
        boolean handled = false;
        if (evt.getSourceComponent() instanceof BPowerMonitorPlatformService) {
            BPowerMonitorPlatformService batteryService = (BPowerMonitorPlatformService)evt.getSourceComponent();
            Property property = evt.getSlot().asProperty();
            BValue propertyValue = batteryService.get(property);
            if (property == BPowerMonitorPlatformService.battery) {
                if (this.batteryFE != null) {
                    this.batteryFE.loadValue((BObject)((BBattery)propertyValue));
                }
                handled = true;
            } else if (property == BPowerMonitorPlatformService.batteryAlarmSupport) {
                if (this.batteryAlarmSupportFE != null) {
                    this.batteryAlarmSupportFE.loadValue((BObject)((BPlatformAlarmSupport)propertyValue));
                }
                handled = true;
            } else if (property == BPowerMonitorPlatformService.batteryGood) {
                if (this.batteryGoodLabel != null) {
                    this.batteryGood = ((BBoolean)propertyValue).getBoolean();
                    this.batteryGoodLabel.setText(lexicon.getText("labels.nimhBatteryGood." + propertyValue.toString()));
                }
                handled = true;
            } else if (property == BPowerMonitorPlatformService.timeOfLastTest) {
                if (this.timeOfLastTestLabel != null) {
                    this.timeOfLastTest = (BAbsTime)propertyValue;
                    this.timeOfLastTestLabel.setText(propertyValue.toString());
                }
                handled = true;
            } else if (property == BPowerMonitorPlatformService.powerAlarmSupport) {
                if (this.powerAlarmSupportFE != null) {
                    this.powerAlarmSupportFE.loadValue((BObject)((BPlatformAlarmSupport)propertyValue));
                }
                handled = true;
            } else if (property == BPowerMonitorPlatformService.primaryPowerPresent) {
                if (this.primaryPowerPresentLabel != null) {
                    this.primaryPowerPresent = ((BBoolean)propertyValue).getBoolean();
                    this.primaryPowerPresentLabel.setText(lexicon.getText("labels.primaryPowerPresent." + propertyValue.toString()));
                }
                handled = true;
            } else if (property == BPowerMonitorPlatformService.shutdownDelay) {
                if (this.shutdownDelayFE != null) {
                    BFacets editorFacets = this.remoteVersion != null && this.remoteVersion.compareTo(this.requiredPlatPowerVersion) >= 0 ? batteryService.getBattery().getShutdownDelayFacets() : batteryService.getSlotFacets((Slot)BPowerMonitorPlatformService.shutdownDelay);
                    this.shutdownDelayFE.loadValue((BObject)((BRelTime)propertyValue), (Context)editorFacets);
                }
                handled = true;
            }
        } else if (evt.getSourceComponent() instanceof BNimhBattery && this.batteryFE != null && this.batteryFE instanceof BNimhBatteryPlugin) {
            BNimhBattery nimhBattery = (BNimhBattery)evt.getSourceComponent();
            this.batteryFE.loadValue((BObject)nimhBattery);
            handled = true;
        }
        if (handled) {
            this.getContent().relayout();
        } else {
            super.handleComponentEvent(evt);
        }
    }
}

