/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower.ui;

import com.tridium.platPower.BBatteryState;
import com.tridium.platPower.BNimhBattery;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"platPower:NimhBattery"}, requiredPermissions="R"), @AgentOn(types={"platPower:Npm2NimhBattery"}, requiredPermissions="R")})
public class BNimhBatteryPlugin
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BNimhBatteryPlugin.class);
    private static final Lexicon lexicon = Lexicon.make((String)"platPower");
    private BLabel batteryState = new BLabel();
    private BLabel timeRemaining;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNimhBatteryPlugin() {
        this.batteryState.setImage(BImage.make((BIcon)BIcon.std((String)"batteryUnknown.png")));
        this.timeRemaining = new BLabel();
        BGridPane outer = new BGridPane(2);
        outer.add("batteryState", (BValue)this.batteryState);
        outer.add("timeRemaining", (BValue)this.timeRemaining);
        this.setContent((BWidget)outer);
    }

    protected void doLoadValue(BObject value, Context cx) {
        BNimhBattery c = (BNimhBattery)value;
        if (c.getState().getOrdinal() == 1) {
            this.batteryState.setText(lexicon.getText("charging"));
            this.batteryState.setImage(BImage.make((BIcon)BIcon.std((String)"batteryCharging.png")));
            this.timeRemaining.setText(c.getChargeTimeLeft().toString(cx) + " " + lexicon.getText("remaining"));
            this.timeRemaining.setVisible(true);
        } else if (c.getState().getOrdinal() == 2) {
            this.batteryState.setText(lexicon.getText("discharging"));
            this.batteryState.setImage(BImage.make((BIcon)BIcon.std((String)"batteryDischarging.png")));
            this.timeRemaining.setVisible(false);
        } else if (c.getState().getOrdinal() == 0) {
            this.batteryState.setText(lexicon.getText("idle"));
            this.batteryState.setImage(BImage.make((BIcon)BIcon.std((String)"batteryFull.png")));
            this.timeRemaining.setVisible(false);
        } else if (c.getState().getOrdinal() == 3) {
            this.batteryState.setText(lexicon.getText("unknown"));
            this.batteryState.setImage(BImage.make((BIcon)BIcon.std((String)"batteryUnknown.png")));
            this.timeRemaining.setVisible(false);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BBatteryState state = (BBatteryState)value;
        return state;
    }
}

