/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import java.text.DecimalFormat;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="baja:Number", to="baja:StatusString"))
@NiagaraProperty(name="format", type="String", defaultValue="")
public final class BNumberToStatusString
extends BConverter
implements BIAgent {
    @Generated
    public static final Property format = BNumberToStatusString.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNumberToStatusString.class);

    @Generated
    public String getFormat() {
        return this.getString(format);
    }

    @Generated
    public void setFormat(String v) {
        this.setString(format, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusString statusString = (BStatusString)to;
        if (from instanceof BFloat && from == BFloat.NaN || from instanceof BDouble && from == BDouble.NaN) {
            statusString.setStatus(64);
            return statusString;
        }
        if (this.getFormat().length() == 0) {
            statusString.setValue(from.toString(cx));
            statusString.setStatus(BStatus.ok);
        } else {
            try {
                DecimalFormat decFormat = new DecimalFormat(this.getFormat());
                statusString.setValue(decFormat.format(((BNumber)from).getDouble()));
            }
            catch (IllegalArgumentException iae) {
                statusString.setStatus(BStatus.fault);
            }
        }
        return statusString;
    }
}

