/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="baja:AbsTime", to="baja:Number"))
public final class BAbsTimeToNumber
extends BConverter
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BAbsTimeToNumber.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BAbsTime absTime = (BAbsTime)from;
        switch (to.getType().getDataTypeSymbol()) {
            case 'i': {
                long millis = absTime.getMillis();
                if (millis > Integer.MAX_VALUE) {
                    return BInteger.MAX;
                }
                return BInteger.make((int)((int)millis));
            }
            case 'l': {
                return BLong.make((long)absTime.getMillis());
            }
            case 'f': {
                return BFloat.make((float)absTime.getMillis());
            }
            case 'd': {
                return BDouble.make((double)absTime.getMillis());
            }
        }
        throw new IllegalStateException();
    }
}

