/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.util;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.nodeTypes.NodeWithRange;
import com.tridium.slottool.generator.LineRange;
import java.util.List;
import java.util.Optional;

public final class JavaParserUtil {
    private JavaParserUtil() {
    }

    public static LineRange getRange(NodeWithRange<?> node) {
        return new LineRange(JavaParserUtil.getStartLine(node), JavaParserUtil.getEndLine(node));
    }

    public static int getStartLine(NodeWithRange<?> node) {
        Optional<Position> begin = node.getBegin();
        if (!begin.isPresent()) {
            throw new IllegalArgumentException("Node has no valid beginning");
        }
        return begin.get().line;
    }

    public static int getEndLine(NodeWithRange<?> node) {
        Optional<Position> end = node.getEnd();
        if (!end.isPresent()) {
            throw new IllegalArgumentException("Node has no valid ending");
        }
        return end.get().line;
    }

    public static Optional<Comment> getAssociatedComment(Node expr) {
        if (expr.getComment().isPresent()) {
            return expr.getComment();
        }
        if (!expr.getRange().isPresent()) {
            throw new IllegalArgumentException("Cannot attempt to derive comment for node without range");
        }
        Range nodeRange = expr.getRange().get();
        Node rootNode = expr.findRootNode();
        if (rootNode instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)rootNode;
            List<Comment> comments = cu.getAllComments();
            if (comments.isEmpty()) {
                return Optional.empty();
            }
            for (Comment comment : comments) {
                if (!comment.getRange().isPresent()) continue;
                Range commentRange = comment.getRange().get();
                if (!nodeRange.begin.equals(commentRange.end.nextLine())) continue;
                return Optional.of(comment);
            }
        }
        return Optional.empty();
    }
}

