/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.processor;

import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.Action;
import com.tridium.slottool.model.BajaType;
import com.tridium.slottool.processor.SlotProcessor;
import java.util.Optional;

public class ActionProcessor
extends SlotProcessor<Action> {
    public ActionProcessor(GeneratedCodeBlock cg) {
        super(cg);
    }

    @Override
    public void accept(Action action) {
        String name = action.getName();
        String newAction = ActionProcessor.generateNewAction(action);
        String invoke = this.generateActionInvoke(action);
        Optional<String> javaDoc = action.getJavaDoc();
        this.cg.addImport("javax.baja.sys.Action");
        if (action.getFlags().isPresent()) {
            this.cg.addImport("javax.baja.sys.Flags");
        }
        if (!action.getFacets().isEmpty()) {
            this.cg.addImport("javax.baja.sys.BFacets");
        }
        this.cg.startRegion("Action \"" + name + "\"");
        this.cg.println();
        this.cg.println("/**");
        this.cg.println(" * Slot for the {@code " + name + "} action.");
        javaDoc.ifPresent(this.cg::printJavadocComment);
        this.cg.println(" * @see #" + name + "(" + ActionProcessor.generateFormalParameter(action) + ")");
        this.cg.println(" */");
        if (action.isDeprecated()) {
            this.cg.println("@Deprecated");
        }
        this.cg.println(newAction);
        if (!action.isOverride()) {
            this.cg.println();
            this.cg.println("/**");
            this.cg.println(" * Invoke the {@code " + name + "} action.");
            javaDoc.ifPresent(this.cg::printJavadocComment);
            this.cg.println(" * @see #" + name);
            this.cg.println(" */");
            if (action.isDeprecated()) {
                this.cg.println("@Deprecated");
            }
            this.cg.println(invoke);
        }
        this.cg.endRegion();
    }

    private String generateActionInvoke(Action action) {
        String name = action.getName();
        String fpName = ActionProcessor.getFormalParameterName(name, action.getParameterName().orElse(null));
        String returnType = "void";
        BajaType returnBajaType = null;
        if (action.getReturnType().isPresent() && (returnBajaType = BajaType.forName(returnType = action.getReturnType().get())).isBType() && returnBajaType != BajaType.BOBJECT_TYPE) {
            this.cg.addImport(returnBajaType.getImport());
        }
        StringBuilder s = new StringBuilder();
        s.append("public ");
        s.append(returnType);
        s.append(' ').append(name);
        s.append('(');
        s.append(ActionProcessor.generateFormalParameter(action));
        s.append(") { ");
        if (!"void".equals(returnType)) {
            s.append("return ");
            if (returnBajaType != BajaType.BVALUE_TYPE) {
                s.append('(');
                s.append(returnType);
                s.append(')');
            }
        }
        s.append("invoke(").append(name);
        s.append(", ");
        s.append(action.getParameterType().map(type -> this.generateInvokeArgument(name, (String)type, fpName)).orElse("null"));
        s.append(", null); }");
        return s.toString();
    }

    private static String generateNewAction(Action action) {
        String name = action.getName();
        String flags = action.getFlags().orElse("0");
        String facets = ActionProcessor.processFacets(action.getFacets()).orElse("null");
        StringBuilder s = new StringBuilder();
        s.append("public static final Action ");
        s.append(name).append(" = newAction(").append(flags);
        action.getDefaultValue().ifPresent(value -> s.append(", ").append((String)value));
        s.append(", " + facets + ");");
        return s.toString();
    }

    private static StringBuffer generateFormalParameter(Action action) {
        String name = action.getName();
        StringBuffer result = new StringBuffer();
        String fpName = ActionProcessor.getFormalParameterName(name, action.getParameterName().orElse(null));
        action.getParameterType().ifPresent(type -> {
            result.append((String)type);
            result.append(' ');
            result.append(fpName);
        });
        return result;
    }

    private static String getFormalParameterName(String name, String fp) {
        return fp != null && !fp.equals(name) ? fp : "parameter";
    }

    private String generateInvokeArgument(String actionName, String parameterType, String parameterName) {
        BajaType bajaType = BajaType.forName(parameterType);
        if (bajaType.isBType() && bajaType != BajaType.BOBJECT_TYPE) {
            this.cg.addImport(bajaType.getImport());
        }
        switch (bajaType) {
            case BOOLEAN_TYPE: {
                return "BBoolean.make(" + parameterName + ')';
            }
            case INT_TYPE: {
                return "BInteger.make(" + parameterName + ')';
            }
            case LONG_TYPE: {
                return "BLong.make(" + parameterName + ')';
            }
            case FLOAT_TYPE: {
                return "BFloat.make(" + parameterName + ')';
            }
            case DOUBLE_TYPE: {
                return "BDouble.make(" + parameterName + ')';
            }
            case STRING_TYPE: {
                return "BString.make(" + parameterName + ')';
            }
            case BBOOLEAN_TYPE: 
            case BINT_TYPE: 
            case BLONG_TYPE: 
            case BFLOAT_TYPE: 
            case BDOUBLE_TYPE: 
            case BSTRING_TYPE: 
            case BVALUE_TYPE: 
            case BOBJECT_TYPE: {
                return parameterName;
            }
        }
        throw new IllegalStateException("Action " + actionName + " callback: " + (Object)((Object)BajaType.forName(parameterType)) + " is not a BObject type.");
    }
}

