/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.annotation.processors;

import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.model.Range;
import com.tridium.slottool.model.annotation.AnnotationClass;
import com.tridium.slottool.model.annotation.AnnotationProcessor;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;

public class NiagaraEnumProcessor
extends AnnotationProcessor {
    public NiagaraEnumProcessor(SlotomaticOptions slotomaticOptions, AnnotationClass unit, String source) {
        super(slotomaticOptions, unit, source);
    }

    @Override
    public String getAnnotationName() {
        return "NiagaraEnum";
    }

    @Override
    public void accept(AnnotationExpr annotation) {
        if (!annotation.isNormalAnnotationExpr()) {
            return;
        }
        NormalAnnotationExpr expr = annotation.asNormalAnnotationExpr();
        AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(expr);
        Optional<String> defaultValue = attributes.getAndMap("defaultValue", AnnotationProcessor::getValue);
        LinkedList range = attributes.requireAndMap("range", AnnotationProcessor::getChildrenAnnotations).stream().map(NiagaraEnumProcessor::extractEnum).collect(Collectors.toCollection(LinkedList::new));
        this.unit.setRange(range);
        this.unit.setDefaultEnumValue(defaultValue);
    }

    private static Range extractEnum(AnnotationExpr annotation) {
        if (annotation.isSingleMemberAnnotationExpr()) {
            String name = NiagaraEnumProcessor.removeQuotes(annotation.asSingleMemberAnnotationExpr().getMemberValue().toString());
            return new Range(name);
        }
        if (annotation.isNormalAnnotationExpr()) {
            AnnotationProcessor.AnnotationAttributes attributes = new AnnotationProcessor.AnnotationAttributes(annotation.asNormalAnnotationExpr());
            String name = attributes.getAndMap("value", AnnotationProcessor::makeName).orElse("");
            Optional<String> ordinal = attributes.getAndMap("ordinal", AnnotationProcessor::getValue);
            if (!name.isEmpty()) {
                return new Range(name, ordinal);
            }
        }
        throw new IllegalArgumentException("Cannot extract enum range entry");
    }
}

