/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.annotation;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.tridium.slottool.Constants;
import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.ExistingCodeBlock;
import com.tridium.slottool.model.Facet;
import com.tridium.slottool.model.Slot;
import com.tridium.slottool.model.annotation.AnnotationClass;
import com.tridium.slottool.util.JavaParserUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class AnnotationProcessor
implements Consumer<AnnotationExpr> {
    private static final Pattern COMMENT_BLOCK_CHAR = Pattern.compile("(/\\*|\\*/)");
    private static final Pattern COMMENT_LINE_CHAR = Pattern.compile("//", 16);
    private static final Pattern NEWLINE = Pattern.compile("\\r?\\n");
    protected final AnnotationClass unit;
    protected final String source;
    protected final List<String> sourceLines;
    protected static final Logger log = Slotomatic.getLogger();
    protected final SlotomaticOptions slotomaticOptions;
    private static final Map<String, Optional<Class<? extends AnnotationProcessor>>> classCache = Collections.synchronizedMap(new HashMap());

    protected AnnotationProcessor(SlotomaticOptions slotomaticOptions, AnnotationClass unit, String source) {
        this.slotomaticOptions = slotomaticOptions;
        this.unit = unit;
        this.source = source;
        this.sourceLines = Arrays.asList(Constants.EOL.split(source));
    }

    public abstract String getAnnotationName();

    @Override
    public abstract void accept(AnnotationExpr var1);

    public static Optional<AnnotationProcessor> getAnnotationProcessor(SlotomaticOptions slotomaticOptions, Name annotationName, AnnotationClass unit, String source) {
        Objects.requireNonNull(annotationName);
        String annotationClassName = annotationName.getIdentifier();
        String processorName = AnnotationProcessor.makeProcessorName(annotationClassName);
        return AnnotationProcessor.getProcessor(processorName).map(processor -> {
            try {
                AnnotationProcessor p = (AnnotationProcessor)processor.getConstructor(SlotomaticOptions.class, AnnotationClass.class, String.class).newInstance(slotomaticOptions, unit, source);
                return p;
            }
            catch (Exception e) {
                log.warning("Could not process annotation " + annotationName);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Caused by", e);
                }
                return null;
            }
        });
    }

    private static Optional<Class<? extends AnnotationProcessor>> getProcessor(String processorName) {
        return classCache.computeIfAbsent(processorName, name -> {
            try {
                return Optional.of(Class.forName(name).asSubclass(AnnotationProcessor.class));
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        });
    }

    private static String makeProcessorName(String annotationName) {
        return "com.tridium.slottool.model.annotation.processors." + annotationName + "Processor";
    }

    public static boolean isSupportedAnnotation(Name annotationName) {
        Objects.requireNonNull(annotationName);
        String processorName = AnnotationProcessor.makeProcessorName(AnnotationProcessor.getAnnotationName(annotationName));
        return AnnotationProcessor.getProcessor(processorName).isPresent();
    }

    public static String getAnnotationName(Name possiblyFullyQualifiedAnnotationName) {
        return possiblyFullyQualifiedAnnotationName.getIdentifier();
    }

    protected void processSlot(Slot slot, AnnotationAttributes attributes) {
        slot.setFlags(attributes.getAndMap("flags", AnnotationProcessor::makeFlags));
        slot.setFacets(attributes.getAndMap("facets", AnnotationProcessor::makeFacets));
        slot.setOverride(attributes.getAndMap("override", AnnotationProcessor::getBoolean).orElse(false));
        slot.setDeprecated(attributes.getAndMap("deprecated", AnnotationProcessor::getBoolean).orElse(false));
        slot.setJavaDoc(this.extractJavadoc(attributes.getAnnotation()));
    }

    protected Optional<String> extractJavadoc(NormalAnnotationExpr expr) {
        Optional<Comment> associatedComment = JavaParserUtil.getAssociatedComment(expr);
        if (associatedComment.isPresent()) {
            Comment comment = associatedComment.get();
            if (comment.isJavadocComment()) {
                StringJoiner joiner = new StringJoiner("\n");
                Javadoc javadoc = comment.asJavadocComment().parse();
                if (!javadoc.getDescription().isEmpty()) {
                    String text = javadoc.getDescription().toText();
                    for (String line : Constants.EOL.split(text)) {
                        joiner.add(line.trim());
                    }
                }
                for (JavadocBlockTag tag : javadoc.getBlockTags()) {
                    String text = tag.toText();
                    for (String line : Constants.EOL.split(text)) {
                        joiner.add(line.trim());
                    }
                }
                return Optional.of(joiner.toString());
            }
            return Optional.ofNullable(this.getCommentContents(comment));
        }
        return Optional.empty();
    }

    private String getCommentContents(Comment comment) {
        ExistingCodeBlock block = new ExistingCodeBlock(JavaParserUtil.getRange(comment), this.sourceLines, this.slotomaticOptions.getLineSeparator());
        String commentString = null;
        if (comment.isBlockComment()) {
            commentString = COMMENT_BLOCK_CHAR.matcher(block.getBlock()).replaceAll(Matcher.quoteReplacement("  "));
            commentString = Arrays.stream(NEWLINE.split(commentString)).map(String::trim).collect(Collectors.joining(this.slotomaticOptions.getLineSeparator())).trim();
        } else if (comment.isLineComment()) {
            commentString = COMMENT_LINE_CHAR.matcher(block.getBlock()).replaceAll(Matcher.quoteReplacement(""));
        }
        return commentString;
    }

    protected static String makeName(Expression value) {
        Objects.requireNonNull(value);
        String name = AnnotationProcessor.getValue(value);
        return name;
    }

    protected static String makeType(Expression value) {
        String typeSpec = AnnotationProcessor.getValue(value);
        return AnnotationProcessor.makeType(typeSpec);
    }

    public static String makeType(String typeSpec) {
        if (typeSpec.indexOf(58) > -1) {
            return 'B' + typeSpec.substring(typeSpec.indexOf(58) + 1);
        }
        return typeSpec;
    }

    protected static String getValue(Expression eleValue) {
        if (eleValue.isStringLiteralExpr()) {
            return eleValue.asStringLiteralExpr().asString();
        }
        return eleValue.toString();
    }

    protected static String getStringValue(Expression eleValue) {
        if (eleValue.isStringLiteralExpr()) {
            return eleValue.asStringLiteralExpr().asString();
        }
        throw new IllegalArgumentException("Value not a string literal");
    }

    protected static Boolean getBoolean(Expression value) {
        if (value.isBooleanLiteralExpr()) {
            return value.asBooleanLiteralExpr().getValue();
        }
        return false;
    }

    protected String processDefaultValue(Expression defaultValue, String type) {
        if (defaultValue.isStringLiteralExpr()) {
            StringLiteralExpr string = defaultValue.asStringLiteralExpr();
            String literalValue = string.asString();
            String escapedValue = string.toString();
            if ("BString".equals(type) && !escapedValue.contains("BString")) {
                return escapedValue;
            }
            if ("String".equals(type)) {
                ParserConfiguration configuration = JavaUnit.getDefaultParserConfiguration(this.slotomaticOptions);
                JavaParser parser = new JavaParser(configuration);
                ParseResult parseResult = parser.parseExpression(literalValue);
                if (!parseResult.isSuccessful()) {
                    return escapedValue;
                }
                Expression node = (Expression)parseResult.getResult().get();
                if (node.isNameExpr()) {
                    return escapedValue;
                }
            }
            return literalValue;
        }
        if (defaultValue.isNullLiteralExpr()) {
            return "null";
        }
        throw new IllegalArgumentException("Value is not a String literal");
    }

    protected static List<Facet> makeFacets(Expression eleValue) {
        return AnnotationProcessor.getChildrenAnnotations(eleValue).stream().map(AnnotationProcessor::processFacet).collect(Collectors.toList());
    }

    protected static String makeFlags(Expression eleValue) {
        return eleValue.toString();
    }

    protected static List<String> getStringList(Expression eleValue) {
        ArrayList<String> values = new ArrayList<String>();
        if (eleValue.isArrayInitializerExpr()) {
            ArrayInitializerExpr arrayInitializer = eleValue.asArrayInitializerExpr();
            values.addAll(arrayInitializer.getValues().stream().map(AnnotationProcessor::getValue).collect(Collectors.toList()));
        } else if (eleValue.isStringLiteralExpr()) {
            values.add(eleValue.asStringLiteralExpr().getValue());
        } else {
            throw new IllegalArgumentException("Could not find String Literals on node");
        }
        return values;
    }

    private static Facet processFacet(AnnotationExpr annotation) {
        if (annotation.isNormalAnnotationExpr()) {
            AnnotationAttributes attributes = new AnnotationAttributes(annotation.asNormalAnnotationExpr());
            String value = attributes.requireAndMap("value", AnnotationProcessor::getValue);
            try {
                Optional<String> name = attributes.getAndMap("name", AnnotationProcessor::getStringValue);
                return new Facet(name.orElse(null), value);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Facet name was not a String literal", iae);
            }
        }
        if (annotation.isSingleMemberAnnotationExpr()) {
            String value = AnnotationProcessor.getValue(annotation.asSingleMemberAnnotationExpr().getMemberValue());
            return new Facet(null, value);
        }
        throw new IllegalArgumentException("Annotation is not valid facet annotation");
    }

    protected static String removeQuotes(String toChange) {
        return toChange.substring(1, toChange.length() - 1);
    }

    protected static List<AnnotationExpr> getChildrenAnnotations(Expression memberValueExpr) {
        ArrayList<AnnotationExpr> values = new ArrayList<AnnotationExpr>();
        if (memberValueExpr.isArrayInitializerExpr()) {
            ArrayInitializerExpr arrayInitializer = memberValueExpr.asArrayInitializerExpr();
            values.addAll(arrayInitializer.getValues().stream().filter(expression -> expression instanceof AnnotationExpr).map(expression -> (AnnotationExpr)expression).collect(Collectors.toList()));
        } else if (memberValueExpr instanceof AnnotationExpr) {
            values.add(memberValueExpr.asAnnotationExpr());
        } else {
            throw new IllegalArgumentException("Could not find annotations on node");
        }
        return values;
    }

    protected static class AnnotationAttributes {
        private final String annotationName;
        private final Map<String, Optional<Expression>> attrs;
        private final NormalAnnotationExpr annotation;

        public AnnotationAttributes(NormalAnnotationExpr annotation) {
            this.attrs = AnnotationAttributes.extractAttributes(annotation);
            this.annotationName = annotation.getNameAsString();
            this.annotation = annotation;
        }

        public NormalAnnotationExpr getAnnotation() {
            return this.annotation;
        }

        public Optional<Expression> get(String key) {
            return this.attrs.getOrDefault(key, Optional.empty());
        }

        public <T> Optional<T> getAndMap(String key, Function<Expression, T> mapper) {
            return this.get(key).map(mapper);
        }

        public <T> T requireAndMap(String key, Function<Expression, T> mapper) {
            return this.getAndMap(key, mapper).orElseThrow(() -> new IllegalStateException(this.annotationName + " must have the " + key + " attribute"));
        }

        private static Map<String, Optional<Expression>> extractAttributes(NormalAnnotationExpr annotation) {
            NodeList<MemberValuePair> attrs = annotation.getPairs();
            return attrs.stream().collect(Collectors.toMap(key -> key.getName().getIdentifier(), value -> Optional.ofNullable(value.getValue())));
        }
    }
}

