/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Problem;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.nodeTypes.NodeWithRange;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.tridium.slottool.BajaMetadata;
import com.tridium.slottool.Constants;
import com.tridium.slottool.InvalidBajaClassException;
import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.AnnotationGenerator;
import com.tridium.slottool.generator.CodeBlock;
import com.tridium.slottool.generator.ExistingCodeBlock;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.generator.LineRange;
import com.tridium.slottool.generator.SortedImportCodeBlock;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.EmptyBajaUnit;
import com.tridium.slottool.model.Slot;
import com.tridium.slottool.model.annotation.AnnotationClass;
import com.tridium.slottool.model.annotation.AnnotationProcessor;
import com.tridium.slottool.model.comment.CommentClass;
import com.tridium.slottool.util.JavaParserUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.CRC32;

public class JavaUnit {
    private static final Pattern EOL_PLACEHOLDER = Pattern.compile("\uffff");
    private boolean isInterface = false;
    private boolean isClassFinal = false;
    private CodeBlock bajaCode = null;
    private CodeBlock oldGen = null;
    private CodeBlock niagaraSlots = null;
    private CodeBlock importBlock = null;
    private SortedImportCodeBlock sortedImports = null;
    protected String annotationCode = null;
    private int annotationInsertionLine = -1;
    private int bajaInsertionLine = -1;
    protected final List<FieldDeclaration> slotDeclarations = new LinkedList<FieldDeclaration>();
    protected final Map<String, FieldDeclaration> fields = new HashMap<String, FieldDeclaration>();
    protected final Map<String, MethodDeclaration> methods = new HashMap<String, MethodDeclaration>();
    private String packageName;
    private final List<String> imports = new LinkedList<String>();
    protected final List<AnnotationExpr> niagaraAnnotations = new ArrayList<AnnotationExpr>();
    private final String fileName;
    private final String source;
    private final List<String> sourceLines;
    private final SlotomaticOptions slotomaticOptions;
    private final HashMap<String, Long> bajaChecksum = new HashMap();
    private final List<Problem> errors = new LinkedList<Problem>();
    private String name;
    private long oldChecksum = -1L;
    private BajaMetadata generatedBajaMetadata = null;
    private String oldDateLine = null;
    private final Logger log = Slotomatic.getLogger();
    private final BajaUnit unit;

    public JavaUnit(File javaFile) throws IOException {
        this(javaFile, SlotomaticOptions.DEFAULT_OPTIONS);
    }

    public JavaUnit(File javaFile, SlotomaticOptions slotomaticOptions) throws IOException {
        String charset = slotomaticOptions.getInputCharset();
        this.source = new String(Files.readAllBytes(javaFile.toPath()), Charset.forName(charset));
        this.fileName = javaFile.getName();
        this.sourceLines = Arrays.asList(Constants.EOL.split(this.source));
        this.slotomaticOptions = slotomaticOptions;
        ParserConfiguration configuration = JavaUnit.getDefaultParserConfiguration(slotomaticOptions);
        configuration.setAttributeComments(true);
        configuration.setIgnoreAnnotationsWhenAttributingComments(false);
        JavaParser javaParser = new JavaParser(configuration);
        ParseResult<CompilationUnit> parseResult = javaParser.parse(javaFile);
        this.errors.addAll(parseResult.getProblems());
        if (!parseResult.isSuccessful() || !parseResult.getResult().isPresent()) {
            this.unit = null;
            return;
        }
        CompilationUnit cu = parseResult.getResult().get();
        this.parse(cu);
        this.unit = this.getBajaUnit();
        if (this.unit.isEnum() && !this.isClassFinal) {
            throw new InvalidBajaClassException("NiagaraEnums must be final");
        }
        Map<String, List<FieldDeclaration>> fieldMap = this.slotDeclarations.stream().collect(Collectors.groupingBy(declaration -> declaration.getElementType().asString()));
        this.checkSlotOverrides(fieldMap, this.unit.getProperties(), "Property");
        this.checkSlotOverrides(fieldMap, this.unit.getActions(), "Action");
        this.checkSlotOverrides(fieldMap, this.unit.getTopics(), "Topic");
    }

    public static ParserConfiguration getDefaultParserConfiguration(SlotomaticOptions options) {
        ParserConfiguration.LanguageLevel parserLanguageLevel;
        ParserConfiguration configuration = new ParserConfiguration();
        String languageLevel = options.getJavaLanguageLevel();
        int javaVersion = languageLevel.length() >= 3 && languageLevel.startsWith("1.") ? Integer.parseInt(languageLevel.substring(2)) : Integer.parseInt(languageLevel);
        switch (javaVersion) {
            case 8: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_8;
                break;
            }
            case 9: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_9;
                break;
            }
            case 10: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_10;
                break;
            }
            case 11: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_11;
                break;
            }
            case 12: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_12;
                break;
            }
            case 13: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_13;
                break;
            }
            case 14: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_14;
                break;
            }
            case 15: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_15;
                break;
            }
            case 16: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_16;
                break;
            }
            case 17: {
                parserLanguageLevel = ParserConfiguration.LanguageLevel.JAVA_17;
                break;
            }
            default: {
                throw new IllegalArgumentException("Slot-o-matic does not support Java " + javaVersion);
            }
        }
        configuration.setLanguageLevel(parserLanguageLevel);
        configuration.setCharacterEncoding(Charset.forName(options.getInputCharset()));
        return configuration;
    }

    private void checkSlotOverrides(Map<String, List<FieldDeclaration>> fieldMap, List<? extends Slot> slots, String slotType) {
        if (!fieldMap.containsKey(slotType)) {
            return;
        }
        List slotNames = slots.stream().map(Slot::getName).collect(Collectors.toList());
        for (FieldDeclaration field : fieldMap.get(slotType)) {
            if (field == null) {
                return;
            }
            String name = field.getVariable(0).getName().getIdentifier();
            if (slotNames.contains(name)) continue;
            this.log.warning(this.fileName + ": " + slotType + " " + name + " not present in annotations!");
        }
    }

    public BajaUnit getBajaUnit() {
        if (this.hasNiagaraAnnotations()) {
            if (this.slotomaticOptions.isStrictAnnotationMode()) {
                this.checkStrictAnnotation();
            }
            AnnotationClass unit = new AnnotationClass(this.name, this.hasNiagaraAnnotation("NiagaraSingleton"), this.hasNiagaraAnnotation("NiagaraEnum"), this.isInterface, this.hasNiagaraAnnotation("NiagaraOrionType"));
            this.getNiagaraAnnotations().forEach(expr -> {
                Name annotationName = expr.getName();
                Optional<AnnotationProcessor> processor = AnnotationProcessor.getAnnotationProcessor(this.slotomaticOptions, annotationName, unit, this.source);
                if (!processor.isPresent()) {
                    System.out.println("Could not find processor for " + annotationName);
                }
                processor.ifPresent(p -> p.accept((AnnotationExpr)expr));
            });
            return unit;
        }
        if (this.hasBajaCode()) {
            return new CommentClass(this.name, this.getBajaCode().orElseThrow(() -> new IllegalArgumentException("JavaFile " + this.name + " does not have a baja comment block")), this.isInterface);
        }
        return new EmptyBajaUnit(this.name, this.isInterface);
    }

    public long getBajaChecksum() {
        return this.getBajaChecksum("\n");
    }

    public long getBajaChecksum(String endOfLine) {
        Objects.requireNonNull(endOfLine);
        return this.bajaChecksum.computeIfAbsent(endOfLine, eol -> {
            long bajaCrcChecksum = 0L;
            if (this.bajaCode != null) {
                String trimmed = this.bajaCode.getBlock().trim();
                char[] dest = new char[trimmed.length()];
                System.arraycopy(trimmed.toCharArray(), 0, dest, 0, dest.length);
                String bajaCode = new String(dest);
                bajaCrcChecksum = this.calculateMetadataCrcChecksum(bajaCode, (String)eol);
            }
            long annotationCrcChecksum = 0L;
            if (!this.niagaraAnnotations.isEmpty()) {
                GeneratedCodeBlock annotationBlock = new AnnotationGenerator(this.slotomaticOptions, this.unit).getGeneratedBlock();
                annotationCrcChecksum = this.calculateMetadataCrcChecksum(annotationBlock.getBlock(), (String)eol);
            }
            return bajaCrcChecksum | annotationCrcChecksum;
        });
    }

    public String getGeneratedPackageName() {
        return this.getGeneratedBajaMetadata().getPackageName();
    }

    public String getGeneratedClassName() {
        return this.getGeneratedBajaMetadata().getClassName();
    }

    public long getGeneratedChecksum() {
        if (this.oldChecksum == -1L) {
            this.oldChecksum = this.getGeneratedBajaMetadata().getChecksum();
        }
        return this.oldChecksum;
    }

    public BajaMetadata getGeneratedBajaMetadata() {
        if (this.generatedBajaMetadata == null) {
            if (this.oldGen == null) {
                throw new IllegalStateException("Cannot find existing metadata block");
            }
            List bajaMetadataLines = this.oldGen.getLines().stream().filter(it -> it.trim().startsWith("/*@")).collect(Collectors.toList());
            if (bajaMetadataLines.size() != 1) {
                throw new IllegalStateException("Found multiple metadata blocks");
            }
            this.generatedBajaMetadata = BajaMetadata.fromExisting((String)bajaMetadataLines.get(0));
        }
        return this.generatedBajaMetadata;
    }

    public String getCurrentBajaDateLine() {
        if (this.oldDateLine == null && this.oldGen != null) {
            for (String line : this.oldGen.getLines()) {
                if (!Constants.GENERATED_ON_DATE.matcher(line).matches()) continue;
                this.oldDateLine = line;
                break;
            }
        }
        return this.oldDateLine;
    }

    public BajaMetadata getBajaMetadata() {
        return BajaMetadata.fromJavaUnit(this);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean hasBajaCode() {
        return this.bajaCode != null;
    }

    public boolean hasNiagaraAnnotations() {
        return !this.niagaraAnnotations.isEmpty();
    }

    public boolean hasGeneratedCode() {
        return this.oldGen != null;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<AnnotationExpr> getNiagaraAnnotations() {
        return this.niagaraAnnotations;
    }

    public List<AnnotationExpr> getNiagaraAnnotations(String annotationName) {
        return this.niagaraAnnotations.stream().filter(it -> annotationName.equals(it.getName().getIdentifier())).collect(Collectors.toList());
    }

    public boolean hasNiagaraAnnotation(String annotationName) {
        Objects.requireNonNull(annotationName);
        return this.niagaraAnnotations.stream().anyMatch(annotation -> annotationName.equals(AnnotationProcessor.getAnnotationName(annotation.getName())));
    }

    public boolean hasImport(String importName) {
        String onDemandImport;
        if (this.imports.contains(importName)) {
            return true;
        }
        return importName.contains(".") && this.imports.contains((onDemandImport = importName.substring(0, importName.lastIndexOf("."))) + ".*");
    }

    public boolean hasImports() {
        return !this.imports.isEmpty();
    }

    public List<String> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    public Optional<String> getBajaCode() {
        if (this.bajaCode != null) {
            return Optional.of(this.bajaCode.getBlock());
        }
        return Optional.empty();
    }

    public List<Problem> getErrors() {
        return this.errors;
    }

    public String getSource() {
        return this.source;
    }

    public List<String> getSourceLines() {
        return this.sourceLines;
    }

    public String getSourceLineSeparator() {
        return this.slotomaticOptions.getLineSeparator();
    }

    public ExistingCodeBlock getSourceBlock(LineRange range) {
        return new ExistingCodeBlock(range, this.sourceLines, this.getSourceLineSeparator());
    }

    public Optional<CodeBlock> getBajaCommentBlock() {
        return Optional.ofNullable(this.bajaCode);
    }

    public Optional<CodeBlock> getBajaBlock() {
        return Optional.ofNullable(this.oldGen);
    }

    public Optional<CodeBlock> getNiagaraSlotsBlock() {
        return Optional.ofNullable(this.niagaraSlots);
    }

    public Optional<CodeBlock> getField(String name) {
        if (this.fields.containsKey(name)) {
            return Optional.of(this.getSourceBlock(JavaParserUtil.getRange(this.fields.get(name))));
        }
        return Optional.empty();
    }

    public Optional<CodeBlock> getMethod(String name) {
        if (this.methods.containsKey(name)) {
            return Optional.of(this.getSourceBlock(JavaParserUtil.getRange(this.methods.get(name))));
        }
        return Optional.empty();
    }

    public int getAnnotationInsertionLine() {
        return this.annotationInsertionLine;
    }

    public int getBajaInsertionLine() {
        return this.bajaInsertionLine;
    }

    public CodeBlock getImportBlock() {
        return this.importBlock;
    }

    public Optional<SortedImportCodeBlock> getSortedImports() {
        return Optional.ofNullable(this.sortedImports);
    }

    public boolean isSlotCodeOutOfDate() {
        try {
            long generatedChecksum = this.getGeneratedChecksum();
            return this.getBajaChecksum() != generatedChecksum && this.getBajaChecksum("\r\n") != generatedChecksum && this.getBajaChecksum("\n") != generatedChecksum;
        }
        catch (IllegalStateException ise) {
            return true;
        }
    }

    private void parse(CompilationUnit cu) {
        LineRange importRange;
        if (!cu.getPackageDeclaration().isPresent()) {
            throw new InvalidBajaClassException("Java file must belong to a package");
        }
        PackageDeclaration packageDeclaration = cu.getPackageDeclaration().get();
        List importDeclarations = cu.getImports().stream().sorted(Comparator.comparingInt(JavaParserUtil::getEndLine)).collect(Collectors.toList());
        if (importDeclarations.isEmpty()) {
            int importLine = JavaParserUtil.getEndLine(packageDeclaration);
            importRange = new LineRange(importLine, importLine);
        } else {
            ImportDeclaration firstImport = (ImportDeclaration)importDeclarations.get(0);
            ImportDeclaration lastImport = (ImportDeclaration)importDeclarations.get(importDeclarations.size() - 1);
            importRange = new LineRange(JavaParserUtil.getStartLine(firstImport), JavaParserUtil.getEndLine(lastImport));
        }
        this.importBlock = this.getSourceBlock(importRange);
        if (this.slotomaticOptions.isSortImports()) {
            this.sortedImports = new SortedImportCodeBlock(this.slotomaticOptions.getLineSeparator());
            this.sortedImports.setStartLine(this.importBlock.getRange().getStart());
        }
        for (Object importDeclaration : importDeclarations) {
            if (this.sortedImports != null) {
                this.sortedImports.addImport((ImportDeclaration)importDeclaration);
            }
            StringBuilder importName = new StringBuilder();
            importName.append(importDeclaration.getNameAsString());
            if (((ImportDeclaration)importDeclaration).isAsterisk()) {
                importName.append(".*");
            }
            if (((ImportDeclaration)importDeclaration).isStatic()) {
                importName.insert(0, "static ");
            }
            this.imports.add(importName.toString());
        }
        this.packageName = packageDeclaration.getNameAsString();
        int genStart = 0;
        for (Comment comment : cu.getAllComments()) {
            String contents;
            if (comment.isBlockComment()) {
                BlockComment blockComment = comment.asBlockComment();
                contents = blockComment.getContent();
                if (contents.startsWith("-") && contents.endsWith("-")) {
                    this.bajaCode = this.getSourceBlock(JavaParserUtil.getRange(blockComment));
                    continue;
                }
                if ("+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +".equals(contents)) {
                    genStart = JavaParserUtil.getStartLine(blockComment);
                    continue;
                }
                if (!"+ ------------ END BAJA AUTO GENERATED CODE -------------- +".equals(contents)) continue;
                this.oldGen = this.getSourceBlock(new LineRange(genStart, JavaParserUtil.getEndLine(blockComment)));
                continue;
            }
            if (!comment.isLineComment()) continue;
            LineComment lineComment = comment.asLineComment();
            contents = lineComment.getContent().trim();
            if ("region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/".equals(contents)) {
                genStart = JavaParserUtil.getStartLine(lineComment);
                continue;
            }
            if (!"endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/".equals(contents)) continue;
            this.oldGen = this.getSourceBlock(new LineRange(genStart, JavaParserUtil.getEndLine(lineComment)));
        }
        if (!cu.getPrimaryType().isPresent()) {
            throw new IllegalArgumentException("Could not determine primary type");
        }
        TypeDeclaration<?> type = cu.getPrimaryType().get();
        if (!type.isClassOrInterfaceDeclaration()) {
            throw new IllegalArgumentException("Top-level definition must be class or interface");
        }
        this.name = type.asClassOrInterfaceDeclaration().getName().getIdentifier();
        NodeList<AnnotationExpr> annotations = type.getAnnotations();
        for (AnnotationExpr annotation : type.getAnnotations()) {
            if (!AnnotationProcessor.isSupportedAnnotation(annotation.getName())) continue;
            this.niagaraAnnotations.add(annotation);
        }
        if (this.hasNiagaraAnnotation("NiagaraSlots")) {
            List<AnnotationExpr> niagaraSlotsAnnotations = this.getNiagaraAnnotations("NiagaraSlots");
            if (niagaraSlotsAnnotations.size() != 1) {
                throw new RuntimeException("Class has multiple @NiagaraSlots annotations");
            }
            AnnotationExpr niagaraSlot = niagaraSlotsAnnotations.get(0);
            this.niagaraSlots = this.getSourceBlock(JavaParserUtil.getRange(niagaraSlot));
        }
        NodeList<Modifier> modifiers = type.getModifiers();
        this.annotationInsertionLine = annotations.isNonEmpty() ? JavaParserUtil.getStartLine(annotations.get(0)) : (modifiers.isNonEmpty() ? JavaParserUtil.getStartLine(modifiers.getFirst().get()) : JavaParserUtil.getStartLine(type));
        this.annotationCode = this.niagaraAnnotations.stream().map(Node::toString).collect(Collectors.joining());
        for (FieldDeclaration field : type.getFields()) {
            this.fields.put(field.getVariable(0).getName().getIdentifier(), field);
            if (!this.isSlotType(field)) continue;
            this.slotDeclarations.add(field);
        }
        this.isInterface = type.asClassOrInterfaceDeclaration().isInterface();
        if (this.oldGen != null) {
            this.bajaInsertionLine = this.oldGen.getRange().getStart();
        } else if (this.bajaCode != null) {
            this.bajaInsertionLine = this.bajaCode.getRange().getEnd() + 1;
        } else if (!this.slotDeclarations.isEmpty()) {
            List sortedSlotDeclarations = this.slotDeclarations.stream().sorted(Comparator.comparingInt(JavaParserUtil::getStartLine).reversed()).collect(Collectors.toList());
            this.bajaInsertionLine = JavaParserUtil.getEndLine((NodeWithRange)sortedSlotDeclarations.get(0)) + 1;
        } else {
            int startIndex = JavaParserUtil.getEndLine(type.getNameAsExpression()) - 1;
            for (int i = startIndex + 1; i < this.sourceLines.size(); ++i) {
                if (!this.sourceLines.get(i).contains("{")) continue;
                this.bajaInsertionLine = i + 2;
                break;
            }
        }
        this.isClassFinal = modifiers.contains(Modifier.finalModifier());
        for (MethodDeclaration method : type.getMethods()) {
            this.methods.put(method.getName().getIdentifier(), method);
        }
    }

    private boolean isSlotType(FieldDeclaration fieldDeclaration) {
        Type fieldType = fieldDeclaration.getElementType();
        if (fieldType.isClassOrInterfaceType()) {
            ClassOrInterfaceType type = fieldType.asClassOrInterfaceType();
            switch (type.getName().getIdentifier()) {
                case "Property": 
                case "Topic": 
                case "Action": {
                    return this.checkSlotModifiers(fieldDeclaration);
                }
            }
        }
        return false;
    }

    private boolean checkSlotModifiers(FieldDeclaration declaration) {
        NodeList<Modifier> modifiers = declaration.getModifiers();
        return modifiers.containsAll(Modifier.createModifierList(Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC, Modifier.Keyword.FINAL));
    }

    private void checkStrictAnnotation() {
        if (!this.hasNiagaraAnnotation("NiagaraType")) {
            throw new IllegalArgumentException("File has no @NiagaraType annotation");
        }
        if (this.hasNiagaraAnnotation("NiagaraSlots")) {
            throw new IllegalArgumentException("File has deprecated @NiagaraSlots annotation");
        }
    }

    private long calculateMetadataCrcChecksum(String source, String eol) {
        Charset charset = Charset.forName(this.slotomaticOptions.getInputCharset());
        String normalizedSource = source;
        if (!eol.isEmpty()) {
            normalizedSource = Constants.EOL.matcher(normalizedSource).replaceAll(Matcher.quoteReplacement("\uffff"));
            normalizedSource = EOL_PLACEHOLDER.matcher(normalizedSource).replaceAll(eol);
        }
        CRC32 crc = new CRC32();
        crc.update(normalizedSource.getBytes(charset));
        return crc.getValue();
    }
}

