/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.SlotomaticOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class JavaFile {
    private final Path inputFile;
    private final JavaUnit javaUnit;
    private final SlotomaticOptions slotomaticOptions;

    public JavaFile(Path inputFile, SlotomaticOptions slotomaticOptions) throws IOException {
        int dotIndex;
        this.slotomaticOptions = slotomaticOptions;
        if (Files.notExists(inputFile, new LinkOption[0]) || Files.isDirectory(inputFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot use file " + inputFile.toString());
        }
        String fullFileName = Objects.requireNonNull(inputFile.getFileName()).toString();
        String fileExt = fullFileName.substring(dotIndex = fullFileName.lastIndexOf(46));
        if (!".java".equals(fileExt)) {
            throw new IllegalArgumentException("Cannot slot file with extension " + fileExt);
        }
        this.inputFile = inputFile;
        this.javaUnit = new JavaUnit(inputFile.toFile(), slotomaticOptions);
    }

    public String getFileName() {
        return this.inputFile.toAbsolutePath().toString();
    }

    public Path getInputFile() {
        return this.inputFile;
    }

    public JavaUnit getJavaUnit() {
        return this.javaUnit;
    }
}

