/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.github.javaparser.Problem;
import com.tridium.slottool.AnnotationTransformer;
import com.tridium.slottool.ImportTransformer;
import com.tridium.slottool.JavaFile;
import com.tridium.slottool.JavaUnit;
import com.tridium.slottool.SlotTransformer;
import com.tridium.slottool.Slotomatic;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.model.Adapter;
import com.tridium.slottool.model.AgentOn;
import com.tridium.slottool.model.EmptyBajaUnit;
import com.tridium.slottool.model.NiagaraType;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Compiler {
    private final SlotomaticOptions options;
    private int compileCount;
    private int skipCount;
    private int failCount;
    private final Map<Path, String> failedFiles = new HashMap<Path, String>();
    private final Logger log = Slotomatic.getLogger();
    private final Map<String, NiagaraType> typeList = new HashMap<String, NiagaraType>();

    public Compiler(SlotomaticOptions options, Path ... moduleIncludePaths) {
        this.options = options;
        this.compileCount = 0;
        this.skipCount = 0;
        this.failCount = 0;
        for (Path moduleIncludePath : moduleIncludePaths) {
            if (Files.exists(moduleIncludePath, new LinkOption[0])) {
                try {
                    String stringBuilder = "<dummyroot>" + options.getLineSeparator() + new String(Files.readAllBytes(moduleIncludePath), Charset.forName("UTF-8")) + options.getLineSeparator() + "</dummyroot>";
                    DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = builderFactory.newDocumentBuilder();
                    Document doc = builder.parse(new ByteArrayInputStream(stringBuilder.getBytes("UTF-8")));
                    NodeList typesList = doc.getElementsByTagName("types");
                    if (typesList.getLength() == 0) {
                        this.log.warning("module-include.xml has no \"types\" node");
                        continue;
                    }
                    if (typesList.getLength() > 1) {
                        this.log.warning("module-include.xml has more than one \"types\" node");
                        continue;
                    }
                    Node types = typesList.item(0);
                    NodeList typeList = types.getChildNodes();
                    for (int i = 0; i < typeList.getLength(); ++i) {
                        Node type = typeList.item(i);
                        if (!"type".equals(type.getNodeName())) continue;
                        NamedNodeMap attributes = type.getAttributes();
                        String className = Optional.ofNullable(attributes.getNamedItem("class")).orElseThrow(IllegalArgumentException::new).getNodeValue();
                        NiagaraType niagaraType = new NiagaraType();
                        niagaraType.setOrdScheme(Compiler.getAttributeByName(attributes, "ordScheme"));
                        List<Node> childNodes = Compiler.toList(type.getChildNodes());
                        for (Node childNode : childNodes) {
                            NamedNodeMap childAttributes = childNode.getAttributes();
                            switch (childNode.getNodeName()) {
                                case "agent": {
                                    AgentOn agentOn = new AgentOn();
                                    agentOn.setRequiredPermissions(Compiler.getAttributeByName(childAttributes, "requiredPermissions"));
                                    agentOn.setApp(Compiler.getAttributeByName(childAttributes, "app"));
                                    agentOn.setPreferredDefault(Compiler.getAttributeByName(childAttributes, "default"));
                                    Compiler.toList(childNode.getChildNodes()).stream().filter(node -> "on".equals(node.getNodeName())).map(Node::getAttributes).map(attrs -> attrs.getNamedItem("type")).filter(Objects::nonNull).map(Node::getNodeValue).forEach(agentOn::addType);
                                    niagaraType.addAgentOn(agentOn);
                                    break;
                                }
                                case "file": {
                                    Compiler.toList(childNode.getChildNodes()).stream().filter(node -> "ext".equals(node.getNodeName())).map(Node::getAttributes).map(attrs -> attrs.getNamedItem("name")).filter(Objects::nonNull).map(Node::getNodeValue).forEach(niagaraType::addFileExt);
                                    break;
                                }
                                case "adapter": {
                                    try {
                                        Adapter adapter = new Adapter(Compiler.getAttributeByName(childAttributes, "from").orElseThrow(() -> new IllegalArgumentException("Malformed adapter tag: does not have from attribute")), Compiler.getAttributeByName(childAttributes, "to").orElseThrow(() -> new IllegalArgumentException("Malformed adapter tag: does not have to attribute")));
                                        niagaraType.setAdapter(Optional.of(adapter));
                                    }
                                    catch (IllegalArgumentException e) {
                                        this.log.log(Level.WARNING, "Malformed adapter tag on " + className, e);
                                    }
                                    break;
                                }
                            }
                        }
                        if (niagaraType.getAdapter().isPresent() || !niagaraType.getAgentOn().isEmpty() || !niagaraType.getFileExt().isEmpty() || niagaraType.getOrdScheme().isPresent()) {
                            this.typeList.put(className, niagaraType);
                            continue;
                        }
                        this.typeList.put(className, NiagaraType.EMPTY);
                    }
                    continue;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.log.log(Level.WARNING, "Could not create XML parser", e);
                    continue;
                }
            }
            if (!this.log.isLoggable(Level.FINE)) continue;
            this.log.fine("File " + moduleIncludePath.toAbsolutePath() + " not found, ignoring");
        }
    }

    private static Optional<String> getAttributeByName(NamedNodeMap attributes, String attributeName) {
        Objects.requireNonNull(attributes);
        Objects.requireNonNull(attributeName);
        return Optional.ofNullable(attributes.getNamedItem(attributeName)).map(Node::getNodeValue);
    }

    private static List<Node> toList(NodeList nodeList) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
        return list;
    }

    public int getCompileCount() {
        return this.compileCount;
    }

    public void compile(Path unit) {
        if (Files.notExists(unit, new LinkOption[0])) {
            this.log.severe("File does not exist: " + unit.toString());
            return;
        }
        if (!Files.isDirectory(unit, new LinkOption[0])) {
            this.process(unit);
        } else {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(unit);){
                directoryStream.forEach(this::compile);
            }
            catch (IOException ioe) {
                this.log.log(Level.SEVERE, ioe, () -> "Error processing path: " + unit.toAbsolutePath().toString());
            }
        }
    }

    private void process(Path inputFile) {
        block17: {
            if (Compiler.checkName(inputFile)) {
                JavaFile jfile;
                String fullFileName = inputFile.toAbsolutePath().toString();
                try {
                    jfile = this.getJavaFile(inputFile);
                }
                catch (Exception e) {
                    Supplier<String> logMessage = () -> String.format("File %s is invalid: %s", fullFileName, e.getMessage());
                    if (this.options.failOnInvalidFile()) {
                        this.log.log(Level.WARNING, e, logMessage);
                        throw new RuntimeException("Fatal error processing " + fullFileName, e);
                    }
                    this.log.log(Level.FINE, e, logMessage);
                    ++this.failCount;
                    this.failedFiles.put(inputFile, e.getMessage());
                    return;
                }
                if (jfile.getJavaUnit().hasNiagaraAnnotation("NoSlotomatic")) {
                    this.log.log(Level.FINE, () -> "Skipping file since it is marked as NoSlotomatic: " + fullFileName);
                    ++this.skipCount;
                    return;
                }
                try {
                    boolean migrated = false;
                    boolean compiled = false;
                    boolean imported = false;
                    if (this.options.isImportFromModuleInclude()) {
                        imported = this.importFromModuleInclude(jfile);
                        if (imported) {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Importing " + jfile.getFileName());
                            }
                            jfile = this.getJavaFile(inputFile);
                        }
                    } else if (jfile.getJavaUnit().getBajaUnit() instanceof EmptyBajaUnit) {
                        throw new IllegalStateException("Cannot transform a class with no metadata");
                    }
                    if (this.options.migrate() && !imported && (migrated = this.migrateSlotomatic(jfile))) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Migrating " + jfile.getFileName());
                        }
                        jfile = this.getJavaFile(inputFile);
                    }
                    if (this.options.compile()) {
                        compiled = this.slotomatic(jfile);
                    }
                    if (migrated || compiled || imported) {
                        ++this.compileCount;
                    } else {
                        ++this.skipCount;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, e, () -> String.format("Could not process %s: %s", fullFileName, e.getMessage()));
                    ++this.failCount;
                    this.failedFiles.put(inputFile, e.getMessage());
                    if (!this.options.failOnInvalidFile()) break block17;
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private JavaFile getJavaFile(Path inputFile) throws IOException {
        String fullFileName = inputFile.toAbsolutePath().toString();
        JavaFile jfile = new JavaFile(inputFile, this.options);
        JavaUnit javaUnit = jfile.getJavaUnit();
        if (javaUnit.hasErrors()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.severe("Could not compile file " + fullFileName + ":");
                for (Problem problem : javaUnit.getErrors()) {
                    this.log.fine(String.format("%s: %s", fullFileName, problem.getVerboseMessage()));
                }
            } else {
                this.log.severe("Could not compile file " + fullFileName + ". Run with --info to see details");
            }
            throw new RuntimeException("File " + fullFileName + " has syntax errors");
        }
        return jfile;
    }

    private boolean migrateSlotomatic(JavaFile jfile) throws IOException {
        String fullFileName = jfile.getFileName();
        JavaUnit javaUnit = jfile.getJavaUnit();
        if (javaUnit.hasBajaCode() || javaUnit.hasNiagaraAnnotation("NiagaraSlots") || this.options.forceRecompile()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Update " + fullFileName);
            }
            AnnotationTransformer transformer = new AnnotationTransformer(this.options, javaUnit, this.getTypeInfoForClass(javaUnit.getPackageName() + "." + javaUnit.getName()));
            this.write(jfile, transformer.transform());
            return true;
        }
        return false;
    }

    private boolean importFromModuleInclude(JavaFile jfile) throws IOException {
        String fullFileName = jfile.getFileName();
        JavaUnit javaUnit = jfile.getJavaUnit();
        String qualifiedName = javaUnit.getPackageName() + "." + javaUnit.getName();
        if (!javaUnit.hasBajaCode() && !javaUnit.hasNiagaraAnnotations()) {
            if (!this.typeList.containsKey(qualifiedName)) {
                throw new IllegalArgumentException("Cannot update " + fullFileName + "; it is not in module-include.xml");
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Update " + fullFileName);
            }
            ImportTransformer transformer = new ImportTransformer(this.options, javaUnit, this.getTypeInfoForClass(qualifiedName));
            this.write(jfile, transformer.transform());
            return true;
        }
        return false;
    }

    private boolean slotomatic(JavaFile jfile) throws IOException {
        String fullFileName = jfile.getFileName();
        JavaUnit javaUnit = jfile.getJavaUnit();
        if ((javaUnit.hasBajaCode() || javaUnit.hasNiagaraAnnotations()) && this.needsRecompile(jfile)) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Compile " + fullFileName);
            }
            SlotTransformer transformer = new SlotTransformer(this.options, javaUnit);
            this.write(jfile, transformer.transform());
            return true;
        }
        return false;
    }

    private void write(JavaFile jfile, String newSource) throws IOException {
        try (TempFile outputFile = new TempFile(jfile.getInputFile());){
            try (BufferedWriter out = Files.newBufferedWriter(outputFile.get(), new OpenOption[0]);){
                out.write(newSource);
            }
            outputFile.setUpdated(true);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Could not write new file", e);
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }

    private boolean needsRecompile(JavaFile jfile) {
        if (this.options.forceRecompile()) {
            return true;
        }
        JavaUnit javaUnit = jfile.getJavaUnit();
        if (!javaUnit.hasGeneratedCode()) {
            return true;
        }
        if (!javaUnit.getName().equals(javaUnit.getGeneratedClassName())) {
            return true;
        }
        if (!javaUnit.getPackageName().equals(javaUnit.getGeneratedPackageName())) {
            return true;
        }
        return javaUnit.isSlotCodeOutOfDate();
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public Map<Path, String> getFailedFiles() {
        return this.failedFiles;
    }

    private static boolean checkName(Path file) {
        String fileName = file.getFileName().toString();
        if (!Compiler.checkClassName(fileName)) {
            return false;
        }
        return fileName.endsWith(".java") && !Files.isDirectory(file, new LinkOption[0]);
    }

    private static boolean checkClassName(String name) {
        if (name.charAt(0) == 'B') {
            char c = name.charAt(1);
            return c >= 'A' && c <= 'Z';
        }
        return false;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public NiagaraType getTypeInfoForClass(String className) {
        return this.typeList.getOrDefault(className, NiagaraType.EMPTY);
    }

    private static class TempFile
    implements AutoCloseable {
        boolean updated;
        private final Path inputFile;
        private final Path outputFile;

        public TempFile(Path inputFile) {
            this.inputFile = inputFile;
            String tempFileName = this.inputFile.getFileName().toString() + ".foobiebletch";
            this.outputFile = this.inputFile.toAbsolutePath().resolveSibling(tempFileName);
        }

        public Path get() {
            return this.outputFile;
        }

        public void setUpdated(boolean updated) {
            this.updated = updated;
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.updated) {
                    Files.move(this.outputFile, this.inputFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            finally {
                Files.deleteIfExists(this.outputFile);
            }
        }
    }
}

