/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.Generator;
import com.tridium.gradle.plugins.templates.ModuleDependency;
import com.tridium.gradle.plugins.templates.ModuleRuntimeProfile;
import com.tridium.gradle.plugins.templates.NiagaraModuleDependencies;
import com.tridium.gradle.plugins.templates.NiagaraModuleGenerator;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class NiagaraModulePartGenerator
extends Generator {
    private final List<String> packages = new LinkedList<String>();
    private final NiagaraModuleDependencies dependencies = new NiagaraModuleDependencies();
    private final NiagaraModuleDependencies testDependencies = new NiagaraModuleDependencies();
    private boolean useMavenLayout = false;

    private NiagaraModulePartGenerator(NiagaraModuleGenerator moduleGenerator, ModuleRuntimeProfile runtimeProfile, String modulePartName) {
        super(moduleGenerator, modulePartName);
        this.dependencies.addNreDependency(ModuleDependency.NRE);
        this.dependencies.addDependency(ModuleDependency.BAJA);
        this.testDependencies.addDependency(ModuleDependency.TEST_WB);
        this.context.put("dependencies", (Object)this.dependencies);
        this.context.put("testDependencies", (Object)this.testDependencies);
        this.context.put("runtimeProfile", (Object)runtimeProfile);
        if (runtimeProfile == ModuleRuntimeProfile.ux) {
            this.context.put("javascriptModule", (Object)true);
        }
        if (runtimeProfile == ModuleRuntimeProfile.doc) {
            this.context.put("docModule", (Object)true);
            this.addFileCopy("gradle/module/docs/index.html", "src/doc/index.html");
            this.addFileCopy("gradle/module/docs/toc.xml", "src/doc/toc.xml");
        }
        this.context.put("packages", this.packages);
        this.addTemplateWrite("gradle/module/module.gradle.kts.vm", modulePartName + ".gradle.kts");
        this.addTemplateWrite("gradle/module/module.lexicon.vm", "module.lexicon");
        this.addTemplateWrite("gradle/module/module-permissions.xml.vm", "module-permissions.xml");
    }

    public static NiagaraModulePartGenerator make(NiagaraModuleGenerator moduleGenerator, ModuleRuntimeProfile runtimeProfile) {
        String modulePartName = moduleGenerator.getModuleName() + "-" + (Object)((Object)runtimeProfile);
        return new NiagaraModulePartGenerator(moduleGenerator, runtimeProfile, modulePartName);
    }

    public void setUseMavenLayout(boolean useMavenLayout) {
        this.useMavenLayout = useMavenLayout;
    }

    public void addPackage(String packageName) {
        this.packages.add(packageName);
    }

    public NiagaraModuleDependencies getDependencies() {
        return this.dependencies;
    }

    public NiagaraModuleDependencies getTestDependencies() {
        return this.testDependencies;
    }

    @Deprecated
    public void addLexicon() {
    }

    public void addPalette() {
        this.addFileCopy("gradle/module/module.palette", "module.palette");
    }

    public void generate() {
        File modulePartDirectory = this.generator.getBaseDirectory();
        this.generateFiles();
        for (String packageName : this.packages) {
            String packagePath = packageName.replace('.', '/');
            String srcMain = "src";
            String srcTest = "srcTest";
            if (this.useMavenLayout) {
                srcMain = "src/main/java";
                srcTest = "src/moduleTest/java";
            }
            this.generator.ensureDirectoryCreated(new File(modulePartDirectory, srcMain + "/" + packagePath));
            this.generator.ensureDirectoryCreated(new File(modulePartDirectory, srcTest + "/test/" + packagePath));
        }
    }
}

