/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.wizards;

import com.tridium.devkit.wizards.DriverWizardModel;
import com.tridium.devkit.wizards.NewDriverWizard2;
import com.tridium.devkit.wizards.NewModuleWizard;
import com.tridium.gradle.plugins.templates.GradleProjectGenerator;
import com.tridium.gradle.plugins.templates.VelocityGenerator;
import com.tridium.gradle.plugins.templates.VideoDriverModuleGenerator;
import com.tridium.gradle.plugins.templates.util.NDriverCommInfo;
import com.tridium.gradle.plugins.templates.util.VideoCameraInfo;
import com.tridium.slottool.Slotomatic;
import java.security.AccessController;
import java.util.logging.ConsoleHandler;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.BWbShell;

public class NewVideoDriverWizard
extends DriverWizardModel {
    static UiLexicon lex = UiLexicon.makeUiLexicon(NewVideoDriverWizard.class);
    static BImage banner = BImage.make((String)"module://icons/x32/newModule.png");
    BWidget protocolSelectionStep;
    BCheckBox httpCheckBox = new BCheckBox("HTTP");
    BCheckBox tcpCheckBox = new BCheckBox("TCP/IP");
    BCheckBox udpCheckBox = new BCheckBox("UDP/IP");
    BCheckBox serialCheckBox = new BCheckBox("Serial");
    BWidget dvrSupportStep;
    BGridPane dvrDiscoverySupportChoicePane = new BGridPane(1);
    BGridPane dvrDisplaySupportChoicePane = new BGridPane(1);
    ToggleCommandGroup<ToggleCommand> dvrSupportToggleGroup = new DvrSupportToggleCommandGroup();
    ToggleCommandGroup<ToggleCommand> dvrDiscoverySupportToggleGroup = new ToggleCommandGroup();
    ToggleCommandGroup<ToggleCommand> dvrDisplaySupportToggleGroup = new ToggleCommandGroup();
    BRadioButton dvrSupportRequiredRadioBtn = new BRadioButton(this.dvrSupportToggleGroup, lex.getText("videoDriver.dvrSupportRequired"));
    BRadioButton dvrSupportNotRequiredRadioBtn = new BRadioButton(this.dvrSupportToggleGroup, lex.getText("videoDriver.dvrSupportNotRequired"));
    BRadioButton dvrDiscoverySupportRequiredRadioBtn = new BRadioButton(this.dvrDiscoverySupportToggleGroup, lex.getText("videoDriver.dvrDiscoverySupportedRequired"));
    BRadioButton dvrDiscoverySupportNotRequiredRadioBtn = new BRadioButton(this.dvrDiscoverySupportToggleGroup, lex.getText("videoDriver.dvrDiscoverySupportNotRequired"));
    BRadioButton dvrDisplaySupportRequiredRadioBtn = new BRadioButton(this.dvrDisplaySupportToggleGroup, lex.getText("videoDriver.dvrDisplaySupportedRequired"));
    BRadioButton dvrDisplaySupportNotRequiredRadioBtn = new BRadioButton(this.dvrDisplaySupportToggleGroup, lex.getText("videoDriver.dvrDisplaySupportedNotRequired"));
    BWidget cameraOperationsSupportStep;
    BCheckBox panTiltCheckBox = new BCheckBox("Pan/Tilt");
    BCheckBox zoomCheckBox = new BCheckBox("Zoom");
    BCheckBox focusCheckBox = new BCheckBox("Focus Control");
    BCheckBox irisCheckBox = new BCheckBox("Iris Control");
    BCheckBox storePresetCheckBox = new BCheckBox("Store Presets");
    BCheckBox moveToPresetCheckBox = new BCheckBox("Move to Preset");

    public NewVideoDriverWizard(BWbShell shell, NewDriverWizard2 eitherDriverWizard) {
        super(shell, eitherDriverWizard);
        this.buildModuleDetailsStep(this.getTitle(), NewDriverWizard2.lexStepXofY(2, 5));
        this.buildProtocolSelectionStep();
        this.buildDvrSupportStep();
        this.buildCameraOperationsStep();
    }

    private void buildProtocolSelectionStep() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(3, 5)));
        BGridPane protocolChoicesPane = new BGridPane(1);
        protocolChoicesPane.setHalign(BHalign.left);
        protocolChoicesPane.setValign(BValign.top);
        protocolChoicesPane.add(null, (BValue)new BLabel(lex.getText("driver.selectProtocols")));
        protocolChoicesPane.add(null, (BValue)this.httpCheckBox);
        protocolChoicesPane.add(null, (BValue)this.tcpCheckBox);
        protocolChoicesPane.add(null, (BValue)this.udpCheckBox);
        protocolChoicesPane.add(null, (BValue)this.serialCheckBox);
        edge.setCenter((BWidget)new BBorderPane((BWidget)protocolChoicesPane, 10.0, 10.0, 10.0, 10.0));
        this.protocolSelectionStep = edge;
    }

    private void buildDvrSupportStep() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(4, 5)));
        BGridPane dvrSupportChoicePane = new BGridPane(1);
        dvrSupportChoicePane.setHalign(BHalign.left);
        dvrSupportChoicePane.setValign(BValign.top);
        dvrSupportChoicePane.add(null, (BValue)new BLabel(lex.getText("videoDriver.useDvrQuestion")));
        dvrSupportChoicePane.add(null, (BValue)this.dvrSupportRequiredRadioBtn);
        dvrSupportChoicePane.add(null, (BValue)this.dvrSupportNotRequiredRadioBtn);
        this.dvrSupportNotRequiredRadioBtn.setSelected(true);
        this.dvrDiscoverySupportChoicePane.setHalign(BHalign.left);
        this.dvrDiscoverySupportChoicePane.setValign(BValign.top);
        this.dvrDiscoverySupportChoicePane.add(null, (BValue)new BLabel(lex.getText("videoDriver.useDvrDiscoveryQuestion")));
        this.dvrDiscoverySupportChoicePane.add(null, (BValue)this.dvrDiscoverySupportRequiredRadioBtn);
        this.dvrDiscoverySupportChoicePane.add(null, (BValue)this.dvrDiscoverySupportNotRequiredRadioBtn);
        this.dvrDisplaySupportChoicePane.setHalign(BHalign.left);
        this.dvrDisplaySupportChoicePane.setValign(BValign.top);
        this.dvrDisplaySupportChoicePane.add(null, (BValue)new BLabel(lex.getText("videoDriver.useDvrDisplayQuestion")));
        this.dvrDisplaySupportChoicePane.add(null, (BValue)this.dvrDisplaySupportRequiredRadioBtn);
        this.dvrDisplaySupportChoicePane.add(null, (BValue)this.dvrDisplaySupportNotRequiredRadioBtn);
        BGridPane containerPane = new BGridPane(1);
        containerPane.setHalign(BHalign.left);
        containerPane.setValign(BValign.top);
        containerPane.add(null, (BValue)dvrSupportChoicePane);
        containerPane.add(null, (BValue)this.dvrDiscoverySupportChoicePane);
        containerPane.add(null, (BValue)this.dvrDisplaySupportChoicePane);
        edge.setCenter((BWidget)new BBorderPane((BWidget)containerPane, 10.0, 10.0, 10.0, 10.0));
        this.dvrSupportStep = edge;
    }

    private void buildCameraOperationsStep() {
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), NewDriverWizard2.lexStepXofY(5, 5)));
        BGridPane containerPane = new BGridPane(1);
        containerPane.setHalign(BHalign.left);
        containerPane.setValign(BValign.top);
        containerPane.add(null, (BValue)new BLabel("Select the operations supported by the camera"));
        containerPane.add(null, (BValue)this.panTiltCheckBox);
        containerPane.add(null, (BValue)this.zoomCheckBox);
        containerPane.add(null, (BValue)this.irisCheckBox);
        containerPane.add(null, (BValue)this.focusCheckBox);
        containerPane.add(null, (BValue)this.moveToPresetCheckBox);
        containerPane.add(null, (BValue)this.storePresetCheckBox);
        edge.setCenter((BWidget)new BBorderPane((BWidget)containerPane, 10.0, 10.0, 10.0, 10.0));
        this.cameraOperationsSupportStep = edge;
    }

    private void stepToModuleDetailsStep() {
        this.update(this.step0, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.moduleDir.requestFocus();
        this.currentStep = 0;
    }

    private void stepToProtocolSelectionStep() {
        this.update(this.protocolSelectionStep, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.currentStep = 1;
    }

    private void stepToDvrSupportStep() {
        this.update(this.dvrSupportStep, this.driverWizard == null ? 2 : 3);
        this.getWizard().setNextAsDefault();
        this.currentStep = 2;
    }

    private void stepToCameraOperationsStep() {
        this.update(this.cameraOperationsSupportStep, this.driverWizard == null ? 2 : 5);
        this.currentStep = 3;
    }

    public void init() {
        this.stepToModuleDetailsStep();
    }

    public void back() {
        switch (this.currentStep) {
            case 0: {
                this.stepToSelectStep();
                break;
            }
            case 1: {
                this.stepToModuleDetailsStep();
                break;
            }
            case 2: {
                this.stepToProtocolSelectionStep();
                break;
            }
            case 3: {
                this.stepToDvrSupportStep();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                this.validateModuleDetail();
                this.stepToProtocolSelectionStep();
                break;
            }
            case 1: {
                this.stepToDvrSupportStep();
                break;
            }
            case 2: {
                this.stepToCameraOperationsStep();
            }
        }
    }

    public boolean finish() {
        this.saveOpt();
        this.shell.enterBusy();
        try {
            this.generateFiles();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot create new driver", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.shell.exitBusy();
        }
    }

    private void generateFiles() throws Exception {
        FilePath path = new FilePath(this.moduleDir.getText());
        BFileSystem fs = BFileSystem.INSTANCE;
        fs.makeDir(path, null);
        VelocityGenerator velocityGenerator = new VelocityGenerator(fs.pathToLocalFile(path));
        GradleProjectGenerator gradleProjectGenerator = new GradleProjectGenerator(velocityGenerator);
        gradleProjectGenerator.setProjectName(this.moduleName());
        gradleProjectGenerator.setVendor(this.vendor.getText());
        gradleProjectGenerator.setCopyright(this.vendor.getText());
        gradleProjectGenerator.setVersion(this.version.getText());
        FilePath existingProperties = path.merge("gradle.properties");
        if (fs.findFile(existingProperties) == null) {
            NewModuleWizard.configureGradleProperties(gradleProjectGenerator);
        }
        VideoDriverModuleGenerator videoDriverModuleGenerator = VideoDriverModuleGenerator.make(gradleProjectGenerator, this.moduleName());
        videoDriverModuleGenerator.setPreferredSymbol(this.prefSymbol.getText());
        videoDriverModuleGenerator.setDescription(this.moduleDescription.getText());
        videoDriverModuleGenerator.setBasePackage(this.basePackage.getText());
        videoDriverModuleGenerator.useDvr(this.dvrSupportRequiredRadioBtn.isSelected());
        videoDriverModuleGenerator.useDvrDisplay(this.hasDisplaySupport());
        videoDriverModuleGenerator.useDvrDiscovery(this.dvrDiscoverySupportRequiredRadioBtn.isSelected());
        NDriverCommInfo commInfo = videoDriverModuleGenerator.getCommInfo();
        commInfo.setHttp(this.httpCheckBox.isSelected());
        commInfo.setTcp(this.tcpCheckBox.isSelected());
        commInfo.setUdp(this.udpCheckBox.isSelected());
        commInfo.setSerial(this.serialCheckBox.isSelected());
        VideoCameraInfo cameraInfo = videoDriverModuleGenerator.getCamera();
        cameraInfo.setPanTiltSupport(this.panTiltCheckBox.isSelected());
        cameraInfo.setZoomSupport(this.zoomCheckBox.isSelected());
        cameraInfo.setIrisSupport(this.irisCheckBox.isSelected());
        cameraInfo.setFocusSupport(this.focusCheckBox.isSelected());
        cameraInfo.setStorePresetsSupport(this.storePresetCheckBox.isSelected());
        cameraInfo.setMoveToPresetSupport(this.moveToPresetCheckBox.isSelected());
        AccessController.doPrivileged(() -> {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Slotomatic.setLogHandler(new ConsoleHandler());
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                gradleProjectGenerator.generate();
                videoDriverModuleGenerator.generate();
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            return null;
        });
        this.shell.hyperlink(BOrd.make((BOrd)fs.getNavOrd(), (OrdQuery)path));
    }

    private boolean hasDisplaySupport() {
        return this.dvrDisplaySupportRequiredRadioBtn.isSelected();
    }

    public FilePath packageToPath(String pack, FilePath fp) {
        return this.packageToPath(pack, fp, false);
    }

    public FilePath packageToPath(String pack, FilePath fp, boolean isTest) {
        String[] s;
        FilePath p = !isTest ? fp.merge("src") : fp.merge("srcTest");
        for (String packPart : s = TextUtil.split((String)pack, (char)'.')) {
            p = p.merge(packPart);
        }
        return p;
    }

    public String getTitle() {
        return lex.getText("videoDriver.title");
    }

    class DvrSupportToggleCommandGroup<T extends ToggleCommand>
    extends ToggleCommandGroup<ToggleCommand> {
        DvrSupportToggleCommandGroup() {
        }

        protected void selected(ToggleCommand command) {
            super.selected(command);
            boolean dvrSupported = command.getLabel().equals(lex.getText("videoDriver.dvrSupportRequired"));
            NewVideoDriverWizard.this.dvrDiscoverySupportChoicePane.setVisible(dvrSupported);
            NewVideoDriverWizard.this.dvrDisplaySupportChoicePane.setVisible(dvrSupported);
        }
    }

    class PrefSymbolModel
    extends TextModel {
        PrefSymbolModel() {
        }

        protected void textModified() {
            String text = this.getText();
            String x = "";
            if (text != null) {
                x = text.trim();
            }
            if (x.length() == 0) {
                return;
            }
            boolean capitalize = Character.isUpperCase(x.charAt(0));
            x = TextUtil.fromFriendly((String)x);
            if (capitalize) {
                x = TextUtil.capitalize((String)x);
            }
            if (!x.equals(text)) {
                NewVideoDriverWizard.this.prefSymbol.setText(x);
            }
        }
    }

    class NameModel
    extends TextModel {
        NameModel() {
        }

        protected void textModified() {
            String text = this.getText();
            String x = "";
            if (text != null) {
                x = text.trim();
            }
            if (x.length() == 0) {
                return;
            }
            boolean capitalize = Character.isUpperCase(x.charAt(0));
            x = TextUtil.fromFriendly((String)x);
            if (capitalize) {
                x = TextUtil.capitalize((String)x);
            }
            if (!x.equals(text)) {
                NewVideoDriverWizard.this.moduleName.setText(x);
            }
        }
    }
}

