/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.ui.history;

import com.tridium.driver.util.DriverUtil;
import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.NavNameColumn;
import javax.baja.gx.BImage;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BIHistory;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class HistoryLearn
extends MgrLearn {
    public static final Lexicon histLex = Lexicon.make((String)"history");
    private static final BImage historyIcon = BImage.make((BIcon)BIcon.std((String)"history.png"));
    private static final BImage deviceIcon = BImage.make((BIcon)BIcon.std((String)"device.png"));

    public HistoryLearn(BArchiveManager manager) {
        super((BAbstractManager)manager);
    }

    protected BWidget makeJobBar() {
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new NavNameColumn(histLex.getText("historyId"))};
    }

    public BImage getIcon(Object discovery) {
        if (discovery instanceof BIHistory) {
            return historyIcon;
        }
        if (discovery instanceof BHistoryDevice) {
            return deviceIcon;
        }
        return null;
    }

    public boolean isDepthExpandable(int depth) {
        return depth < 2;
    }

    public boolean isGroup(Object discovery) {
        return discovery instanceof BHistoryDevice;
    }

    public boolean hasChildren(Object discovery) {
        return this.isGroup(discovery);
    }

    public Object[] getChildren(Object discovery) {
        return DriverUtil.getHistoryChildren((Object)discovery);
    }

    public boolean isMatchable(Object discovery, BComponent database) {
        if (discovery instanceof BHistoryDevice) {
            return false;
        }
        return discovery instanceof BIHistory && database instanceof BArchiveDescriptor;
    }

    public MgrTypeInfo[] toTypes(Object discovery) {
        return new MgrTypeInfo[0];
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BIHistory history = (BIHistory)discovery;
        String name = history.getId().toString();
        name = name.substring(1).replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)history.getId());
    }

    public Object[] getDiscovery(BComponent target) {
        return new Object[0];
    }
}

