/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.BInfinityLogonSequenceRequest;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BInfinityInitializeScreenRequest
extends BDdfRequest
implements BIDdfCustomRequest,
Vt100Const,
RequiresNetworkAccess {
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityInitializeScreenRequest.class);
    BInfinityNetwork network;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInfinityInitializeScreenRequest() {
    }

    public BInfinityInitializeScreenRequest(BInfinityNetwork network) {
        this.network = network;
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        if (this.network.getScreen().isBell()) {
            this.network.getLogger().fine("received bell in response to initialize request");
            return new BInfinityAckWithData("\u001bOS");
        }
        int cursorLine = this.network.getScreen().getCursorLine();
        int cursorCol = this.network.getScreen().getCursorCol();
        if (cursorLine == 13 && cursorCol == 45) {
            return new BInfinityAckWithData(this.network.getScreen().getRecovery(17));
        }
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityInitializeScreenRequest:processReceive, mode=" + cursorModes[mode]);
        switch (mode) {
            case 4: {
                BInfinityDeviceId networkId = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
                String name = this.network.getScreen().parseNetworkControllerNameFromLine1();
                if (name != null) {
                    networkId.setControllerName(name);
                }
                BInfinitySuccessResponse rsp = new BInfinitySuccessResponse();
                return rsp;
            }
        }
        return new BInfinityAckWithData(this.network.getScreen().getRecovery(mode));
    }

    public byte[] toByteArray() {
        this.network.getLogger().fine("BInfinityInitializeScreenRequest:toByteArray()");
        return "\r\u001a".getBytes();
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
    }

    public void processLateResponse(BIDdfResponse devRsp) {
    }

    public void processResponse(BIDdfResponse devRsp) {
        this.network.setConnected(true);
    }

    public void processTimeout() {
        this.network.setConnected(false);
        this.network.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityLogonSequenceRequest(this.network));
    }
}

