/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.net;

import javax.baja.nre.util.TextUtil;

public class HttpUtil {
    public static String encodeUrl(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        char[] c = s.toCharArray();
        block8: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case ' ': {
                    buf.append("%20");
                    continue block8;
                }
                case '%': {
                    buf.append("%25");
                    continue block8;
                }
                case '&': {
                    buf.append("%26");
                    continue block8;
                }
                case '=': {
                    buf.append("%3D");
                    continue block8;
                }
                case '+': {
                    buf.append("%2B");
                    continue block8;
                }
                case '|': {
                    buf.append("%7C");
                    continue block8;
                }
                default: {
                    buf.append(c[i]);
                }
            }
        }
        return buf.toString();
    }

    public static String decodeUrl(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 10);
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '+') {
                buf.append(' ');
                continue;
            }
            if (c[i] == '%') {
                int val = 0;
                int n = ++i;
                val += HttpUtil.fromHex(c[n]) * 16;
                buf.append((char)(val += HttpUtil.fromHex(c[++i])));
                continue;
            }
            buf.append(c[i]);
        }
        return buf.toString();
    }

    private static int fromHex(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + ch);
    }

    public static String parseHost(String authority) {
        try {
            String auth = authority;
            int lastColon = auth.lastIndexOf(58);
            int firstColon = auth.indexOf(58);
            if (firstColon < 0) {
                return auth;
            }
            if (firstColon != lastColon) {
                int openBracket = auth.indexOf(91);
                int closeBracket = auth.lastIndexOf(93);
                if (openBracket < 0 || closeBracket < 0) {
                    if (openBracket < 0) {
                        auth = TextUtil.replace((String)auth, (String)"%5B", (String)"[");
                        auth = TextUtil.replace((String)auth, (String)"%5b", (String)"[");
                    }
                    if (closeBracket < 0) {
                        auth = TextUtil.replace((String)auth, (String)"%5D", (String)"]");
                        auth = TextUtil.replace((String)auth, (String)"%5d", (String)"]");
                    }
                    openBracket = auth.indexOf(91);
                    closeBracket = auth.lastIndexOf(93);
                    if (openBracket < 0 || closeBracket < 0) {
                        throw new IllegalArgumentException("Can't determine host from port for " + authority + ", IPv6 Numeric Hosts need to be wrapped by '[' ']' ");
                    }
                }
                return auth.substring(0, closeBracket + 1);
            }
            return auth.substring(0, firstColon);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid authority: " + authority);
        }
    }

    public static int parsePort(String authority, int defaultPort) {
        try {
            String auth = authority;
            int lastColon = auth.lastIndexOf(58);
            int firstColon = auth.indexOf(58);
            if (firstColon < 0) {
                return defaultPort;
            }
            if (firstColon != lastColon) {
                int openBracket = auth.indexOf(91);
                int closeBracket = auth.lastIndexOf(93);
                if (openBracket < 0 || closeBracket < 0) {
                    if (openBracket < 0) {
                        auth = TextUtil.replace((String)auth, (String)"%5B", (String)"[");
                        auth = TextUtil.replace((String)auth, (String)"%5b", (String)"[");
                    }
                    if (closeBracket < 0) {
                        auth = TextUtil.replace((String)auth, (String)"%5D", (String)"]");
                        auth = TextUtil.replace((String)auth, (String)"%5d", (String)"]");
                    }
                    openBracket = auth.indexOf(91);
                    closeBracket = auth.lastIndexOf(93);
                    lastColon = auth.lastIndexOf(58);
                    firstColon = auth.indexOf(58);
                    if (openBracket < 0 || closeBracket < 0) {
                        throw new IllegalArgumentException("Can't determine host from port for " + authority + ", IPv6 Numeric Hosts need to be wrapped by '[' ']' ");
                    }
                }
                if (lastColon > closeBracket) {
                    return Integer.parseInt(auth.substring(lastColon + 1));
                }
                if (closeBracket < auth.length() - 1) {
                    throw new IllegalArgumentException("Can't determine host from port for " + auth + ", IPv6 Numeric Hosts need ':' after ']' to specify port");
                }
                return defaultPort;
            }
            return Integer.parseInt(auth.substring(firstColon + 1));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid authority: " + authority);
        }
    }
}

