/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.retention;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.retention.BIDomainRetentionPolicy;
import javax.baja.retention.BILastModifiedRetainable;
import javax.baja.retention.BIRetainable;
import javax.baja.retention.BISimpleRetentionPolicy;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BTimeSinceLastModified
extends BRetentionPolicy
implements BISimpleRetentionPolicy,
BIDomainRetentionPolicy {
    public static final BTimeSinceLastModified DEFAULT = new BTimeSinceLastModified();
    public static final Type TYPE = Sys.loadType(BTimeSinceLastModified.class);
    private BRelTime retentionPeriod = BRelTime.make((long)604800000L);

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTimeSinceLastModified() {
    }

    public BTimeSinceLastModified(BRelTime retPd) {
        this.setRetentionPeriod(retPd);
    }

    public BRelTime getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public void setRetentionPeriod(BRelTime value) {
        this.retentionPeriod = value;
    }

    @Override
    public void executePolicy(BIRetainable retainable) {
        BILastModifiedRetainable checkMe = (BILastModifiedRetainable)retainable;
        BAbsTime checkTime = checkMe.getLastModified().add(this.getRetentionPeriod());
        if (checkTime.isBefore(BAbsTime.now())) {
            retainable.dispose();
        }
    }

    @Override
    public Type[] getApplicableRetainableTypes() {
        return new Type[]{BILastModifiedRetainable.TYPE};
    }

    public boolean equals(Object obj) {
        return obj instanceof BTimeSinceLastModified && ((BTimeSinceLastModified)obj).getRetentionPeriod().equals((Object)this.getRetentionPeriod());
    }

    public int hashCode() {
        return this.retentionPeriod.hashCode();
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    public String encodeToString() throws IOException {
        return this.getRetentionPeriod().encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        return new BTimeSinceLastModified((BRelTime)BRelTime.DEFAULT.decodeFromString(s));
    }
}

