/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import java.util.concurrent.CancellationException;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.job.JobLogItem;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Lexicon;

public class BatchJobTask
implements Runnable {
    BForEachDeviceStage stage;
    BBatchJobService service;
    BDevice device;
    DeviceNetworkJobOp op;
    BDeviceJobStep[] steps;
    int delayStartSeconds = 0;
    static int MAX_DELAY = 30;

    public BatchJobTask(BForEachDeviceStage stage, BBatchJobService service, BDevice device, DeviceNetworkJobOp op, BDeviceJobStep[] steps, int delay) {
        this.stage = stage;
        this.service = service;
        this.device = device;
        this.op = op;
        this.steps = steps;
        this.delayStartSeconds = delay > MAX_DELAY ? MAX_DELAY : delay;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doRun() {
        try {
            Thread.sleep(this.delayStartSeconds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean anyFailed = false;
        boolean anyCanceled = false;
        BJobState deviceState = BJobState.running;
        for (BDeviceJobStep step : this.steps) {
            BDeviceStepDetails stepDetails;
            if (this.stage.canPassDefaultCheck(this.device, step)) {
                stepDetails = step.run(this.service, this.device, this.op);
            } else {
                stepDetails = new BDeviceStepDetails(this.device, step);
                step.add(SlotPath.escape((String)this.device.getName()), (BValue)stepDetails, 4);
                JobLogItem[] logItems = this.stage.getJob().log().getItems();
                if (logItems != null) {
                    for (JobLogItem item : logItems) {
                        stepDetails.add(item);
                    }
                }
                stepDetails.failed("batchJob", "ForEachDeviceStage.fail.defaultCheck");
                stepDetails.complete(BJobState.failed);
            }
            deviceState = stepDetails.getState();
            if (deviceState == BJobState.failed) {
                this.stage.stepComplete(this.service, stepDetails, this.op);
                this.op.setDeviceFailed(this.device);
                anyFailed = true;
                break;
            }
            if (deviceState == BJobState.canceled || deviceState == BJobState.canceling) {
                if (deviceState == BJobState.canceling) {
                    deviceState = BJobState.canceled;
                    stepDetails.setState(deviceState);
                }
                this.op.setDeviceFailed(this.device);
                this.stage.stepComplete(this.service, stepDetails, this.op);
                anyCanceled = true;
                break;
            }
            this.stage.stepComplete(this.service, stepDetails, this.op);
        }
        this.stage.setDeviceState(this.device, deviceState);
        if (anyCanceled) {
            throw new CancellationException(Lexicon.make((String)"batchJob").getText("ForEachDeviceStage.jobTaskCanceled"));
        }
        if (anyFailed) {
            throw new BajaRuntimeException(Lexicon.make((String)"batchJob").getText("ForEachDeviceStage.jobTaskFailed"));
        }
    }
}

