/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import javax.baja.batchJob.IJobDispatcher;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
public class BThreadPoolJobQueue
extends BThreadPoolWorker
implements Worker.ITodo,
IJobDispatcher {
    @Generated
    public static final Type TYPE = Sys.loadType(BThreadPoolJobQueue.class);
    private Queue queue = new Queue();
    private Worker worker = new ThreadPoolWorker((Worker.ITodo)this);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BThreadPoolJobQueue() {
    }

    public BThreadPoolJobQueue(int pMaxThreads) {
        super(pMaxThreads);
    }

    @Override
    public void dispatch(BJob job, Context cx) {
        this.queue.enqueue((Object)new JobTask(job, cx));
    }

    @Override
    public void cancel(BJob job, Context cx) {
    }

    public Runnable todo(int timeout) throws InterruptedException {
        return this.queue.todo(timeout);
    }

    public Worker getWorker() {
        return this.worker;
    }

    private static class JobTask
    implements Runnable {
        private BJob job;
        private Context cx;

        public JobTask(BJob job, Context cx) {
            this.job = job;
            this.cx = cx;
        }

        @Override
        public void run() {
            if (this.job.getJobState() == BJobState.canceling) {
                this.job.complete(BJobState.canceled);
                return;
            }
            if (this.job.getJobState() != BJobState.canceled) {
                try {
                    this.job.setJobState(BJobState.running);
                    this.job.doRun(this.cx);
                    if (this.job.getJobState().isRunning()) {
                        this.job.success();
                    }
                }
                catch (Throwable e) {
                    this.job.failed(e);
                }
            }
        }
    }
}

