/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.driver.history;

import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.history.BJobStepHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.driver.BINetworkStepSummary;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"batchJob:NetworkJobStep"})})
@NiagaraProperties(value={@NiagaraProperty(name="networkType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="networkOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="devicesToProcess", type="BValueList", defaultValue="BValueList.DEFAULT", flags=1)})
public class BNetworkStepHistoryRecord
extends BJobStepHistoryRecord
implements BIAgent,
BINetworkStepSummary {
    @Generated
    public static final Property networkType = BNetworkStepHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property networkOrd = BNetworkStepHistoryRecord.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property devicesToProcess = BNetworkStepHistoryRecord.newProperty((int)1, (BValue)BValueList.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNetworkStepHistoryRecord.class);

    @Override
    @Generated
    public BTypeSpec getNetworkType() {
        return (BTypeSpec)this.get(networkType);
    }

    @Generated
    public void setNetworkType(BTypeSpec v) {
        this.set(networkType, (BValue)v, null);
    }

    @Override
    @Generated
    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    @Generated
    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    @Override
    @Generated
    public BValueList getDevicesToProcess() {
        return (BValueList)this.get(devicesToProcess);
    }

    @Generated
    public void setDevicesToProcess(BValueList v) {
        this.set(devicesToProcess, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNetworkStepHistoryRecord() {
    }

    public BNetworkStepHistoryRecord(BNetworkStepDetails stepDetails, BAbsTime jobStartTime) {
        super(stepDetails, jobStartTime);
        this.update(stepDetails);
    }

    @Override
    public BJobStepDetails getStepDetails(BObject base) throws Exception {
        if (this.stepDetails == null) {
            try {
                BBatchJobStepLogFile file = BBatchJobStepLogFile.find(this.getStepType(), this.getLocalStartTime(), base);
                this.stepDetails = file.getDetails();
                this.stepDetails.setStartTimeLocalZone(this.localTz);
                this.stepDetails.setDisplayTimeZone(this.getTimestamp().getTimeZone());
            }
            catch (UnresolvedException unresolvedException) {
                // empty catch block
            }
        }
        return this.stepDetails;
    }

    @Override
    public void update(BJobStepDetails stepDetails) {
        super.update(stepDetails);
        this.setNetworkType(((BNetworkStepDetails)stepDetails).getNetworkType());
        this.setNetworkOrd(((BNetworkStepDetails)stepDetails).getNetworkOrd());
        this.setDevicesToProcess(((BNetworkStepDetails)stepDetails).getDevicesToProcess());
    }

    @Override
    protected void doRead(DataInput in) throws IOException {
        super.doRead(in);
        this.setNetworkType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(in.readUTF()));
        this.setNetworkOrd((BOrd)BOrd.DEFAULT.decodeFromString(in.readUTF()));
        this.setDevicesToProcess((BValueList)BValueList.DEFAULT.decodeFromString(in.readUTF()));
    }

    @Override
    protected void doWrite(DataOutput out) throws IOException {
        super.doWrite(out);
        out.writeUTF(this.getNetworkType().encodeToString());
        out.writeUTF(this.getNetworkOrd().encodeToString());
        out.writeUTF(this.getDevicesToProcess().encodeToString());
    }
}

