/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.util;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.DiscreteAlarmType;
import com.prosysopc.ua.types.opcua.LimitAlarmType;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.tridium.opcUaCore.enums.BUaDataType;
import com.tridium.opcUaServer.BOpcUaNamespace;
import com.tridium.opcUaServer.point.BOpcUaServerProxyExt;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.BStringPoint;
import javax.baja.data.BIDataValue;
import javax.baja.history.BTrendRecord;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.units.BUnit;
import javax.baja.util.BEnumSet;
import javax.baja.util.Lexicon;

public final class OpcUaServerUtil {
    private static final Lexicon lex = Lexicon.make((String)"opcUaServer");
    private static final Logger logger = Logger.getLogger("opcUaServer.util");
    private static final LinkedHashMap<Integer, String> numericDataTypeSupportMap = new LinkedHashMap();
    private static final LinkedHashMap<Integer, String> booleanDataTypeSupportMap = new LinkedHashMap();
    private static final LinkedHashMap<Integer, String> enumDataTypeSupportMap = new LinkedHashMap();
    private static final LinkedHashMap<Integer, String> stringDataTypeSupportMap = new LinkedHashMap();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern LOCALE_SECTION_PATTERN = Pattern.compile("^\\(\\s*(([a-z]{2})(-([A-Z]{2,3}))?)?\\s*\\)(.*?)$");
    private static final Pattern LOCALE_KEY_EXTRACTION_PATTERN = Pattern.compile("\\((.*?)\\)");
    private static final BInteger DEFAULT_PRECISION = BInteger.make((int)2);

    private OpcUaServerUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Variant convertStatusValueForWrite(BStatusValue wrStatusValue, BUaDataType dataType) {
        if (wrStatusValue instanceof BStatusNumeric) {
            double dValue = ((BStatusNumeric)wrStatusValue).getValue();
            if (BUaDataType.Byte.equals((Object)dataType)) {
                return new Variant((Object)((byte)dValue));
            }
            if (BUaDataType.UnsignedByte.equals((Object)dataType)) {
                return new Variant((Object)UnsignedByte.valueOf((int)((int)dValue)));
            }
            if (BUaDataType.Short.equals((Object)dataType)) {
                return new Variant((Object)((short)dValue));
            }
            if (BUaDataType.UnsignedShort.equals((Object)dataType)) {
                return new Variant((Object)UnsignedShort.valueOf((int)((int)dValue)));
            }
            if (BUaDataType.Integer.equals((Object)dataType)) {
                return new Variant((Object)((int)dValue));
            }
            if (BUaDataType.UnsignedInteger.equals((Object)dataType)) {
                return new Variant((Object)UnsignedInteger.valueOf((long)((long)dValue)));
            }
            if (BUaDataType.Long.equals((Object)dataType)) {
                return new Variant((Object)((long)dValue));
            }
            if (BUaDataType.UnsignedLong.equals((Object)dataType)) {
                return new Variant((Object)UnsignedLong.valueOf((long)((long)dValue)));
            }
            if (BUaDataType.Float.equals((Object)dataType)) {
                return new Variant((Object)Float.valueOf((float)dValue));
            }
            if (!BUaDataType.Double.equals((Object)dataType)) throw new IllegalArgumentException("Invalid Numeric type: " + dataType);
            return new Variant((Object)dValue);
        }
        if (wrStatusValue instanceof BStatusBoolean) {
            return new Variant((Object)((BStatusBoolean)wrStatusValue).getValue());
        }
        if (wrStatusValue instanceof BStatusEnum) {
            return new Variant((Object)((BStatusEnum)wrStatusValue).getValue().getOrdinal());
        }
        String sValue = ((BStatusString)wrStatusValue).getValue();
        if (dataType.equals((Object)BUaDataType.String)) {
            return new Variant((Object)sValue);
        }
        if (dataType.equals((Object)BUaDataType.LocalizedText)) {
            return new Variant((Object)OpcUaServerUtil.stringToLocalizedText(sValue));
        }
        if (!dataType.equals((Object)BUaDataType.ByteString)) throw new IllegalArgumentException("Invalid String type: " + dataType);
        return new Variant((Object)ByteString.fromHex((String)sValue));
    }

    public static BFacets getMinMaxFacets(BUaDataType uaDataType) {
        BFacets facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)2, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
        if (BUaDataType.Byte.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-128.0, (double)127.0);
        } else if (BUaDataType.UnsignedByte.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)0.0, (double)255.0);
        } else if (BUaDataType.Short.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-32768.0, (double)32767.0);
        } else if (BUaDataType.UnsignedShort.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedShort.L_MIN_VALUE, (double)UnsignedShort.L_MAX_VALUE);
        } else if (BUaDataType.Integer.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-2.147483648E9, (double)2.147483647E9);
        } else if (BUaDataType.UnsignedInteger.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedInteger.MIN_VALUE.doubleValue(), (double)UnsignedInteger.MAX_VALUE.doubleValue());
        } else if (BUaDataType.Long.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)-9.223372036854776E18, (double)9.223372036854776E18);
        } else if (BUaDataType.UnsignedLong.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)0, (double)UnsignedLong.MIN_VALUE.doubleValue(), (double)UnsignedLong.MAX_VALUE.doubleValue());
        } else if (BUaDataType.Float.equals((Object)uaDataType)) {
            facets = BFacets.makeNumeric((BUnit)BUnit.DEFAULT, (int)2, (double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY);
        }
        return facets;
    }

    public static BDynamicEnum getSupportedUaDataTypes(BControlPoint point) {
        OpcUaServerUtil.initializeDataTypeMaps();
        BDynamicEnum supportedTypesEnum = BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make(null, (int[])new int[]{0}, (String[])new String[]{BUaDataType.unknown.getTag()}));
        try {
            if (point instanceof BNumericPoint) {
                BEnumRange supportedTypesRange = BEnumRange.make(null, (int[])numericDataTypeSupportMap.keySet().stream().mapToInt(Integer::intValue).toArray(), (String[])numericDataTypeSupportMap.values().toArray(EMPTY_STRING_ARRAY));
                supportedTypesEnum = BDynamicEnum.make((int)11, (BEnumRange)supportedTypesRange);
            } else if (point instanceof BBooleanPoint) {
                BEnumRange supportedTypesRange = BEnumRange.make(null, (int[])booleanDataTypeSupportMap.keySet().stream().mapToInt(Integer::intValue).toArray(), (String[])booleanDataTypeSupportMap.values().toArray(EMPTY_STRING_ARRAY));
                supportedTypesEnum = BDynamicEnum.make((int)1, (BEnumRange)supportedTypesRange);
            } else if (point instanceof BEnumPoint) {
                BEnumRange supportedTypesRange = BEnumRange.make(null, (int[])enumDataTypeSupportMap.keySet().stream().mapToInt(Integer::intValue).toArray(), (String[])enumDataTypeSupportMap.values().toArray(EMPTY_STRING_ARRAY));
                supportedTypesEnum = BDynamicEnum.make((int)0, (BEnumRange)supportedTypesRange);
            } else if (point instanceof BStringPoint) {
                BEnumRange supportedTypesRange = BEnumRange.make(null, (int[])stringDataTypeSupportMap.keySet().stream().mapToInt(Integer::intValue).toArray(), (String[])stringDataTypeSupportMap.values().toArray(EMPTY_STRING_ARRAY));
                supportedTypesEnum = BDynamicEnum.make((int)12, (BEnumRange)supportedTypesRange);
            }
            return supportedTypesEnum;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while get supported UA Data Types.", e);
            return supportedTypesEnum;
        }
    }

    public static BControlPoint findOpcUaPoint(String nodeId, BOpcUaNamespace nodeSpace) {
        for (BOpcUaServerProxyExt proxyExt : (BOpcUaServerProxyExt[])nodeSpace.getPoints().getChildren(BOpcUaServerProxyExt.class)) {
            if (!proxyExt.getUaNodeId().equals(nodeId)) continue;
            return proxyExt.getParentPoint();
        }
        return null;
    }

    public static BHistoryExt getPointHistoryExt(BControlPoint point) {
        for (BPointExtension extension : point.getExtensions()) {
            if (!(extension instanceof BHistoryExt)) continue;
            return (BHistoryExt)extension;
        }
        return null;
    }

    public static BAlarmSourceExt getPointAlarmExt(BControlPoint point) {
        for (BPointExtension extension : point.getExtensions()) {
            if (!(extension instanceof BAlarmSourceExt)) continue;
            return (BAlarmSourceExt)extension;
        }
        return null;
    }

    public static DataValue trendRecordToDataValue(BTrendRecord tr) {
        DateTime dt = OpcUaServerUtil.absTimeToDateTime(tr.getTimestamp());
        Property prop = tr.getValueProperty();
        BValue bValue = tr.get(prop);
        Object value = null;
        if (bValue instanceof BDouble) {
            value = ((BDouble)bValue).getDouble();
        } else if (bValue instanceof BBoolean) {
            value = ((BBoolean)bValue).getBoolean();
        } else if (bValue instanceof BEnum) {
            value = ((BEnum)bValue).getOrdinal();
        } else if (bValue instanceof BString) {
            value = ((BString)bValue).getString();
        }
        if (value != null) {
            Variant variant = new Variant(value);
            return new DataValue(variant, StatusCode.GOOD, dt, dt);
        }
        return null;
    }

    public static DateTime absTimeToDateTime(BAbsTime dt) {
        return DateTime.fromMillis((long)dt.getMillis());
    }

    public static BAbsTime dateTimeToAbsTime(DateTime dt) {
        return BAbsTime.make((long)dt.getTimeInMillis());
    }

    public static UaNode getNode(NodeManagerUaNode nodeManager, NodeId nodeId) {
        try {
            return AccessController.doPrivileged(() -> nodeManager.getNode(nodeId));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while getting node " + nodeId, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while getting node " + nodeId + ": " + e);
            }
            return null;
        }
    }

    public static AlarmConditionTypeNode createAlarmTypeInstance(NodeManagerUaNode uaNodeManager, Class<?> alarmTypeClass, String name, NodeId myAlarmId) {
        try {
            return AccessController.doPrivileged(() -> (AlarmConditionTypeNode)uaNodeManager.createInstance(alarmTypeClass, name, myAlarmId));
        }
        catch (PrivilegedActionException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Exception occurred while creating AlarmConditionTypeNode " + myAlarmId, e);
            } else {
                logger.log(Level.SEVERE, "Exception occurred while creating AlarmConditionTypeNode " + myAlarmId + ": " + e);
            }
            return null;
        }
    }

    public static void triggerEvent(ConditionTypeNode opcUaEvent, BAlarmRecord n4Alarm) {
        BFacets alarmData = n4Alarm.getAlarmData();
        BObject toState = alarmData.get("toState", (BObject)BString.DEFAULT);
        BObject presentValue = alarmData.get("presentValue", (BObject)BString.DEFAULT);
        if (n4Alarm.isNormal()) {
            opcUaEvent.setMessage(new LocalizedText(lex.getText("alarm.returnToNormal", new Object[]{presentValue})));
        } else if (opcUaEvent instanceof LimitAlarmType) {
            opcUaEvent.setMessage(new LocalizedText(lex.getText("alarm.levelExceeded", new Object[]{toState, presentValue})));
        } else if (opcUaEvent instanceof DiscreteAlarmType) {
            opcUaEvent.setMessage(new LocalizedText(lex.getText("alarm.discrete", new Object[]{toState, presentValue})));
        }
        if (opcUaEvent instanceof AcknowledgeableConditionTypeNode) {
            AcknowledgeableConditionTypeNode opcUaEvent1 = (AcknowledgeableConditionTypeNode)opcUaEvent;
            opcUaEvent1.setAcked(n4Alarm.isAcknowledged());
        }
        opcUaEvent.triggerEvent(ByteString.valueOf((byte[])n4Alarm.getUuid().getBytes()));
    }

    public static String getTextBetweenFirstSetOfParentheses(String str) {
        String textBetweenParentheses = "";
        Matcher matcher = LOCALE_KEY_EXTRACTION_PATTERN.matcher(str);
        if (matcher.find()) {
            textBetweenParentheses = matcher.group(1);
        }
        return textBetweenParentheses;
    }

    public static String getTextAfterFirstClosingParentheses(String str) {
        if (str.contains(")")) {
            if (str.indexOf(41) != str.length() - 1) {
                return str.substring(str.indexOf(41) + 1);
            }
            return "";
        }
        return str;
    }

    public static LocalizedText stringToLocalizedText(String str) {
        Locale locale = LocalizedText.NO_LOCALE;
        String text = str.trim();
        String localeKey = OpcUaServerUtil.getTextBetweenFirstSetOfParentheses(text).trim();
        Matcher matcher = LOCALE_SECTION_PATTERN.matcher(text);
        boolean parenthesesPatternMatches = matcher.matches();
        if (parenthesesPatternMatches) {
            locale = LocalizedText.toLocale((String)(localeKey.isEmpty() ? null : localeKey));
        }
        if (locale != LocalizedText.NO_LOCALE || localeKey.isEmpty() && parenthesesPatternMatches) {
            text = OpcUaServerUtil.getTextAfterFirstClosingParentheses(text).trim();
        }
        return new LocalizedText(text, locale);
    }

    public static BFacets makeUaDataTypeEnumRangeLimiterFacets(BControlPoint point) {
        BString uxAllowedTypes = BString.DEFAULT;
        BEnumRange allowedUaDataTypesRange = OpcUaServerUtil.getSupportedUaDataTypes(point).getRange();
        try {
            uxAllowedTypes = BString.make((String)BEnumSet.make((int[])allowedUaDataTypesRange.getOrdinals()).encodeToString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return BFacets.make((String)"range", (BIDataValue)allowedUaDataTypesRange, (String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:LimitedFrozenEnumFE"), (String)"uxValidOptions", (BIDataValue)uxAllowedTypes);
    }

    public static int getBaseThreadCount(int cores) {
        return Math.min(8, cores);
    }

    public static void initializeNumericDataTypeSupportMap() {
        numericDataTypeSupportMap.put(2, BUaDataType.Byte.getTag());
        numericDataTypeSupportMap.put(3, BUaDataType.UnsignedByte.getTag());
        numericDataTypeSupportMap.put(4, BUaDataType.Short.getTag());
        numericDataTypeSupportMap.put(5, BUaDataType.UnsignedShort.getTag());
        numericDataTypeSupportMap.put(6, BUaDataType.Integer.getTag());
        numericDataTypeSupportMap.put(7, BUaDataType.UnsignedInteger.getTag());
        numericDataTypeSupportMap.put(8, BUaDataType.Long.getTag());
        numericDataTypeSupportMap.put(9, BUaDataType.UnsignedLong.getTag());
        numericDataTypeSupportMap.put(10, BUaDataType.Float.getTag());
        numericDataTypeSupportMap.put(11, BUaDataType.Double.getTag());
    }

    public static void initializeBooleanDataTypeSupportMap() {
        booleanDataTypeSupportMap.put(1, BUaDataType.Boolean.getTag());
    }

    public static void initializeEnumDataTypeSupportMap() {
        enumDataTypeSupportMap.put(0, BUaDataType.unknown.getTag());
    }

    public static void initializeStringDataTypeSupportMap() {
        stringDataTypeSupportMap.put(12, BUaDataType.String.getTag());
        stringDataTypeSupportMap.put(21, BUaDataType.LocalizedText.getTag());
        stringDataTypeSupportMap.put(15, BUaDataType.ByteString.getTag());
    }

    public static void initializeDataTypeMaps() {
        OpcUaServerUtil.initializeNumericDataTypeSupportMap();
        OpcUaServerUtil.initializeStringDataTypeSupportMap();
        OpcUaServerUtil.initializeBooleanDataTypeSupportMap();
        OpcUaServerUtil.initializeEnumDataTypeSupportMap();
    }
}

