/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.point;

import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.point.BNProxyExt;
import com.tridium.opcUaCore.enums.BUaDataType;
import com.tridium.opcUaServer.BOpcUaNamespace;
import com.tridium.opcUaServer.BOpcUaServer;
import com.tridium.opcUaServer.export.BIOpcExport;
import com.tridium.opcUaServer.node.OpcUaIoManagerListener;
import com.tridium.opcUaServer.point.BOpcUaServerPointDeviceExt;
import com.tridium.opcUaServer.util.OpcUaServerUtil;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="uaNodeId", type="String", defaultValue="", flags=1), @NiagaraProperty(name="uaDataType", type="BUaDataType", defaultValue="BUaDataType.Double"), @NiagaraProperty(name="localPoint", type="BOrd", defaultValue="BOrd.NULL", flags=4), @NiagaraProperty(name="localPointSlot", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0, BEnumRange.make(new String[]{\"na\"}))", flags=4), @NiagaraProperty(name="infoLogging", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="enableInfoLog", parameterType="BBoolean", defaultValue="BBoolean.make(false)")
public class BOpcUaServerProxyExt
extends BNProxyExt {
    @Generated
    public static final Property uaNodeId = BOpcUaServerProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property uaDataType = BOpcUaServerProxyExt.newProperty((int)0, (BValue)BUaDataType.Double, null);
    @Generated
    public static final Property localPoint = BOpcUaServerProxyExt.newProperty((int)4, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property localPointSlot = BOpcUaServerProxyExt.newProperty((int)4, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((String[])new String[]{"na"})), null);
    @Generated
    public static final Property infoLogging = BOpcUaServerProxyExt.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action enableInfoLog = BOpcUaServerProxyExt.newAction((int)0, (BValue)BBoolean.make((boolean)false), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOpcUaServerProxyExt.class);
    public static final Logger rdlogger = Logger.getLogger("opcUaServer.point.rd");
    public static final Logger wrlogger = Logger.getLogger("opcUaServer.point.wr");
    boolean configFault = false;
    boolean hasHistoryExt = false;
    boolean hasAlarmExt = false;
    private static final String IMPORT_LINK_NAME = "impL";

    @Generated
    public String getUaNodeId() {
        return this.getString(uaNodeId);
    }

    @Generated
    public void setUaNodeId(String v) {
        this.setString(uaNodeId, v, null);
    }

    @Generated
    public BUaDataType getUaDataType() {
        return (BUaDataType)this.get(uaDataType);
    }

    @Generated
    public void setUaDataType(BUaDataType v) {
        this.set(uaDataType, (BValue)v, null);
    }

    @Generated
    public BOrd getLocalPoint() {
        return (BOrd)this.get(localPoint);
    }

    @Generated
    public void setLocalPoint(BOrd v) {
        this.set(localPoint, (BValue)v, null);
    }

    @Generated
    public BDynamicEnum getLocalPointSlot() {
        return (BDynamicEnum)this.get(localPointSlot);
    }

    @Generated
    public void setLocalPointSlot(BDynamicEnum v) {
        this.set(localPointSlot, (BValue)v, null);
    }

    @Generated
    public boolean getInfoLogging() {
        return this.getBoolean(infoLogging);
    }

    @Generated
    public void setInfoLogging(boolean v) {
        this.setBoolean(infoLogging, v, null);
    }

    @Generated
    public void enableInfoLog(BBoolean parameter) {
        this.invoke(enableInfoLog, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        AccessController.doPrivileged(() -> {
            this.updateNodeId(this.addProxyPointToNodeSpace());
            return null;
        });
        try {
            if (this.hasLocalLink()) {
                if (this.isExport()) {
                    this.addExportLink();
                } else {
                    this.addImportLink();
                }
            }
        }
        catch (Exception e) {
            this.logMessage(rdlogger, "Error starting a Proxy Ext: " + this.getParentPoint().getDisplayName(null));
        }
        this.updatePointFacets();
        this.setUaDataTypePropertyFacets();
        if (this.getParentPoint().isWritablePoint()) {
            this.writablePointActionInvoked();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p.equals(uaDataType) && this.getBOpcUaServerDevice() != null && this.getBOpcUaServerDevice().isRunning()) {
            if (rdlogger.isLoggable(Level.FINE)) {
                rdlogger.log(Level.FINE, "UA Data Type changed to " + this.getUaDataType().getDisplayTag(cx) + ". Re-initializing proxy ext for point: " + this.getParentPoint().getDisplayName(cx));
            }
            if (!this.getUaNodeId().isEmpty()) {
                this.removeProxyPointFromNodeSpace();
            }
            this.updateNodeId(this.addProxyPointToNodeSpace());
            this.updatePointFacets();
        }
    }

    public void stopped() throws Exception {
        if (!this.getUaNodeId().isEmpty()) {
            this.removeProxyPointFromNodeSpace();
        }
        super.stopped();
    }

    private void updatePointFacets() {
        if (this.getParentPoint() instanceof BNumericPoint) {
            this.getParentPoint().setFacets(BFacets.make((BFacets)this.getPointFacets(), (BFacets)OpcUaServerUtil.getMinMaxFacets(this.getUaDataType())));
        }
    }

    private void setUaDataTypePropertyFacets() {
        this.asComplex().setFacets((Slot)uaDataType, BFacets.make((BFacets)uaDataType.getFacets(), (BFacets)OpcUaServerUtil.makeUaDataTypeEnumRangeLimiterFacets(this.getParentPoint())));
    }

    private boolean addExportLink() {
        String slotName = this.getLocalPointSlot().getTag();
        boolean isExport = "out".equals(slotName);
        if (isExport) {
            BControlPoint targetPoint = this.getParentPoint();
            BOrd ord = this.getLocalPoint();
            if (!ord.equals((Object)BOrd.NULL)) {
                BControlPoint sourcePoint = (BControlPoint)this.getLocalPoint().get((BObject)this);
                BFacets sourceFacets = sourcePoint.getFacets();
                targetPoint.setFacets(sourceFacets);
                BLink newLink = new BLink(sourcePoint.getHandleOrd(), slotName, "in", true);
                Property rdLinkProp = null;
                try {
                    rdLinkProp = targetPoint.add("rdLink", (BValue)newLink, 2, Context.decoding);
                }
                catch (Exception e) {
                    this.logMessage(wrlogger, "Exception while adding export link: " + e);
                }
                if (rdLinkProp != null && ((BLink)this.get(rdLinkProp)).isActive()) {
                    BStatusValue sourceValue = sourcePoint.getOutStatusValue();
                    targetPoint.set("in", sourceValue.newCopy(), null);
                }
                return true;
            }
        }
        return false;
    }

    private boolean addImportLink() {
        String slotName = this.getLocalPointSlot().getTag();
        boolean isExport = "out".equals(slotName);
        if (!isExport) {
            BControlPoint sourcePoint = this.getParentPoint();
            BOrd ord = this.getLocalPoint();
            if (!ord.equals((Object)BOrd.NULL)) {
                BControlPoint targetPoint = (BControlPoint)ord.get((BObject)this);
                BLink newLink = new BLink(sourcePoint.getHandleOrd(), "out", slotName, true);
                Property wrLinkProp = null;
                try {
                    wrLinkProp = targetPoint.add(IMPORT_LINK_NAME, (BValue)newLink, 2);
                }
                catch (Exception e) {
                    this.logMessage(wrlogger, "Exception while adding import link: " + e);
                }
                if (wrLinkProp != null && ((BLink)this.get(wrLinkProp)).isActive()) {
                    BStatusValue sourceValue = (BStatusValue)sourcePoint.getOutStatusValue().newCopy();
                    sourceValue.setStatus(BStatus.make((BStatus)sourceValue.getStatus(), (int)1));
                    targetPoint.set(slotName, (BValue)sourceValue, null);
                }
                return true;
            }
        }
        return false;
    }

    public BIPointFolder getParentPointFolder() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BIPointFolder); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return (BIPointFolder)parent;
    }

    public final BOpcUaServer getOpcUaServer() {
        return (BOpcUaServer)this.getNetwork();
    }

    public final BOpcUaNamespace getBOpcUaServerDevice() {
        return (BOpcUaNamespace)DrUtil.getParent((BComplex)this, (Type)BOpcUaNamespace.TYPE);
    }

    public final BOpcUaServerPointDeviceExt getOpcUaServerPointDeviceExt() {
        return (BOpcUaServerPointDeviceExt)this.getDeviceExt();
    }

    public boolean isExport() {
        return "out".equals(this.getLocalPointSlot().getTag());
    }

    public boolean hasLocalLink() {
        return !this.getLocalPoint().equals((Object)BOrd.NULL);
    }

    public void pointFacetsChanged() {
        BOpcUaNamespace uaNodeSpace = this.getBOpcUaServerDevice();
        uaNodeSpace.pointFacetsChanged(this);
        super.pointFacetsChanged();
    }

    public boolean requiresPointSubscription() {
        if (!Sys.atSteadyState()) {
            return super.requiresPointSubscription();
        }
        BControlPoint parentPoint = this.getParentPoint();
        boolean needToAddHistory = false;
        boolean needToAddAlarm = false;
        boolean historyRemoved = true;
        boolean alarmRemoved = true;
        for (BPointExtension extension : parentPoint.getExtensions()) {
            if (extension instanceof BHistoryExt) {
                historyRemoved = false;
                if (this.hasHistoryExt) continue;
                needToAddHistory = true;
                continue;
            }
            if (!(extension instanceof BAlarmSourceExt)) continue;
            alarmRemoved = false;
            if (this.hasAlarmExt) continue;
            needToAddAlarm = true;
        }
        if (needToAddHistory && !this.hasHistoryExt) {
            this.hasHistoryExt = this.getBOpcUaServerDevice().addUaNodeHistory(this.getUaNodeId(), parentPoint);
        } else if (!needToAddHistory && this.hasHistoryExt && historyRemoved) {
            this.hasHistoryExt = this.getBOpcUaServerDevice().removeUaNodeHistory(this.getUaNodeId(), parentPoint);
        }
        if (needToAddAlarm && !this.hasAlarmExt) {
            this.hasAlarmExt = this.getBOpcUaServerDevice().addUaNodeCondition(this.getUaNodeId(), parentPoint);
        } else if (!needToAddAlarm && this.hasAlarmExt && alarmRemoved) {
            this.hasAlarmExt = this.getBOpcUaServerDevice().removeUaNodeCondition(this.getUaNodeId(), parentPoint);
        }
        return super.requiresPointSubscription();
    }

    public void readSubscribed(Context cx) {
        BOpcUaServer opcUaServer = this.getOpcUaServer();
        if (opcUaServer != null) {
            OpcUaIoManagerListener ioManagerListener = this.getBOpcUaServerDevice().getIoManagerListener();
            if (ioManagerListener != null) {
                ioManagerListener.getOpcUaNamespace().addPointToControlPointsMap(this);
            }
            if (!this.getMode().equals((Object)BReadWriteMode.writeonly) && ioManagerListener != null) {
                ioManagerListener.addMonitorPoint(this);
            }
        }
    }

    public void readUnsubscribed(Context cx) {
        BOpcUaServer opcUaServer = this.getOpcUaServer();
        if (opcUaServer != null) {
            OpcUaIoManagerListener ioManagerListener = this.getBOpcUaServerDevice().getIoManagerListener();
            if (ioManagerListener != null) {
                ioManagerListener.getOpcUaNamespace().removePointFromControlPointsMap(this);
            }
            if (!this.getMode().equals((Object)BReadWriteMode.writeonly) && ioManagerListener != null) {
                ioManagerListener.removeMonitorPoint(this);
            }
        }
    }

    public boolean write(Context cx) {
        boolean isWritable;
        boolean bl = isWritable = this.getParentPoint().isWritablePoint() || this.getParentPoint() instanceof BIOpcExport;
        if (this.configFault || !isWritable || this.getUaNodeId().isEmpty()) {
            return false;
        }
        BStatusValue wValue = this.getWriteValue();
        this.readOk(wValue);
        try {
            UaNode node = AccessController.doPrivileged(() -> {
                NodeId nodeId = NodeId.parseNodeId((String)this.getUaNodeId());
                NodeManagerTable addressSpace = this.getOpcUaServer().server.getAddressSpace();
                return addressSpace.getNode(nodeId);
            });
            if (node instanceof UaValueNode) {
                UaValueNode valueNode = (UaValueNode)node;
                Variant wrVariant = OpcUaServerUtil.convertStatusValueForWrite(wValue, this.getUaDataType());
                DataValue wrDataValue = new DataValue(wrVariant, StatusCode.GOOD, DateTime.currentTime(), DateTime.currentTime());
                valueNode.setValue(wrDataValue);
            }
        }
        catch (Exception e) {
            this.writeFail(e.getLocalizedMessage());
        }
        return false;
    }

    public void doWrite(BStatusValue out) {
        this.writeOk(out);
    }

    public Type getDeviceExtType() {
        return BOpcUaServerPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        BControlPoint parentPoint = this.getParentPoint();
        if (parentPoint instanceof BIOpcExport) {
            return BReadWriteMode.writeonly;
        }
        if (parentPoint.isWritablePoint()) {
            return BReadWriteMode.readWrite;
        }
        return BReadWriteMode.readonly;
    }

    public boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    public boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    public boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    public boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(enableInfoLog)) {
            return BBoolean.make((!this.getInfoLogging() ? 1 : 0) != 0);
        }
        return super.getActionParameterDefault(action);
    }

    public void doEnableInfoLog(BBoolean enable) {
        this.setInfoLogging(enable.getBoolean());
        rdlogger.info("enableInfoLog:" + this.getParentPoint().getName() + " " + enable.getBoolean());
    }

    public void processValueUpdate(DataValue dataValue, String source) {
        boolean isUnwritten = dataValue.getSourceTimestamp() == null && dataValue.getServerTimestamp() == null;
        BStatus valueStatus = isUnwritten ? BStatus.stale : BStatus.ok;
        BStatusNumeric readValue = null;
        if (this.isNumeric()) {
            double dValue = dataValue.getValue().doubleValue();
            readValue = new BStatusNumeric(dValue, valueStatus);
        } else if (this.isBoolean()) {
            boolean value = dataValue.getValue().booleanValue();
            readValue = new BStatusBoolean(value, valueStatus);
        } else if (this.isEnum()) {
            BEnumRange range = (BEnumRange)this.getPointFacets().get("range");
            int value = dataValue.getValue().intValue();
            readValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)value, (BEnumRange)range), valueStatus);
        } else if (this.isString()) {
            String value = dataValue.getValue().toString();
            readValue = new BStatusString(value, valueStatus);
            if (BUaDataType.LocalizedText.equals((Object)this.getUaDataType()) && dataValue.getValue().getValue() instanceof LocalizedText) {
                LocalizedText localizedText = (LocalizedText)dataValue.getValue().getValue();
                readValue = new BStatusString(localizedText.toString(), valueStatus);
            }
        }
        if (readValue == null) {
            this.readFail("unsupported type");
        } else {
            this.logMessage(rdlogger, source + this.getParentPoint().getName() + " rdValue = " + readValue);
            this.readOk((BStatusValue)readValue);
        }
    }

    public void logMessage(Logger logger, String message) {
        if (this.getInfoLogging()) {
            logger.info(message);
        } else {
            logger.fine(message);
        }
    }

    private String addProxyPointToNodeSpace() {
        return this.getBOpcUaServerDevice().addControlPoint(this);
    }

    private void removeProxyPointFromNodeSpace() {
        this.getBOpcUaServerDevice().deleteControlPoint(this);
    }

    public void updateNodeId(String nodeId) {
        if (!nodeId.startsWith("*")) {
            if (rdlogger.isLoggable(Level.FINE)) {
                rdlogger.log(Level.FINE, "Updating Node ID: " + nodeId);
            }
            this.setUaNodeId(nodeId);
        } else {
            this.readFail(nodeId);
            rdlogger.log(Level.SEVERE, "Failed to update Node ID. " + nodeId.substring(1));
        }
    }
}

