/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.node;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.io.IoManagerListener;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AccessRestrictionType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.tridium.opcUaServer.BOpcUaNamespace;
import com.tridium.opcUaServer.point.BOpcUaServerProxyExt;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;

public class OpcUaIoManagerListener
implements IoManagerListener {
    private HashMap<String, BOpcUaServerProxyExt> importPoints;
    private BOpcUaNamespace opcUaNamespace;
    private static final Logger LOGGER = Logger.getLogger("opcUaServer.ioListener");

    public AccessLevelType onGetUserAccessLevel(ServiceContext serviceContext, NodeId nodeId, UaVariable node) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to get user access level for: " + nodeId);
        }
        AccessLevelType.Builder userAccessBuilder = (AccessLevelType.Builder)AccessLevelType.of().toBuilder();
        if (serviceContext == null || nodeId == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Get user access level denied for: " + nodeId + " as service context or nodeId null");
            }
            return userAccessBuilder.build();
        }
        try {
            this.opcUaNamespace.verifyMismatch(serviceContext);
        }
        catch (StatusException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Get user access level denied for: " + nodeId + " as request type not configured in server");
            }
            return userAccessBuilder.build();
        }
        switch (serviceContext.getSession().getUserIdentity().getType()) {
            case Anonymous: {
                userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.CurrentRead});
                if (!node.getHistorizing().booleanValue()) break;
                userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.HistoryRead});
                break;
            }
            case Certificate: {
                userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.CurrentRead, AccessLevelType.Options.CurrentWrite});
                if (!node.getHistorizing().booleanValue()) break;
                userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.HistoryRead, AccessLevelType.Options.HistoryWrite});
                break;
            }
            case UserName: {
                boolean canRead = false;
                boolean canWrite = false;
                try {
                    BPermissions bPermissions = this.opcUaNamespace.verifyUserAndNodeIdAndGetPermissions(serviceContext.getSession().getUserIdentity(), nodeId);
                    if (this.opcUaNamespace.hasReadPermission(bPermissions)) {
                        canRead = true;
                    }
                    if (this.opcUaNamespace.hasWritePermission(bPermissions)) {
                        canWrite = true;
                    }
                    if (canRead && canWrite) {
                        userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.CurrentRead, AccessLevelType.Options.CurrentWrite});
                        if (!node.getHistorizing().booleanValue()) break;
                        userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.HistoryRead, AccessLevelType.Options.HistoryWrite});
                        break;
                    }
                    if (!canRead) break;
                    userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.CurrentRead});
                    if (!node.getHistorizing().booleanValue()) break;
                    userAccessBuilder.add(new OptionSpecification[]{AccessLevelType.Options.HistoryRead});
                }
                catch (StatusException statusException) {}
                break;
            }
        }
        AccessLevelType accessLevelType = userAccessBuilder.build();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Granting user access: " + accessLevelType + " to usertype: " + serviceContext.getSession().getUserIdentity().getType() + " on node " + nodeId);
        }
        return accessLevelType;
    }

    public Boolean onGetUserExecutable(ServiceContext serviceContext, NodeId nodeId, UaMethod node) {
        return true;
    }

    public AttributeWriteMask onGetUserWriteMask(ServiceContext serviceContext, NodeId nodeId, UaNode node) {
        return AttributeWriteMask.of((AttributeWriteMask.Options[])AttributeWriteMask.Options.values());
    }

    public boolean onReadNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode node, UnsignedInteger attributeId, DataValue dataValue) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to read non value: " + nodeId);
        }
        this.opcUaNamespace.checkReadAccess(serviceContext, nodeId);
        if (Attributes.AccessRestrictions.equals((Object)attributeId)) {
            AccessRestrictionType accessRestrictionType = this.opcUaNamespace.getAccessRestrictionType();
            dataValue.setValue(new Variant((Object)accessRestrictionType));
            dataValue.setStatusCode(StatusCode.GOOD);
            return true;
        }
        if (Attributes.AccessLevel.equals((Object)attributeId) || Attributes.AccessLevelEx.equals((Object)attributeId)) {
            AccessLevelType accessLevel = this.onGetUserAccessLevel(serviceContext, nodeId, (UaVariable)node);
            dataValue.setValue(new Variant((Object)accessLevel));
            dataValue.setStatusCode(StatusCode.GOOD);
            return true;
        }
        return false;
    }

    public boolean onReadValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode node, NumericRange indexRange, TimestampsToReturn timestampsToReturn, DateTime minTimestamp, DataValue dataValue) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to read value: " + nodeId);
        }
        this.beGoodOrThrowBeforeReadOperation(nodeId);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("onReadValue: nodeId=" + nodeId + (node != null ? " node=" + node.getBrowseName() : ""));
        }
        this.opcUaNamespace.checkReadAccess(serviceContext, nodeId);
        return false;
    }

    public boolean onWriteNonValue(ServiceContext serviceContext, NodeId nodeId, UaNode node, UnsignedInteger attributeId, DataValue dataValue) throws StatusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to write non value: " + nodeId);
        }
        this.opcUaNamespace.checkWriteAccess(serviceContext, nodeId);
        return false;
    }

    public boolean onWriteValue(ServiceContext serviceContext, NodeId nodeId, UaValueNode node, NumericRange indexRange, DataValue dataValue) throws StatusException {
        BOpcUaServerProxyExt proxyExt;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Received request to write value: " + nodeId);
        }
        this.beGoodOrThrowBeforeWriteOperation(nodeId);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("onWriteValue: nodeId=" + nodeId + (node != null ? " node=" + node.getBrowseName() : "") + (indexRange != null ? " indexRange=" + indexRange : "") + " value=" + dataValue);
        }
        if (this.importPoints != null && (proxyExt = this.importPoints.get(nodeId.toString())) != null) {
            dataValue.setServerTimestamp(DateTime.currentTime());
            proxyExt.processValueUpdate(dataValue, "ioPush:");
        }
        this.opcUaNamespace.checkWriteAccess(serviceContext, nodeId);
        return false;
    }

    public void addMonitorPoint(BOpcUaServerProxyExt proxyExt) {
        if (this.importPoints == null) {
            this.importPoints = new HashMap();
        }
        this.importPoints.put(proxyExt.getUaNodeId(), proxyExt);
    }

    public void removeMonitorPoint(BOpcUaServerProxyExt proxyExt) {
        if (this.importPoints == null) {
            this.importPoints = new HashMap();
        }
        this.importPoints.remove(proxyExt.getUaNodeId());
    }

    private void beGoodOrThrowBeforeReadOperation(NodeId nodeId) throws StatusException {
        BStatus status = this.opcUaNamespace.getControlPointStatus(nodeId);
        if (status == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Failed to determine control point status. Node Id: " + nodeId);
            }
            throw new StatusException("Unable to get status for node " + nodeId, StatusCodes.Bad_OutOfService);
        }
        if (status.isFault() || status.isDown() || status.isDisabled() || status.isNull()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Control Point status: " + status + ". Node Id: " + nodeId);
            }
            throw new StatusException(status.toString(), StatusCodes.Bad);
        }
    }

    private void beGoodOrThrowBeforeWriteOperation(NodeId nodeId) throws StatusException {
        BStatus status = this.opcUaNamespace.getControlPointStatus(nodeId);
        if (status != null && (status.isDown() || status.isDisabled())) {
            throw new StatusException(status.toString(), StatusCodes.Bad_OutOfService);
        }
    }

    public void setOpcUaNamespace(BOpcUaNamespace opcUaNamespace) {
        this.opcUaNamespace = opcUaNamespace;
    }

    public BOpcUaNamespace getOpcUaNamespace() {
        return this.opcUaNamespace;
    }
}

