/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ux.rpc;

import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.schedule.BIScheduleSnapshotHandler;
import com.tridium.schedule.ScheduleValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public class BScheduleRpc
extends BSingleton {
    @Generated
    public static final BScheduleRpc INSTANCE = new BScheduleRpc();
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduleRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BScheduleRpc() {
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String toLocalizableString(String encodedBSON, Context cx) throws Exception {
        return BScheduleRpc.unmarshal(encodedBSON, TransportType.box, cx).toString(cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void validateSchedule(String encodedBSON, Context cx) throws Exception {
        BAbstractSchedule schedule = (BAbstractSchedule)BScheduleRpc.unmarshal(encodedBSON, TransportType.box, cx);
        ScheduleValidator.validate((BAbstractSchedule)schedule, (Context)cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static List<String> getHighlightedDates(String sourceOrd, String encodedSchedule, String encodedStart, String encodedEnd, Context cx) throws Exception {
        TransportType transportType = BScheduleRpc.getTransportType(cx);
        BAbstractSchedule sched = (BAbstractSchedule)BScheduleRpc.unmarshal(encodedSchedule, transportType, cx);
        BDate start = (BDate)BScheduleRpc.unmarshal(encodedStart, transportType, cx);
        BDate end = (BDate)BScheduleRpc.unmarshal(encodedEnd, transportType, cx);
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorRead, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        return handler.getHighlightedDates(sourceComp, sched, start, end, cx).stream().map(BDate::encodeToString).collect(Collectors.toList());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static List<Map<String, String>> getSummary(String sourceOrd, String encodedSchedule, String encodedStart, String encodedEnd, String encodedFacets, Context cx) throws Exception {
        TransportType transportType = BScheduleRpc.getTransportType(cx);
        BWeeklySchedule sched = (BWeeklySchedule)BScheduleRpc.unmarshal(encodedSchedule, transportType, cx);
        BDate start = (BDate)BScheduleRpc.unmarshal(encodedStart, transportType, cx);
        BDate end = (BDate)BScheduleRpc.unmarshal(encodedEnd, transportType, cx);
        BFacets facets = (BFacets)BScheduleRpc.unmarshal(encodedFacets, transportType, cx);
        BasicContext merged = new BasicContext(cx, facets);
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorRead, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        return handler.getSummary(sourceComp, (BAbstractSchedule)sched, start, end, (Context)merged);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static String save(String sourceOrd, String newScheduleEnc, Context cx) throws Exception {
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorWrite, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        TransportType transportType = BScheduleRpc.getTransportType(cx);
        BAbstractSchedule newSchedule = (BAbstractSchedule)BScheduleRpc.unmarshal(newScheduleEnc, transportType, cx);
        try {
            BAbstractSchedule updatedSchedule = handler.saveSnapshot(sourceComp, newSchedule, cx);
            return BScheduleRpc.marshal((BValue)updatedSchedule, transportType, cx);
        }
        catch (CannotValidateException err) {
            Lexicon lex = Lexicon.make((String)"schedule", (Context)cx);
            String message = lex.get("validation.cannotValidate") + ": " + err.toString(cx);
            Logger.getLogger("schedule").log(Level.WARNING, message, err);
            throw new Exception(message, err);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static String getSnapshot(String sourceOrd, Context cx) throws Exception {
        TransportType transportType = BScheduleRpc.getTransportType(cx);
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorRead, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        BAbstractSchedule snapShot = handler.getSnapshot(sourceComp, cx);
        return BScheduleRpc.marshal((BValue)snapShot, transportType, cx);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getRefBase(String sourceOrd, Context cx) {
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorRead, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        return handler.getRefBaseOrd(sourceComp).toString();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static List<String> findCalendarSchedules(String sourceOrd, Context cx) {
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorRead, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        return handler.findCalendarSchedules(sourceComp, cx).stream().map(BOrd::encodeToString).collect(Collectors.toList());
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static Map<String, Object> getScheduleOptions(String sourceOrd, Context cx) {
        BComponent sourceComp = BScheduleRpc.getSourceComp(sourceOrd, BPermissions.operatorRead, cx);
        BIScheduleSnapshotHandler handler = BScheduleRpc.getSnapshotHandler(sourceComp);
        return handler.getScheduleOptions(sourceComp, cx);
    }

    private static TransportType getTransportType(Context cx) {
        return TransportType.valueOf((String)cx.getFacet("transportType").toString());
    }

    private static BValue unmarshal(String str, TransportType transportType, Context cx) throws Exception {
        return transportType.equals((Object)TransportType.box) ? BsonDecoderPlugin.unmarshal((String)str, (Context)cx) : ValueDocDecoder.unmarshal((String)str);
    }

    private static String marshal(BValue value, TransportType transportType, Context cx) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (BsonEncoderPlugin.DisplayEncoder encoder = transportType.equals((Object)TransportType.box) ? new BsonEncoderPlugin.DisplayEncoder((ValueDocEncoder.IEncoderPlugin)new BsonEncoderPlugin((OutputStream)out), cx) : new ValueDocEncoder((ValueDocEncoder.IEncoderPlugin)new ValueDocEncoder.BogEncoderPlugin((OutputStream)out, cx), cx);){
            encoder.setEncodeTransients(true);
            encoder.encode(value);
        }
        return new String(out.toByteArray());
    }

    private static BIScheduleSnapshotHandler getSnapshotHandler(BComponent sourceComp) {
        return (BIScheduleSnapshotHandler)sourceComp.getAgents().filter(info -> info.getAgentType().is(BIScheduleSnapshotHandler.TYPE)).getDefault().getInstance();
    }

    private static BComponent getSourceComp(String sourceOrd, BPermissions required, Context cx) {
        BComponent sourceComp = (BComponent)BOrd.make((String)sourceOrd).get((BObject)BLocalHost.INSTANCE, cx);
        BUser user = cx.getUser();
        if (user != null) {
            cx.getUser().check((BIProtected)sourceComp, required);
        } else if (Sys.getStation() != null) {
            throw new PermissionException("No user found");
        }
        return sourceComp;
    }
}

