/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.user;

import com.tridium.hx.util.HxUtils;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.ConfirmDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.BHxTabbedView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.util.CustomThemeModuleManager;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.roles.BEntsecRole;
import com.tridiumx.entsecHx.BHxAccessProfile;
import com.tridiumx.entsecHx.orionToolsHx.BHxMissingTenantView;
import com.tridiumx.entsecHx.securityUtilHx.UpLevelCommand;
import com.tridiumx.entsecHx.securityUtilHx.fieldeditors.BHxAccessProfileFE;
import com.tridiumx.entsecHx.securityUtilHx.manager.BHxManageDevicesView;
import com.tridiumx.entsecHx.securityUtilHx.manager.ManageDevicesCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.TableCommand;
import com.tridiumx.entsecHx.user.BHxRolesFE;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebProfileConfig;

@NiagaraType(agent={@AgentOn(types={"baja:User"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxUserView
extends BHxManageDevicesView {
    public static final BHxUserView INSTANCE = new BHxUserView();
    public static final Type TYPE = Sys.loadType(BHxUserView.class);
    protected Lexicon lex = Lexicon.make(BHxUserView.class);
    protected SmartCommand queryTableCommand = new TableCommand((BHxView)this);
    protected SmartCommand clearLockOut;
    private static final String DEFAULT_THEME_NAME = "Lucid";

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxUserView() {
        this.registerEvent((Event)this.queryTableCommand);
        this.clearLockOut = new ClearLockOut((BHxView)this);
        this.registerEvent((Event)this.clearLockOut);
    }

    public String getSaveConfirmMessage(HxOp op) throws Exception {
        BUser opUser = (BUser)op.get();
        BUser signedInUser = op.getUser();
        if (signedInUser == opUser) {
            return this.lex.getText("modifySameUserQuestion");
        }
        return super.getSaveConfirmMessage(op);
    }

    public void setDefaults(HxOp op) {
        BUser user = (BUser)op.get();
        if (!user.isMounted()) {
            BWebProfileConfig webProfile = (BWebProfileConfig)user.getMixIn(BWebProfileConfig.TYPE);
            webProfile.setTypeSpec(BHxAccessProfile.TYPE.getTypeSpec());
            BDynamicEnum themeEnum = CustomThemeModuleManager.getDefaultThemeEnum();
            BEnumRange themeRange = themeEnum.getRange();
            webProfile.remove("selectedHxTheme");
            webProfile.add("selectedHxTheme", (BValue)BDynamicEnum.make((int)0, (BEnumRange)themeRange));
            user.set(MappingSupport.getMixInName((Type)BWebProfileConfig.TYPE), (BValue)webProfile);
            if (user.getNavFile().isNull()) {
                user.setNavFile(BOrd.make((String)"module://entsec/rc/entsecHome.nav"));
            }
        }
    }

    @Override
    public BHxTabbedView.PropertyTab getPropertyTab(HxOp op) throws Exception {
        BHxTabbedView.PropertyTab propertyTab = super.getPropertyTab(op);
        BHxFieldSheet fieldSheet = (BHxFieldSheet)propertyTab.view;
        int index = -1;
        String[] properties = this.getProperties(op);
        String[] fieldEditors = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].equals("web_WebProfileConfig.typeSpec")) continue;
            fieldEditors[i] = BHxAccessProfileFE.TYPE.toString();
        }
        propertyTab.op.mergeFacets(BHxFieldSheet.getFieldEditorsProvidedFacets((String[])fieldEditors));
        return propertyTab;
    }

    @Override
    public String getAddTabName(HxOp op) {
        return this.lex.getText("userName");
    }

    @Override
    public Tab[] getTabs(HxOp op) throws Exception {
        BUser user = (BUser)op.get();
        this.setDefaults(op);
        if (EntsecTenantUtil.isMissingTenant((BComponent)user, (boolean)true, (Context)op)) {
            HxOp tabOp = op.make("restricted", (OrdTarget)op);
            tabOp.setReadonly(true);
            Tab tab = new Tab((BHxView)BHxMissingTenantView.INSTANCE, this.lex.getText("restricted.label"), tabOp);
            return new Tab[]{tab};
        }
        if (user.isMounted() && Flags.isReadonly((BComplex)user.getParent(), (Slot)user.getPropertyInParent())) {
            op.setReadonly(true);
        }
        Tab rolesTab = new Tab((BHxView)BHxRolesFE.INSTANCE, HxTabUtil.getPluralDisplayName((Type)BEntsecRole.TYPE, (Context)op), op.make("roles", (OrdTarget)op), op);
        Object[] defaultTabs = super.getTabs(op);
        Array a = new Array(defaultTabs);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        if (user != userService.getAdmin()) {
            a.add((Object)rolesTab);
        }
        return (Tab[])a.trim();
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        BUser user = (BUser)op.get();
        Array arr = new Array((Object[])super.getButtonCommands(op));
        for (int i = arr.size() - 1; i >= 0; --i) {
            if (!(arr.get(i) instanceof ManageDevicesCommand) && !(arr.get(i) instanceof UpLevelCommand)) continue;
            arr.remove(i);
        }
        arr.add((Object)this.clearLockOut);
        arr.add((Object)this.queryTableCommand);
        return (SmartCommand[])arr.trim();
    }

    public class ClearLockOut
    extends SmartCommand {
        protected ConfirmDialog dlg;

        public ClearLockOut(BHxView view) {
            super(view);
            this.dlg = new ConfirmDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "clearLockOut";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isVisible(HxOp op) {
            BUser user = (BUser)op.get();
            return user.getLockOut();
        }

        public void handle(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(this.lexModule.getText("confirmClearLockOut", (Context)op), op);
                return;
            }
            BUser user = (BUser)op.get();
            user.invoke(BUser.clearLockOut, null, (Context)op);
            HxUtils.forceUpdate((HxOp)op);
        }
    }
}

