/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.user;

import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.user.BUserQuery;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxAddUserQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableConfig;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.entsecHx.securityUtilHx.query.BatchEditCommand;
import com.tridiumx.entsecHx.securityUtilHx.query.ColumnsCommand;
import com.tridiumx.entsecHx.tab.HxEntsecUtil;
import com.tridiumx.entsecHx.user.BHxPasswordStrengthFE;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"entsec:UserQuery", "baja:UserService"}, app="entsec", requiredPermissions="rR")})
@NiagaraSingleton
public class BHxUserQueryView
extends BHxQueryTableView {
    public static final BHxUserQueryView INSTANCE = new BHxUserQueryView();
    public static final Type TYPE = Sys.loadType(BHxUserQueryView.class);
    protected SmartCommand configure;
    protected SmartCommand userAddCommand;
    protected SmartCommand batchEditCommand = new UserBatchEditCommand((BHxView)this);
    protected SmartCommand userColumnsCommand;
    protected SmartCommand userDeleteCommand;
    public static final Lexicon lex = Lexicon.make((String)"entsecHx");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BHxUserQueryView() {
        this.registerEvent((Event)this.batchEditCommand);
        this.userColumnsCommand = new UserColumnsCommand((BHxView)this);
        this.registerEvent((Event)this.userColumnsCommand);
        this.userAddCommand = new UserAddCommand((BHxView)this);
        this.registerEvent((Event)this.userAddCommand);
        this.userDeleteCommand = new UserDeleteCommand((BHxView)this);
        this.registerEvent((Event)this.userDeleteCommand);
        this.configure = new ConfigureCommand((BHxView)this);
        this.registerEvent((Event)this.configure);
    }

    @Override
    public BObject getBase(HxOp op) {
        if (op.get() instanceof BQuery) {
            return op.get();
        }
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        return service.getUsers();
    }

    @Override
    public BQuery getQuery(HxOp op) {
        BQuery query = null;
        if (op.get() instanceof BQuery) {
            query = super.getQuery(op);
            return EntsecTenantUtil.filter((BQuery)query, (Context)op);
        }
        return BHxUserQueryView.getUserQuery(op);
    }

    public static BQuery getUserQuery(HxOp op) {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BUserQuery query = service.getUsers();
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        query = EntsecTenantUtil.filter((BQuery)query, (Context)op);
        return query;
    }

    @Override
    public SmartCommand[] getButtonCommands(HxOp op) {
        Array arr = new Array((Object[])super.getButtonCommands(op));
        for (int i = 0; i < arr.size(); ++i) {
            if (arr.get(i) instanceof ColumnsCommand) {
                arr.set(i, (Object)this.userColumnsCommand);
            }
            if (arr.get(i) instanceof BHxQueryTableView.AddCommand) {
                arr.set(i, (Object)this.userAddCommand);
            }
            if (!(arr.get(i) instanceof BHxQueryTableView.DeleteCommand)) continue;
            arr.set(i, (Object)this.userDeleteCommand);
        }
        arr.add((Object)this.configure);
        arr.add((Object)this.batchEditCommand);
        return (SmartCommand[])arr.trim();
    }

    public Tab getConfigureTab(HxOp op) throws Exception {
        String[] fieldNames = new String[]{BUserService.lockOutEnabled.getName(), BUserService.lockOutPeriod.getName(), BUserService.maxBadLoginsBeforeLockOut.getName(), BUserService.lockOutWindow.getName()};
        BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames));
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        HxOp tabOp = op.make("field", (BObject)userService, facets);
        HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)tabOp.scope(BUserService.lockOutEnabled.getName() + ".value"), (String)tabOp.scope(BUserService.lockOutPeriod.getName()), (String)"true", (HxOp)op);
        HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)tabOp.scope(BUserService.lockOutEnabled.getName() + ".value"), (String)tabOp.scope(BUserService.maxBadLoginsBeforeLockOut.getName()), (String)"true", (HxOp)op);
        HxTabUtil.addEvent((String)HxTabUtil.CHANGE, (String)HxTabUtil.HIDE_ELEM, (boolean)HxTabUtil.CALL_NOW, (String)tabOp.scope(BUserService.lockOutEnabled.getName() + ".value"), (String)tabOp.scope(BUserService.lockOutWindow.getName()), (String)"true", (HxOp)op);
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, "configure", tabOp, op);
    }

    public Tab getPasswordStrengthTab(HxOp op) throws Exception {
        String[] fieldNames = new String[]{BPasswordStrength.minimumLength.getName(), BPasswordStrength.minimumLowerCase.getName(), BPasswordStrength.minimumUpperCase.getName(), BPasswordStrength.minimumDigits.getName(), BPasswordStrength.minimumSpecial.getName(), BPasswordStrength.maximumLength.getName()};
        BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames));
        String userName = op.getUser().getUsername();
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        userService.lease();
        BUser user = (BUser)userService.get(userName);
        user.lease();
        BAuthenticationScheme scheme = user.getAuthenticationScheme();
        BPasswordAuthenticationScheme passwordScheme = null;
        HxOp tabOp = null;
        if (scheme instanceof BPasswordAuthenticationScheme) {
            passwordScheme = (BPasswordAuthenticationScheme)scheme;
            tabOp = op.make("field", (BObject)passwordScheme.getGlobalPasswordConfiguration().getPasswordStrength(), facets);
        }
        return new Tab((BHxView)BHxPasswordStrengthFE.INSTANCE, "configure", tabOp, op);
    }

    public Tab getPasswordConfigurationTab(HxOp op) throws Exception {
        String[] fieldNames = new String[]{BGlobalPasswordConfiguration.expirationInterval.getName(), BGlobalPasswordConfiguration.warningPeriod.getName(), BGlobalPasswordConfiguration.passwordHistoryLength.getName()};
        BUser user = op.getUser();
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BAuthenticationScheme authenticationScheme = userService.getAuthenticationSchemeForUser(user);
        BPasswordAuthenticationScheme passwordScheme = null;
        HxOp tabOp = null;
        if (authenticationScheme instanceof BPasswordAuthenticationScheme) {
            passwordScheme = (BPasswordAuthenticationScheme)authenticationScheme;
            BFacets facets = BFacets.make((BFacets)BHxFieldSheet.getFieldsProvidedFacets((String[])fieldNames));
            tabOp = op.make("field", (BObject)passwordScheme.getGlobalPasswordConfiguration(), facets);
        }
        return new Tab((BHxView)BHxFieldSheet.INSTANCE, "configure", tabOp, op);
    }

    public BPasswordAuthenticator getTargetAuthenticator(HxOp op) {
        HxOp t = op;
        while (!(t.get() instanceof BPasswordAuthenticator)) {
            t = t.getBaseOrdTarget();
        }
        return (BPasswordAuthenticator)t.get();
    }

    public class ConfigureDialog
    extends Dialog {
        public ConfigureDialog(String title, Command handler) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            HxEntsecUtil.writeHeader(lex.getText("userQueryView.lockout.label"), op);
            BHxUserQueryView.this.getConfigureTab(op).write();
            HxEntsecUtil.getSpacerDiv((HxOp)op);
            HxEntsecUtil.writeHeader(lex.getText("userQueryView.passwordStrength.label"), op);
            BHxUserQueryView.this.getPasswordStrengthTab(op).write();
            HxEntsecUtil.writeHeader(lex.getText("userQueryView.passwordConfiguration.label"), op);
            BHxUserQueryView.this.getPasswordConfigurationTab(op).write();
        }
    }

    public class ConfigureCommand
    extends SmartCommand {
        ConfigureDialog dialog;

        public ConfigureCommand(BHxView view) {
            super(view);
            this.lexModule = LexiconModule.make(BHxUserQueryView.class);
            this.dialog = new ConfigureDialog(this.getDisplayName(null), (Command)this);
        }

        public String getName(HxOp op) {
            return "configure";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dialog.isSubmit(op)) {
                this.dialog.open(op);
                return;
            }
            BHxUserQueryView.this.getConfigureTab(op).save();
            BHxUserQueryView.this.getPasswordStrengthTab(op).save();
            BHxUserQueryView.this.getPasswordConfigurationTab(op).save();
        }
    }

    public static class UserAddCommand
    extends BHxQueryTableView.AddCommand {
        public UserAddCommand(BHxView view) {
            super(view);
        }

        @Override
        public void handle(HxOp op) throws Exception {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            BUserQuery query = service.getUsers();
            this.redirect(op, op.toUri(BOrd.make((String)("station:|" + query.getSlotPathOrd().toString() + "|view:" + BHxAddUserQueryTableView.TYPE))));
        }
    }

    public class UserColumnsCommand
    extends ColumnsCommand {
        public UserColumnsCommand(BHxView view) {
            super(view);
        }

        @Override
        public void redirect(HxOp op) throws Exception {
            BOrd ord = BOrd.make((String)("station:|" + BHxUserQueryView.this.getBase(op).asComponent().getSlotPathOrd() + "|view:" + BHxQueryTableConfig.TYPE));
            this.redirect(op, op.toUri(ord));
        }
    }

    public class UserBatchEditCommand
    extends BatchEditCommand {
        public UserBatchEditCommand(BHxView view) {
            super(view);
        }

        @Override
        public String[] getProperties(HxOp op) {
            return new String[]{"expiration", "language", "networkUser", "web_WebProfileConfig.autoLogoffEnabled", "web_WebProfileConfig.autoLogoffPeriod", "entsec_SecurityAlarmConsoleOptions.notesRequiredOnAck", "entsec_EntsecUserConfig.tenants"};
        }
    }

    public static class UserDeleteCommand
    extends BHxQueryTableView.DeleteCommand {
        public UserDeleteCommand(BHxView view) {
            super(view);
        }

        @Override
        public void checkDelete(BComponent subject, HxOp op) {
            super.checkDelete(subject, op);
            if (subject == op.getUser()) {
                throw new IllegalStateException("You cannot delete the User that you are currently logged in with.");
            }
        }
    }
}

