/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.user;

import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.IValidator;
import com.tridium.smartTableHx.fieldeditors.BHxAssignmentFE;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxLinkFE;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxQueryTableAssignedView;
import com.tridiumx.entsecHx.securityUtilHx.link.BHxQueryTableUnassignedWriteNeededView;
import javax.baja.hx.HxOp;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BPredicate;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.role.BAbstractRole;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraSingleton
public class BHxRolesFE
extends BHxAssignmentFE
implements IValidator {
    public static final BHxRolesFE INSTANCE = new BHxRolesFE();
    public static final Type TYPE = Sys.loadType(BHxRolesFE.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxRolesFE() {
    }

    public void validate(HxOp op) throws Exception {
        block3: {
            BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser user = (BUser)this.getComponent(op);
            if (user == userService.getAdmin()) {
                return;
            }
            try {
                BHxLinkFE.validate(BAbstractRole.TYPE, false, 1, this, op);
            }
            catch (IllegalStateException ie) {
                if (ie.getMessage().indexOf("Users require at least 1 Abstract Role") <= -1) break block3;
                throw new IllegalStateException("Users require at least 1 Role");
            }
        }
    }

    public BHxSmartTableView getAssignedView(HxOp op) {
        return BHxQueryTableAssignedView.INSTANCE;
    }

    public BHxSmartTableView getUnassignedView(HxOp op) {
        return BHxQueryTableUnassignedWriteNeededView.INSTANCE;
    }

    public BObject save(HxOp op) throws Exception {
        BObject saved = super.save(op);
        BUser user = (BUser)this.getComponent(op);
        return saved;
    }

    public void saveNewlyAssigned(String unassignedId, HxOp op) throws Exception {
        BUser user = (BUser)this.getComponent(op);
        BAbstractRole role = (BAbstractRole)BOrd.make((String)("station:|" + unassignedId)).get();
        String entsecRoles = user.getRoles();
        Array a = new Array((Object[])TextUtil.split((String)entsecRoles, (char)','));
        a.add((Object)role.getName());
        user.set("roles", (BValue)BString.make((String)TextUtil.join((String[])((String[])a.trim()), (char)',')), (Context)op);
    }

    public void saveNewlyUnassigned(String assignedId, HxOp op) throws Exception {
        BUser user = (BUser)this.getComponent(op);
        BAbstractRole role = (BAbstractRole)BOrd.make((String)("station:|" + assignedId)).get();
        if (!role.getPermissions((Context)op).hasOperatorWrite()) {
            throw new IllegalStateException("Operator Write Permission required to unassign Role: \"" + role.getDisplayName((Context)op) + "\".");
        }
        String entsecRoles = user.getRoles();
        Array a = new Array((Object[])TextUtil.split((String)entsecRoles, (char)','));
        for (int i = a.size() - 1; i >= 0; --i) {
            String roleString = (String)a.get(i);
            if (!roleString.equals(role.getName())) continue;
            a.remove(i);
        }
        user.set("roles", (BValue)BString.make((String)TextUtil.join((String[])((String[])a.trim()), (char)',')), (Context)op);
    }

    public BObject getUnassignedTable(BComponent target, HxOp op) {
        BQuery query = this.getRoleQuery();
        BPredicate predicate = query.getPredicate();
        ExpressionBuilder b = new ExpressionBuilder();
        if (predicate != null && predicate.getPredicateExpr() != null) {
            b.and(predicate.getPredicateExpr());
        }
        b.and(Predicates.not((BExpression)this.getAssignedExpression(op)));
        query.where(b.getExpression());
        return query;
    }

    public BObject getAssignedTable(BComponent target, HxOp op) {
        BQuery query = this.getRoleQuery();
        BPredicate predicate = query.getPredicate();
        ExpressionBuilder b = new ExpressionBuilder();
        if (predicate != null && predicate.getPredicateExpr() != null) {
            b.and(predicate.getPredicateExpr());
        }
        b.and(this.getAssignedExpression(op));
        query.where(b.getExpression());
        return query;
    }

    public BExpression getAssignedExpression(HxOp op) {
        BUser user = (BUser)this.getComponent(op);
        StringBuffer b = new StringBuffer();
        b.append(user.getHandle());
        b.append(".");
        if (op != null && op.getUser() != null) {
            b.append(op.getUser().getHandle());
        }
        BFunctionExpression function = Funcs.make((String)"entsecHx:HxRolesFE.isLinked", (Type)BBoolean.TYPE, (BExpression)Exprs.simple((BSimple)BString.make((String)b.toString())));
        return function;
    }

    public BQuery getRoleQuery() {
        BQuery query = QueryUtil.makeQuery((BTypeSpec)BAbstractRole.TYPE.getTypeSpec());
        query.add("base", (BValue)BOrd.make((String)"service:baja:RoleService"));
        return query;
    }

    public static BBoolean isLinked(BObject target, BString params) {
        BComplex source = target.asComplex();
        String[] split = TextUtil.split((String)params.toString(), (char)'.');
        String handle = split[0];
        if (handle.equals("null")) {
            return BBoolean.FALSE;
        }
        BUser user = (BUser)BOrd.make((String)("station:|h:" + handle)).get();
        String entsecRoles = user.getRoles();
        String[] entsecRolesSplit = TextUtil.split((String)entsecRoles, (char)',');
        for (int i = 0; i < entsecRolesSplit.length; ++i) {
            if (!entsecRolesSplit[i].equals(source.getName())) continue;
            return BBoolean.TRUE;
        }
        return BBoolean.FALSE;
    }
}

