/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsecHx.user;

import com.tridium.smartTableHx.tab.HxTabUtil;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryService;
import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"wbutil:PermissionsMapFE", "baja:PermissionsMap"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxPermissionsMapFE
extends BHxFieldEditor {
    public static final BHxPermissionsMapFE INSTANCE = new BHxPermissionsMapFE();
    public static final Type TYPE = Sys.loadType(BHxPermissionsMapFE.class);

    public Type getType() {
        return TYPE;
    }

    protected BHxPermissionsMapFE() {
    }

    public void write(HxOp op) throws Exception {
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        op.addStyleSheet(BOrd.make((String)"module://entsecHx/rc/roleManager.css"));
        Lexicon lex = op.getLexicon("entsecHx");
        BPermissionsMap map = (BPermissionsMap)op.get();
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BCategory[] cats = catService.getCategories();
        HtmlWriter out = op.getHtmlWriter();
        if (op.getUser().getPermissions().isSuperUser() || map.isSuperUser()) {
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("superUser")).w((Object)"' value='true'");
            if (map.isSuperUser()) {
                out.w((Object)" checked='checked'");
            }
            if (!op.canWrite() || !op.getUser().getPermissions().isSuperUser()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)"/>");
            out.w((Object)"<b>");
            out.safe((Object)lex.getText("roleManager.superUser"));
            out.w((Object)"</b>");
        }
        HxTabUtil.addEvent((String)HxTabUtil.CLICK, (String)HxTabUtil.HIDE_CHECKED, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope("superUser"), (String)op.scope("map"), (String)"true", (HxOp)op);
        out.w((Object)"<table cellspacing='0' cellpadding='0' class='role-manager-permissions-map'");
        HxTabUtil.scope((String)"map", (HtmlWriter)out, (HxOp)op);
        if (map.isSuperUser()) {
            out.attr("style", "display:none;");
        }
        out.w((Object)">");
        out.w((Object)"<tr>");
        out.w((Object)"<td class='role-manager-header2'>&nbsp;</td>");
        out.w((Object)"<td class='role-manager-header2'>").safe((Object)lex.getText("roleManager.read")).w((Object)"</td>");
        out.w((Object)"<td class='role-manager-header2'>").safe((Object)lex.getText("roleManager.write")).w((Object)"</td>");
        out.w((Object)"<td class='role-manager-header2' style='border-right: none;'>").safe((Object)lex.getText("roleManager.invoke")).w((Object)"</td>");
        out.w((Object)"</tr>");
        for (int i = 0; i < cats.length; ++i) {
            BPermissions assignablePermissions = BPermissions.all;
            BPermissions catPermissions = null;
            if (map.isSuperUser()) {
                catPermissions = BPermissions.none;
            } else {
                catPermissions = map.getPermissions(cats[i].getIndex());
                BPermissionsMap userMap = op.getUser().getPermissions();
                assignablePermissions = userMap.getPermissions(cats[i].getIndex());
                if (!assignablePermissions.hasOperatorRead()) continue;
            }
            out.w((Object)"<tr>");
            out.w((Object)"<td class='role-manager-catcell'");
            if (i == cats.length - 1) {
                out.w((Object)" style='border-bottom: none;'");
            }
            out.w((Object)">").safe((Object)cats[i].getDisplayName((Context)op)).w((Object)"</td>");
            out.w((Object)"<td class='role-manager-pcell'");
            if (i == cats.length - 1) {
                out.w((Object)" style='border-bottom: none;'");
            }
            out.w((Object)">");
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("cat_" + cats[i].getIndex() + "_R")).w((Object)"' value='true'");
            if (catPermissions.hasAdminRead()) {
                out.w((Object)" checked='checked'");
            }
            if (!assignablePermissions.hasAdminRead() || !op.canWrite() || catPermissions.hasAdminWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"<td class='role-manager-pcell'");
            if (i == cats.length - 1) {
                out.w((Object)" style='border-bottom: none;'");
            }
            out.w((Object)">");
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("cat_" + cats[i].getIndex() + "_W")).w((Object)"' value='true'");
            if (catPermissions.hasAdminWrite()) {
                out.w((Object)" checked='checked'");
            }
            if (!assignablePermissions.hasAdminWrite() || !op.canWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"<td class='role-manager-pcell'");
            out.w((Object)" style='border-right: none;");
            if (i == cats.length - 1) {
                out.w((Object)" border-bottom: none;");
            }
            out.w((Object)"'>");
            out.w((Object)"<input type='checkbox' name='").w((Object)op.scope("cat_" + cats[i].getIndex() + "_I")).w((Object)"' value='true'");
            if (catPermissions.hasAdminInvoke()) {
                out.w((Object)" checked='checked'");
            }
            if (!assignablePermissions.hasAdminInvoke() || !op.canWrite()) {
                out.w((Object)" disabled='disabled'");
            }
            out.w((Object)"/>");
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
            String prefix = "cat_" + cats[i].getIndex() + "_";
            HxTabUtil.addEvent((String)HxTabUtil.CLICK, (String)HxTabUtil.MATCH_CHECKED, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope(prefix + "W"), (String)op.scope(prefix + "R"), (String)"", (HxOp)op);
            HxTabUtil.addEvent((String)HxTabUtil.CLICK, (String)HxTabUtil.DISABLE_CHECKED, (!HxTabUtil.CALL_NOW ? 1 : 0) != 0, (String)op.scope(prefix + "W"), (String)op.scope(prefix + "R"), (String)"false", (HxOp)op);
        }
        out.w((Object)"</table>");
    }

    public BObject save(HxOp op) {
        boolean isSuperUser;
        BPermissionsMap opMap = (BPermissionsMap)op.get();
        if (!op.canWrite() || !op.getUser().getPermissions().isSuperUser() && opMap.isSuperUser()) {
            return op.get();
        }
        boolean bl = isSuperUser = op.getFormValue("superUser") != null;
        if (isSuperUser) {
            return BPermissionsMap.SUPER_USER;
        }
        BCategoryService catService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        BCategory[] cats = catService.getCategories();
        int maxIndex = 0;
        for (int c = 0; c < cats.length; ++c) {
            maxIndex = Math.max(maxIndex, cats[c].getIndex());
        }
        BPermissions[] permissions = new BPermissions[maxIndex + 1];
        for (int c = 0; c < cats.length; ++c) {
            int catIndex = cats[c].getIndex();
            boolean r = this.isSet(catIndex, "rr", op);
            boolean w = this.isSet(catIndex, "ww", op);
            boolean i = this.isSet(catIndex, "ii", op);
            boolean R = this.isSet(catIndex, "R", op);
            boolean W = this.isSet(catIndex, "W", op);
            boolean I = this.isSet(catIndex, "I", op);
            int mask = 0;
            if (r) {
                mask |= 1;
            }
            if (w) {
                mask |= 2;
            }
            if (i) {
                mask |= 4;
            }
            if (R) {
                mask |= 0x10;
            }
            if (W) {
                mask |= 0x20;
            }
            if (I) {
                mask |= 0x40;
            }
            permissions[catIndex] = BPermissions.make((int)mask);
        }
        return BPermissionsMap.make((BPermissions[])permissions);
    }

    private boolean isSet(int index, String permission, HxOp op) {
        String key = "cat_" + index + "_" + permission;
        String value = op.getFormValue(key);
        return value != null && value.equals("true");
    }
}

